/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.uij;

import com.mathworks.hg.uij.ColorMap;
import com.mathworks.hg.uij.ColormapPaint;
import com.mathworks.hg.uij.GouraudPaint;
import com.mathworks.hg.uij.LitColormapPaint;
import com.mathworks.hg.uij.LitTexture2DPaint;
import com.mathworks.hg.uij.Polyline;
import com.mathworks.hg.uij.Texture2DPaint;
import com.mathworks.hg.uij.TextureMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;

public class JavaDrawable {
    private Graphics2D fGraphics2d = null;
    private float fPointSize = 1.0f;
    private float fLineWidth = 1.0f;
    private int fLineCapStyle = 0;
    private int fLineJoinStyle = 2;
    private int fLineStipplePattern = 65535;
    private int fLineStippleFactor = 1;
    private boolean fLineSmoothing = true;
    private ColorMap fCurrColormap = null;
    private TextureMap fCurrTexture = null;
    private boolean fAntialiasingEnabled = false;

    private void setAntialiasingEnabled(boolean bl) {
        if (this.fAntialiasingEnabled != bl) {
            this.fAntialiasingEnabled = bl;
            if (this.fAntialiasingEnabled) {
                this.fGraphics2d.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            } else {
                this.fGraphics2d.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF));
            }
        }
    }

    JavaDrawable(Graphics2D graphics2D) {
        this.fGraphics2d = graphics2D;
    }

    public Graphics2D getGraphics2D() {
        return this.fGraphics2d;
    }

    public void setColormap(ColorMap colorMap) {
        this.fCurrColormap = colorMap;
    }

    private BufferedImage makeImage(int n, int n2, int[] nArray, boolean bl) {
        DirectColorModel directColorModel;
        int[] nArray2;
        Object object;
        if (bl) {
            object = new int[]{0xFF0000, 65280, 255, -16777216};
            nArray2 = object;
            directColorModel = new DirectColorModel(32, nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
        } else {
            object = new int[]{0xFF0000, 65280, 255};
            nArray2 = object;
            directColorModel = new DirectColorModel(32, nArray2[0], nArray2[1], nArray2[2]);
        }
        object = new DataBufferInt(nArray, n * n2);
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(((DataBuffer)object).getDataType(), n, n2, nArray2);
        WritableRaster writableRaster = Raster.createWritableRaster(singlePixelPackedSampleModel, (DataBuffer)object, new Point(0, 0));
        return new BufferedImage(directColorModel, writableRaster, true, null);
    }

    public BufferedImage createTexture(int n, int n2, int[] nArray) {
        return this.makeImage(n, n2, nArray, true);
    }

    public void setTexture(TextureMap textureMap) {
        this.fCurrTexture = textureMap;
    }

    public void setPointSize(float f) {
        this.fPointSize = f;
    }

    public void setLineWidth(float f) {
        this.fLineWidth = f;
    }

    public void setLineStipple(int n, int n2) {
        this.fLineStipplePattern = n;
        this.fLineStippleFactor = n2;
    }

    public void setLineSmoothing(boolean bl) {
        this.fLineSmoothing = bl;
    }

    public void setSurfaceAttributes() {
    }

    public void setScissorRectangle(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            this.fGraphics2d.setClip(n, n2, n3, n4);
        } else {
            this.fGraphics2d.setClip(null);
        }
    }

    private Color int2Color(int n) {
        boolean bl = (n & 0xFF000000) != -16777216;
        return new Color(n, bl);
    }

    private void drawPoint(float f, float f2, Color color) {
        this.setAntialiasingEnabled(true);
        float f3 = this.fPointSize;
        float f4 = this.fPointSize;
        float f5 = f3 / 2.0f;
        float f6 = f4 / 2.0f;
        this.fGraphics2d.setPaint(color);
        this.fGraphics2d.fill(new RoundRectangle2D.Float(f - f5, f2 - f6, f3, f4, f3, f4));
    }

    public void drawSolidPoint(float f, float f2, int n) {
        this.drawPoint(f, f2, this.int2Color(n));
    }

    public void drawIndexPoint(float f, float f2, float f3) {
        Color color = Color.WHITE;
        if (this.fCurrColormap != null) {
            int n = (int)(f3 * (float)this.fCurrColormap.getLength());
            color = this.fCurrColormap.getColor(n);
        }
        this.drawPoint(f, f2, color);
    }

    public void drawTexturedPoint(float f, float f2, float f3, float f4) {
        Color color = Color.WHITE;
        if (this.fCurrTexture != null) {
            int n = this.fCurrTexture.getWidth();
            int n2 = this.fCurrTexture.getHeight();
            int n3 = (int)(f3 * (float)n);
            int n4 = (int)(f4 * (float)n2);
            color = this.fCurrTexture.getColor(n3, n4);
        }
        this.drawPoint(f, f2, color);
    }

    private Stroke createStroke() {
        BasicStroke basicStroke = null;
        switch (this.fLineStipplePattern) {
            case 65472: {
                basicStroke = new BasicStroke(this.fLineWidth, this.fLineCapStyle, this.fLineJoinStyle, 1.0f, new float[]{10.0f, 6.0f}, 10.0f);
                break;
            }
            case 61680: {
                basicStroke = new BasicStroke(this.fLineWidth, this.fLineCapStyle, this.fLineJoinStyle, 1.0f, new float[]{4 * this.fLineStippleFactor, 4 * this.fLineStippleFactor}, 4 * this.fLineStippleFactor);
                break;
            }
            case 34952: {
                basicStroke = new BasicStroke(this.fLineWidth, this.fLineCapStyle, this.fLineJoinStyle, 1.0f, new float[]{1.0f, 3.0f}, 1.0f);
                break;
            }
            case 43690: {
                basicStroke = new BasicStroke(this.fLineWidth, this.fLineCapStyle, this.fLineJoinStyle, 1.0f, new float[]{1 * this.fLineStippleFactor, 1 * this.fLineStippleFactor}, 1 * this.fLineStippleFactor);
                break;
            }
            case 6399: {
                basicStroke = new BasicStroke(this.fLineWidth, this.fLineCapStyle, this.fLineJoinStyle, 1.0f, new float[]{8.0f, 3.0f, 2.0f, 3.0f}, 0.0f);
                break;
            }
            case 28527: {
                basicStroke = new BasicStroke(this.fLineWidth, this.fLineCapStyle, this.fLineJoinStyle, 1.0f, new float[]{4 * this.fLineStippleFactor, 1 * this.fLineStippleFactor, 2 * this.fLineStippleFactor, 1 * this.fLineStippleFactor}, 0.0f);
                break;
            }
            default: {
                basicStroke = new BasicStroke(this.fLineWidth);
            }
        }
        return basicStroke;
    }

    public void drawSolidLine(float f, float f2, float f3, float f4, int n) {
        this.setAntialiasingEnabled(this.fLineSmoothing);
        this.fGraphics2d.setStroke(this.createStroke());
        this.fGraphics2d.setPaint(this.int2Color(n));
        this.fGraphics2d.draw(new Line2D.Float(f, f2, f3, f4));
    }

    public void drawSolidLineStrip(Vector<Point2D.Float> vector, int n) {
        this.setAntialiasingEnabled(this.fLineSmoothing);
        this.fGraphics2d.setStroke(this.createStroke());
        this.fGraphics2d.setPaint(this.int2Color(n));
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(new Polyline(vector), false);
        this.fGraphics2d.draw(generalPath);
    }

    public void drawInterpRGBLine(float f, float f2, float f3, float f4, int n, int n2) {
        this.setAntialiasingEnabled(this.fLineSmoothing);
        Stroke stroke = this.createStroke();
        Shape shape = stroke.createStrokedShape(new Line2D.Float(f, f2, f3, f4));
        this.fGraphics2d.setPaint(new GradientPaint(new Point2D.Float(f, f2), new Color(n), new Point2D.Float(f3, f4), new Color(n2)));
        this.fGraphics2d.fill(shape);
    }

    public void drawInterpIndexLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.setAntialiasingEnabled(this.fLineSmoothing);
        Stroke stroke = this.createStroke();
        Shape shape = stroke.createStrokedShape(new Line2D.Float(f, f2, f3, f4));
        if (this.fCurrColormap != null) {
            this.fGraphics2d.setPaint(new ColormapPaint(f, f2, f5, f7, f3, f4, f6, f8, this.fCurrColormap));
        }
        this.fGraphics2d.fill(shape);
    }

    public void drawLitInterpIndexLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20) {
        this.setAntialiasingEnabled(this.fLineSmoothing);
        Stroke stroke = this.createStroke();
        Shape shape = stroke.createStrokedShape(new Line2D.Float(f, f2, f3, f4));
        if (this.fCurrColormap != null) {
            this.fGraphics2d.setPaint(new LitColormapPaint(f, f2, f5, f7, f9, f10, f11, f15, f16, f17, f3, f4, f6, f8, f12, f13, f14, f18, f19, f20, this.fCurrColormap));
        }
        this.fGraphics2d.fill(shape);
    }

    public void drawTexturedLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.setAntialiasingEnabled(this.fLineSmoothing);
        Stroke stroke = this.createStroke();
        Shape shape = stroke.createStrokedShape(new Line2D.Float(f, f2, f3, f4));
        if (this.fCurrTexture != null) {
            this.fGraphics2d.setPaint(new Texture2DPaint(f, f2, f5, f6, f9, f3, f4, f7, f8, f10, this.fCurrTexture));
        }
        this.fGraphics2d.fill(shape);
    }

    public void drawLitTexturedLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20, float f21, float f22) {
        this.setAntialiasingEnabled(this.fLineSmoothing);
        Stroke stroke = this.createStroke();
        Shape shape = stroke.createStrokedShape(new Line2D.Float(f, f2, f3, f4));
        if (this.fCurrTexture != null) {
            this.fGraphics2d.setPaint(new LitTexture2DPaint(f, f2, f5, f6, f9, f11, f12, f13, f17, f18, f19, f3, f4, f7, f8, f10, f14, f15, f16, f20, f21, f22, this.fCurrTexture));
        }
        this.fGraphics2d.fill(shape);
    }

    public void fillSolidTriangle(float f, float f2, float f3, float f4, float f5, float f6, int n) {
        this.setAntialiasingEnabled(false);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f5, f6);
        generalPath.closePath();
        this.fGraphics2d.setPaint(this.int2Color(n));
        this.fGraphics2d.fill(generalPath);
    }

    public void fillInterpRGBTriangle(float f, float f2, float f3, float f4, float f5, float f6, int n, int n2, int n3) {
        this.setAntialiasingEnabled(false);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f5, f6);
        generalPath.closePath();
        this.fGraphics2d.setPaint(new GouraudPaint(new Point2D.Float(f, f2), n, new Point2D.Float(f3, f4), n2, new Point2D.Float(f5, f6), n3));
        this.fGraphics2d.fill(generalPath);
    }

    public void fillInterpIndexTriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.setAntialiasingEnabled(false);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f5, f6);
        generalPath.closePath();
        if (this.fCurrColormap != null) {
            this.fGraphics2d.setPaint(new ColormapPaint(f, f2, f7, f10, f3, f4, f8, f11, f5, f6, f9, f12, this.fCurrColormap));
        }
        this.fGraphics2d.fill(generalPath);
    }

    public void fillLitInterpIndexTriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20, float f21, float f22, float f23, float f24, float f25, float f26, float f27, float f28, float f29, float f30) {
        this.setAntialiasingEnabled(false);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f5, f6);
        generalPath.closePath();
        if (this.fCurrColormap != null) {
            this.fGraphics2d.setPaint(new LitColormapPaint(f, f2, f7, f10, f13, f14, f15, f22, f23, f24, f3, f4, f8, f11, f16, f17, f18, f25, f26, f27, f5, f6, f9, f12, f19, f20, f21, f28, f29, f30, this.fCurrColormap));
        }
        this.fGraphics2d.fill(generalPath);
    }

    public void fillTexturedTriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15) {
        this.setAntialiasingEnabled(false);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f5, f6);
        generalPath.closePath();
        if (this.fCurrTexture != null) {
            this.fGraphics2d.setPaint(new Texture2DPaint(f, f2, f7, f8, f13, f3, f4, f9, f10, f14, f5, f6, f11, f12, f15, this.fCurrTexture));
        }
        this.fGraphics2d.fill(generalPath);
    }

    public void fillLitTexturedTriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20, float f21, float f22, float f23, float f24, float f25, float f26, float f27, float f28, float f29, float f30, float f31, float f32, float f33) {
        this.setAntialiasingEnabled(false);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f5, f6);
        generalPath.closePath();
        if (this.fCurrTexture != null) {
            this.fGraphics2d.setPaint(new LitTexture2DPaint(f, f2, f7, f8, f13, f16, f17, f18, f25, f26, f27, f3, f4, f9, f10, f14, f19, f20, f21, f28, f29, f30, f5, f6, f11, f12, f15, f22, f23, f24, f31, f32, f33, this.fCurrTexture));
        }
        this.fGraphics2d.fill(generalPath);
    }

    public void fillSolidQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n) {
        this.setAntialiasingEnabled(false);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f5, f6);
        generalPath.lineTo(f7, f8);
        generalPath.closePath();
        this.fGraphics2d.setPaint(this.int2Color(n));
        this.fGraphics2d.fill(generalPath);
    }

    public void fillInterpRGBQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n, int n2, int n3, int n4) {
        this.fillInterpRGBTriangle(f, f2, f3, f4, f5, f6, n, n2, n3);
        this.fillInterpRGBTriangle(f5, f6, f7, f8, f, f2, n3, n4, n);
    }

    public void fillInterpIndexQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.fillInterpIndexTriangle(f, f2, f3, f4, f5, f6, f9, f10, f11, f13, f14, f15);
        this.fillInterpIndexTriangle(f5, f6, f7, f8, f, f2, f11, f12, f9, f15, f16, f13);
    }

    public void fillLitInterpIndexQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20, float f21, float f22, float f23, float f24, float f25, float f26, float f27, float f28, float f29, float f30, float f31, float f32, float f33, float f34, float f35, float f36, float f37, float f38, float f39, float f40) {
        this.fillLitInterpIndexTriangle(f, f2, f3, f4, f5, f6, f9, f10, f11, f13, f14, f15, f17, f18, f19, f20, f21, f22, f23, f24, f25, f29, f30, f31, f32, f33, f34, f35, f36, f37);
        this.fillLitInterpIndexTriangle(f5, f6, f7, f8, f, f2, f11, f12, f9, f15, f16, f13, f23, f24, f25, f26, f27, f28, f17, f18, f19, f35, f36, f36, f38, f39, f40, f29, f30, f31);
    }

    public void fillTexturedQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20) {
        this.fillTexturedTriangle(f, f2, f3, f4, f5, f6, f9, f10, f11, f12, f13, f14, f17, f18, f19);
        this.fillTexturedTriangle(f5, f6, f7, f8, f, f2, f13, f14, f15, f16, f9, f10, f19, f20, f17);
    }

    public void fillLitTexturedQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20, float f21, float f22, float f23, float f24, float f25, float f26, float f27, float f28, float f29, float f30, float f31, float f32, float f33, float f34, float f35, float f36, float f37, float f38, float f39, float f40, float f41, float f42, float f43, float f44) {
        this.fillLitTexturedTriangle(f, f2, f3, f4, f5, f6, f9, f10, f11, f12, f13, f14, f17, f18, f19, f21, f22, f23, f24, f25, f26, f27, f28, f29, f33, f34, f35, f36, f37, f38, f39, f40, f41);
        this.fillLitTexturedTriangle(f5, f6, f7, f8, f, f2, f13, f14, f15, f16, f9, f10, f19, f20, f17, f27, f28, f29, f30, f31, f32, f21, f22, f23, f39, f40, f40, f42, f43, f44, f33, f34, f35);
    }

    public void clearBackground(int n, int n2, float f, float f2, float f3, float f4) {
        if (this.fGraphics2d != null) {
            Color color = new Color(f, f2, f3, f4);
            this.fGraphics2d.setColor(color);
            this.fGraphics2d.fillRect(0, 0, n, n2);
        }
    }
}

