/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.hg.util.MPrintJob;
import com.mathworks.hg.util.OutputHelper;
import com.mathworks.hg.util.OutputHelperCreator;
import com.mathworks.hg.util.OutputHelperFactoryException;
import com.mathworks.hg.util.OutputHelperInstantiationException;
import java.util.HashMap;
import java.util.ResourceBundle;

public class OutputHelperFactory {
    private static OutputHelperFactory sInstance = new OutputHelperFactory();
    private HashMap fHelpers = null;
    private static ResourceBundle sFactoryInfo = ResourceBundle.getBundle("com.mathworks.hg.util.resources.RES_outputhelperfactory");

    public static OutputHelperFactory getInstance() {
        return sInstance;
    }

    public OutputHelper createOutputHelper(MPrintJob mPrintJob) throws OutputHelperFactoryException {
        return this.createOutputHelper(mPrintJob.getDriver(), mPrintJob);
    }

    public OutputHelper createOutputHelper(String string, MPrintJob mPrintJob) throws OutputHelperFactoryException {
        if (this.fHelpers == null || !this.fHelpers.containsKey(string)) {
            throw new OutputHelperFactoryException(sFactoryInfo.getString("factory.noOutputHelperRegistered") + " " + string);
        }
        OutputHelperCreator outputHelperCreator = (OutputHelperCreator)this.fHelpers.get(string);
        if (outputHelperCreator == null) {
            throw new OutputHelperFactoryException(sFactoryInfo.getString("factory.noOutputHelpeCreatorProvided") + " " + string);
        }
        try {
            return outputHelperCreator.create(string, mPrintJob);
        }
        catch (OutputHelperInstantiationException outputHelperInstantiationException) {
            throw new OutputHelperFactoryException(sFactoryInfo.getString("factory.OutputHelperNotCreated") + " " + string);
        }
    }

    public void registerOutputHelperCreator(String string, OutputHelperCreator outputHelperCreator) throws OutputHelperFactoryException {
        if (this.fHelpers == null) {
            this.fHelpers = new HashMap();
        }
        if (this.fHelpers == null) {
            throw new OutputHelperFactoryException(sFactoryInfo.getString("factory.unableToAllocate") + " " + string);
        }
        if (this.fHelpers.containsKey(string)) {
            throw new OutputHelperFactoryException(sFactoryInfo.getString("factory.FormatKeyAlreadyRegistered") + " " + string);
        }
        this.fHelpers.put(string, outputHelperCreator);
    }

    public boolean unregisterOutputHelperCreator(String string) throws OutputHelperFactoryException {
        boolean bl = false;
        if (this.isOutputHelperCreatorRegistered(string)) {
            this.fHelpers.remove(string);
            bl = true;
        }
        return bl;
    }

    public boolean isOutputHelperCreatorRegistered(String string) throws OutputHelperFactoryException {
        return this.fHelpers != null && this.fHelpers.containsKey(string);
    }

    private OutputHelperFactory() {
    }
}

