/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.impl.filter.SearchTerm;
import ca.odell.glazedlists.impl.filter.TextMatcher;
import ca.odell.glazedlists.impl.filter.TextMatchers;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchEngineTextMatcherEditor<E>
extends TextMatcherEditor<E> {
    private final JTextField textField;
    private final FilterHandler filterHandler = new FilterHandler();
    private final Set<Field<E>> fields = new HashSet<Field<E>>();

    public SearchEngineTextMatcherEditor(JTextField textField, TextFilterator<? super E> textFilterator) {
        super(textFilterator);
        this.textField = textField;
        this.textField.addActionListener(this.filterHandler);
        this.refilter();
    }

    public void setFields(Set<Field<E>> fields) {
        this.fields.clear();
        this.fields.addAll(fields);
    }

    public Set<Field<E>> getFields() {
        return new HashSet<Field<E>>(this.fields);
    }

    public void dispose() {
        this.textField.removeActionListener(this.filterHandler);
    }

    private void refilter() {
        SearchTerm[] filterTerms = TextMatchers.parse(this.textField.getText(), this.getFields());
        this.setTextMatcher(new TextMatcher(filterTerms, this.getFilterator(), this.getMode(), this.getStrategy()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Field<E> {
        private final String name;
        private final TextFilterator<? super E> textFilterator;

        public Field(String name, TextFilterator<? super E> textFilterator) {
            if (name == null) {
                throw new IllegalArgumentException("name may not be null");
            }
            if (textFilterator == null) {
                throw new IllegalArgumentException("textFilterator may not be null");
            }
            this.name = name;
            this.textFilterator = textFilterator;
        }

        public String getName() {
            return this.name;
        }

        public TextFilterator<? super E> getTextFilterator() {
            return this.textFilterator;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Field field = (Field)o;
            return this.name.equals(field.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private class FilterHandler
    implements ActionListener {
        private FilterHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            SearchEngineTextMatcherEditor.this.refilter();
        }
    }
}

