/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.SelectionManager;
import com.mathworks.page.plottool.WaitBar;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTRecoverable;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractPlotTool
extends DTClientBase
implements DTRecoverable {
    volatile Object fFigure;
    SelectionManager fSelectionMgr;
    final Vector<Component> fInvalidFigures = new Vector();
    volatile String fGroupName = "Figures";
    protected static final String GROUP_ATTRIBUTE = "Group";
    Desktop fDesktop;
    private PlotToolDTClientListener fClientLsnr;
    private final DTClientListener proxyClientListener = new DTClientListener(){
        private boolean clientClosed = true;

        public void clientActivated(DTClientEvent dTClientEvent) {
            if (!this.clientClosed) {
                AbstractPlotTool.this.fClientLsnr.clientActivated(dTClientEvent);
            }
        }

        public void clientActivating(DTClientEvent dTClientEvent) {
            if (!this.clientClosed) {
                AbstractPlotTool.this.fClientLsnr.clientActivating(dTClientEvent);
            }
        }

        public void clientClosed(DTClientEvent dTClientEvent) {
            Component component = dTClientEvent.getClient();
            if (component == AbstractPlotTool.this) {
                AbstractPlotTool.this.fClientLsnr.clientClosed(dTClientEvent);
                this.clientClosed = true;
            }
        }

        public void clientClosing(DTClientEvent dTClientEvent) {
            if (!(dTClientEvent.getClient() instanceof AbstractPlotTool)) {
                AbstractPlotTool.this.fClientLsnr.clientClosing(dTClientEvent);
            } else if (!this.clientClosed) {
                AbstractPlotTool.this.fClientLsnr.clientClosing(dTClientEvent);
            }
        }

        public void clientDeactivated(DTClientEvent dTClientEvent) {
            if (!this.clientClosed) {
                AbstractPlotTool.this.fClientLsnr.clientDeactivated(dTClientEvent);
            }
        }

        public void clientDocked(DTClientEvent dTClientEvent) {
            if (!this.clientClosed) {
                AbstractPlotTool.this.fClientLsnr.clientDocked(dTClientEvent);
            }
        }

        public void clientDocking(DTClientEvent dTClientEvent) {
            if (!this.clientClosed) {
                AbstractPlotTool.this.fClientLsnr.clientDocking(dTClientEvent);
            }
        }

        public void clientOpened(DTClientEvent dTClientEvent) {
            Component component = dTClientEvent.getClient();
            if (component == AbstractPlotTool.this) {
                this.clientClosed = false;
                AbstractPlotTool.this.fClientLsnr.clientOpened(dTClientEvent);
            }
        }

        public void clientRelocated(DTClientEvent dTClientEvent) {
            if (!this.clientClosed) {
                AbstractPlotTool.this.fClientLsnr.clientRelocated(dTClientEvent);
            }
        }

        public void clientUndocked(DTClientEvent dTClientEvent) {
            if (!(dTClientEvent.getClient() instanceof AbstractPlotTool)) {
                AbstractPlotTool.this.fClientLsnr.clientUndocked(dTClientEvent);
            } else if (!this.clientClosed) {
                AbstractPlotTool.this.fClientLsnr.clientUndocked(dTClientEvent);
            }
        }

        public void clientUndocking(DTClientEvent dTClientEvent) {
            if (!this.clientClosed) {
                AbstractPlotTool.this.fClientLsnr.clientUndocking(dTClientEvent);
            }
        }
    };

    protected AbstractPlotTool() {
        this.constructorHelper(this.fGroupName, MatlabDesktopServices.getDesktop());
    }

    protected AbstractPlotTool(SimpleElement simpleElement) {
        this.constructorHelper(simpleElement.getAttribute(GROUP_ATTRIBUTE), MatlabDesktopServices.getDesktop());
    }

    protected AbstractPlotTool(String string, Desktop desktop) {
        this.constructorHelper(string, desktop);
    }

    private void constructorHelper(String string, Desktop desktop) {
        this.fClientLsnr = new PlotToolDTClientListener();
        this.setGroupAndDesktop(string, desktop);
        this.setStatusBar(DTClientProperty.NULL_STATUS_BAR);
        this.setMenuBar(null);
        this.setOnTopWhenUndocked(true);
    }

    protected void setParentDesktop(Desktop desktop) {
        super.setParentDesktop(desktop);
        if (this.fDesktop != null) {
            this.fDesktop.removeClientListener(this.fGroupName, this.proxyClientListener);
        }
        this.fDesktop = desktop;
        if (desktop != null) {
            desktop.addClientListener(this.fGroupName, this.proxyClientListener);
        }
    }

    public void setGroupAndDesktop(String string, Desktop desktop) {
        if (this.fDesktop != null) {
            this.fDesktop.removeClientListener(this.fGroupName, this.proxyClientListener);
        }
        super.setGroup(string);
        this.fGroupName = string;
        this.fDesktop = desktop;
        if (desktop != null) {
            desktop.addClientListener(this.fGroupName, this.proxyClientListener);
        }
    }

    protected abstract void respondToNullFigure();

    protected abstract void respondToDifferentFigure();

    public Object getFigure() {
        return this.fFigure;
    }

    public void setFigure(final Object object) {
        if (object == null || object instanceof double[] && ((double[])object).length == 0) {
            SelectionManager.retargetSelectionManagerListeners(null);
            this.respondToNullFigure();
            this.fFigure = null;
            this.fSelectionMgr = null;
            return;
        }
        if (this.fFigure == object || this.fFigure != null && this.fFigure.equals(object)) {
            return;
        }
        if (this.fFigure != object) {
            this.fFigure = object;
            SelectionManager.retargetSelectionManagerListeners(this.fFigure);
        }
        if (NativeMatlab.nativeIsMatlabThread()) {
            this.internalSetFigure(object);
        } else if (Matlab.isMatlabAvailable()) {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractPlotTool.this.internalSetFigure(object);
                }
            });
        }
    }

    protected void plotToolClosed() {
    }

    protected void plotToolOpened() {
    }

    private void internalSetFigure(Object object) {
        try {
            Object object2 = Matlab.mtFevalConsoleOutput((String)"ishandle", (Object[])new Object[]{object}, (int)1);
            if (object2 instanceof boolean[] && !((boolean[])object2)[0]) {
                return;
            }
            object2 = Matlab.mtFevalConsoleOutput((String)"getplottool", (Object[])new Object[]{object, "selectionmanager"}, (int)1);
            if (object2 != null && object2 instanceof SelectionManager) {
                Object object3;
                Object object4;
                SelectionManager selectionManager = (SelectionManager)object2;
                if (this.fSelectionMgr != null && ((object4 = this.fSelectionMgr.getFigureHandle()) == (object3 = selectionManager.getFigureHandle()) || object4 != null && object4.equals(object3))) {
                    return;
                }
                this.fSelectionMgr = selectionManager;
            }
        }
        catch (Exception exception) {
            ErrorHandler.showJavaException("getplottool", exception);
            return;
        }
        this.respondToDifferentFigure();
    }

    public boolean getFigureHandleVisibility() {
        boolean bl = true;
        assert (NativeMatlab.nativeIsMatlabThread());
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                Object object = Matlab.mtFevalConsoleOutput((String)"get", (Object[])new Object[]{this.fFigure, "HandleVisibility"}, (int)1);
                if ("off".equals(object)) {
                    bl = false;
                }
            }
            catch (Exception exception) {
                return true;
            }
        }
        return bl;
    }

    public void saveState(Document document, Element element) {
        if (element == null) {
            return;
        }
        element.setAttribute(GROUP_ATTRIBUTE, this.fGroupName);
    }

    public void restoreState(SimpleElement simpleElement) {
    }

    class PlotToolDTClientListener
    extends DTClientAdapter {
        PlotToolDTClientListener() {
        }

        public void clientClosed(DTClientEvent dTClientEvent) {
            Component component = dTClientEvent.getClient();
            if (component == AbstractPlotTool.this) {
                AbstractPlotTool.this.plotToolClosed();
            }
        }

        public void clientOpened(DTClientEvent dTClientEvent) {
            Component component = dTClientEvent.getClient();
            if (component == AbstractPlotTool.this) {
                Desktop desktop = AbstractPlotTool.this.fDesktop;
                Component component2 = desktop.getLastDocumentSelectedInGroup(AbstractPlotTool.this.fGroupName);
                if (component2 == null) {
                    WaitBar.close();
                    return;
                }
                if (!(component2 instanceof AbstractPlotTool) && desktop.isClientDocked(component2)) {
                    this.setFigureInClient(component2);
                } else {
                    AbstractPlotTool.this.setFigure(null);
                }
                this.enablePlotToolButtons();
                AbstractPlotTool.this.plotToolOpened();
            }
        }

        public void clientActivated(DTClientEvent dTClientEvent) {
            this.respondToActivate(dTClientEvent);
        }

        public void clientDocked(DTClientEvent dTClientEvent) {
            this.respondToActivate(dTClientEvent);
        }

        public void clientUndocked(DTClientEvent dTClientEvent) {
            Component component = dTClientEvent.getClient();
            if (component instanceof AbstractPlotTool) {
                return;
            }
            Desktop desktop = AbstractPlotTool.this.fDesktop;
            Component component2 = desktop.getFirstClientDockedInGroup(AbstractPlotTool.this.fGroupName);
            if (!(component2 instanceof AbstractPlotTool) && desktop.isClientDocked(component2)) {
                this.setFigureInClient(component2);
            } else {
                AbstractPlotTool.this.setFigure(null);
            }
            this.enablePlotToolButtons();
        }

        public void clientClosing(DTClientEvent dTClientEvent) {
            Component component = dTClientEvent.getClient();
            Desktop desktop = AbstractPlotTool.this.fDesktop;
            if (component == AbstractPlotTool.this) {
                this.enablePlotToolButtons();
            } else {
                if (!desktop.hasClient(component) || !desktop.isClientDocked(component)) {
                    return;
                }
                if (!(component instanceof AbstractPlotTool)) {
                    Component component2 = desktop.getLastDocumentSelectedInGroup(AbstractPlotTool.this.fGroupName);
                    if (!(component2 instanceof AbstractPlotTool) && desktop.isClientDocked(component2) && component2 != component) {
                        this.setFigureInClient(component2);
                    } else {
                        AbstractPlotTool.this.setFigure(null);
                    }
                }
            }
        }

        private void respondToActivate(DTClientEvent dTClientEvent) {
            Component component = dTClientEvent.getClient();
            if (component instanceof AbstractPlotTool) {
                return;
            }
            Desktop desktop = AbstractPlotTool.this.fDesktop;
            if (desktop.isClientDocked(component)) {
                this.setFigureInClient(component);
                this.enablePlotToolButtons();
            }
        }

        private void setFigureInClient(final Component component) {
            if (component == null) {
                WaitBar.close();
                return;
            }
            if (AbstractPlotTool.this.fInvalidFigures.contains(component)) {
                WaitBar.close();
                return;
            }
            if (Matlab.isMatlabAvailable()) {
                Matlab.whenMatlabIdle((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Object object;
                        try {
                            object = Matlab.mtFevalConsoleOutput((String)"getfigurefordesktopclient", (Object[])new Object[]{component}, (int)1);
                        }
                        catch (Exception exception) {
                            AbstractPlotTool.this.fInvalidFigures.add(component);
                            ErrorHandler.showJavaException("getfigurefordesktopclient", exception);
                            WaitBar.close();
                            return;
                        }
                        if (object != null) {
                            if (object instanceof MLArrayRef) {
                                try {
                                    object = Matlab.mtFeval((String)"java", (Object[])new Object[]{object}, (int)1);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            boolean bl = true;
                            try {
                                Object object2 = Matlab.mtFeval((String)"isempty", (Object[])new Object[]{object}, (int)1);
                                assert (object2 instanceof boolean[]);
                                boolean[] blArray = (boolean[])object2;
                                assert (blArray.length > 0);
                                bl = blArray[0];
                            }
                            catch (Exception exception) {
                                ErrorHandler.showJavaException("isempty", exception);
                            }
                            if (!bl) {
                                AbstractPlotTool.this.setFigure(object);
                            }
                        }
                        WaitBar.close();
                    }
                });
            }
        }

        private void enablePlotToolButtons() {
            Desktop desktop = AbstractPlotTool.this.fDesktop;
            final Component component = desktop.getLastDocumentSelectedInGroup(AbstractPlotTool.this.fGroupName);
            if (component == null) {
                return;
            }
            if (Matlab.isMatlabAvailable()) {
                Matlab.whenMatlabIdle((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Object object;
                        try {
                            object = Matlab.mtFevalConsoleOutput((String)"getfigurefordesktopclient", (Object[])new Object[]{component}, (int)1);
                        }
                        catch (Exception exception) {
                            ErrorHandler.showJavaException("getfigurefordesktopclient", exception);
                            return;
                        }
                        try {
                            Matlab.mtFevalConsoleOutput((String)"enableplottoolbuttons", (Object[])new Object[]{object}, (int)0);
                        }
                        catch (Exception exception) {
                            ErrorHandler.showJavaException("enableplottoolbuttons", exception);
                        }
                    }
                });
            }
        }
    }
}

