/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.figurepalette;

import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDimensionPicker;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.FigurePalette;
import com.mathworks.page.plottool.figurepalette.AbstractPalettePage;
import com.mathworks.page.plottool.figurepalette.FigurePaletteResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class AxesPalettePage
extends AbstractPalettePage {
    private int fNumSubplots = 0;
    protected String fPlotLoc;

    public AxesPalettePage() {
        this.addItem(FigurePaletteResources.getBundle().getString("axes.item.2d"), FigurePalette.makeImage("palette-subplot-plot.gif"), new Object[]{"axes", "View", new double[]{0.0, 90.0}, "Box", "on", "XGrid", "off", "YGrid", "off", "ZGrid", "off"});
        this.addItem(FigurePaletteResources.getBundle().getString("axes.item.3d"), FigurePalette.makeImage("palette-subplot-3d.gif"), new Object[]{"axes", "View", new double[]{-37.5, 30.0}, "XGrid", "on", "YGrid", "on", "ZGrid", "on"});
    }

    @Override
    public void addItem(String string, Icon icon, Object[] objectArray) {
        MJButton mJButton = new MJButton(string, icon);
        AbstractPalettePage.setupItemButton((AbstractButton)mJButton);
        mJButton.setToolTipText(FigurePaletteResources.getBundle().getString("axes.button.tooltip"));
        mJButton.addMouseListener((MouseListener)this.itemBtnLsnr);
        this.argsTable.put(mJButton, objectArray);
        JComponent jComponent = this.createItemWithArrow(mJButton);
        jComponent.setCursor(Cursor.getPredefinedCursor(12));
        this.fGridLayout.setRows(this.fGridLayout.getRows() + 1);
        this.fGridPanel.add((Component)jComponent);
    }

    @Override
    protected void onButtonPress() {
        this.fPlotLoc = "Bottom";
        final Object[] objectArray = new Object[this.fPlotArgs.length + 2];
        objectArray[0] = this.fFigure;
        objectArray[1] = this.fPlotLoc;
        System.arraycopy(this.fPlotArgs, 0, objectArray, 2, this.fPlotArgs.length);
        if (Matlab.isMatlabAvailable()) {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        Matlab.mtFeval((String)"addsubplot", (Object[])objectArray, (int)0);
                    }
                    catch (Exception exception) {
                        ErrorHandler.showJavaException("addsubplot", exception);
                        return;
                    }
                }
            });
        }
        ++this.fNumSubplots;
    }

    protected JComponent createItemWithArrow(MJButton mJButton) {
        final MJDimensionPicker mJDimensionPicker = this.createDimensionPicker(mJButton);
        final MJButton mJButton2 = new MJButton((Icon)FigurePalette.makeImage("right-arrow.gif"));
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MJButton mJButton = mJButton2;
                Rectangle rectangle = mJButton.getBounds();
                mJDimensionPicker.setOccupancy(AxesPalettePage.this.fNumSubplots);
                mJDimensionPicker.show((Component)mJButton, rectangle.width, rectangle.y);
            }
        });
        mJButton2.setToolTipText(FigurePaletteResources.getBundle().getString("axes.pullright.tooltip"));
        AbstractPalettePage.setupItemButton((AbstractButton)mJButton2);
        mJButton2.setMargin(new Insets(0, 2, 0, 5));
        mJButton2.setName(mJButton.getText() + FigurePaletteResources.getBundle().getString("axes.pullright.button.suffix"));
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.add((Component)mJButton, (Object)"Center");
        mJPanel.add((Component)mJButton2, (Object)"East");
        Color color = UIManager.getColor("List.background");
        mJPanel.setBackground(color);
        return mJPanel;
    }

    private MJDimensionPicker createDimensionPicker(MJButton mJButton) {
        Object[] objectArray = (Object[])this.argsTable.get(mJButton);
        final Object[] objectArray2 = new Object[objectArray.length - 1];
        System.arraycopy(objectArray, 1, objectArray2, 0, objectArray.length - 1);
        MJDimensionPicker mJDimensionPicker = new MJDimensionPicker(new Dimension(4, 5));
        mJDimensionPicker.setName(mJButton.getText() + "DimensionPicker");
        mJDimensionPicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component component;
                MJDimensionPicker mJDimensionPicker = (MJDimensionPicker)actionEvent.getSource();
                Dimension dimension = mJDimensionPicker.getSelectedSize();
                AxesPalettePage.this.fNumSubplots = dimension.width * dimension.height;
                final Object[] objectArray = new Object[]{"makeSubplotGrid", AxesPalettePage.this.fFigure, dimension.width, dimension.height, objectArray2};
                if (Matlab.isMatlabAvailable()) {
                    Matlab.whenMatlabIdle((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Matlab.mtFeval((String)"plottoolfunc", (Object[])objectArray, (int)0);
                            }
                            catch (Exception exception) {
                                ErrorHandler.showJavaException("makeSubplotGrid", exception);
                                return;
                            }
                        }
                    });
                }
                if ((component = AxesPalettePage.this.fSelectionMgr.getFigureCanvas()) != null) {
                    component.requestFocusInWindow();
                }
            }
        });
        return mJDimensionPicker;
    }
}

