/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.plotbrowser;

import com.mathworks.hg.types.HGColor;
import com.mathworks.hg.types.HGDouble;
import com.mathworks.hg.types.HGMeshColor;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.PlotBrowser;
import com.mathworks.page.plottool.PropertyEditor;
import com.mathworks.page.plottool.plotbrowser.MLPropertyTypeConverter;
import com.mathworks.util.CategoricalVariable;
import com.mathworks.util.Log;
import java.awt.Color;
import java.awt.SystemColor;

public class ChartObjectProxyFactory {
    public static SeriesProxy createSeriesProxy(Object object, String string) {
        if (object == null) {
            return null;
        }
        String string2 = string.replace('.', '_');
        return ChartObjectProxyFactory.createSeriesProxyFromClassName(object, string2);
    }

    public static SeriesProxy createHG2SeriesProxy(Object object, String string) {
        return ChartObjectProxyFactory.createSeriesProxy(object, string);
    }

    private static SeriesProxy createSeriesProxyFromClassName(Object object, String string) {
        SeriesProxy seriesProxy = null;
        if (string.startsWith("graph2d_lineseries") || string.startsWith("matlab_graphics_chart_primitive_Line") || string.startsWith("matlab_graphics_chart_primitive_ConstantLine") || string.startsWith("matlab_graphics_chart_primitive_FunctionLine")) {
            seriesProxy = new LineSeriesProxy(object);
        } else if (string.startsWith("specgraph_bar") || string.startsWith("matlab_graphics_chart_primitive_Bar")) {
            seriesProxy = new BarAreaSeriesProxy(object);
        } else if (string.startsWith("specgraph_stem") || string.startsWith("matlab_graphics_chart_primitive_Stem")) {
            seriesProxy = new StemSeriesProxy(object);
        } else if (string.startsWith("specgraph_stair") || string.startsWith("matlab_graphics_chart_primitive_Stair")) {
            seriesProxy = new StairSeriesProxy(object);
        } else if (string.startsWith("specgraph_area") || string.startsWith("matlab_graphics_chart_primitive_Area")) {
            seriesProxy = new BarAreaSeriesProxy(object);
        } else if (string.startsWith("specgraph_errorbar") || string.startsWith("matlab_graphics_chart_primitive_ErrorBar")) {
            seriesProxy = new ErrorbarSeriesProxy(object);
        } else if (string.startsWith("specgraph_scatter") || string.startsWith("matlab_graphics_chart_primitive_Scatter")) {
            seriesProxy = new ScatterSeriesProxy(object);
        } else if (string.startsWith("specgraph_contour") || string.startsWith("matlab_graphics_chart_primitive_Contour")) {
            seriesProxy = new ContourSeriesProxy(object);
        } else if (string.startsWith("specgraph_quiver") || string.startsWith("matlab_graphics_chart_primitive_Quiver")) {
            seriesProxy = new QuiverSeriesProxy(object);
        } else if (string.startsWith("graph3d_surfaceplot") || string.startsWith("matlab_graphics_chart_primitive_Surface")) {
            seriesProxy = new SurfaceProxy(object);
        } else if (string.startsWith("surface") || string.startsWith("matlab_graphics_primitive_Surface")) {
            seriesProxy = new SurfaceProxy(object);
        } else if (string.startsWith("image") || string.startsWith("matlab_graphics_primitive_Image")) {
            seriesProxy = new ImageProxy(object);
        } else if (string.startsWith("line") || string.startsWith("matlab_graphics_primitive_Line")) {
            seriesProxy = new LineProxy(object);
        } else if (string.startsWith("patch") || string.startsWith("matlab_graphics_primitive_Patch")) {
            seriesProxy = new PatchProxy(object);
        }
        return seriesProxy;
    }

    public static SeriesProxy[] createSeriesProxyArray(int n) {
        return new SeriesProxy[n];
    }

    public static void updateProperty(ChartObjectProxy chartObjectProxy, String string) {
        if (string.equalsIgnoreCase("HandleVisibility")) {
            chartObjectProxy.updateHandleVisibility();
        } else if (string.equalsIgnoreCase("Visible")) {
            chartObjectProxy.updateVisible();
        } else if (string.equalsIgnoreCase("DisplayName")) {
            chartObjectProxy.updateDisplayName();
        } else if (string.equalsIgnoreCase("XDataSource")) {
            chartObjectProxy.updateXDataSource();
        } else if (string.equalsIgnoreCase("YDataSource")) {
            chartObjectProxy.updateYDataSource();
        } else if (string.equalsIgnoreCase("ZDataSource")) {
            chartObjectProxy.updateZDataSource();
        } else if (string.equalsIgnoreCase("Name")) {
            chartObjectProxy.updateName();
        } else if (string.equalsIgnoreCase("Title")) {
            chartObjectProxy.updateTitle();
        } else if (string.equalsIgnoreCase("Tag")) {
            chartObjectProxy.updateTag();
        } else if (string.equalsIgnoreCase("Color")) {
            chartObjectProxy.updateColor();
        } else if (string.equalsIgnoreCase("FaceColor")) {
            chartObjectProxy.updateFaceColor();
        } else if (string.equalsIgnoreCase("EdgeColor")) {
            chartObjectProxy.updateEdgeColor();
        } else if (string.equalsIgnoreCase("LineColor")) {
            chartObjectProxy.updateLineColor();
        } else if (string.equalsIgnoreCase("LineWidth")) {
            chartObjectProxy.updateLineWidth();
        } else if (string.equalsIgnoreCase("LineStyle")) {
            chartObjectProxy.updateLineStyle();
        } else if (string.equalsIgnoreCase("Marker")) {
            chartObjectProxy.updateMarker();
        } else if (string.equalsIgnoreCase("MarkerFaceColor")) {
            chartObjectProxy.updateMarkerFaceColor();
        } else if (string.equalsIgnoreCase("MarkerEdgeColor")) {
            chartObjectProxy.updateMarkerEdgeColor();
        }
    }

    public static LineSeriesProxy createLineSeriesProxy(Object object) {
        return new LineSeriesProxy(object);
    }

    public StemSeriesProxy createStemSeriesProxy(Object object) {
        return new StemSeriesProxy(object);
    }

    public StairSeriesProxy createStairSeriesProxy(Object object) {
        return new StairSeriesProxy(object);
    }

    public ScatterSeriesProxy createScatterSeriesProxy(Object object) {
        return new ScatterSeriesProxy(object);
    }

    public QuiverSeriesProxy createQuiverSeriesProxy(Object object) {
        return new QuiverSeriesProxy(object);
    }

    public ErrorbarSeriesProxy createErrorbarSeriesProxy(Object object) {
        return new ErrorbarSeriesProxy(object);
    }

    public LineProxy createLineProxy(Object object) {
        return new LineProxy(object);
    }

    public BarAreaSeriesProxy createBarAreaSeriesProxy(Object object) {
        return new BarAreaSeriesProxy(object);
    }

    public PatchProxy createPatchProxy(Object object) {
        return new PatchProxy(object);
    }

    public SurfaceProxy createSurfaceProxy(Object object) {
        return new SurfaceProxy(object);
    }

    public ImageProxy createImageProxy(Object object) {
        return new ImageProxy(object);
    }

    public static class ImageProxy
    extends SeriesProxy {
        protected Color color1 = new Color(255, 255, 255);
        protected Color color2 = new Color(231, 231, 255);
        protected Color color3 = new Color(198, 198, 255);
        protected Color color4 = new Color(156, 156, 255);
        protected Color color5 = new Color(132, 132, 255);
        protected Color color6 = new Color(16, 16, 255);

        ImageProxy(Object object) {
            super(object);
        }

        public Color getColor1() {
            return this.color1;
        }

        public Color getColor2() {
            return this.color2;
        }

        public Color getColor3() {
            return this.color3;
        }

        public Color getColor4() {
            return this.color4;
        }

        public Color getColor5() {
            return this.color5;
        }

        public Color getColor6() {
            return this.color6;
        }
    }

    public static class SurfaceProxy
    extends SeriesProxy {
        protected Color edgeColor;
        protected Color faceColor;

        public SurfaceProxy(Object object) {
            super(object);
        }

        public Color getFaceColor() {
            return this.faceColor;
        }

        public Color getEdgeColor() {
            return this.edgeColor;
        }

        @Override
        public void updateDisplayName() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("DisplayName");
            this.name = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateXDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("XDataSource");
            this.xDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateYDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("YDataSource");
            this.yDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateZDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("ZDataSource");
            this.zDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateEdgeColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("EdgeColor");
            if (object instanceof MLArrayRef) {
                object = MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, 3);
            }
            this.edgeColor = object == null || !(object instanceof HGMeshColor) ? Color.black : (((HGMeshColor)object).getStyle() != -1 ? new Color(16, 16, 255) : HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object)));
        }

        @Override
        public void updateFaceColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("FaceColor");
            if (object instanceof MLArrayRef) {
                object = MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, 0);
            }
            this.faceColor = object == null || !(object instanceof HGMeshColor) || ((HGMeshColor)object).getStyle() == 0 ? SystemColor.text : (((HGMeshColor)object).getStyle() != -1 ? new Color(16, 16, 255) : HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object)));
        }
    }

    public static class PatchProxy
    extends SeriesProxy {
        protected Color edgeColor;
        protected Color faceColor;

        public PatchProxy(Object object) {
            super(object);
        }

        public Color getFaceColor() {
            return this.faceColor;
        }

        public Color getEdgeColor() {
            return this.edgeColor;
        }

        @Override
        public void updateFaceColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("FaceColor");
            if (object instanceof MLArrayRef) {
                object = MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, 3);
            }
            if (object == null || !(object instanceof HGMeshColor) || ((HGMeshColor)object).getStyle() == 0) {
                this.faceColor = SystemColor.text;
            } else if (((HGMeshColor)object).getStyle() != -1) {
                this.faceColor = new Color(16, 16, 255);
                try {
                    Object object2 = Matlab.mtFeval((String)"plottoolfunc", (Object[])new Object[]{"getBarAreaColor", this.chartObject}, (int)1);
                    if (object2 != null && object2 instanceof double[]) {
                        double[] dArray = (double[])object2;
                        this.faceColor = new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]);
                    }
                }
                catch (Exception exception) {
                    Log.log((String)exception.toString());
                }
            } else {
                this.faceColor = HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object));
            }
        }

        @Override
        public void updateEdgeColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("EdgeColor");
            if (object instanceof MLArrayRef) {
                object = MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, 3);
            }
            this.edgeColor = object == null || !(object instanceof HGMeshColor) ? Color.black : (((HGMeshColor)object).getStyle() != -1 ? new Color(16, 16, 255) : HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object)));
        }

        @Override
        public void updateDisplayName() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("DisplayName");
            this.name = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }
    }

    public static class ContourSeriesProxy
    extends SeriesProxy {
        protected Color outerColor;
        protected Color innerColor;

        ContourSeriesProxy(Object object) {
            super(object);
        }

        public Color getOuterColor() {
            return this.outerColor;
        }

        public Color getInnerColor() {
            return this.innerColor;
        }

        @Override
        public void updateDisplayName() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("DisplayName");
            this.name = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateXDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("XDataSource");
            this.xDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateYDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("YDataSource");
            this.yDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateZDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("ZDataSource");
            this.zDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateLineColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("LineColor");
            if (object instanceof MLArrayRef) {
                object = PropertyEditor.isHGUsingMATLABClasses() ? MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, 3) : MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, 1);
            }
            if (object instanceof HGMeshColor && PropertyEditor.isHGUsingMATLABClasses() && (((HGMeshColor)object).getStyle() == 0 || ((HGMeshColor)object).getStyle() == 1)) {
                this.outerColor = Color.blue;
                this.innerColor = Color.red;
            } else if (object instanceof HGMeshColor && !PropertyEditor.isHGUsingMATLABClasses() && ((HGMeshColor)object).getStyle() == 4) {
                this.outerColor = Color.blue;
                this.innerColor = Color.red;
            } else {
                Color color;
                this.outerColor = color = HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object));
                this.innerColor = color;
            }
        }
    }

    public static class BarAreaSeriesProxy
    extends SeriesProxy {
        protected Color faceColor;
        protected Color edgeColor;

        BarAreaSeriesProxy(Object object) {
            super(object);
        }

        public Color getFaceColor() {
            return this.faceColor;
        }

        public Color getEdgeColor() {
            return this.edgeColor;
        }

        @Override
        public void updateDisplayName() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("DisplayName");
            this.name = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateXDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("XDataSource");
            this.xDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateYDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("YDataSource");
            this.yDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateFaceColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("FaceColor");
            if (object instanceof MLArrayRef) {
                object = MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, 3);
            }
            if (object == null || !(object instanceof HGMeshColor)) {
                this.faceColor = Color.black;
            } else if (((HGMeshColor)object).getStyle() != -1) {
                Color color = new Color(16, 16, 255);
                try {
                    Object object2 = Matlab.mtFeval((String)"plottoolfunc", (Object[])new Object[]{"getBarAreaColor", this.chartObject}, (int)1);
                    if (object2 != null && object2 instanceof double[]) {
                        double[] dArray = (double[])object2;
                        color = new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]);
                    }
                }
                catch (Exception exception) {
                    ErrorHandler.showJavaException("getBarAreaColor", exception);
                }
                this.faceColor = color;
            } else {
                this.faceColor = HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object));
            }
        }

        @Override
        public void updateEdgeColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("EdgeColor");
            if (object instanceof MLArrayRef) {
                object = MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, 3);
            }
            this.edgeColor = object == null || !(object instanceof HGMeshColor) ? Color.black : (((HGMeshColor)object).getStyle() != -1 ? this.faceColor : HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object)));
        }
    }

    public static class LineProxy
    extends OneDimSeriesProxy {
        LineProxy(Object object) {
            super(object);
        }

        @Override
        public void updateTag() {
            Object object;
            this.name = this.chartObject.getClass().getName().startsWith("graph2d_constantline") || this.chartObject.getClass().getName().startsWith("matlab_graphics_chart_primitive_ConstantLine") || this.chartObject.getClass().getName().startsWith("matlab_graphics_chart_primitive_FunctionLine") ? ((object = ((UDDObject)this.chartObject).getPropertyValue("Tag")) instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object) : "";
        }
    }

    public static class ErrorbarSeriesProxy
    extends OneDimSeriesProxy {
        ErrorbarSeriesProxy(Object object) {
            super(object);
        }
    }

    public static class QuiverSeriesProxy
    extends OneDimSeriesProxy {
        QuiverSeriesProxy(Object object) {
            super(object);
        }
    }

    public static class ScatterSeriesProxy
    extends OneDimSeriesProxy {
        ScatterSeriesProxy(Object object) {
            super(object);
        }
    }

    public static class StairSeriesProxy
    extends OneDimSeriesProxy {
        StairSeriesProxy(Object object) {
            super(object);
        }
    }

    public static class StemSeriesProxy
    extends OneDimSeriesProxy {
        StemSeriesProxy(Object object) {
            super(object);
        }
    }

    public static class LineSeriesProxy
    extends OneDimSeriesProxy {
        LineSeriesProxy(Object object) {
            super(object);
        }
    }

    public static abstract class OneDimSeriesProxy
    extends SeriesProxy {
        protected Color lineColor;
        protected int lineStyle = 4;
        protected double lineWidth;
        protected int marker = 13;
        protected Color markerFaceColor;
        protected Color markerEdgeColor;

        OneDimSeriesProxy(Object object) {
            super(object);
        }

        public Color getLineColor() {
            return this.lineColor;
        }

        public int getLineStyle() {
            return this.lineStyle;
        }

        public double getLineWidth() {
            return this.lineWidth;
        }

        public int getMarker() {
            return this.marker;
        }

        public Color getMarkerFaceColor() {
            return this.markerFaceColor;
        }

        public Color getMarkerEdgeColor() {
            return this.markerEdgeColor;
        }

        @Override
        public void updateDisplayName() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("DisplayName");
            this.name = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateXDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("XDataSource");
            this.xDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateYDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("YDataSource");
            this.yDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateZDataSource() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("ZDataSource");
            this.zDataSource = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseString((MLArrayRef)object) : (String)object;
        }

        @Override
        public void updateColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("Color");
            this.lineColor = object instanceof MLArrayRef ? MLPropertyTypeConverter.parseColor((MLArrayRef)object) : this.setupColorValue(object);
            this.updateMarkerEdgeColor();
        }

        @Override
        public void updateLineWidth() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("LineWidth");
            if (object instanceof MLArrayRef) {
                this.lineWidth = MLPropertyTypeConverter.parseDouble((MLArrayRef)object);
            } else if (object instanceof HGDouble) {
                this.lineWidth = ((HGDouble)object).getValue();
            } else if (object instanceof Double) {
                this.lineWidth = (Double)object;
            }
        }

        @Override
        public void updateLineStyle() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("LineStyle");
            if (object instanceof MLArrayRef) {
                this.lineStyle = MLPropertyTypeConverter.parseLineStyle((MLArrayRef)object);
            } else if (object instanceof CategoricalVariable) {
                this.lineStyle = (Integer)((CategoricalVariable)object).getValue();
            } else if (object instanceof Integer) {
                this.lineStyle = (Integer)object;
            }
        }

        @Override
        public void updateMarker() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("Marker");
            if (object instanceof MLArrayRef) {
                this.marker = MLPropertyTypeConverter.parseMarker((MLArrayRef)object);
            } else if (object instanceof CategoricalVariable) {
                this.marker = (Integer)((CategoricalVariable)object).getValue();
            } else if (object instanceof Integer) {
                this.marker = (Integer)object;
            }
        }

        @Override
        public void updateMarkerFaceColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("MarkerFaceColor");
            if (object instanceof MLArrayRef) {
                object = MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, 1);
            }
            this.markerFaceColor = object != null && object instanceof HGMeshColor && ((HGMeshColor)object).getStyle() == 4 ? null : this.setupColorValue(object);
        }

        @Override
        public void updateMarkerEdgeColor() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("MarkerEdgeColor");
            if (object instanceof MLArrayRef) {
                object = MLPropertyTypeConverter.parseHGMeshColor((MLArrayRef)object, 1);
            }
            if (object instanceof MLArrayRef) {
                this.markerFaceColor = MLPropertyTypeConverter.parseAutoManColor((MLArrayRef)object);
                return;
            }
            this.markerEdgeColor = object != null && object instanceof HGMeshColor && ((HGMeshColor)object).getStyle() == 4 ? this.lineColor : this.setupColorValue(object);
        }

        protected Color setupColorValue(Object object) {
            Color color = null;
            if (object == null) {
                return null;
            }
            if (object instanceof HGColor) {
                color = HGColor.getColor((HGColor)((HGColor)object));
            } else if (object instanceof HGMeshColor) {
                if (((HGMeshColor)object).getStyle() == 0) {
                    return null;
                }
                color = ((HGMeshColor)object).getStyle() == -1 ? HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object)) : new Color(16, 16, 255);
            }
            return color;
        }
    }

    public static abstract class SeriesProxy
    extends ChartObjectProxy {
        SeriesProxy(Object object) {
            super(object);
        }
    }

    public static abstract class ChartObjectProxy
    extends PlotBrowser.BrowserItem {
        public Object chartObject;
        public String name;
        public String xDataSource;
        public String yDataSource;
        public String zDataSource;
        public Boolean isVisible = Boolean.TRUE;
        protected boolean isHandleVisible = true;
        public ChartObjectProxy parent;

        public ChartObjectProxy(Object object) {
            this.chartObject = object;
        }

        public Object getChartObject() {
            return this.chartObject;
        }

        public String getName() {
            return this.name;
        }

        public Boolean getVisible() {
            return this.isVisible;
        }

        public Boolean getHandleVisibility() {
            return this.isHandleVisible;
        }

        public String getXDataSource() {
            return this.xDataSource;
        }

        public String getYDataSource() {
            return this.yDataSource;
        }

        public String getZDataSource() {
            return this.zDataSource;
        }

        public void updateHandleVisibility() {
            Boolean bl;
            Object object = ((UDDObject)this.chartObject).getPropertyValue("HandleVisibility");
            Integer n = -1;
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            } else {
                if (object instanceof MLArrayRef) {
                    this.isHandleVisible = MLPropertyTypeConverter.parseOnOff((MLArrayRef)object);
                    return;
                }
                if (object instanceof CategoricalVariable) {
                    n = (Integer)((CategoricalVariable)object).getValue();
                } else if (object instanceof Integer) {
                    n = (Integer)object;
                }
                Boolean bl2 = bl = n.equals(2) ? Boolean.FALSE : Boolean.TRUE;
            }
            if (Boolean.valueOf(this.isHandleVisible).equals(bl)) {
                return;
            }
            this.isHandleVisible = bl;
        }

        public void updateVisible() {
            Object object = ((UDDObject)this.chartObject).getPropertyValue("Visible");
            Integer n = -1;
            if (object instanceof Boolean) {
                this.isVisible = (Boolean)object;
                return;
            }
            if (object instanceof MLArrayRef) {
                this.isVisible = MLPropertyTypeConverter.parseOnOff((MLArrayRef)object);
                return;
            }
            if (object instanceof CategoricalVariable) {
                n = (Integer)((CategoricalVariable)object).getValue();
            } else if (object instanceof Integer) {
                n = (Integer)object;
            }
            this.isVisible = n.equals(1) ? Boolean.TRUE : Boolean.FALSE;
        }

        public void updateDisplayName() {
        }

        public void updateXDataSource() {
        }

        public void updateYDataSource() {
        }

        public void updateZDataSource() {
        }

        public void updateName() {
        }

        public void updateTitle() {
        }

        public void updateTag() {
        }

        public void updateColor() {
        }

        public void updateFaceColor() {
        }

        public void updateEdgeColor() {
        }

        public void updateLineColor() {
        }

        public void updateLineWidth() {
        }

        public void updateLineStyle() {
        }

        public void updateMarker() {
        }

        public void updateMarkerFaceColor() {
        }

        public void updateMarkerEdgeColor() {
        }

        public void setTitleString(String string) {
        }

        public String toString() {
            return this.name;
        }
    }
}

