/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.controls;

import com.mathworks.hg.types.HGColor;
import com.mathworks.hg.types.HGMeshColor;
import com.mathworks.mlwidgets.graphics.ColorPicker;
import com.mathworks.page.plottool.plotbrowser.MLPropertyTypeConverter;
import com.mathworks.page.plottool.propertyeditor.controls.PropertyControl;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.event.CellEditorListener;

public class ColorControl
extends PropertyControl {
    protected ColorPicker fColor;

    public ColorControl(String string, CellEditorListener cellEditorListener, int n, int n2, String string2, String string3) {
        super(string, cellEditorListener);
        this.constructorHelper(n, n2, string2);
        this.setMaximumSize(new Dimension(this.fColor.getPreferredSize().width, this.fColor.getPreferredSize().height));
        this.fColor.setName(string3 + "." + string);
    }

    private void constructorHelper(int n, int n2, String string) {
        this.fColor = new ColorPicker(n, n2, string);
        this.setCustomEditor((JComponent)this.fColor);
    }

    @Override
    public String getName() {
        if (this.fColor != null) {
            return this.fColor.getName() + "." + this.getClass().getSimpleName();
        }
        return null;
    }

    @Override
    public void addEditStoppedSupport() {
        this.fColor.addActionListener(this.action);
    }

    @Override
    public void setDisplayedValue(Object object) {
        if (object == PropertyControl.MIXED_VALUES) {
            this.fColor.setValueWithoutEvents(null);
        } else if (object instanceof Color) {
            this.fColor.setValueWithoutEvents(object);
        } else if (object instanceof HGColor) {
            this.fColor.setValueWithoutEvents((Object)HGColor.getColor((HGColor)((HGColor)object)));
        } else if (object instanceof HGMeshColor) {
            this.fColor.setValueWithoutEvents((Object)HGMeshColor.getColor((HGMeshColor)((HGMeshColor)object)));
        }
    }

    @Override
    public Object getDisplayedValue() {
        Object object;
        Object object2 = this.fColor.getValue();
        String string = this.getPropertyType().getName();
        if (string.endsWith("MLArrayRef") || string.equals("java.lang.Object")) {
            string = MLPropertyTypeConverter.lookupDataType(this.getPropertyName(), this.getValue().getClass().getName());
        }
        if (object2 instanceof Color) {
            Color color = (Color)object2;
            if (string.equals("com.mathworks.hg.types.HGColor")) {
                float[] fArray = color.getRGBColorComponents(null);
                object = new HGColor((double)fArray[0], (double)fArray[1], (double)fArray[2]);
            } else if (string.equals("com.mathworks.hg.types.HGMeshColor")) {
                float[] fArray = color.getRGBColorComponents(null);
                object = new HGMeshColor((double)fArray[0], (double)fArray[1], (double)fArray[2], 0);
            } else {
                object = color;
            }
        } else if (object2 instanceof String && string.equals("com.mathworks.hg.types.HGMeshColor")) {
            int n = 0;
            if (object2.equals("flat")) {
                n = 1;
            } else if (object2.equals("interp")) {
                n = 2;
            } else if (object2.equals("texturemap")) {
                n = 3;
            } else if (object2.equals("auto")) {
                n = 4;
            }
            object = new HGMeshColor(n, 0);
        } else {
            object = object2;
        }
        return object;
    }
}

