/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.controls;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.propertyeditor.PropertyEditorResources;
import com.mathworks.page.plottool.propertyeditor.controls.AbstractMultiFieldControl;
import com.mathworks.page.plottool.propertyeditor.controls.PropertyControl;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;

public class CurvatureControl
extends AbstractMultiFieldControl {
    protected MJTextField fXTF = new MJTextField();
    protected MJTextField fYTF = new MJTextField();
    protected double[] fCurrentCurvature = new double[2];
    private static int NO_SECOND_ELEMENT = -1;
    private String fPrevXText;
    private String fPrevYText;

    public CurvatureControl(String string, CellEditorListener cellEditorListener, String string2) {
        super(string, cellEditorListener);
        this.constructorHelper();
        this.setName(string2 + "." + string);
    }

    public void setName(String string) {
        if (this.fXTF != null && this.fYTF != null) {
            this.fXTF.setName(string + ".X");
            this.fYTF.setName(string + ".Y");
        }
    }

    private void constructorHelper() {
        this.fXTF.addFocusListener(this.focusLsnr);
        this.fYTF.addFocusListener(this.focusLsnr);
        this.fXTF.addActionListener(this.actionLsnr);
        this.fYTF.addActionListener(this.actionLsnr);
        this.fXTF.addKeyListener((KeyListener)this.enterLsnr);
        this.fYTF.addKeyListener((KeyListener)this.enterLsnr);
        GridLayout gridLayout = new GridLayout(1, 2, 5, 5);
        MJPanel mJPanel = new MJPanel((LayoutManager)gridLayout);
        mJPanel.add((Component)this.fXTF);
        mJPanel.add((Component)this.fYTF);
        this.setCustomEditor((JComponent)mJPanel);
        this.fXTF.setToolTipText("X");
        this.fYTF.setToolTipText("Y");
    }

    @Override
    protected void doEventResponse(JTextField jTextField) {
        String string = jTextField.getText();
        boolean bl = jTextField.getName().endsWith("X");
        if (bl && (string == null || string.length() == 0)) {
            this.fXTF.setText(this.fPrevXText);
            return;
        }
        if (!string.equals((String)PropertyControl.MIXED_VALUES)) {
            if (!(bl || string != null && string.length() != 0)) {
                this.fCurrentCurvature[1] = NO_SECOND_ELEMENT;
            } else {
                double d;
                try {
                    d = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorHandler.showSimpleError(MessageFormat.format(PropertyEditorResources.getBundle().getString("PropertyControl.error.parse"), string), this.getTopLevelAncestor());
                    if (bl) {
                        this.fXTF.setText(this.fPrevXText);
                        this.fXTF.requestFocus();
                    } else {
                        this.fYTF.setText(this.fPrevYText);
                        this.fYTF.requestFocus();
                    }
                    return;
                }
                if (d < 0.0 || d > 1.0) {
                    ErrorHandler.showSimpleError(MessageFormat.format(PropertyEditorResources.getBundle().getString("PropertyControl.error.normalized"), new Double(d)), this.getTopLevelAncestor());
                    if (bl) {
                        this.fXTF.setText(this.fPrevXText);
                        this.fXTF.requestFocus();
                    } else {
                        this.fYTF.setText(this.fPrevYText);
                        this.fYTF.requestFocus();
                    }
                    return;
                }
                this.fCurrentCurvature[bl ? 0 : 1] = d;
            }
        }
    }

    @Override
    public void setDisplayedValue(Object object) {
        String string = null;
        String string2 = null;
        if (object == null) {
            string = this.fPrevXText;
        } else if (object == PropertyControl.MIXED_VALUES) {
            string = string2 = (String)PropertyControl.MIXED_VALUES;
        } else {
            double[] dArray;
            String string3 = object.getClass().getName();
            if (string3.startsWith("[D") && (dArray = (double[])object).length > 0) {
                this.fCurrentCurvature[0] = dArray[0];
                string = this.fNumberFormat.format(dArray[0]);
                if (dArray.length == 1) {
                    this.fCurrentCurvature[1] = NO_SECOND_ELEMENT;
                    string2 = "";
                } else {
                    this.fCurrentCurvature[1] = dArray[1];
                    string2 = this.fNumberFormat.format(dArray[1]);
                }
            }
        }
        this.fPrevXText = string;
        this.fPrevYText = string2;
        this.fXTF.setText(string);
        this.fYTF.setText(string2);
    }

    @Override
    public Object getDisplayedValue() {
        double[] dArray;
        if (this.fCurrentCurvature[1] == (double)NO_SECOND_ELEMENT) {
            double[] dArray2 = new double[1];
            dArray = dArray2;
            dArray2[0] = this.fCurrentCurvature[0];
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = this.fCurrentCurvature[0];
            dArray = dArray3;
            dArray3[1] = this.fCurrentCurvature[1];
        }
        double[] dArray4 = dArray;
        return dArray4;
    }

    @Override
    public void addEditStoppedSupport() {
        this.fXTF.addActionListener(this.action);
        this.fXTF.addFocusListener((FocusListener)this.focus);
        this.fXTF.addKeyListener((KeyListener)this.enterKey);
        this.fYTF.addActionListener(this.action);
        this.fYTF.addFocusListener((FocusListener)this.focus);
        this.fYTF.addKeyListener((KeyListener)this.enterKey);
    }

    public void setEnabled(boolean bl) {
        this.fXTF.setEnabled(bl);
        this.fYTF.setEnabled(bl);
    }

    @Override
    protected void propertyEditStopped() {
        if (this.fXTF.getText().equals(PropertyControl.MIXED_VALUES) || this.fYTF.getText().equals(PropertyControl.MIXED_VALUES)) {
            return;
        }
        super.propertyEditStopped();
    }
}

