/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.controls;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.plotbrowser.MLPropertyTypeConverter;
import com.mathworks.page.plottool.propertyeditor.BeanManager;
import com.mathworks.page.plottool.propertyeditor.PropertyEditorResources;
import com.mathworks.page.plottool.propertyeditor.controls.ValueStringVector;
import com.mathworks.page.plottool.propertyeditor.panels.PropertyPanel;
import com.mathworks.util.QueueEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.VetoableChangeListener;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;

public abstract class PropertyControl
extends MJPanel
implements TableCellRenderer,
TableCellEditor,
PropertyChangeListener,
VetoableChangeListener {
    protected transient CellEditorListener[] fCellListeners = new CellEditorListener[0];
    protected int fNCellListeners;
    private PropertyDescriptor fProperty = null;
    private Object fValue = null;
    private String fPropertyName = null;
    protected AbstractTableModel fTableModel = null;
    protected JTable fTable = null;
    protected JTree fTree = null;
    protected TreePath fPath = null;
    protected JButton fbtnDialog = null;
    protected JComponent fEditor = null;
    protected boolean fLeftOfEditor = true;
    protected final ValueStringVector fValueString = new ValueStringVector();
    public static final Object MIXED_VALUES = PropertyEditorResources.getBundle().getString("value.mixed");
    private final Vector<UDDPropertyChangeListener> uddLsnrs = new Vector();
    protected FocusAdapter focus = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent focusEvent) {
            PropertyControl.this.propertyEditStopped();
        }
    };
    protected KeyAdapter enterKey = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 && !(PropertyControl.this.fEditor instanceof JTextArea)) {
                PropertyControl.this.propertyEditStopped();
                keyEvent.consume();
            }
        }
    };
    protected MouseAdapter mouse = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            PropertyControl.this.propertyEditStopped();
        }
    };
    protected ActionListener action = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PropertyControl.this.propertyEditStopped();
        }
    };

    public PropertyControl() {
    }

    public PropertyControl(String string, CellEditorListener cellEditorListener) {
        this.setPropertyName(string);
        this.addCellEditorListener(cellEditorListener);
        if (cellEditorListener instanceof PropertyPanel) {
            ((PropertyPanel)cellEditorListener).registerControl(this);
        }
    }

    public void initialize(Object[] objectArray, String string) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        Object object = objectArray[0];
        if (object == null || object instanceof UDDObject && !((UDDObject)object).isValid()) {
            return;
        }
        PropertyDescriptor propertyDescriptor = BeanManager.getProperty(object, string);
        if (propertyDescriptor == null) {
            if (MLPropertyTypeConverter.isSupportedProperty(string.toLowerCase(), object.getClass().getName())) {
                Object[] objectArray2 = new Object[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = MLPropertyTypeConverter.getProperty(objectArray[i], string);
                    if (!(objectArray2[i] instanceof MLArrayRef)) continue;
                    objectArray2[i] = MLPropertyTypeConverter.parseMLArrayRef((MLArrayRef)objectArray2[i], string, objectArray[i].getClass().getName());
                }
                this.initializeMultipleValues(null, objectArray2);
                return;
            }
            this.disableEditor();
            return;
        }
        Object[] objectArray3 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray3[i] = propertyDescriptor.getPropertyType() == MLArrayRef.class || propertyDescriptor.getPropertyType() == Object.class ? MLPropertyTypeConverter.getProperty(objectArray[i], propertyDescriptor) : BeanManager.getPropertyValue(objectArray[i], propertyDescriptor);
            if (!(objectArray3[i] instanceof MLArrayRef)) continue;
            objectArray3[i] = MLPropertyTypeConverter.parseMLArrayRef((MLArrayRef)objectArray3[i], propertyDescriptor, objectArray[i].getClass().getName());
        }
        this.initializeMultipleValues(propertyDescriptor, objectArray3);
    }

    public void initialize(Object object, String string) {
        PropertyDescriptor propertyDescriptor = BeanManager.getProperty(object, string);
        if (propertyDescriptor == null) {
            if (MLPropertyTypeConverter.isSupportedProperty(string.toLowerCase(), object.getClass().getName())) {
                Object object2 = MLPropertyTypeConverter.getProperty(object, string);
                if (object2 instanceof MLArrayRef) {
                    object2 = MLPropertyTypeConverter.parseMLArrayRef((MLArrayRef)object2, propertyDescriptor, object.getClass().getName());
                }
                this.initialize(null, object2);
                return;
            }
            this.disableEditor();
            return;
        }
        Object object3 = propertyDescriptor.getPropertyType() == MLArrayRef.class || propertyDescriptor.getPropertyType() == Object.class ? MLPropertyTypeConverter.getProperty(object, propertyDescriptor) : BeanManager.getPropertyValue(object, propertyDescriptor);
        if (object3 instanceof MLArrayRef) {
            object3 = MLPropertyTypeConverter.parseMLArrayRef((MLArrayRef)object3, propertyDescriptor, object.getClass().getName());
        }
        this.initialize(propertyDescriptor, object3);
    }

    protected void initialize(Object object, String string, Object object2) {
        PropertyDescriptor propertyDescriptor = BeanManager.getProperty(object, string);
        this.initialize(propertyDescriptor, object2);
    }

    public void initialize(PropertyDescriptor propertyDescriptor, Object object, String string) {
        this.fValueString.putValueString(string, object);
        this.initialize(propertyDescriptor, object);
    }

    protected void postInitializeUsingPropContent(Object object) {
    }

    public void initializeMultipleValues(PropertyDescriptor propertyDescriptor, Object[] objectArray) {
        this.fProperty = propertyDescriptor;
        final Object[] objectArray2 = Arrays.copyOf(objectArray, objectArray.length);
        if (SwingUtilities.isEventDispatchThread()) {
            this.postInitializeUsingPropContent(objectArray2);
            this.setValue(objectArray, true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PropertyControl.this.postInitializeUsingPropContent(objectArray2);
                    PropertyControl.this.setValue(objectArray2, true);
                }
            });
        }
        if (this.fEditor != null && propertyDescriptor != null && propertyDescriptor.getWriteMethod() == null) {
            this.disableEditor();
        }
        this.initialize();
    }

    public void initialize(PropertyDescriptor propertyDescriptor, Object object) {
        this.fProperty = propertyDescriptor;
        final Object object2 = object;
        if (SwingUtilities.isEventDispatchThread()) {
            this.postInitializeUsingPropContent(object2);
            this.setValue(object);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PropertyControl.this.postInitializeUsingPropContent(object2);
                    PropertyControl.this.setValue(object2);
                }
            });
        }
        if (this.fEditor != null && propertyDescriptor != null && propertyDescriptor.getWriteMethod() == null) {
            this.disableEditor();
        }
        this.initialize();
    }

    protected void initialize() {
        this.addEditStoppedSupport();
    }

    private void disableEditor() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.fEditor.setEnabled(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PropertyControl.this.fEditor.setEnabled(false);
                }
            });
        }
    }

    public void setWidth(int n) {
        this.setPreferredSize(new Dimension(n, this.getPreferredSize().height));
    }

    public void setMinimumWidth(int n) {
        this.setMinimumSize(new Dimension(n, this.getMinimumSize().height));
    }

    public abstract String getName();

    public void setValueStrings(String[] stringArray, Object[] objectArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.putValueString(stringArray[i], objectArray[i]);
        }
    }

    public void putValueString(String string, Object object) {
        this.fValueString.putValueString(string, object);
    }

    public Object stringToValue(String string) {
        return this.fValueString.stringToValue(string);
    }

    public String valueToString(Object object) {
        return this.fValueString.valueToString(object);
    }

    public void setTreePath(TreePath treePath) {
        this.fPath = treePath;
    }

    public void setTable(JTable jTable) {
        this.fTable = jTable;
        this.fTableModel = (AbstractTableModel)jTable.getModel();
    }

    public void setTree(JTree jTree) {
        this.fTree = jTree;
    }

    public TreePath getTreePath() {
        return this.fPath;
    }

    protected boolean isCellInTable() {
        return this.fPath != null;
    }

    public String getPropertyName() {
        if (this.fProperty != null) {
            this.fPropertyName = this.fProperty.getName();
        }
        return this.fPropertyName;
    }

    public void setPropertyName(String string) {
        this.fPropertyName = string;
        this.setName(string);
    }

    public Class getPropertyType() {
        if (this.fProperty == null) {
            return Object.class;
        }
        return this.fProperty.getPropertyType();
    }

    public abstract Object getDisplayedValue();

    public abstract void setDisplayedValue(Object var1);

    public void setValue(Object object) {
        this.fValue = object;
        if (this.isCellInTable()) {
            this.fTableModel.setValueAt(object, this.fTree.getRowForPath(this.fPath), 0);
        }
        this.setDisplayedValue(object);
        if (this.fTable != null) {
            this.fTable.repaint();
        }
    }

    public void setValue(Object[] objectArray, boolean bl) {
        if (objectArray.length == 1) {
            this.setValue(objectArray[0]);
            return;
        }
        boolean bl2 = true;
        Object object = objectArray[0];
        for (int i = 1; i < objectArray.length; ++i) {
            if (object == objectArray[i] || object != null && object.equals(objectArray[i])) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            this.setValue(object);
        } else {
            this.fValue = objectArray;
            if (this.isCellInTable()) {
                this.fTableModel.setValueAt(MIXED_VALUES, this.fTree.getRowForPath(this.fPath), 0);
            }
            this.setDisplayedValue(MIXED_VALUES);
            if (this.fTable != null) {
                this.fTable.repaint();
            }
        }
    }

    public Object getValue() {
        return this.fValue;
    }

    public JButton getDialogButton() {
        return this.fbtnDialog;
    }

    public Component getCustomEditor() {
        return this.fEditor;
    }

    public void setCustomEditor(JComponent jComponent) {
        this.setCustomEditor(jComponent, null, this.fLeftOfEditor);
    }

    public void setCustomEditor(JComponent jComponent, JButton jButton) {
        this.setCustomEditor(jComponent, jButton, this.fLeftOfEditor);
    }

    public void setCustomEditor(JComponent jComponent, JButton jButton, boolean bl) {
        this.fEditor = jComponent;
        this.fbtnDialog = jButton;
        this.fLeftOfEditor = bl;
        if (this.fbtnDialog != null) {
            jButton.setPreferredSize(new Dimension(20, 20));
        }
        this.initComponentPanel();
    }

    public JPanel getComponentPanel() {
        return this;
    }

    public void initComponentPanel() {
        this.removeAll();
        this.setLayout(new GridLayout(1, 1));
        if (this.fEditor instanceof JTextArea) {
            MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fEditor);
            mJScrollPane.setHorizontalScrollBarPolicy(30);
            this.add((Component)mJScrollPane);
        } else {
            this.add(this.fEditor);
        }
        this.fEditor.setToolTipText(this.fPropertyName);
        this.setToolTipText(this.fPropertyName);
        this.setMinimumWidth(50);
    }

    protected void addDialogButton(GridBagConstraints gridBagConstraints) {
        if (this.fbtnDialog != null) {
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this.add(this.fbtnDialog, gridBagConstraints);
        }
    }

    protected void propertyEditCanceled() {
    }

    protected void propertyEditStopped() {
        Object object = this.getValue();
        Object object2 = this.getDisplayedValue();
        if (object == null && object2 == null || object != null && object.equals(object2)) {
            return;
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = this.fNCellListeners - 1; i >= 0; --i) {
            this.fCellListeners[i].editingStopped(changeEvent);
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        jTable.setValueAt(object, n, n2);
        return this;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        int n;
        for (n = this.fNCellListeners - 1; n >= 0 && !cellEditorListener.equals(this.fCellListeners[n]); --n) {
        }
        if (n > 0) {
            if (n < this.fNCellListeners - 1) {
                System.arraycopy(this.fCellListeners, n, this.fCellListeners, n - 1, this.fNCellListeners - n);
            }
            --this.fNCellListeners;
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.ensureCapacity(this.fNCellListeners + 1);
        this.fCellListeners[this.fNCellListeners++] = cellEditorListener;
    }

    public void clearCellEditorListeners() {
        this.fCellListeners = new CellEditorListener[0];
        this.fNCellListeners = 0;
    }

    protected void ensureCapacity(int n) {
        if (n >= this.fCellListeners.length) {
            CellEditorListener[] cellEditorListenerArray = new CellEditorListener[1 + n + n / 2];
            System.arraycopy(this.fCellListeners, 0, cellEditorListenerArray, 0, this.fNCellListeners);
            this.fCellListeners = cellEditorListenerArray;
        }
    }

    @Override
    public void cancelCellEditing() {
        this.propertyEditCanceled();
    }

    @Override
    public boolean stopCellEditing() {
        this.propertyEditStopped();
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.getValue();
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        jTable.setValueAt(object, n, n2);
        return this;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent != null) {
            JOptionPane.showMessageDialog(this.fEditor, propertyChangeEvent.getNewValue());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent != null) {
            this.setValue(propertyChangeEvent.getNewValue());
            if (this.fTableModel != null) {
                this.fTableModel.fireTableCellUpdated(this.fTree.getRowForPath(this.fPath), 0);
            }
        }
    }

    public void applyChanges(Object[] objectArray) {
        Object object = this.getValue();
        final Object object2 = this.getDisplayedValue();
        if (object2 != null && (object2.equals(MIXED_VALUES) || object2 instanceof String[] && ((String[])object2).length > 0 && ((String[])object2)[0].equals(MIXED_VALUES))) {
            return;
        }
        final Object[] objectArray2 = objectArray;
        if (objectArray != null && (this.getPropertyType() == MLArrayRef.class || this.getPropertyType() == Object.class)) {
            for (Object object3 : objectArray) {
                if (this.fProperty != null) {
                    MLPropertyTypeConverter.setProperty(object3, object, object2, this.fProperty);
                    continue;
                }
                MLPropertyTypeConverter.setProperty(object3, object, object2, this.fPropertyName);
            }
            return;
        }
        if (object != null && !object.equals(object2) || object != object2) {
            try {
                Matlab.whenMatlabIdle((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (objectArray2 != null && objectArray2.length > 0) {
                            for (Object object : objectArray2) {
                                BeanManager.setPropertyValue(object, PropertyControl.this.fProperty, object2);
                            }
                        }
                    }
                });
            }
            catch (Exception exception) {
                Throwable throwable = exception.getCause();
                if (throwable instanceof RuntimeException) {
                    ErrorHandler.showJavaException("BeanManager.setPropertyValue (\"" + this.fProperty.getName() + "\")", (Exception)throwable);
                }
                ErrorHandler.showJavaException("BeanManager.setPropertyValue (\"" + this.fProperty.getName() + "\")", exception);
            }
        }
    }

    public void addPropertyControlListeners(Object[] objectArray) {
        for (Object object : objectArray) {
            this.addPropertyChangeListener(this.getPropertyName(), object);
            this.addVetoableChangeListener(object);
        }
    }

    public void clearPropertyControlListeners() {
        this.clearPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String string, Object object) {
        Object[] objectArray;
        Class[] classArray = new Class[]{String.class, PropertyChangeListener.class};
        Method method = BeanManager.getMethod(object, "addPropertyChangeListener", classArray);
        if (method == null) {
            classArray = new Class[]{PropertyChangeListener.class};
            method = BeanManager.getMethod(object, "addPropertyChangeListener", classArray);
            objectArray = new Object[]{this};
        } else {
            objectArray = new Object[]{string, this};
        }
        if (method != null) {
            try {
                method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (object != null) {
            UDDObject uDDObject = (UDDObject)object;
            UDDObject uDDObject2 = uDDObject.findProperty(string);
            if (uDDObject2 == null) {
                return;
            }
            UDDPropertyChangeListener uDDPropertyChangeListener = new UDDPropertyChangeListener(uDDObject, string);
            uDDPropertyChangeListener.setPropertyControl(this);
            uDDPropertyChangeListener.add();
            this.uddLsnrs.add(uDDPropertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enablePropertyChangeListeners(final boolean bl) {
        if (NativeMatlab.nativeIsMatlabThread()) {
            Vector<UDDPropertyChangeListener> vector = this.uddLsnrs;
            synchronized (vector) {
                for (UDDPropertyChangeListener uDDPropertyChangeListener : this.uddLsnrs) {
                    uDDPropertyChangeListener.setEnabled(bl);
                }
            }
        } else {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Vector vector = PropertyControl.this.uddLsnrs;
                    synchronized (vector) {
                        for (UDDPropertyChangeListener uDDPropertyChangeListener : PropertyControl.this.uddLsnrs) {
                            uDDPropertyChangeListener.setEnabled(bl);
                        }
                    }
                }
            });
        }
    }

    public void clearPropertyChangeListeners() {
        for (UDDPropertyChangeListener uDDPropertyChangeListener : this.uddLsnrs) {
            uDDPropertyChangeListener.remove();
        }
        this.uddLsnrs.clear();
    }

    public void addVetoableChangeListener(Object object) {
        Object[] objectArray = new Object[2];
        Class[] classArray = new Class[]{String.class, VetoableChangeListener.class};
        Method method = BeanManager.getMethod(object, "addVetoableChangeListener", classArray);
        objectArray[0] = this.getPropertyName();
        objectArray[1] = this;
        if (method != null) {
            try {
                method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void clearVetoableChangeListeners(Object object) {
        Object[] objectArray = null;
        Method method = BeanManager.getMethod(object, "getVetoableChangeListeners", null);
        if (method != null) {
            try {
                objectArray = (Object[])method.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (objectArray != null) {
            Method method2 = BeanManager.getMethod(object, "removeVetoableChangeListener", null);
            try {
                for (Object object2 : objectArray) {
                    method2.invoke(object, object2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public abstract void addEditStoppedSupport();

    public static class UDDPropertyChangeListener
    implements PropertyChangeListener {
        PropertyControl fpc = null;
        UDDObject fbean = null;
        Object fVal = null;
        boolean fEnabled = true;
        String fPropName;

        public UDDPropertyChangeListener(UDDObject uDDObject, String string) {
            this.fbean = uDDObject;
            this.fPropName = string;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!this.fEnabled) {
                return;
            }
            PropertyDescriptor propertyDescriptor = BeanManager.getProperty(this.fbean, this.fPropName);
            if (propertyDescriptor == null) {
                if (MLPropertyTypeConverter.isSupportedProperty(this.fPropName.toLowerCase(), this.fbean.getClass().getName())) {
                    this.fVal = MLPropertyTypeConverter.getProperty((Object)this.fbean, this.fPropName);
                    QueueEvent.postQueueEvent((QueueEvent)new QueueEvent(){

                        public void dispatch() {
                            UDDPropertyChangeListener.this.fpc.setValue(UDDPropertyChangeListener.this.fVal);
                        }
                    });
                    return;
                }
                return;
            }
            this.fVal = propertyDescriptor.getPropertyType() == MLArrayRef.class || propertyDescriptor.getPropertyType() == Object.class ? MLPropertyTypeConverter.getProperty((Object)this.fbean, propertyDescriptor) : BeanManager.getPropertyValue(this.fbean, propertyDescriptor);
            if (this.fVal instanceof MLArrayRef) {
                this.fVal = MLPropertyTypeConverter.parseMLArrayRef((MLArrayRef)this.fVal, propertyDescriptor, this.fbean.getClass().getName());
            }
            QueueEvent.postQueueEvent((QueueEvent)new QueueEvent(){

                public void dispatch() {
                    UDDPropertyChangeListener.this.fpc.setValue(UDDPropertyChangeListener.this.fVal);
                }
            });
        }

        void remove() {
            this.fbean.removeObjectPropertyChangeListener(this.fPropName, (PropertyChangeListener)this);
        }

        void add() {
            this.fbean.addObjectPropertyChangeListener(this.fPropName, (PropertyChangeListener)this);
        }

        void setEnabled(boolean bl) {
            this.fEnabled = bl;
        }

        boolean getEnabled() {
            return this.fEnabled;
        }

        public void setPropertyControl(PropertyControl propertyControl) {
            this.fpc = propertyControl;
        }
    }
}

