/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.macosx;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.macosx.CGL;
import com.sun.opengl.impl.macosx.MacOSXGLDrawable;
import com.sun.opengl.impl.macosx.MacOSXPbufferGLContext;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class MacOSXPbufferGLDrawable
extends MacOSXGLDrawable {
    private static final boolean DEBUG = Debug.debug("MacOSXPbufferGLDrawable");
    protected int initWidth;
    protected int initHeight;
    protected long pBuffer;
    protected int width;
    protected int height;
    private int textureTarget;
    private int texture;
    private boolean haveSetOpenGLMode = false;
    private int openGLMode = 1;
    protected Impl impl;

    public MacOSXPbufferGLDrawable(GLCapabilities gLCapabilities, int n, int n2) {
        super(gLCapabilities, null);
        this.initWidth = n;
        this.initHeight = n2;
        this.initOpenGLImpl();
        this.createPbuffer();
    }

    public GLContext createContext(GLContext gLContext) {
        return new MacOSXPbufferGLContext(this, gLContext);
    }

    public void destroy() {
        if (this.pBuffer != 0L) {
            this.impl.destroy(this.pBuffer);
            this.pBuffer = 0L;
            if (DEBUG) {
                System.err.println("Destroyed pbuffer " + this.width + " x " + this.height);
            }
        }
    }

    public void setSize(int n, int n2) {
        throw new GLException("Not yet implemented");
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public GLCapabilities getCapabilities() {
        return this.capabilities;
    }

    public long getPbuffer() {
        return this.pBuffer;
    }

    public void swapBuffers() throws GLException {
    }

    protected void createPbuffer() {
        int n;
        if (this.capabilities.getPbufferRenderToTextureRectangle()) {
            this.width = this.initWidth;
            this.height = this.initHeight;
            n = 34037;
        } else {
            this.width = this.getNextPowerOf2(this.initWidth);
            this.height = this.getNextPowerOf2(this.initHeight);
            n = 3553;
        }
        int n2 = 6408;
        if (this.capabilities.getPbufferFloatingPointBuffers()) {
            switch (this.capabilities.getRedBits()) {
                case 16: {
                    n2 = 34842;
                    break;
                }
                case 32: {
                    n2 = 34836;
                    break;
                }
                default: {
                    throw new GLException("Invalid floating-point bit depth (only 16 and 32 supported)");
                }
            }
        }
        this.pBuffer = this.impl.create(n, n2, this.width, this.height);
        if (this.pBuffer == 0L) {
            throw new GLException("pbuffer creation error: CGL.createPBuffer() failed");
        }
        if (DEBUG) {
            System.err.println("Created pbuffer " + MacOSXPbufferGLDrawable.toHexString(this.pBuffer) + ", " + this.width + " x " + this.height + " for " + this);
        }
    }

    private int getNextPowerOf2(int n) {
        if ((n - 1 & n) == 0) {
            return n;
        }
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return 1 << n2;
    }

    public void setOpenGLMode(int n) {
        if (n == this.openGLMode) {
            return;
        }
        if (this.haveSetOpenGLMode) {
            throw new GLException("Can't switch between using NSOpenGLPixelBuffer and CGLPBufferObj more than once");
        }
        this.destroy();
        this.openGLMode = n;
        this.haveSetOpenGLMode = true;
        if (DEBUG) {
            System.err.println("Switching PBuffer drawable mode to " + (n == 1 ? "NSOPENGL_MODE" : "CGL_MODE"));
        }
        this.initOpenGLImpl();
        this.createPbuffer();
    }

    public int getOpenGLMode() {
        return this.openGLMode;
    }

    private void initOpenGLImpl() {
        switch (this.openGLMode) {
            case 1: {
                this.impl = new NSOpenGLImpl();
                break;
            }
            case 2: {
                this.impl = new CGLImpl();
                break;
            }
            default: {
                throw new InternalError("Illegal implementation mode " + this.openGLMode);
            }
        }
    }

    class CGLImpl
    implements Impl {
        CGLImpl() {
        }

        public long create(int n, int n2, int n3, int n4) {
            long[] lArray = new long[1];
            int n5 = CGL.CGLCreatePBuffer(n3, n4, n, n2, 0L, lArray, 0);
            if (n5 != 0) {
                throw new GLException("Error creating CGL-based pbuffer: error code " + n5);
            }
            return lArray[0];
        }

        public void destroy(long l) {
            int n = CGL.CGLDestroyPBuffer(l);
            if (n != 0) {
                throw new GLException("Error destroying CGL-based pbuffer: error code " + n);
            }
        }
    }

    class NSOpenGLImpl
    implements Impl {
        NSOpenGLImpl() {
        }

        public long create(int n, int n2, int n3, int n4) {
            return CGL.createPBuffer(n, n2, n3, n4);
        }

        public void destroy(long l) {
            CGL.destroyPBuffer(0L, l);
        }
    }

    static interface Impl {
        public long create(int var1, int var2, int var3, int var4);

        public void destroy(long var1);
    }
}

