/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.lmlogin;

import com.mathworks.lmlogin.BlockingValidationStrategy;
import com.mathworks.lmlogin.LicenseManagerValidationConsumerFactory;
import com.mathworks.lmlogin.LmLoginResourceKey;
import com.mathworks.widgets.login.AbstractDialogValidationStrategy;
import com.mathworks.widgets.login.AuthenticationListener;
import com.mathworks.widgets.login.LoginProxyConfigurationToProxySettingsAdapter;
import com.mathworks.widgets.login.ProxySettings;
import com.mathworks.widgets.login.UniversalLoginComponent;
import com.mathworks.widgets.login.ValidationConsumer;
import com.mathworks.widgets.login.ValidationCriteria;
import com.mathworks.widgets.login.WorkFlowReturn;
import java.awt.Dimension;
import java.util.concurrent.Semaphore;

final class LicenseManagerLoginValidationStrategy
extends AbstractDialogValidationStrategy
implements BlockingValidationStrategy {
    private WorkFlowReturn workFlowReturn;
    private Semaphore semaphore = new Semaphore(0);

    LicenseManagerLoginValidationStrategy() {
    }

    public boolean forceNewAuthentication() {
        return true;
    }

    public void workFlowComplete(WorkFlowReturn workFlowReturn) {
        this.workFlowReturn = workFlowReturn;
        this.semaphore.release();
    }

    public String getValidationCriteria() {
        return ValidationCriteria.TWENTY_FOUR_HOUR.getLabel();
    }

    public String getClientString() {
        return LmLoginResourceKey.LOGIN_CLIENTSTRING.getString(new Object[0]);
    }

    public ProxySettings getProxySettings() {
        LoginProxyConfigurationToProxySettingsAdapter loginProxyConfigurationToProxySettingsAdapter = new LoginProxyConfigurationToProxySettingsAdapter();
        return loginProxyConfigurationToProxySettingsAdapter.adaptProxyConfiguration();
    }

    public void doAuthentication(AuthenticationListener authenticationListener) {
        this.getUniversalLoginHandler().invokeLogin(authenticationListener, this.getLoginPersistenceStrategy(), null, null, UniversalLoginComponent.LoginDisplayType.SHORT_LOGIN);
    }

    public ValidationConsumer getValidationConsumer() {
        return new LicenseManagerValidationConsumerFactory().createValidationConsumer();
    }

    @Override
    public WorkFlowReturn getWorkFlowReturn() {
        return this.workFlowReturn;
    }

    @Override
    public void awaitComplete() throws InterruptedException {
        this.semaphore.acquire();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getUniversalLoginHandler().getPreferredSize();
    }
}

