/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwebservices;

import com.mathworks.internal.mwaws.client.v5.ArrayOfString;
import com.mathworks.internal.mwaws.client.v5.MWAEntitlement;
import com.mathworks.mlwebservices.Account;
import com.mathworks.mlwebservices.AccountFactoryImpl;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.MaskFormatter;

class AccountImpl
implements Account {
    private String securityToken;
    private Map<String, MWAEntitlement> entitlementMap = new LinkedHashMap<String, MWAEntitlement>();
    private String emailAddress = "";
    private String password;
    private String selectedEntitlementId = "";
    private String firstName = "";
    private String lastName = "";
    private String userName = "";
    private String activationKey;
    private boolean verified;

    AccountImpl() {
    }

    @Override
    public void initialize(String string, String string2, String string3, String string4) {
        this.emailAddress = string;
        this.firstName = string2;
        this.lastName = string3;
        this.activationKey = string4;
    }

    @Override
    public boolean isLoggedIn() {
        String string = this.securityToken;
        return string != null && string.length() != 0;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setFirstName(String string) {
        this.firstName = string;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void setLastName(String string) {
        this.lastName = string;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String string) {
        this.password = string;
    }

    @Override
    public MWAEntitlement getSelectedEntitlement() {
        return this.entitlementMap.get(this.selectedEntitlementId);
    }

    @Override
    public void setSelectedEntitlement(String string) {
        this.selectedEntitlementId = string;
    }

    @Override
    public void setSelectedEntitlement(MWAEntitlement mWAEntitlement) {
        this.addEntitlement(mWAEntitlement);
        this.selectedEntitlementId = mWAEntitlement.getId();
    }

    @Override
    public void addEntitlement(MWAEntitlement mWAEntitlement) {
        String string = mWAEntitlement.getId();
        this.entitlementMap.put(string, mWAEntitlement);
    }

    @Override
    public String getSecurityToken() {
        return this.securityToken;
    }

    @Override
    public void setSecurityToken(String string) {
        this.securityToken = string;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public void setEmailAddress(String string) {
        this.emailAddress = string;
    }

    @Override
    public List<MWAEntitlement> getEntitlements() {
        Collection<MWAEntitlement> collection = this.entitlementMap.values();
        return new ArrayList<MWAEntitlement>(collection);
    }

    @Override
    public String getActivationKey() {
        String string;
        MWAEntitlement mWAEntitlement = this.entitlementMap.get(this.selectedEntitlementId);
        String string2 = mWAEntitlement == null ? this.activationKey : ((string = mWAEntitlement.getActivationKey()) == null || "".equalsIgnoreCase(string) ? this.activationKey : string);
        if (string2 == null) {
            string = "";
        } else {
            String string3 = AccountFactoryImpl.getActivationKeyMask();
            try {
                MaskFormatter maskFormatter = new MaskFormatter(string3);
                string = (String)maskFormatter.stringToValue(string2);
            }
            catch (ParseException parseException) {
                string = string2;
            }
        }
        return string;
    }

    @Override
    public void setActivationKey(String string) {
        MWAEntitlement mWAEntitlement = this.entitlementMap.get(this.selectedEntitlementId);
        if (mWAEntitlement == null) {
            this.activationKey = string;
        } else {
            mWAEntitlement.setActivationKey(string);
        }
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String string) {
        this.userName = string.trim();
    }

    @Override
    public boolean isAdmin(String string) {
        return null != string && this.containsPermission(string, "ActivateForOthers");
    }

    @Override
    public boolean a2ak(String string) {
        return null != string && (this.containsPermission(string, "ActivationKeyAvailable") || this.isAdmin(string));
    }

    private boolean containsPermission(String string, String string2) {
        boolean bl = false;
        if (null != string) {
            MWAEntitlement mWAEntitlement = this.entitlementMap.get(string);
            if (mWAEntitlement == null) {
                return false;
            }
            ArrayOfString arrayOfString = mWAEntitlement.getPermissions();
            if (arrayOfString != null) {
                String[] stringArray = arrayOfString.getItem();
                if (stringArray != null) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.addAll(Arrays.asList(stringArray));
                    bl = arrayList.contains(string2);
                } else {
                    bl = false;
                }
            }
        }
        return bl;
    }

    @Override
    public void clearEntitlements() {
        this.entitlementMap = new LinkedHashMap<String, MWAEntitlement>();
        this.selectedEntitlementId = "";
    }

    @Override
    public String getActivationKeyByEntitlementId(String string) {
        MWAEntitlement mWAEntitlement = this.entitlementMap.get(string);
        if (mWAEntitlement == null) {
            return "";
        }
        return mWAEntitlement.getActivationKey();
    }

    @Override
    public void setVerified(boolean bl) {
        this.verified = bl;
    }

    @Override
    public boolean isVerified() {
        return this.verified;
    }
}

