/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.sun.jini.start.SharedGroupBackEnd;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.TrustEquivalence;

final class ProxyVerifier
implements TrustVerifier,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String START_PROXY = "com.sun.jini.start.proxy";
    private static final Logger logger = Logger.getLogger("com.sun.jini.start.proxy");
    private final RemoteMethodControl serverProxy;

    ProxyVerifier(SharedGroupBackEnd sharedGroupBackEnd) {
        if (!(sharedGroupBackEnd instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException("No verifier available for non-secure service");
        }
        if (!(sharedGroupBackEnd instanceof TrustEquivalence)) {
            throw new UnsupportedOperationException("Verifier requires service proxy to implement TrustEquivalence");
        }
        this.serverProxy = (RemoteMethodControl)sharedGroupBackEnd;
    }

    public boolean isTrustedObject(Object object, TrustVerifier.Context context) throws RemoteException {
        logger.entering(ProxyVerifier.class.getName(), "isTrustedObject", new Object[]{object, context});
        if (object == null || context == null) {
            throw new NullPointerException("Arguments must not be null");
        }
        if (!(object instanceof SharedGroupBackEnd)) {
            logger.log(Level.FINEST, "Object {0} is not a supported type", object);
            return false;
        }
        RemoteMethodControl remoteMethodControl = (RemoteMethodControl)object;
        MethodConstraints methodConstraints = remoteMethodControl.getConstraints();
        TrustEquivalence trustEquivalence = (TrustEquivalence)this.serverProxy.setConstraints(methodConstraints);
        boolean bl = trustEquivalence.checkTrustEquivalence((Object)remoteMethodControl);
        logger.exiting(ProxyVerifier.class.getName(), "isTrustedObject", new Boolean(bl));
        return bl;
    }
}

