/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.dragdrop;

import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.dragdrop.DragTracker;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

abstract class MarqueeDrag
extends DragTracker {
    protected Point fStartPt;
    protected Point fCurrentPt;

    MarqueeDrag(LayoutArea layoutArea) {
        super(layoutArea);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.fStartPt = mouseEvent.getPoint();
        this.constrainBounds(this.fStartPt);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Graphics graphics = this.getXORGraphics(true);
        this.drawMarquee(graphics);
        this.fCurrentPt = mouseEvent.getPoint();
        if (this.fCurrentPt != null && this.fStartPt != null) {
            this.constrainMarquee(mouseEvent.isMetaDown());
        }
        this.constrainBounds(this.fCurrentPt);
        this.drawMarquee(graphics);
        this.fLayoutArea.getHRuler().doMouseTrackMouseMoved(this.fCurrentPt);
        this.fLayoutArea.getVRuler().doMouseTrackMouseMoved(this.fCurrentPt);
        Rectangle rectangle = this.getBounds();
        int n = this.fLayoutArea.getPalette().getSelectedButtonIndex();
        if (n != 0 && this.fLayoutArea.getLayoutStatusBar() != null) {
            this.fLayoutArea.getLayoutStatusBar().setPosition(null, new Point((int)rectangle.getMinX(), (int)rectangle.getMaxY()), new Point((int)rectangle.getMaxX(), (int)rectangle.getMinY()), false);
        }
        graphics.dispose();
        graphics = null;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Graphics graphics = this.getXORGraphics(true);
        this.drawMarquee(graphics);
        graphics.dispose();
        graphics = null;
        this.fCurrentPt = mouseEvent.getPoint();
        if (this.fCurrentPt != null && this.fStartPt != null) {
            this.constrainMarquee(mouseEvent.isMetaDown());
        }
        this.constrainBounds(this.fCurrentPt);
    }

    Rectangle getBounds() {
        Rectangle rectangle = null;
        if (this.fCurrentPt != null) {
            rectangle = new Rectangle(this.fCurrentPt.x, this.fCurrentPt.y, 0, 0);
            if (this.fStartPt != null) {
                int n = Math.min(this.fStartPt.x, this.fCurrentPt.x);
                int n2 = Math.min(this.fStartPt.y, this.fCurrentPt.y);
                int n3 = Math.abs(this.fCurrentPt.x - this.fStartPt.x);
                int n4 = Math.abs(this.fCurrentPt.y - this.fStartPt.y);
                rectangle.x = n;
                rectangle.y = n2;
                rectangle.width = n3 + 1;
                rectangle.height = n4 + 1;
            }
        }
        return rectangle;
    }

    private void drawMarquee(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        if (rectangle != null && rectangle.width > 2 && rectangle.height > 2) {
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
    }

    protected abstract void constrainMarquee(boolean var1);
}

