/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.scroll;

import com.mathworks.mwswing.MJComponent;
import com.mathworks.toolbox.matlab.guide.scroll.ScrollTarget;
import com.mathworks.util.IntHashtable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.RotatedText;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;

public class ScrollRuler
extends MJComponent
implements ScrollTarget {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private static final int MINOR_HEIGHT = 4;
    private static final int MAJOR_HEIGHT = 6;
    private static final int RULER_WIDTH = 18;
    private static IntHashtable sLabels = new IntHashtable(10);
    private int fOrientation;
    private int fMinorInterval;
    private int fMajorInterval;
    private int fMargin;
    private int fLength;
    private int fLabelInterval;
    private int fLabelStart;
    private int fLabelUnit;
    private int fOffset;
    private boolean fShowTracker;
    private boolean fMouseMoveTrackDrawn;
    private boolean fMouseDragTrackDrawn;
    private Point fLastMouseDrawPt = new Point(0, 0);
    private Rectangle fLastBoundingRect = new Rectangle(0, 0, 0, 0);

    public ScrollRuler(int n, int n2, int n3) {
        this.setFont(ScrollRuler.getRulerFont());
        this.setOrientation(n);
        this.setMinorInterval(n2);
        this.setMajorInterval(n3);
        this.setLabelInterval(n3);
        this.setLabelUnit(n3);
        switch (n) {
            case 0: 
            case 1: {
                this.fOrientation = n;
                break;
            }
            default: {
                this.fOrientation = 1;
            }
        }
        this.setSize(this.getPreferredSize());
    }

    public ScrollRuler() {
        this(1, 10, 50);
    }

    public void setOrientation(int n) {
        switch (n) {
            case 0: 
            case 1: {
                this.fOrientation = n;
                break;
            }
        }
    }

    public final int getOrientation() {
        return this.fOrientation;
    }

    public void setMinorInterval(int n) {
        this.fMinorInterval = n;
    }

    public final int getMinorInterval() {
        return this.fMinorInterval;
    }

    public void setMajorInterval(int n) {
        this.fMajorInterval = n;
    }

    public final int getMajorInterval() {
        return this.fMajorInterval;
    }

    public void setLabelInterval(int n) {
        this.fLabelInterval = n;
    }

    public final int getLabelInterval() {
        return this.fLabelInterval;
    }

    public void setLabelUnit(int n) {
        this.fLabelUnit = n;
    }

    public final int getLabelUnit() {
        return this.fLabelUnit;
    }

    public void setLabelStart(int n) {
        this.fLabelStart = n;
    }

    public final int getLabelStart() {
        return this.fLabelStart;
    }

    public void setMargin(int n) {
        this.fMargin = n;
    }

    public final int getMargin() {
        return this.fMargin;
    }

    public void setLength(int n) {
        this.fLength = n;
    }

    public final int getLength() {
        return this.fLength;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(0, 0);
        switch (this.fOrientation) {
            case 1: {
                dimension.width = this.fLength != 0 ? 2 * this.fMargin + this.fLength : Math.max(this.getSize().width, 2 * this.fMargin + this.fMajorInterval);
                dimension.height = 18;
                break;
            }
            case 0: {
                dimension.width = 18;
                dimension.height = this.fLength != 0 ? 2 * this.fMargin + this.fLength : Math.max(this.getSize().height, 2 * this.fMargin + this.fMajorInterval);
            }
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        switch (this.fOrientation) {
            case 0: {
                dimension.height = Short.MAX_VALUE;
                break;
            }
            case 1: {
                dimension.width = Short.MAX_VALUE;
            }
        }
        return dimension;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.fMouseMoveTrackDrawn) {
            this.drawMoveTrack(graphics, dimension);
        }
        this.drawRuler(graphics, dimension);
        this.drawTicks(graphics, dimension);
        if (this.fMouseMoveTrackDrawn) {
            this.drawMoveTrack(graphics, dimension);
        }
    }

    private void drawMoveTrack(Graphics graphics, Dimension dimension) {
        graphics.setColor(Color.black);
        graphics.setXORMode(Color.white);
        switch (this.fOrientation) {
            case 1: {
                graphics.drawLine(this.fLastMouseDrawPt.x, 1, this.fLastMouseDrawPt.x, dimension.height - 2);
                break;
            }
            case 0: {
                graphics.drawLine(2, this.fLastMouseDrawPt.y, dimension.width, this.fLastMouseDrawPt.y);
            }
        }
        graphics.setPaintMode();
    }

    private void drawRuler(Graphics graphics, Dimension dimension) {
        SystemColor systemColor = SystemColor.control;
        SystemColor systemColor2 = SystemColor.controlShadow;
        int n = dimension.width;
        int n2 = dimension.height;
        graphics.setColor(systemColor);
        graphics.fillRect(0, 0, n, n2);
        switch (this.fOrientation) {
            case 1: {
                graphics.setColor(systemColor2);
                graphics.drawLine(0, 16, n - 1, 16);
                graphics.setColor(Color.black);
                graphics.drawLine(0, 17, n - 1, 17);
                break;
            }
            case 0: {
                graphics.setColor(systemColor2);
                graphics.drawLine(16, 0, 16, n2 - 1);
                graphics.setColor(Color.black);
                graphics.drawLine(17, 0, 17, n2 - 1);
                break;
            }
        }
    }

    private void drawTicks(Graphics graphics, Dimension dimension) {
        Color color = Color.black;
        SystemColor systemColor = SystemColor.controlDkShadow;
        int n = this.getLastPosition();
        int n2 = this.getFirstMinor();
        int n3 = this.getFirstMajor();
        int n4 = this.getFirstLabel();
        int n5 = this.fOffset < this.fMargin ? this.fOffset - this.fMargin : this.fOffset;
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = this.getFontMetrics(graphics.getFont());
        while (n2 < n) {
            int n6;
            graphics.setColor(systemColor);
            while (n2 < n && n2 < n3) {
                n6 = this.getActualLocation(n2);
                if (this.fOrientation == 1) {
                    graphics.drawLine(n6, 14, n6, 16);
                } else {
                    graphics.drawLine(14, n6, 16, n6);
                }
                n2 += this.fMinorInterval;
            }
            if (n2 >= n) continue;
            n6 = this.getActualLocation(n2);
            if (this.fOrientation == 1) {
                graphics.drawLine(n6, 12, n6, 16);
            } else {
                graphics.drawLine(12, n6, 16, n6);
            }
            if (n2 >= n4 && fontMetrics != null) {
                graphics.setColor(color);
                String string = this.getTickLabel(n2);
                int n7 = fontMetrics.stringWidth(string);
                if (this.fOrientation == 1) {
                    if (n2 - n7 / 2 + 1 > n5) {
                        graphics.drawString(string, n6 - n7 / 2 + 1, 10);
                        n5 = n2 + n7 / 2 + this.fMinorInterval + 1;
                    }
                } else if (n2 - n7 / 2 > n5) {
                    RotatedText.drawRotatedText((Graphics)graphics, (String)string, (int)10, (int)(n6 + n7 / 2), (int)90, (Component)((Object)this));
                    n5 = n2 + n7 / 2 + this.fMinorInterval;
                }
                n4 += this.fLabelInterval;
            }
            n2 += this.fMinorInterval;
            n3 += this.fMajorInterval;
        }
    }

    public static void drawMitre(Graphics graphics, Dimension dimension) {
        SystemColor systemColor = SystemColor.control;
        SystemColor systemColor2 = SystemColor.controlShadow;
        graphics.setColor(systemColor);
        graphics.fillRect(1, 1, dimension.width, dimension.height);
        graphics.setColor(systemColor2);
        graphics.fillRect(dimension.width - 2, dimension.height - 2, 2, 2);
        graphics.setColor(Color.black);
        graphics.fillRect(dimension.width - 1, dimension.height - 1, 1, 1);
    }

    private String getTickLabel(int n) {
        int n2 = this.fLabelStart + n / this.fLabelInterval * this.fLabelUnit;
        String string = (String)sLabels.get(n2);
        if (string == null) {
            string = String.valueOf(n2);
            sLabels.put(n2, (Object)string);
        }
        return string;
    }

    private int getFirstMinor() {
        if (this.fOffset < this.fMargin) {
            return 0;
        }
        return this.fMinorInterval * ((this.fOffset - this.fMargin) / this.fMinorInterval + 1);
    }

    private int getFirstMajor() {
        if (this.fOffset < this.fMargin) {
            return 0;
        }
        return this.fMajorInterval * ((this.fOffset - this.fMargin) / this.fMajorInterval + 1);
    }

    private int getFirstLabel() {
        if (this.fOffset < this.fMargin) {
            return 0;
        }
        return this.fLabelInterval * ((this.fOffset - this.fMargin) / this.fLabelInterval + 1);
    }

    private int getLastPosition() {
        int n = this.fOffset + (this.fOrientation == 1 ? this.getSize().width : this.getSize().height);
        if (this.fLength > 0) {
            return Math.min(this.fLength + 1, n);
        }
        return n;
    }

    private int getActualLocation(int n) {
        return this.fMargin + n - this.fOffset;
    }

    public void setShowTracker(boolean bl) {
        if (bl != this.fShowTracker) {
            if (this.fShowTracker) {
                if (this.fMouseMoveTrackDrawn) {
                    this.doMouseTrackXOROff();
                }
                if (this.fMouseDragTrackDrawn) {
                    this.doMouseDragXOROff();
                }
            }
            this.fShowTracker = bl;
        }
    }

    public void doMouseDragMouseMoved(Rectangle rectangle) {
        if (this.fShowTracker && this.isShowing()) {
            Graphics graphics = this.getGraphics();
            Color color = Color.black;
            graphics.setColor(color);
            Color color2 = Color.white;
            graphics.setXORMode(color2);
            switch (this.fOrientation) {
                case 1: {
                    if (this.fMouseDragTrackDrawn) {
                        graphics.drawLine(this.fLastBoundingRect.x, 1, this.fLastBoundingRect.x, this.getSize().height - 2);
                        graphics.drawLine(this.fLastBoundingRect.x + this.fLastBoundingRect.width - 1, 1, this.fLastBoundingRect.x + this.fLastBoundingRect.width - 1, this.getSize().height - 2);
                    }
                    graphics.drawLine(rectangle.x - this.fOffset, 1, rectangle.x - this.fOffset, this.getSize().height - 2);
                    graphics.drawLine(rectangle.x + rectangle.width - 1 - this.fOffset, 1, rectangle.x + rectangle.width - 1 - this.fOffset, this.getSize().height - 2);
                    break;
                }
                case 0: {
                    if (this.fMouseDragTrackDrawn) {
                        graphics.drawLine(2, this.fLastBoundingRect.y, this.getSize().width, this.fLastBoundingRect.y);
                        graphics.drawLine(2, this.fLastBoundingRect.y + this.fLastBoundingRect.height - 1, this.getSize().width, this.fLastBoundingRect.y + this.fLastBoundingRect.height - 1);
                    }
                    graphics.drawLine(2, rectangle.y - this.fOffset, this.getSize().width, rectangle.y - this.fOffset);
                    graphics.drawLine(2, rectangle.y + rectangle.height - 1 - this.fOffset, this.getSize().width, rectangle.y + rectangle.height - 1 - this.fOffset);
                    break;
                }
            }
            this.fMouseDragTrackDrawn = true;
            this.fLastBoundingRect.x = rectangle.x - this.fOffset;
            this.fLastBoundingRect.y = rectangle.y - this.fOffset;
            this.fLastBoundingRect.width = rectangle.width;
            this.fLastBoundingRect.height = rectangle.height;
            graphics.setPaintMode();
            graphics.dispose();
        }
    }

    public void doMouseDragXOROff() {
        if (this.fShowTracker && this.isShowing()) {
            Graphics graphics = this.getGraphics();
            Color color = Color.black;
            graphics.setColor(color);
            Color color2 = Color.white;
            graphics.setXORMode(color2);
            switch (this.fOrientation) {
                case 1: {
                    if (!this.fMouseDragTrackDrawn) break;
                    graphics.drawLine(this.fLastBoundingRect.x, 1, this.fLastBoundingRect.x, this.getSize().height - 2);
                    graphics.drawLine(this.fLastBoundingRect.x + this.fLastBoundingRect.width - 1, 1, this.fLastBoundingRect.x + this.fLastBoundingRect.width - 1, this.getSize().height - 2);
                    break;
                }
                case 0: {
                    if (!this.fMouseDragTrackDrawn) break;
                    graphics.drawLine(2, this.fLastBoundingRect.y, this.getSize().width, this.fLastBoundingRect.y);
                    graphics.drawLine(2, this.fLastBoundingRect.y + this.fLastBoundingRect.height - 1, this.getSize().width, this.fLastBoundingRect.y + this.fLastBoundingRect.height - 1);
                    break;
                }
            }
            this.fMouseDragTrackDrawn = false;
            this.fLastBoundingRect.x = 0;
            this.fLastBoundingRect.y = 0;
            this.fLastBoundingRect.width = 0;
            this.fLastBoundingRect.height = 0;
            graphics.setPaintMode();
            graphics.dispose();
        }
    }

    public void doMouseTrackMouseMoved(Point point) {
        if (this.fShowTracker && this.isShowing()) {
            Graphics graphics = this.getGraphics();
            Color color = Color.black;
            graphics.setColor(color);
            Color color2 = Color.white;
            graphics.setXORMode(color2);
            switch (this.fOrientation) {
                case 1: {
                    if (this.fMouseMoveTrackDrawn) {
                        graphics.drawLine(this.fLastMouseDrawPt.x, 1, this.fLastMouseDrawPt.x, this.getSize().height - 2);
                    }
                    graphics.drawLine(point.x - this.fOffset, 1, point.x - this.fOffset, this.getSize().height - 2);
                    break;
                }
                case 0: {
                    if (this.fMouseMoveTrackDrawn) {
                        graphics.drawLine(2, this.fLastMouseDrawPt.y, this.getSize().width, this.fLastMouseDrawPt.y);
                    }
                    graphics.drawLine(2, point.y - this.fOffset, this.getSize().width, point.y - this.fOffset);
                    break;
                }
            }
            this.fMouseMoveTrackDrawn = true;
            this.fLastMouseDrawPt.x = point.x - this.fOffset;
            this.fLastMouseDrawPt.y = point.y - this.fOffset;
            graphics.setPaintMode();
            graphics.dispose();
        }
    }

    public void doMouseTrackXOROff() {
        if (this.fShowTracker && this.isShowing()) {
            Graphics graphics = this.getGraphics();
            Color color = Color.black;
            graphics.setColor(color);
            Color color2 = Color.white;
            graphics.setXORMode(color2);
            switch (this.fOrientation) {
                case 1: {
                    if (!this.fMouseMoveTrackDrawn) break;
                    graphics.drawLine(this.fLastMouseDrawPt.x, 1, this.fLastMouseDrawPt.x, this.getSize().height - 2);
                    break;
                }
                case 0: {
                    if (!this.fMouseMoveTrackDrawn) break;
                    graphics.drawLine(2, this.fLastMouseDrawPt.y, this.getSize().width, this.fLastMouseDrawPt.y);
                    break;
                }
            }
            this.fMouseMoveTrackDrawn = false;
            this.fLastMouseDrawPt.x = 0;
            this.fLastMouseDrawPt.y = 0;
            graphics.setPaintMode();
            graphics.dispose();
        }
    }

    @Override
    public void scrollTo(int n, int n2) {
        if (this.fOrientation == 1 && n != this.fOffset) {
            this.fOffset = n;
            this.repaint(5L);
        } else if (this.fOrientation == 0 && n2 != this.fOffset) {
            this.fOffset = n2;
            this.repaint(5L);
        }
    }

    private static Font getRulerFont() {
        Font font;
        switch (PlatformInfo.getPlatform()) {
            case 0: {
                font = new Font("Geneva", 0, 9);
                break;
            }
            case 1: {
                font = new Font("Monospaced", 0, 10);
                break;
            }
            default: {
                font = new Font("Monospaced", 0, 10);
            }
        }
        return font;
    }
}

