/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.helpsearch.product.DocProduct;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CategoryUtils {
    private static final Pattern ID_FROM_INDEX_PAGE_PATTERN = Pattern.compile("^(.*/)?index.html(#.*)?");
    private static final Pattern ID_FROM_FILENAME_PATTERN = Pattern.compile("([^/]*).html(.*)");
    private static final String VALID_ID_CHARS = "\\w-";
    private static final String VALID_ID_CHAR_PATTERN = "[\\w-]";
    private static final String INVALID_ID_CHAR_PATTERN = "[^\\w-]";

    private CategoryUtils() {
    }

    public static String buildSearchIndexString(List<ResultCategory> breadCrumbs) {
        StringBuilder sb = new StringBuilder();
        for (ResultCategory breadCrumb : breadCrumbs) {
            sb.append(CategoryUtils.buildSearchIndexString(breadCrumb)).append('\n');
        }
        return sb.toString().trim();
    }

    static String buildSearchIndexString(ResultCategory breadCrumb) {
        StringBuilder builder = new StringBuilder();
        for (ResultCategory currentCat = breadCrumb; currentCat != null; currentCat = currentCat.getParent()) {
            builder.insert(0, ">>");
            builder.insert(0, CategoryUtils.buildSingleNodeIndexString(currentCat));
        }
        if (builder.length() > 1) {
            builder.delete(builder.length() - 2, builder.length());
        }
        return builder.toString();
    }

    public static String buildAncestorIdsString(List<ResultCategory> categories) {
        return CategoryUtils.buildAncestorIdsString(categories, null);
    }

    public static String buildAncestorIdsString(List<ResultCategory> categories, String nodeId) {
        StringBuilder sb = new StringBuilder();
        for (ResultCategory cat : categories) {
            sb.append(CategoryUtils.buildAncestorIdsString(cat, nodeId)).append('\n');
        }
        return sb.toString().trim();
    }

    private static String buildAncestorIdsString(ResultCategory category, String nodeId) {
        StringBuilder builder = new StringBuilder();
        ResultCategory currentCat = category;
        if (nodeId != null) {
            builder.append(nodeId);
        }
        while (currentCat != null) {
            builder.insert(0, ' ');
            builder.insert(0, currentCat.getNodeId());
            currentCat = currentCat.getParent();
        }
        return builder.toString().trim();
    }

    public static List<ResultCategory> parseSearchIndexString(String indexString) {
        String[] breadCrumbStrings;
        ArrayList<ResultCategory> categories = new ArrayList<ResultCategory>();
        for (String catString : breadCrumbStrings = indexString.split("\\n")) {
            if (catString.trim().length() <= 0) continue;
            categories.add(CategoryUtils.parseBreadCrumbString(catString));
        }
        return categories;
    }

    private static ResultCategory parseBreadCrumbString(String indexString) {
        String[] parts = indexString.split(">>");
        ResultCategory currentCategory = null;
        for (String part : parts) {
            currentCategory = CategoryUtils.fromSearchIndexValue(part, currentCategory);
        }
        return currentCategory;
    }

    private static String buildSingleNodeIndexString(ResultCategory category) {
        StringBuilder builder = new StringBuilder();
        String label = category.getLabel().replaceAll("\\s+", " ");
        builder.append(CategoryUtils.escapeString(label));
        builder.append("::");
        builder.append(CategoryUtils.escapeString(category.getRelativePath()));
        builder.append("::");
        builder.append(String.valueOf(category.getNodeId()));
        return builder.toString();
    }

    private static ResultCategory fromSearchIndexValue(String indexString, ResultCategory parent) {
        Pattern p = Pattern.compile("(.*)::(.*)::(.*)");
        Matcher m = p.matcher(indexString);
        if (m.find()) {
            String label = CategoryUtils.decodeString(m.group(1));
            String relPath = CategoryUtils.decodeString(m.group(2));
            String nodeId = m.group(3);
            return new ResultCategory(parent, label, relPath, nodeId);
        }
        return null;
    }

    public static ResultCategory getAncestorsFromIndexString(String indexString, String id) {
        String[] breadcrumbs = indexString.split("\\n");
        String catString = null;
        if (breadcrumbs.length == 1) {
            catString = breadcrumbs[0];
        } else {
            for (String breadcrumb : breadcrumbs) {
                if (!breadcrumb.matches(".*::" + Pattern.quote(id) + "(>>|$).*")) continue;
                catString = breadcrumb;
                break;
            }
        }
        if (catString == null) {
            return null;
        }
        for (ResultCategory category = CategoryUtils.parseBreadCrumbString(catString); category != null; category = category.getParent()) {
            if (!category.getNodeId().equals(id)) continue;
            return category;
        }
        return null;
    }

    public static ResultCategory getSingleCategoryFromIndexString(String indexString, String id) {
        for (ResultCategory category = CategoryUtils.parseBreadCrumbString(indexString); category != null; category = category.getParent()) {
            if (!category.getNodeId().equals(id)) continue;
            return category;
        }
        return null;
    }

    public static String createIdFromFilePath(DocProduct product, String relPath) {
        String baseId = CategoryUtils.getBaseIdString(relPath);
        if (baseId != null) {
            baseId = baseId.replaceAll(INVALID_ID_CHAR_PATTERN, "");
        }
        if (product != null) {
            baseId = product.getShortName() + "-" + baseId;
        }
        return baseId;
    }

    private static String getBaseIdString(String relPath) {
        Matcher indexFileMatcher = ID_FROM_INDEX_PAGE_PATTERN.matcher(relPath);
        if (indexFileMatcher.find()) {
            String after;
            StringBuilder id = new StringBuilder();
            String before = indexFileMatcher.group(1);
            if (before != null && before.length() > 0) {
                id.append(before.replace('/', '-'));
                if (id.charAt(id.length() - 1) == '-') {
                    id.deleteCharAt(id.length() - 1);
                }
            }
            if ((after = indexFileMatcher.group(2)) != null && after.length() > 0) {
                if (id.length() == 0) {
                    id.append("top-");
                } else {
                    id.append("-");
                }
                id.append(after.substring(1));
            }
            return id.length() > 0 ? id.toString() : null;
        }
        Matcher fileNameMatcher = ID_FROM_FILENAME_PATTERN.matcher(relPath);
        if (fileNameMatcher.find()) {
            String id = fileNameMatcher.group(1);
            if (fileNameMatcher.group(2).length() > 0) {
                id = id + fileNameMatcher.group(2);
            }
            return id;
        }
        return null;
    }

    static Pattern buildIdFromIndexStringPattern(String parent) {
        if (parent == null) {
            return Pattern.compile("(?<=^|\n)([\\w-]*)");
        }
        return Pattern.compile(Pattern.quote(parent) + "\\s+(" + VALID_ID_CHAR_PATTERN + "*)");
    }

    public static boolean isLeafId(String indexIdString, String id) {
        return indexIdString.equals(id) || indexIdString.endsWith(" " + id);
    }

    private static String escapeString(String toEscape) {
        return toEscape == null ? null : toEscape.replaceAll("[>:\\\\]", "\\\\$0");
    }

    private static String decodeString(String toDecode) {
        return toDecode == null ? null : toDecode.replaceAll("\\\\([>:\\\\])", "$1");
    }
}

