/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.search.SearchResult;
import com.mathworks.search.facet.FacetFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class InformationTypeFilter
implements FacetFilter<InformationType> {
    private final ContentFormat fFormat;
    private final Map<String, InformationType> fKnownFacets = new HashMap<String, InformationType>();

    public InformationTypeFilter(ContentFormat format) {
        this.fFormat = format;
    }

    public Collection<InformationType> determineFacet(SearchResult result) {
        InformationType facet;
        String typeStr = result.getFieldValue(DocumentationSearchField.RESULT_TYPE.getFieldName());
        if (this.fKnownFacets.containsKey(typeStr)) {
            facet = this.fKnownFacets.get(typeStr);
        } else {
            facet = this.fFormat.getInfoTypeByIndexString(typeStr);
            this.fKnownFacets.put(typeStr, facet);
        }
        if (facet == null) {
            return Collections.emptyList();
        }
        LinkedList<InformationType> types = new LinkedList<InformationType>();
        types.add(facet);
        return types;
    }
}

