/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.facets;

import com.mathworks.helpsearch.CategoryUtils;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.search.SearchCriteria;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchField;
import com.mathworks.search.SearchResult;
import com.mathworks.search.SearchResultCollector;
import com.mathworks.search.SimpleSearchExpression;

public class CategoryLabelRetriever {
    private final SearchEngine fEngine;

    public CategoryLabelRetriever(SearchEngine engine) {
        this.fEngine = engine;
    }

    public String getFacetLabel(String queryStringValue) {
        SearchCriteria criteria = CategoryLabelRetriever.getSearchCriteria(queryStringValue);
        CategoryCollector collector = new CategoryCollector(queryStringValue);
        try {
            this.fEngine.search(criteria, new SearchResultCollector[]{collector});
            return collector.iLabel;
        }
        catch (SearchException se) {
            return null;
        }
    }

    private static SearchCriteria getSearchCriteria(String queryStringValue) {
        SimpleSearchExpression expression = new SimpleSearchExpression(queryStringValue);
        expression.addSearchField((SearchField)DocumentationSearchField.ANCESTOR_ID);
        return new SearchCriteria((SearchExpression)expression);
    }

    static class CategoryCollector
    implements SearchResultCollector {
        private final String iId;
        private String iLabel;

        private CategoryCollector(String id) {
            this.iId = id;
        }

        public void examineResult(SearchResult result) throws SearchException {
            if (this.iLabel == null) {
                this.iLabel = this.getLabelFromResult(result);
            }
        }

        private String getLabelFromResult(SearchResult result) {
            String ancestorLabels = result.getFieldValue(DocumentationSearchField.ANCESTOR_LABEL.getFieldName());
            ResultCategory category = CategoryUtils.getSingleCategoryFromIndexString(ancestorLabels, this.iId);
            return category == null ? null : category.getLabel();
        }

        public void resultsComplete() {
        }
    }
}

