/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.index.DocumentBooster;
import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.product.DocProduct;
import java.util.HashMap;
import java.util.Map;

public class DocumentationBooster
implements DocumentBooster {
    private static final Map<String, Float> REF_PAGE_BOOSTS = new HashMap<String, Float>();

    @Override
    public float getDocumentBoost(DocumentationDocument doc) {
        if (doc.isReferencePage()) {
            return DocumentationBooster.getBoostForProduct(doc.getProduct());
        }
        return 1.0f;
    }

    private static float getBoostForProduct(DocProduct product) {
        Float boost = REF_PAGE_BOOSTS.get(product.getShortName());
        return boost == null ? 1.0f : boost.floatValue();
    }

    static {
        REF_PAGE_BOOSTS.put("matlab", Float.valueOf(2.0f));
        REF_PAGE_BOOSTS.put("simulink", Float.valueOf(1.5f));
    }
}

