/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.report;

import com.mathworks.helpsearch.index.report.SimpleReport;
import com.mathworks.helpsearch.product.DocProduct;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReportSummary {
    public final Map<String, Map<SimpleReport, Integer>> fProductSummaries = new HashMap<String, Map<SimpleReport, Integer>>();
    private static final Pattern PROPERTIES_KEY_PATTERN = ReportSummary.buildPropertiesFileKeyPattern();

    public ReportSummary() {
    }

    public ReportSummary(Map<String, Map<SimpleReport, Integer>> summaries) {
        this.fProductSummaries.putAll(summaries);
    }

    public Map<SimpleReport, Integer> getProductSummary(DocProduct product) {
        return this.fProductSummaries.get(product.getIndexValue());
    }

    public void addProductSummary(DocProduct product, Map<SimpleReport, Integer> prodSummary) {
        this.fProductSummaries.put(product.getIndexValue(), prodSummary);
    }

    public Properties toProperties() {
        Properties props = new Properties();
        for (Map.Entry<String, Map<SimpleReport, Integer>> entry : this.fProductSummaries.entrySet()) {
            Map<String, String> prodValues = ReportSummary.getProductEntries(entry.getKey(), entry.getValue());
            props.putAll(prodValues);
        }
        return props;
    }

    private static Pattern buildPropertiesFileKeyPattern() {
        StringBuilder pattern = new StringBuilder("(.*)_(");
        for (SimpleReport report : SimpleReport.values()) {
            pattern.append(Pattern.quote(report.toString())).append("|");
        }
        pattern.deleteCharAt(pattern.length() - 1);
        pattern.append(")");
        return Pattern.compile(pattern.toString());
    }

    public static ReportSummary fromProperties(Properties props) {
        LinkedHashMap<String, Map<SimpleReport, Integer>> summaries = new LinkedHashMap<String, Map<SimpleReport, Integer>>();
        for (Object key : props.keySet()) {
            Matcher keyMatcher = PROPERTIES_KEY_PATTERN.matcher(key.toString());
            if (!keyMatcher.find()) continue;
            String shortName = keyMatcher.group(1);
            String reportName = keyMatcher.group(2);
            EnumMap<SimpleReport, Integer> prodSummary = (EnumMap<SimpleReport, Integer>)summaries.get(keyMatcher.group(1));
            if (prodSummary == null) {
                prodSummary = new EnumMap<SimpleReport, Integer>(SimpleReport.class);
                summaries.put(shortName, prodSummary);
            }
            SimpleReport report = SimpleReport.valueOf(reportName);
            int num = Integer.parseInt(props.getProperty(key.toString()));
            prodSummary.put(report, num);
        }
        return new ReportSummary(summaries);
    }

    private static Map<String, String> getProductEntries(String shortName, Map<SimpleReport, Integer> reports) {
        LinkedHashMap<String, String> entries = new LinkedHashMap<String, String>();
        for (Map.Entry<SimpleReport, Integer> reportEntry : reports.entrySet()) {
            String key = shortName + "_" + reportEntry.getKey().toString();
            entries.put(key, String.valueOf(reportEntry.getValue()));
        }
        return entries;
    }
}

