/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.help.helpui.FacetLabelVisitor;
import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.help.helpui.SearchHelper;
import com.mathworks.help.helpui.SearchResultPageWrapper;
import com.mathworks.help.helpui.json.JsonArray;
import com.mathworks.help.helpui.json.JsonEntity;
import com.mathworks.help.helpui.json.JsonObject;
import com.mathworks.helpsearch.DocSearchEngineFactory;
import com.mathworks.helpsearch.DocumentationQuery;
import com.mathworks.helpsearch.DocumentationSearchResult;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.helpsearch.SearchConfig;
import com.mathworks.helpsearch.SearchEngineDocSearcher;
import com.mathworks.helpsearch.SearchHighlight;
import com.mathworks.helpsearch.facets.DocFacet;
import com.mathworks.helpsearch.facets.DocFacetResults;
import com.mathworks.helpsearch.facets.DocumentationFacetVisitor;
import com.mathworks.helpsearch.facets.Facetable;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.ProductFilter;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchResults;
import com.mathworks.search.SearchStringParseException;
import com.mathworks.search.facet.FacetResult;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class DocSearchPageChangedListener
implements PageChangedListener {
    private static final int MAX_RESULTS = 200;
    private static final String INDEX_FILE = HelpBrowserUtils.getString("helpbrowser.index.file");
    private static final String DOC_CENTER_FILE = HelpBrowserUtils.getString("helpbrowser.doccenter.file");
    private static final String SEARCH_RESULTS_FILE = HelpBrowserUtils.getString("helpbrowser.searchresults.file");
    private static final String QUERY_STRING_QDOC_FIELD = "qdoc";
    private static final String QUERY_STRING_PAGE_FIELD = "page";
    private static final int NUM_SEARCH_RESULTS = 10;
    private static final FacetLabelVisitor sFacetLabelVisitor = new FacetLabelVisitor();
    private final HtmlComponent<? extends HtmlActions> fHtmlComponent;
    private final SearchConfig fSearchConfig;
    private final DocumentationSet fDocumentationSet;
    private final String fBreadcrumbRoot;
    private ProductFilter fProductFilter;

    public DocSearchPageChangedListener(HtmlComponent<? extends HtmlActions> htmlComponent, SearchHelper searchHelper, String string) {
        this.fHtmlComponent = htmlComponent;
        this.fSearchConfig = searchHelper.getSearchConfig();
        this.fDocumentationSet = searchHelper.getDocumentationSet();
        this.fProductFilter = searchHelper.getProductFilter();
        this.fBreadcrumbRoot = string;
    }

    public void pageChanged(PageChangedEvent pageChangedEvent) {
        String string;
        if (pageChangedEvent != null && DocSearchPageChangedListener.isSearchResultsPage(string = pageChangedEvent.getBaseUrl())) {
            this.doSearchAsynchronous(string);
        }
    }

    private static boolean isSearchResultsPage(String string) {
        return string != null && string.contains(SEARCH_RESULTS_FILE);
    }

    private void doSearchAsynchronous(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DocSearchPageChangedListener.this.doSearch(string);
            }
        };
        new Thread(runnable).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSearch(String string) {
        String string2 = HelpBrowserUtils.getQueryStringValue(string = DocSearchPageChangedListener.unescapeEncodedStringFromHTML(string), QUERY_STRING_QDOC_FIELD);
        if (string2 == null || string2.length() == 0) {
            this.doDisplaySearchError(HelpBrowserUtils.getString("helpbrowser.error.search.string"), "");
            return;
        }
        String string3 = DocSearchPageChangedListener.getDecodedSearchString(string2);
        DocumentationQuery documentationQuery = new DocumentationQuery(string3, this.fDocumentationSet.getFormat());
        String string4 = documentationQuery.getSearchText();
        SearchEngineDocSearcher searchEngineDocSearcher = null;
        try {
            searchEngineDocSearcher = this.getSearcher(documentationQuery);
            searchEngineDocSearcher.doSearch();
            String string5 = HelpBrowserUtils.getQueryStringValue(string, QUERY_STRING_PAGE_FIELD);
            int n = DocSearchPageChangedListener.getPageNumber(string5);
            int n2 = DocSearchPageChangedListener.getStartPosition(n);
            SearchResults searchResults = searchEngineDocSearcher.getSearchResults(n2, 10);
            if (searchResults.getFullResultCount() == 0) {
                this.doDisplayNoResults(string4);
                return;
            }
            JsonEntity jsonEntity = this.getJsonPageData(searchResults.getFullResultCount(), string, n2, n, string3);
            JsonEntity jsonEntity2 = this.getJsonFacetLabel(searchEngineDocSearcher.getFacetResults());
            JsonEntity jsonEntity3 = DocSearchPageChangedListener.getJsonFacetResults(searchEngineDocSearcher.getFacetResults(), string);
            JsonEntity jsonEntity4 = this.getJsonSearchResults((SearchResults<DocumentationSearchResult>)searchResults);
            this.doDisplaySearchResults(jsonEntity4.getJsonString(), jsonEntity.getJsonString(), jsonEntity3.getJsonString(), jsonEntity2.getJsonString());
        }
        catch (SearchStringParseException searchStringParseException) {
            this.doDisplaySearchError(DocSearchPageChangedListener.getErrorMessage(searchStringParseException), string4);
        }
        catch (Exception exception) {
            this.doDisplaySearchError(HelpBrowserUtils.getString("helpbrowser.error.search.general"), string4);
        }
        finally {
            if (searchEngineDocSearcher != null) {
                try {
                    searchEngineDocSearcher.cleanup();
                }
                catch (SearchException searchException) {}
            }
        }
    }

    private static String getDecodedSearchString(String string) {
        try {
            return URLDecoder.decode(string, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    private SearchEngineDocSearcher getSearcher(DocumentationQuery documentationQuery) throws SearchStringParseException {
        SearchEngine searchEngine = DocSearchEngineFactory.createSearchEngine((SearchConfig)this.fSearchConfig, (DocumentationSet)this.fDocumentationSet);
        SearchEngineDocSearcher searchEngineDocSearcher = new SearchEngineDocSearcher(this.fDocumentationSet, searchEngine, documentationQuery);
        searchEngineDocSearcher.setMaxResults(200);
        if (this.fProductFilter != null) {
            searchEngineDocSearcher.addProductFilter(this.fProductFilter);
        }
        return searchEngineDocSearcher;
    }

    private JsonEntity getJsonPageData(int n, String string, int n2, int n3, String string2) {
        int n4 = DocSearchPageChangedListener.getEndPosition(n2, n);
        JsonEntity jsonEntity = DocSearchPageChangedListener.getJsonSummary(n2 + 1, n4 + 1, n);
        JsonEntity jsonEntity2 = DocSearchPageChangedListener.getJsonFooter(n2 + 1, n4 + 1, n, n3, string);
        JsonEntity jsonEntity3 = this.getJsonProductBreadcrumb();
        JsonEntity jsonEntity4 = DocSearchPageChangedListener.getJsonSearchTerm(string2);
        return DocSearchPageChangedListener.getJsonDataObject(jsonEntity, jsonEntity2, jsonEntity3, jsonEntity4);
    }

    private static JsonEntity getJsonSearchTerm(String string) {
        JsonArray jsonArray = new JsonArray();
        if (string != null) {
            jsonArray.addString(string);
        }
        return jsonArray;
    }

    private static String escapeEncodedStringForHTML(String string) {
        return string.replaceAll("%22", "&#034;");
    }

    private static String unescapeEncodedStringFromHTML(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("%22", "\\\"").replaceAll("%3A", ":");
    }

    private static int getPageNumber(String string) {
        return string != null ? Integer.valueOf(string) : 1;
    }

    private static int getStartPosition(int n) {
        return (n - 1) * 10;
    }

    private static int getEndPosition(int n, int n2) {
        int n3 = n + 10 - 1;
        if (n3 < n2) {
            return n3;
        }
        return n2 - 1;
    }

    private static JsonEntity getJsonDataObject(JsonEntity jsonEntity, JsonEntity jsonEntity2, JsonEntity jsonEntity3, JsonEntity jsonEntity4) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addJsonProperty("summarydata", jsonEntity);
        jsonObject.addJsonProperty("footerdata", jsonEntity2);
        jsonObject.addJsonProperty("productbreadcrumb", jsonEntity3);
        jsonObject.addJsonProperty("searchterm", jsonEntity4);
        return jsonObject;
    }

    private JsonEntity getJsonProductBreadcrumb() {
        return this.fBreadcrumbRoot == null ? new JsonObject() : this.getBreadcrumb(this.fBreadcrumbRoot);
    }

    private static JsonEntity getJsonSummary(int n, int n2, int n3) {
        JsonObject jsonObject = new JsonObject();
        String string = DocSearchPageChangedListener.getSummaryText(n, n2, n3);
        jsonObject.addStringProperty(DocSearchPageChangedListener.getSummaryTextPropertyName(), string);
        return jsonObject;
    }

    private static String getSummaryTextPropertyName() {
        return "summarytext";
    }

    private static String getSummaryText(int n, int n2, int n3) {
        String string = HelpBrowserUtils.getString("helpbrowser.seachresults.summary");
        string = MessageFormat.format(string, n, n2, n3);
        return string;
    }

    private static JsonEntity getJsonFooter(int n, int n2, int n3, int n4, String string) {
        JsonArray jsonArray = new JsonArray();
        JsonObject jsonObject = new JsonObject();
        String string2 = DocSearchPageChangedListener.getSummaryText(n, n2, n3);
        jsonObject.addStringProperty(DocSearchPageChangedListener.getSummaryTextPropertyName(), string2);
        JsonEntity jsonEntity = DocSearchPageChangedListener.getJsonFooterPages(n3, n4, string);
        jsonObject.addJsonProperty("footerpages", jsonEntity);
        jsonArray.addEntity(jsonObject);
        return jsonArray;
    }

    private static JsonEntity getJsonFooterPages(int n, int n2, String string) {
        JsonArray jsonArray = new JsonArray();
        int n3 = n % 10 == 0 ? n / 10 : n / 10 + 1;
        List<SearchResultPageWrapper> list = HelpBrowserUtils.getSearchResultPages(n3, n2);
        for (SearchResultPageWrapper searchResultPageWrapper : list) {
            String string2 = searchResultPageWrapper.getPageName();
            boolean bl = searchResultPageWrapper.isSelectedPage();
            boolean bl2 = searchResultPageWrapper.pageHasUrl();
            String string3 = "";
            if (bl2) {
                int n4 = searchResultPageWrapper.getUrlPageNumber();
                String string4 = String.valueOf(n4);
                String string5 = HelpBrowserUtils.addToUrlQueryString(string, QUERY_STRING_PAGE_FIELD, string4);
                string3 = HelpBrowserUtils.getQueryString(string5);
                string3 = DocSearchPageChangedListener.escapeEncodedStringForHTML(string3);
            }
            JsonEntity jsonEntity = DocSearchPageChangedListener.getJsonFooterPage(string2, bl, bl2, string3);
            jsonArray.addEntity(jsonEntity);
        }
        return jsonArray;
    }

    private static JsonEntity getJsonFooterPage(String string, Boolean bl, Boolean bl2, String string2) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addStringProperty("pagename", string);
        jsonObject.addStringProperty("isselected", bl.toString());
        jsonObject.addStringProperty("hasurl", bl2.toString());
        if (bl2.booleanValue()) {
            jsonObject.addStringProperty("pageurlquery", string2);
        }
        return jsonObject;
    }

    private static JsonEntity getJsonFacetResults(Iterable<DocFacetResults> iterable, String string) {
        JsonObject jsonObject = new JsonObject();
        String string2 = HelpBrowserUtils.removeQueryStringFromUrl(string, QUERY_STRING_PAGE_FIELD);
        for (DocFacetResults docFacetResults : iterable) {
            JsonEntity jsonEntity = DocSearchPageChangedListener.getJsonFacets(docFacetResults, string2);
            jsonObject.addJsonProperty(docFacetResults.getFacetType().getFacetPrefix(), jsonEntity);
        }
        JsonArray jsonArray = new JsonArray();
        jsonArray.addEntity(jsonObject);
        return jsonArray;
    }

    private JsonEntity getJsonFacetLabel(Iterable<DocFacetResults> iterable) {
        JsonArray jsonArray = new JsonArray();
        for (DocFacetResults docFacetResults : iterable) {
            Facetable facetable = docFacetResults.getSelectedFacet();
            if (facetable == null) continue;
            JsonObject jsonObject = new JsonObject();
            jsonObject.addStringProperty("field", docFacetResults.getFacetType().getFacetPrefix());
            jsonObject.addStringProperty("value", facetable.getQueryStringValue());
            facetable.accept((DocumentationFacetVisitor)sFacetLabelVisitor);
            String string = sFacetLabelVisitor.getMessage();
            jsonObject.addStringProperty("label", string);
            jsonArray.addEntity(jsonObject);
        }
        return jsonArray;
    }

    private static JsonEntity getJsonFacets(DocFacetResults docFacetResults, String string) {
        Facetable facetable;
        JsonObject jsonObject = new JsonObject();
        DocFacet docFacet = docFacetResults.getFacetType();
        String string2 = DocSearchPageChangedListener.getFacetTitle(docFacet);
        jsonObject.addStringProperty("facettitle", string2);
        List list = docFacetResults.getResults();
        Boolean bl = list != null && !list.isEmpty();
        JsonEntity jsonEntity = null;
        if (bl.booleanValue()) {
            jsonEntity = DocSearchPageChangedListener.getJsonRefinableFacets(docFacetResults.getResults(), string);
        }
        Boolean bl2 = (facetable = docFacetResults.getSelectedFacet()) != null;
        jsonObject.addStringProperty("hasrefinedfacet", bl2.toString());
        if (bl2.booleanValue()) {
            JsonEntity jsonEntity2 = DocSearchPageChangedListener.getJsonRefinedFacet(facetable, string, bl, jsonEntity);
            jsonObject.addJsonProperty("refinedfacet", jsonEntity2);
            jsonObject.addStringProperty("hasrefinablefacets", Boolean.FALSE.toString());
        } else {
            jsonObject.addStringProperty("hasrefinablefacets", bl.toString());
            if (bl.booleanValue()) {
                jsonObject.addJsonProperty("refinablefacets", jsonEntity);
            }
        }
        return jsonObject;
    }

    private static String getFacetTitle(DocFacet docFacet) {
        String string = HelpBrowserUtils.getString("helpbrowser.seachresults.facettitle");
        String string2 = HelpBrowserUtils.getString("helpbrowser.seachresults.facet." + docFacet.toString().toLowerCase(Locale.ENGLISH));
        return MessageFormat.format(string, string2);
    }

    private static JsonEntity getJsonRefinedFacet(Facetable facetable, String string, Boolean bl, JsonEntity jsonEntity) {
        JsonObject jsonObject = DocSearchPageChangedListener.getJsonRefinedFacet(facetable, string);
        jsonObject.addStringProperty("hasrefinedfacet", Boolean.FALSE.toString());
        jsonObject.addStringProperty("hasrefinablefacets", bl.toString());
        if (bl.booleanValue()) {
            jsonObject.addJsonProperty("refinablefacets", jsonEntity);
        }
        for (Facetable facetable2 = facetable.getParent(); facetable2 != null; facetable2 = facetable2.getParent()) {
            JsonObject jsonObject2 = DocSearchPageChangedListener.getJsonRefinedFacet(facetable2, string);
            jsonObject2.addStringProperty("hasrefinedfacet", Boolean.TRUE.toString());
            jsonObject2.addJsonProperty("refinedfacet", jsonObject);
            jsonObject2.addStringProperty("hasrefinablefacets", Boolean.FALSE.toString());
            jsonObject = jsonObject2;
        }
        return jsonObject;
    }

    private static JsonObject getJsonRefinedFacet(Facetable facetable, String string) {
        String string2;
        String string3;
        facetable.accept((DocumentationFacetVisitor)sFacetLabelVisitor);
        String string4 = sFacetLabelVisitor.getMessage();
        DocFacet docFacet = facetable.getFacetType();
        String string5 = docFacet.getFacetPrefix();
        String string6 = facetable.getQueryStringValue();
        Facetable facetable2 = facetable.getParent();
        if (facetable2 != null) {
            string3 = facetable2.getQueryStringValue();
            string2 = HelpBrowserUtils.addToUrlQueryString(string, QUERY_STRING_QDOC_FIELD, string5, string3);
        } else {
            string2 = HelpBrowserUtils.removeFromUrlQueryString(string, QUERY_STRING_QDOC_FIELD, string5);
        }
        string3 = HelpBrowserUtils.getQueryString(string2);
        return DocSearchPageChangedListener.getJsonFacet(string4, string6, string3);
    }

    private static JsonEntity getJsonRefinableFacets(Iterable<FacetResult<? extends Facetable>> iterable, String string) {
        JsonArray jsonArray = new JsonArray();
        Iterator<FacetResult<? extends Facetable>> iterator = iterable.iterator();
        for (int i = 0; i < 10 && iterator.hasNext(); ++i) {
            FacetResult<? extends Facetable> facetResult = iterator.next();
            JsonEntity jsonEntity = DocSearchPageChangedListener.getJsonRefinableFacet(facetResult, string);
            jsonArray.addEntity(jsonEntity);
        }
        return jsonArray;
    }

    private static JsonEntity getJsonRefinableFacet(FacetResult<? extends Facetable> facetResult, String string) {
        Facetable facetable = (Facetable)facetResult.getCategory();
        facetable.accept((DocumentationFacetVisitor)sFacetLabelVisitor);
        String string2 = sFacetLabelVisitor.getMessage();
        DocFacet docFacet = facetable.getFacetType();
        String string3 = docFacet.getFacetPrefix();
        String string4 = facetable.getQueryStringValue();
        String string5 = HelpBrowserUtils.addToUrlQueryString(string, QUERY_STRING_QDOC_FIELD, string3, string4);
        String string6 = HelpBrowserUtils.getQueryString(string5);
        return DocSearchPageChangedListener.getJsonFacet(string2, string4, string6);
    }

    private static JsonObject getJsonFacet(String string, String string2, String string3) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addStringProperty("facetname", string);
        jsonObject.addStringProperty("facetcount", "");
        jsonObject.addStringProperty("facetid", string2);
        jsonObject.addStringProperty("faceturlquery", DocSearchPageChangedListener.escapeEncodedStringForHTML(string3));
        return jsonObject;
    }

    private JsonEntity getJsonSearchResults(SearchResults<DocumentationSearchResult> searchResults) {
        JsonArray jsonArray = new JsonArray();
        int n = searchResults.getNumIncluded();
        int n2 = searchResults.getStart();
        int n3 = n2 + n;
        for (int i = n2; i < n3; ++i) {
            JsonEntity jsonEntity = this.getJsonSearchResult((DocumentationSearchResult)searchResults.getResult(i));
            jsonArray.addEntity(jsonEntity);
        }
        return jsonArray;
    }

    private JsonEntity getJsonSearchResult(DocumentationSearchResult documentationSearchResult) {
        List list;
        JsonEntity jsonEntity;
        String string = documentationSearchResult.getTitle();
        String string2 = documentationSearchResult.getSummary();
        Boolean bl = string2 != null && string2.length() > 0;
        DocProduct docProduct = documentationSearchResult.getProduct();
        String string3 = docProduct != null ? docProduct.getHelpLocation() : "";
        String string4 = docProduct != null ? docProduct.getDisplayName() : "";
        String string5 = documentationSearchResult.getPath();
        String string6 = documentationSearchResult.getDescription();
        if (string6 != null && string6.length() > 0) {
            jsonEntity = DocSearchPageChangedListener.getJsonDescription(string6);
        } else {
            list = documentationSearchResult.getHighlights();
            jsonEntity = DocSearchPageChangedListener.getJsonHighlights(list);
        }
        list = documentationSearchResult.getBreadCrumbs();
        InformationType informationType = documentationSearchResult.getType();
        String string7 = informationType != null ? informationType.getIndexString() : "";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addStringProperty("title", string);
        jsonObject.addStringProperty("hassummary", bl.toString());
        if (bl.booleanValue()) {
            jsonObject.addStringProperty("summary", string2);
        }
        jsonObject.addStringProperty("product", string3);
        jsonObject.addStringProperty("path", string5);
        jsonObject.addJsonProperty("highlights", jsonEntity);
        JsonEntity jsonEntity2 = this.getJsonBreadcrumbs(list, string3, string4);
        jsonObject.addJsonProperty("breadcrumbs", jsonEntity2);
        jsonObject.addStringProperty("type", string7);
        return jsonObject;
    }

    private JsonEntity getJsonBreadcrumbs(Iterable<ResultCategory> iterable, String string, String string2) {
        if (iterable == null) {
            return new JsonArray();
        }
        JsonArray jsonArray = new JsonArray();
        for (ResultCategory resultCategory : iterable) {
            JsonEntity jsonEntity = this.getJsonBreadcrumb(resultCategory, string, string2);
            jsonArray.addEntity(jsonEntity);
        }
        return jsonArray;
    }

    private JsonEntity getJsonBreadcrumb(ResultCategory resultCategory, String string, String string2) {
        ArrayList<Breadcrumb> arrayList = new ArrayList<Breadcrumb>();
        while (resultCategory != null) {
            arrayList.add(new Breadcrumb(resultCategory.getLabel(), resultCategory.getRelativePath(), string));
            resultCategory = resultCategory.getParent();
        }
        JsonArray jsonArray = new JsonArray();
        JsonEntity jsonEntity = this.getProductBreadcrumb(string2, string);
        jsonArray.addEntity(jsonEntity);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Breadcrumb breadcrumb = (Breadcrumb)arrayList.get(i);
            jsonEntity = DocSearchPageChangedListener.getJsonCrumb(breadcrumb);
            jsonArray.addEntity(jsonEntity);
        }
        return jsonArray;
    }

    private JsonEntity getBreadcrumb(String string) {
        return string.matches("^.*(R20\\d\\d[ab]).*$") ? this.getLandingPageBreadcrumb(string) : this.getProductBreadcrumb(string);
    }

    private JsonEntity getLandingPageBreadcrumb(String string) {
        return DocSearchPageChangedListener.getJsonCrumb(DocSearchPageChangedListener.getBreadcrumbLabel(string), DOC_CENTER_FILE, "");
    }

    private static String getBreadcrumbLabel(String string) {
        String string2 = HelpBrowserUtils.getString("helpbrowser.seachresults.breadcrumb.release.label");
        string2 = MessageFormat.format(string2, string);
        return string2;
    }

    private JsonEntity getProductBreadcrumb(String string) {
        DocProduct docProduct = this.fDocumentationSet.getProductByIndexString(string);
        return this.getProductBreadcrumb(docProduct.getDisplayName(), docProduct.getHelpLocation());
    }

    private JsonEntity getProductBreadcrumb(String string, String string2) {
        return DocSearchPageChangedListener.getJsonCrumb(string, INDEX_FILE, string2);
    }

    private static JsonEntity getJsonCrumb(Breadcrumb breadcrumb) {
        return DocSearchPageChangedListener.getJsonCrumb(breadcrumb.getLabel(), breadcrumb.getRelativePath(), breadcrumb.getHelpLocation());
    }

    private static JsonEntity getJsonCrumb(String string, String string2, String string3) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addStringProperty("label", string);
        jsonObject.addStringProperty("relativepath", string2);
        jsonObject.addStringProperty("product", string3);
        jsonObject.addStringProperty("search", HelpBrowserUtils.getString("helpbrowser.seachresults.breadcrumb.search"));
        return jsonObject;
    }

    private static JsonEntity getJsonDescription(String string) {
        JsonArray jsonArray = new JsonArray();
        jsonArray.addString(string);
        return jsonArray;
    }

    private static JsonEntity getJsonHighlights(Iterable<SearchHighlight> iterable) {
        if (iterable == null) {
            return new JsonArray();
        }
        JsonArray jsonArray = new JsonArray();
        for (SearchHighlight searchHighlight : iterable) {
            String string = DocSearchPageChangedListener.getHighlightHtml(searchHighlight);
            jsonArray.addString(string);
        }
        return jsonArray;
    }

    private static String getHighlightHtml(SearchHighlight searchHighlight) {
        String string = searchHighlight.getHighlightText();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (SearchHighlight.Extent extent : searchHighlight.getExtents()) {
            stringBuilder.append(string.substring(n, extent.getStart()));
            stringBuilder.append("<b>");
            stringBuilder.append(extent.getText());
            stringBuilder.append("</b>");
            n = extent.getEnd();
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    private static String getErrorMessage(SearchStringParseException searchStringParseException) {
        return HelpBrowserUtils.getString(DocSearchPageChangedListener.getErrorMessageKey(searchStringParseException.getType()));
    }

    private static String getErrorMessageKey(SearchStringParseException.Type type) {
        switch (type) {
            case EMPTY_SEARCH_STRING: {
                return "helpbrowser.error.search.string";
            }
            case MISMATCHED_QUOTES: {
                return "helpbrowser.error.search.mismatched_quotes";
            }
            case TOO_FEW_NONWILDCARD_CHARS: {
                return "helpbrowser.error.search.too_few_nonwildcard";
            }
            case WILDCARD_IN_EXACT_PHRASE: {
                return "helpbrowser.error.search.wildcard_exact_phrase";
            }
            case STARTS_WITH_WILDCARD: {
                return "helpbrowser.error.search.wildcard_start";
            }
            case NO_SEARCHABLE_WORDS: {
                return "helpbrowser.error.search.no_searchable_words";
            }
            case TOO_FEW_CHARS: {
                return "helpbrowser.error.search.too_few_chars";
            }
        }
        return "helpbrowser.error.search.general";
    }

    private void doDisplaySearchError(String string, String string2) {
        this.fHtmlComponent.executeScript(String.format("displayError('%s','%s');", string, string2));
    }

    private void doDisplaySearchResults(String string, String string2, String string3, String string4) {
        this.chainJavaScriptCalls(0, String.format("populateLookupTable(%s);", string4), String.format("populateResultsList(%s);", string), String.format("populateResultData(%s);", string2), String.format("populateFacets(%s);", string3));
    }

    private void doDisplayNoResults(String string) {
        String string2 = HelpBrowserUtils.getString("helpbrowser.search.noresults");
        String string3 = string.replaceAll("'", "\\\\'");
        String string4 = MessageFormat.format(string2, string3);
        this.fHtmlComponent.executeScript(String.format("displayMessage('%s','%s');", string4, string));
    }

    private void chainJavaScriptCalls(final int n, final String ... stringArray) {
        this.fHtmlComponent.executeScript(stringArray[n], (HtmlDataListener)new HtmlDataListener<String>(){

            public void dataRetrieved(String string) {
                int n2 = n + 1;
                if (n2 < stringArray.length) {
                    DocSearchPageChangedListener.this.chainJavaScriptCalls(n2, stringArray);
                }
            }
        });
    }

    private static class Breadcrumb {
        private final String iLabel;
        private final String iRelativePath;
        private final String iHelpLocation;

        private Breadcrumb(String string, String string2, String string3) {
            this.iLabel = string;
            this.iRelativePath = string2;
            this.iHelpLocation = string3;
        }

        private String getLabel() {
            return this.iLabel;
        }

        private String getRelativePath() {
            return this.iRelativePath;
        }

        private String getHelpLocation() {
            return this.iHelpLocation;
        }
    }
}

