/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.suggestions;

import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.help.helpui.json.JsonArray;
import com.mathworks.help.helpui.json.JsonObject;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.suggestion.PageSuggestion;
import com.mathworks.html.UrlFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SuggestionUtils {
    private static final String TITLE_SUMMARY_SEPARATOR = " - ";
    private static final int TITLE_PLUS_SUMMARY_CHARS = 83 - " - ".length();

    public static JsonArray createWordSuggestionArray(Iterable<String> iterable) {
        JsonArray jsonArray = new JsonArray();
        for (String string : iterable) {
            jsonArray.addString(string);
        }
        return jsonArray;
    }

    public static JsonArray createPageSuggestionArray(InformationType informationType, String string, Iterable<PageSuggestion> iterable) {
        JsonArray jsonArray = new JsonArray();
        String string2 = informationType.getQueryStringValue();
        for (PageSuggestion pageSuggestion : iterable) {
            jsonArray.addEntity(SuggestionUtils.getSuggestionJson(string2, string, pageSuggestion));
        }
        return jsonArray;
    }

    public static JsonObject getSuggestionJson(String string, String string2, PageSuggestion pageSuggestion) {
        JsonObject jsonObject = new JsonObject();
        String string3 = pageSuggestion.getTitle();
        jsonObject.addStringProperty("title", string3);
        String string4 = SuggestionUtils.trimSummary(string3, pageSuggestion.getSummary(), TITLE_PLUS_SUMMARY_CHARS);
        jsonObject.addStringProperty("summary", string4 != null && string4.length() > 0 ? TITLE_SUMMARY_SEPARATOR + string4 : "");
        jsonObject.addStringProperty("product", pageSuggestion.getProduct().getDisplayName());
        String string5 = HelpBrowserUtils.buildDocumentationPath(string2, pageSuggestion.getProduct(), pageSuggestion.getPath());
        string5 = new UrlFormatter(false).formatUrl(string5);
        jsonObject.addStringProperty("path", string5);
        jsonObject.addStringProperty("type", string);
        return jsonObject;
    }

    public static String trimSummary(String string, String string2, int n) {
        if (string2 != null && string2.length() > 0) {
            int n2 = n - string.length();
            return SuggestionUtils.trimStringToWordBreak(string2, n2, "...");
        }
        return string2;
    }

    public static String trimStringToWordBreak(String string, int n, String string2) {
        if (string.length() > n) {
            Pattern pattern = Pattern.compile("^.{0," + String.valueOf(n - string2.length() - 1) + "}\\w\\b");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                return matcher.group() + string2;
            }
            return "";
        }
        return string;
    }

    public static String[] getSearchWords(String string) {
        return string.split("\\W+");
    }
}

