/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.compare.concr;

import com.mathworks.mlwidgets.dialog.ProgressBarDialog;
import com.mathworks.mlwidgets.html.HTMLCallbackProvider;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringEscapeUtils;

class ListReportUpdater {
    private String fScript;
    private Thread fThread;
    private boolean fReportReady;
    private boolean fReportClosed;
    private ProgressBarDialog fProgressBar;
    private String fReportID;
    private HTMLCallbackProvider fReport;

    public ListReportUpdater(HTMLCallbackProvider hTMLCallbackProvider, String string, ProgressBarDialog progressBarDialog) {
        this.fReport = hTMLCallbackProvider;
        this.fReportReady = false;
        this.fReportClosed = false;
        this.fReportID = string;
        this.fProgressBar = progressBarDialog;
    }

    public void reportClosed() {
        this.fReportClosed = true;
    }

    public synchronized void updateReport(String string, String string2, int n) {
        String string3 = StringEscapeUtils.escapeJavaScript((String)string);
        string3 = string3.replace("xmlns:filelistcomparison=\\\"http://www.mathworks.com/filelistcomparison\\\"", "");
        string3 = string3.replace(":", "&#58;");
        String string4 = "replace_table_cell(\"" + string2 + "\",\"" + string3 + "\"," + n + ");";
        if (this.fThread != null) {
            assert (this.fScript != null);
            this.fScript = this.fScript + "\n" + string4;
        } else if (this.fReportReady) {
            this.doUpdate(string4);
        } else {
            this.fScript = string4;
            this.startWaitThread();
        }
    }

    private void doUpdate(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ListReportUpdater.this.fReportClosed) {
                    ListReportUpdater.this.fReport.executeScript(string);
                }
            }
        });
    }

    public boolean isReportReady() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.fReportReady) {
            return true;
        }
        try {
            String string = this.fReport.executeScriptWithReturn("pageid");
            if (!string.equals(this.fReportID)) {
                return false;
            }
            if (this.fProgressBar != null) {
                this.fProgressBar.dispose();
            }
            this.fReportReady = true;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private synchronized void executePendingScript() {
        String string = this.fScript;
        this.fScript = null;
        this.fThread = null;
        this.doUpdate(string);
    }

    private void startWaitThread() {
        assert (!SwingUtilities.isEventDispatchThread());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 100; ++i) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ListReportUpdater.this.fReportReady = ListReportUpdater.this.isReportReady();
                            }
                        });
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (ListReportUpdater.this.fReportReady) {
                        ListReportUpdater.this.executePendingScript();
                        return;
                    }
                    if (ListReportUpdater.this.fReportClosed) {
                        ListReportUpdater.this.fThread = null;
                        return;
                    }
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        return;
                    }
                }
                if (ListReportUpdater.this.fProgressBar != null) {
                    ListReportUpdater.this.fProgressBar.dispose();
                }
                throw new RuntimeException("Page not ready to receive Javascript updates");
            }
        };
        this.fThread = new Thread(runnable);
        this.fThread.start();
    }
}

