/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.source.impl;

import com.mathworks.comparisons.source.impl.ComparisonSourceImpl;
import com.mathworks.comparisons.source.type.CSTypeString;
import com.mathworks.comparisons.util.LocalIOUtils;
import com.mathworks.util.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public final class StringSource
extends ComparisonSourceImpl {
    private String mName;
    private String mData;
    private Charset mEncoding;
    private File mTempFile = null;
    private InputStream mInputStream = null;

    public StringSource(String string, String string2, Charset charset) {
        this.mName = string;
        this.mData = string2;
        this.mEncoding = charset == null ? Charset.defaultCharset() : charset;
        this.setType(new CSTypeString());
    }

    @Override
    public void refresh() {
        this.dispose();
    }

    @Override
    public synchronized void dispose() {
        if (this.mTempFile != null) {
            this.mTempFile.delete();
            this.mTempFile = null;
        }
        if (this.mInputStream != null) {
            LocalIOUtils.closeQuietly(this.mInputStream);
            this.mInputStream = null;
        }
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    private String getName() {
        return this.mName;
    }

    private String getText() {
        return this.mData;
    }

    private synchronized File getReadableLocation() {
        if (this.mTempFile == null) {
            String string = this.getName() + "_";
            try {
                this.mTempFile = LocalIOUtils.createTempFile(string, null);
                LocalIOUtils.writeStringToFile(this.mData, this.mTempFile, this.mEncoding);
            }
            catch (IOException iOException) {
                Log.logException((Exception)iOException);
            }
        }
        return this.mTempFile;
    }

    private synchronized InputStream getInputStream() {
        if (this.mInputStream == null) {
            try {
                this.mInputStream = new ByteArrayInputStream(this.mData.getBytes(this.mEncoding.name()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.logException((Exception)unsupportedEncodingException);
            }
        }
        return this.mInputStream;
    }
}

