/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.util;

import com.mathworks.widgets.SyntaxTextPaneUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class LocalIOUtils {
    private LocalIOUtils() {
    }

    public static File createTempFile(String string, String string2) throws IOException {
        File file = File.createTempFile(string, string2);
        file.deleteOnExit();
        return file;
    }

    public static void writeStringToFile(String string, File file) throws IOException {
        LocalIOUtils.writeStringToFile(string, file, Charset.defaultCharset());
    }

    public static void writeStringToFile(String string, File file, Charset charset) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)string, (String)charset.name());
    }

    public static void copyStreamToFile(InputStream inputStream, File file) throws IOException {
        com.mathworks.util.FileUtils.copyStreamToFile((InputStream)inputStream, (File)file);
    }

    public static void closeQuietly(InputStream inputStream) {
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public static boolean contentEquals(InputStream inputStream, InputStream inputStream2) throws IOException {
        return IOUtils.contentEquals((InputStream)inputStream, (InputStream)inputStream2);
    }

    public static Charset getDefaultEncoding() {
        return SyntaxTextPaneUtilities.getDefaultFileEncoding();
    }

    public static String truncatePathName(String string) {
        return com.mathworks.util.FileUtils.truncatePathname((String)string);
    }

    public static String getFileName(String string) {
        String string2 = string;
        if (string.contains(File.separator)) {
            string2 = string2.substring(string.lastIndexOf(File.separator) + 1);
        } else if (string.contains("/")) {
            string2 = string2.substring(string.lastIndexOf("/") + 1);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileChecksum(String string) throws IOException {
        MessageDigest messageDigest = LocalIOUtils.getMessageDigest();
        File file = new File(string);
        byte[] byArray = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            int n = fileInputStream.available();
            while (n > 0) {
                if (byArray == null) {
                    byArray = new byte[n > 100000 ? 100000 : n];
                }
                int n2 = fileInputStream.read(byArray);
                messageDigest.update(byArray, 0, n2);
                n = fileInputStream.available();
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return messageDigest.digest();
    }

    private static MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
    }
}

