/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.util.Modules;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallModule;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.InstalledProduct;
import com.mathworks.install.InstalledProductData;
import com.mathworks.install.InstallerRequirements;
import com.mathworks.install.OwningProductResponse;
import com.mathworks.install.archive.Archive;
import com.mathworks.install.archive.ArchiveFactory;
import com.mathworks.install.archive.ArchiveInputStreamExtractor;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.instutil.DefaultSecurityOverrideImpl;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.ExecutorServiceManager;
import com.mathworks.instutil.ExecutorServiceManagerImpl;
import com.mathworks.instutil.IOObserver;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.MachineInfo;
import com.mathworks.instutil.SecurityOverride;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.instutil.logging.AppLoggerImpl;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.webproxy.ProxyConfigurationVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;

public final class InstalledProductFactory {
    private InstalledProductFactory() {
    }

    public static Collection<InstalledProduct> getInstalledProducts(String string) {
        Task<Collection<InstalledProduct>> task = new Task<Collection<InstalledProduct>>(){

            @Override
            public Collection<InstalledProduct> execute(InstalledProductData installedProductData, File file) {
                InstallableProduct[] installableProductArray = installedProductData.getInstallableProds(file);
                ArrayList<InstalledProduct> arrayList = new ArrayList<InstalledProduct>();
                for (InstallableProduct installableProduct : installableProductArray) {
                    if (!installableProduct.isCustomerFacing()) continue;
                    InstalledProduct installedProduct = InstalledProductFactory.createInstalledProduct(installableProduct);
                    arrayList.add(installedProduct);
                }
                return arrayList;
            }
        };
        try {
            return (Collection)new InstallerWorkSpace().executeTask(task, string);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static InstalledProduct createInstalledProduct(InstallableProduct installableProduct) {
        return new InstalledProduct(installableProduct);
    }

    public static OwningProductResponse getOwningProducts(String string, final String[] stringArray) throws Exception {
        Task<OwningProductResponse> task = new Task<OwningProductResponse>(){

            @Override
            public OwningProductResponse execute(InstalledProductData installedProductData, File file) throws Exception {
                installedProductData.loadAllData(file);
                return installedProductData.getOwningFiles(file, stringArray);
            }
        };
        return (OwningProductResponse)new InstallerWorkSpace().executeTask(task, string);
    }

    private static class InstallerWorkSpace<V> {
        private InstallerWorkSpace() {
        }

        private static Injector createInjector(final File file) {
            InstallModule installModule = new InstallModule((Module)new AbstractModule(){

                protected void configure() {
                    this.bind(ArchiveFactory.class).toInstance((Object)new ArchiveFactory(){

                        @Override
                        public Archive createArchive(File file) throws IOException {
                            return null;
                        }
                    });
                }
            });
            return Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{installModule}).with(new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(ExecutorServiceManager.class).to(ExecutorServiceManagerImpl.class).in(Scopes.SINGLETON);
                    this.bind(AppLogger.class).toInstance((Object)new AppLoggerImpl());
                    this.bind(SecurityOverride.class).toInstance((Object)new DefaultSecurityOverrideImpl());
                    this.bind(ArchiveInputStreamExtractor.class).toInstance((Object)new ArchiveInputStreamExtractor(){

                        @Override
                        public void extract(InputStream inputStream, File file, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
                        }
                    });
                    this.bind(InstallerRequirements.class).toInstance((Object)new InstallerRequirements(){

                        @Override
                        public boolean userIsAdmin() {
                            return false;
                        }

                        @Override
                        public boolean anyMatlabRunning() {
                            return false;
                        }

                        @Override
                        public boolean isRunningInEmulationMode() {
                            return false;
                        }
                    });
                    this.bind(Downloader.class).toInstance((Object)new Downloader(){

                        public long download(ProxyConfiguration proxyConfiguration, URL uRL, File file, IOObserver ... iOObserverArray) throws InterruptedException, IOException {
                            return 0L;
                        }
                    });
                    this.bind(ProxyConfiguration.class).toInstance((Object)new ProxyConfiguration(){

                        public boolean accept(ProxyConfigurationVisitor proxyConfigurationVisitor) {
                            return false;
                        }

                        public Proxy findProxyForURL(URL uRL) {
                            return null;
                        }
                    });
                }

                @Provides
                Machine providesMachine() throws JNIException {
                    return new MachineInfo(file.getAbsolutePath());
                }
            }})});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private V executeTask(Task<V> task, String string) throws Exception {
            File file = new File(string);
            Injector injector = InstallerWorkSpace.createInjector(file);
            InstalledProductData installedProductData = (InstalledProductData)injector.getInstance(InstalledProductData.class);
            ExecutorServiceManager executorServiceManager = (ExecutorServiceManager)injector.getInstance(ExecutorServiceManager.class);
            AppLogger appLogger = (AppLogger)injector.getInstance(AppLogger.class);
            try {
                V v = task.execute(installedProductData, file);
                return v;
            }
            finally {
                executorServiceManager.shutdownAndAwaitTermination();
                appLogger.close();
            }
        }
    }

    private static interface Task<V> {
        public V execute(InstalledProductData var1, File var2) throws Exception;
    }
}

