/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.Command;
import com.mathworks.instutil.Registry;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;

final class RegisterUninstallerCommand
implements Command {
    static final String UNINSTALL_VERSION_SUB_KEY = "Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\";
    static final String INSTALL_LOCATION_NAME = "InstallLocation";
    static final String DISPLAY_ICON_NAME = "DisplayIcon";
    static final String UNINSTALL_STRING_NAME = "UninstallString";
    static final String DISPLAY_NAME_NAME = "DisplayName";
    static final String DISPLAY_VERSION_NAME = "DisplayVersion";
    static final String URLINFO_ABOUT_NAME = "URLInfoAbout";
    static final String URLINFO_ABOUT_VALUE = "www.mathworks.com";
    static final String PUBLISHER_NAME = "Publisher";
    static final String PUBLISHER_VALUE = "The MathWorks, Inc.";
    static final String HELP_LINK_NAME = "HelpLink";
    static final String HELP_LINK_VALUE = "www.mathworks.com/support";
    private final String appRelease;
    private final String appName;
    private final String displayName;
    private final String pathToUninstallExe;
    private final String pathToIconFile;
    private final String appVersion;
    private final Registry registry;
    private final AppLogger appLogger;

    RegisterUninstallerCommand(Registry registry, String string, String string2, String string3, String string4, String string5, String string6, AppLogger appLogger) {
        this.appRelease = string3;
        this.appName = string;
        this.displayName = string4;
        this.pathToUninstallExe = string5;
        this.pathToIconFile = string6;
        this.appVersion = string2;
        this.registry = registry;
        this.appLogger = appLogger;
    }

    @Override
    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.appLogger.logMsg("Registering Uninstaller");
        this.setDisplayName();
        this.setUninstallString(file);
        this.setDisplayIcon(file);
        this.setInstallLocation(file);
        this.setDisplayVersion();
        this.setURLInfoAbout();
        this.setPublisher();
        this.setHelpLink();
    }

    @Override
    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.appLogger.logMsg("Unregistering Uninstaller");
        this.appLogger.logMsg("removing registry key HKEY_LOCAL_MACHINE\\" + this.getUninstallVersionSubKey());
        this.registry.deleteRegKeyIfValueMatches("HKEY_LOCAL_MACHINE", this.getUninstallVersionSubKey(), INSTALL_LOCATION_NAME, file.getAbsolutePath());
    }

    private String getUninstallVersionSubKey() {
        return UNINSTALL_VERSION_SUB_KEY + this.appName + ' ' + this.appRelease;
    }

    private void setUninstallKeyValue(String string, String string2) {
        this.appLogger.logMsg("setting registry key HKEY_LOCAL_MACHINE\\" + this.getUninstallVersionSubKey() + "\\" + string + " to " + string2);
        this.registry.setRegKeyValue("HKEY_LOCAL_MACHINE", this.getUninstallVersionSubKey(), string, string2);
    }

    private void setHelpLink() {
        this.setUninstallKeyValue(HELP_LINK_NAME, HELP_LINK_VALUE);
    }

    private void setPublisher() {
        this.setUninstallKeyValue(PUBLISHER_NAME, PUBLISHER_VALUE);
    }

    private void setURLInfoAbout() {
        this.setUninstallKeyValue(URLINFO_ABOUT_NAME, URLINFO_ABOUT_VALUE);
    }

    private void setDisplayVersion() {
        this.setUninstallKeyValue(DISPLAY_VERSION_NAME, this.appVersion);
    }

    private void setInstallLocation(File file) {
        this.setUninstallKeyValue(INSTALL_LOCATION_NAME, file.getAbsolutePath());
    }

    private void setDisplayIcon(File file) {
        File file2 = RegisterUninstallerCommand.getAbsoluteFile(file, this.pathToIconFile);
        this.setUninstallKeyValue(DISPLAY_ICON_NAME, file2.getAbsolutePath());
    }

    private void setUninstallString(File file) {
        File file2 = RegisterUninstallerCommand.getAbsoluteFile(file, this.pathToUninstallExe);
        this.setUninstallKeyValue(UNINSTALL_STRING_NAME, file2.getAbsolutePath() + " " + file.getAbsolutePath());
    }

    private void setDisplayName() {
        this.setUninstallKeyValue(DISPLAY_NAME_NAME, this.displayName);
    }

    private static File getAbsoluteFile(File file, String string) {
        return new File(file, string);
    }
}

