/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.doc.DocDestination;
import com.mathworks.install.command.doc.DocLandingPageCommand;
import com.mathworks.install.command.doc.DocProductList;
import com.mathworks.install.command.doc.GenerateDocSetCommand;
import com.mathworks.install.command.doc.InstallerDocProductList;
import com.mathworks.install.command.doc.SearchIndexCommand;
import com.mathworks.install.command.doc.SharedDocSubCommand;
import com.mathworks.instutil.FileIO;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.FilePermissionsUtil;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.MachineInfo;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class BuildSharedDocCommand
implements Command {
    private final List<SharedDocSubCommand> subCommands;
    private final DocProductList prodList;
    private final DocDestination destination;

    public BuildSharedDocCommand(IO iO) {
        this(iO, DocDestination.INSTALL, false);
    }

    private BuildSharedDocCommand(IO iO, DocDestination docDestination, boolean bl) {
        this.prodList = new InstallerDocProductList(iO);
        this.destination = docDestination;
        this.subCommands = Arrays.asList(BuildSharedDocCommand.getSubCommands(iO, docDestination, bl));
    }

    private static SharedDocSubCommand[] getSubCommands(IO iO, DocDestination docDestination, boolean bl) {
        return new SharedDocSubCommand[]{new SearchIndexCommand(iO), new DocLandingPageCommand(iO, docDestination), new GenerateDocSetCommand(iO, bl)};
    }

    @Override
    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        File file2 = BuildSharedDocCommand.getDocRoot(file);
        this.execute(file2);
    }

    @Override
    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.execute(string, file, installFlowControlHandler);
    }

    private void execute(File file) throws IOException, InterruptedException {
        this.prodList.populate(file, this.destination);
        if (this.prodList.isEmpty()) {
            for (SharedDocSubCommand sharedDocSubCommand : this.subCommands) {
                sharedDocSubCommand.handleNoProducts(file);
            }
        } else {
            for (SharedDocSubCommand sharedDocSubCommand : this.subCommands) {
                sharedDocSubCommand.handleProductsFound(file, this.prodList);
            }
        }
    }

    private static File getDocRoot(File file) {
        return new File(file, "help");
    }

    public static void main(String[] stringArray) throws IOException, JNIException, InterruptedException {
        if (stringArray.length > 1) {
            BuildSharedDocCommand.buildSharedDocFiles(stringArray[0], stringArray[1]);
        } else {
            BuildSharedDocCommand.buildSharedDocFiles(stringArray[0], stringArray[0]);
        }
    }

    public static void buildSharedDocFiles(String string, String string2) throws IOException, InterruptedException, JNIException {
        BuildSharedDocCommand.buildSharedDocFiles(string, string2, DocDestination.INSTALL);
    }

    public static void buildSharedDocFiles(String string, DocDestination docDestination) throws IOException, InterruptedException, JNIException {
        BuildSharedDocCommand.buildSharedDocFiles(string, string, docDestination);
    }

    private static void buildSharedDocFiles(String string, String string2, DocDestination docDestination) throws IOException, InterruptedException, JNIException {
        File file;
        string = string.trim();
        IO iO = BuildSharedDocCommand.createIoForBat(new File(string2.trim()));
        if (iO.isDirectory(file = new File(string, "help"))) {
            BuildSharedDocCommand buildSharedDocCommand = new BuildSharedDocCommand(iO, docDestination, true);
            buildSharedDocCommand.execute(file);
        } else {
            System.err.println(file + " is not a valid docroot");
        }
    }

    public static DocDestination resolveDestination(String string) {
        try {
            return DocDestination.valueOf(string.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception exception) {
            System.out.println("Invalid destination: [" + string + "].  Valid options are:");
            for (DocDestination docDestination : DocDestination.values()) {
                System.out.println("\t" + docDestination.toString());
            }
            System.out.println("Using INSTALL destination.");
            return DocDestination.INSTALL;
        }
    }

    private static IO createIoForBat(File file) throws JNIException {
        File file2 = new File(file, "bin");
        String string = MachineInfo.getArch();
        File file3 = new File(file2, string);
        return new FileIO((FilePermissions)new FilePermissionsUtil(file3.toString()));
    }
}

