/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AbstractFigurePanelProxy;
import com.mathworks.hg.peer.AbstractUicontrolPeer;
import com.mathworks.hg.peer.FigureBorderLayout;
import com.mathworks.hg.peer.FigureChild;
import com.mathworks.hg.peer.FigureComponentContainerNotification;
import com.mathworks.hg.peer.FigureComponentContainerProxy;
import com.mathworks.hg.peer.FigureComponentNotification;
import com.mathworks.hg.peer.FigureNotification;
import com.mathworks.hg.peer.FigureNotificationHandler;
import com.mathworks.hg.peer.FigureNotificationHandlerImpl;
import com.mathworks.hg.peer.FigureOverlayLayout;
import com.mathworks.hg.peer.FigurePanelProxyNotification;
import com.mathworks.hg.peer.HeavyweightLightweightContainerFactory;
import com.mathworks.hg.peer.UIComponentManager;
import com.mathworks.hg.peer.UIComponentParent;
import com.mathworks.util.PlatformInfo;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager2;
import java.awt.Panel;
import java.awt.event.ComponentAdapter;
import java.awt.peer.ComponentPeer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class FigurePanel
implements AbstractFigurePanelProxy {
    private Container fContainer = null;
    private FigureNotificationHandlerImpl fNotificationHandler = new FigureNotificationHandlerImpl();
    protected boolean fLightweight = true;
    protected JComponent fComponentContainer = null;
    protected Component fAxisComponent = null;
    protected int fLayoutManagerId = 1001;
    protected UIComponentManager fCompManager = null;
    private boolean fInitialized = false;
    private boolean fDisposed = false;
    private static final String sPanelName = "fFigurePanel";

    public void dispose() {
        this.fCompManager.setComponentContainer(null);
        this.fCompManager = null;
        this.fContainer = null;
        this.fAxisComponent = null;
        this.fComponentContainer = null;
        this.setNotificationSuccessor(null);
        this.fDisposed = true;
    }

    @Override
    public void handleNotification(FigureNotification figureNotification) {
        if (figureNotification instanceof FigureComponentNotification) {
            FigureComponentNotification figureComponentNotification = (FigureComponentNotification)figureNotification;
            int n = figureNotification.getType();
            if (n == 1) {
                if (!(figureComponentNotification instanceof FigureComponentContainerNotification)) {
                    this.fAxisComponent = figureComponentNotification.getComponent();
                }
                this.reconstructFigurePanel();
                if (figureComponentNotification instanceof FigureComponentContainerNotification) {
                    this.fNotificationHandler.handleNotification(figureNotification);
                }
            } else if (n == 2) {
                assert (this.fInitialized);
                if (this.fDisposed) {
                    return;
                }
                Container container = this.getContainer();
                assert (container != null);
                assert (this.fAxisComponent.equals(figureComponentNotification.getComponent()));
                container.remove(this.fAxisComponent);
                container.validate();
            }
        } else {
            this.fNotificationHandler.handleNotification(figureNotification);
        }
    }

    private void reconstructFigurePanel() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must assemble the figure panel on the EDT.";
        assert (this.getContainer() != null) : "Figure panel not properly initialized";
        Container container = this.getContainer();
        container.removeAll();
        this.assembleFigurePanel();
    }

    @Override
    public FigureNotificationHandler getNotificationSuccessor() {
        return this.fNotificationHandler.getNotificationSuccessor();
    }

    @Override
    public void setNotificationSuccessor(FigureNotificationHandler figureNotificationHandler) {
        this.fNotificationHandler.setNotificationSuccessor(figureNotificationHandler);
    }

    public void setComponentContainer(JComponent jComponent) {
        this.fComponentContainer = jComponent;
        this.fComponentContainer.setName("fComponentContainer");
        this.fCompManager.setComponentContainer(this.fComponentContainer);
    }

    public Container getContainer() {
        return this.fContainer;
    }

    void initUIComponentManager(UIComponentParent uIComponentParent) {
        this.fCompManager = new UIComponentManager(uIComponentParent);
    }

    void doInitializeContainer(boolean bl) {
        assert (SwingUtilities.isEventDispatchThread());
        this.fContainer = HeavyweightLightweightContainerFactory.getFigurePanelContainer(bl);
        assert (this.fContainer != null);
        this.setLayoutHelper();
        this.fLightweight = bl;
    }

    private void assembleFigurePanel() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must assemble the figure panel on the EDT.";
        assert (this.getContainer() != null) : "Figure panel not properly initialized";
        this.getContainer().setName(sPanelName);
        this.doAdd(this.fComponentContainer, "FigureComponentContainer");
        if (this.fAxisComponent != null) {
            this.doAdd(this.fAxisComponent, "FigureComponent");
        }
        this.fNotificationHandler.handleNotification(new FigurePanelProxyNotification(1, this.getContainer()));
        this.getContainer().validate();
    }

    private void doAdd(Component component, String string) {
        this.getContainer().add(component, string);
        if (component instanceof Child) {
            Child child = (Child)((Object)component);
            child.setInFigurePanel(true);
            assert (child.isInFigurePanel());
        }
    }

    public Graphics getGraphics() {
        Graphics graphics = null;
        if (this.fAxisComponent != null) {
            graphics = this.fAxisComponent.getGraphics();
        } else {
            Container container = this.getContainer();
            if (container != null) {
                graphics = container.getGraphics();
            }
        }
        return graphics;
    }

    static void disableBackgroundEraseHack(Canvas canvas) {
        FigurePanel.disableBackgroundEraseHelper(canvas, false);
    }

    static void disableBackgroundEraseHack(Panel panel) {
        FigurePanel.disableBackgroundEraseHelper(panel, true);
    }

    private static void disableBackgroundEraseHelper(Component component, boolean bl) {
        assert (component != null);
        if (PlatformInfo.isWindows() && PlatformInfo.getVersion() > 6) {
            ComponentPeer componentPeer = component.getPeer();
            Class<?> clazz = componentPeer.getClass();
            if (bl) {
                clazz = clazz.getSuperclass();
            }
            ReflectiveOperationException reflectiveOperationException = null;
            try {
                Method method = clazz.getDeclaredMethod("disableBackgroundErase", null);
                method.setAccessible(true);
                method.invoke((Object)componentPeer, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                reflectiveOperationException = noSuchMethodException;
            }
            catch (IllegalAccessException illegalAccessException) {
                reflectiveOperationException = illegalAccessException;
            }
            catch (InvocationTargetException invocationTargetException) {
                reflectiveOperationException = invocationTargetException;
            }
            if (reflectiveOperationException != null) {
                boolean bl2 = false;
                if (!$assertionsDisabled) {
                    bl2 = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (bl2) {
                    String string = "FigurePanel Warning: disableBackgroundErase failed.";
                    System.out.println(string);
                    reflectiveOperationException.printStackTrace();
                }
            }
        }
    }

    private void setLayoutHelper() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.fLayoutManagerId == 0) {
            return;
        }
        LayoutManager2 layoutManager2 = null;
        switch (this.fLayoutManagerId) {
            case 1001: {
                layoutManager2 = new FigureOverlayLayout(this.getContainer());
                break;
            }
            case 1002: {
                layoutManager2 = new FigureBorderLayout();
                this.fComponentContainer.setOpaque(true);
                this.fComponentContainer.setPreferredSize(new Dimension(100, 400));
                break;
            }
            default: {
                assert (false) : "Unrecognized case value for layout manager ID";
                break;
            }
        }
        this.getContainer().setLayout(layoutManager2);
        this.getContainer().validate();
    }

    void requestFocus() {
        if (this.fAxisComponent == null || !this.fAxisComponent.requestFocusInWindow()) {
            this.fComponentContainer.requestFocusInWindow();
        }
    }

    public void addUIcontrol(Component component, int n) {
        this.fCompManager.addUIcontrol(component, n);
    }

    public void removeUIcontrol(Component component) {
        this.fCompManager.removeUIcontrol(component);
    }

    public void replaceUIcontrol(AbstractUicontrolPeer abstractUicontrolPeer, AbstractUicontrolPeer abstractUicontrolPeer2) {
        this.fCompManager.replaceUIcontrol(abstractUicontrolPeer, abstractUicontrolPeer2);
    }

    public void postProcessAddUIcontrol(AbstractUicontrolPeer abstractUicontrolPeer) {
    }

    public void postProcessRemoveUIcontrol(AbstractUicontrolPeer abstractUicontrolPeer) {
    }

    public FigureChild addchild(Component component) {
        return this.fCompManager.addchild(component);
    }

    public FigureChild addchild(FigureChild figureChild) {
        return this.fCompManager.addchild(figureChild);
    }

    public void removechild(FigureChild figureChild) {
        this.fCompManager.removechild(figureChild);
    }

    void initialize(FigureComponentContainerProxy figureComponentContainerProxy, UIComponentParent uIComponentParent) {
        this.fLightweight = uIComponentParent.useLightWeightContainer();
        figureComponentContainerProxy.setNotificationSuccessor(this);
        this.initUIComponentManager(uIComponentParent);
    }

    void doInitialize(FigureComponentContainerProxy figureComponentContainerProxy) {
        this.setComponentContainer(figureComponentContainerProxy.getJComponent());
        this.doInitializeContainer(this.fLightweight);
        figureComponentContainerProxy.handleNotification(new FigureComponentContainerNotification(figureComponentContainerProxy));
        this.fInitialized = true;
    }

    void setBackgroundColor(Color color) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must set background color on components on the EDT.";
        this.fComponentContainer.setBackground(color);
    }

    public void addContainerPositionListener(ComponentAdapter componentAdapter) {
        this.fContainer.addComponentListener(componentAdapter);
    }

    public void removeContainerPositionListener(ComponentAdapter componentAdapter) {
        this.fContainer.removeComponentListener(componentAdapter);
    }

    public static class ChildAdapter
    implements Child {
        private boolean fInFigurePanel = false;
        private Component fComponent;

        public ChildAdapter(Component component) {
            assert (component != null);
            this.fComponent = component;
        }

        @Override
        public void setInFigurePanel(boolean bl) {
            this.fInFigurePanel = bl;
        }

        @Override
        public boolean isInFigurePanel() {
            if (!this.fInFigurePanel) {
                return false;
            }
            if (this.fComponent.getParent() == null) {
                this.fInFigurePanel = false;
                return false;
            }
            if (!FigurePanel.sPanelName.equals(this.fComponent.getParent().getName())) {
                this.fInFigurePanel = false;
                return false;
            }
            return true;
        }
    }

    public static interface Child {
        public void setInFigurePanel(boolean var1);

        public boolean isInFigurePanel();
    }
}

