/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AbstractUicontrolPeer;
import com.mathworks.hg.peer.AcceleratorEventNotification;
import com.mathworks.hg.peer.ActiveXCanvas;
import com.mathworks.hg.peer.BlockedOnPositionState;
import com.mathworks.hg.peer.ComponentContainer;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.Echo;
import com.mathworks.hg.peer.EditTextPeer;
import com.mathworks.hg.peer.FigureBoundsNotification;
import com.mathworks.hg.peer.FigureChild;
import com.mathworks.hg.peer.FigureClient;
import com.mathworks.hg.peer.FigureClientProxy;
import com.mathworks.hg.peer.FigureComponentContainerNotification;
import com.mathworks.hg.peer.FigureDTClientEventNotification;
import com.mathworks.hg.peer.FigureEditableComponent;
import com.mathworks.hg.peer.FigureEditableComponentManager;
import com.mathworks.hg.peer.FigureJavaComponentListener;
import com.mathworks.hg.peer.FigureJavaEventNotification;
import com.mathworks.hg.peer.FigureMenuBarNotification;
import com.mathworks.hg.peer.FigureMoveResizeNotification;
import com.mathworks.hg.peer.FigureNotification;
import com.mathworks.hg.peer.FigureNotificationHandler;
import com.mathworks.hg.peer.FigureNotificationHandlerImpl;
import com.mathworks.hg.peer.FigureOverlayLayout;
import com.mathworks.hg.peer.FigurePaintNotification;
import com.mathworks.hg.peer.FigurePeerAcceleratorKeyListener;
import com.mathworks.hg.peer.FigurePeerButtonMotionListener;
import com.mathworks.hg.peer.FigurePeerComponentEvent;
import com.mathworks.hg.peer.FigurePeerComponentListener;
import com.mathworks.hg.peer.FigurePeerFocusEvent;
import com.mathworks.hg.peer.FigurePeerFocusListener;
import com.mathworks.hg.peer.FigurePeerKeyListener;
import com.mathworks.hg.peer.FigurePeerMouseEvent;
import com.mathworks.hg.peer.FigurePeerMouseListener;
import com.mathworks.hg.peer.FigurePeerPaintEvent;
import com.mathworks.hg.peer.FigurePeerPaintListener;
import com.mathworks.hg.peer.FigurePeerScrollWheelEvent;
import com.mathworks.hg.peer.FigurePeerScrollWheelListener;
import com.mathworks.hg.peer.FigurePeerWindowEvent;
import com.mathworks.hg.peer.FigurePeerWindowListener;
import com.mathworks.hg.peer.FigurePeerWindowStyleEvent;
import com.mathworks.hg.peer.FigurePeerWindowStyleListener;
import com.mathworks.hg.peer.FigureRenderLocker;
import com.mathworks.hg.peer.FigureToolBarNotification;
import com.mathworks.hg.peer.FigureValidator;
import com.mathworks.hg.peer.FigureWindowActiveState;
import com.mathworks.hg.peer.FigureWindowNotification;
import com.mathworks.hg.peer.JavaSceneServerPeer;
import com.mathworks.hg.peer.MenuPeer;
import com.mathworks.hg.peer.PositionEventType;
import com.mathworks.hg.peer.PushButtonPeer;
import com.mathworks.hg.peer.RestoreFocusNotification;
import com.mathworks.hg.peer.ToolPushButtonPeer;
import com.mathworks.hg.peer.ToolToggleButtonPeer;
import com.mathworks.hg.peer.ToolbarPeer;
import com.mathworks.hg.peer.UIComponentParentWithLayout;
import com.mathworks.hg.peer.UIControlMouseNotification;
import com.mathworks.hg.peer.UIControlMouseWheelNotification;
import com.mathworks.hg.peer.UIPanel;
import com.mathworks.hg.peer.UITreePeer;
import com.mathworks.hg.peer.UitablePeer;
import com.mathworks.hg.peer.WindowRectHandler;
import com.mathworks.hg.util.HGPeerQueueUser;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.Callback;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.modality.ModalManagerImpl;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.Desktop;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public abstract class FigurePeer
implements HGPeerQueueUser,
FigureNotificationHandler,
FigureValidator,
UIComponentParentWithLayout {
    private boolean fUseLightWeightContainer = LightWeightManager.isUseLightWeightContainer();
    protected FigureClient fFigureClient;
    private ComponentContainer fComponentContainer;
    private Vector<JToolBar> fFigureToolBars = new Vector(5, 3);
    private FigureWindowActiveState fFigWindowActiveState = new FigureWindowActiveState();
    private FigurePeerNotificationHandler fNotificationHandler = new FigurePeerNotificationHandler();
    private Component[] fJavaComponents = FigureJavaComponentListener.createComponentArray();
    protected WindowRectHandler fWindowRectHandler = this.createWindowRectHandler();
    private FigureJavaComponentListener[] fJavaComponentListeners = FigureJavaComponentListener.createComponentListeners(this.fWindowRectHandler);
    private boolean fFigureIsBeingDestroyed = false;
    private boolean fListenersEnabled = false;
    private String fTitle = "Figure";
    private static String sGroupName = "Figures";
    private static Desktop sDesktop = null;
    private String fGroupName;
    private Desktop fDesktop;
    private boolean fPendingResizeState = true;
    private boolean fDockPending = false;
    private boolean fFigureVisible = false;
    protected BlockedOnPositionState fBlockedOnPositionState;
    private boolean fOffscreenRendering = false;
    private WindowStyle fCurrentWindowStyle = WindowStyle.UNSET;
    static int sCXMin = 20;
    static int sCYMin = 20;
    static int sCXMaxTrack = 5000;
    static int sCYMaxTrack = 5000;
    private transient EventListenerList fFigurePeerListeners = new EventListenerList();
    private transient Vector figureMouseWheelListeners;
    private static final int sFirstMethodIndex = 0;
    protected static final int sAddComponent = 0;
    protected static final int sRemoveComponent = 1;
    protected static final int sSetFigureVisible = 2;
    protected static final int sDisposeFigure = 3;
    protected static final int sShowMenuBar = 4;
    protected static final int sHideMenuBar = 5;
    protected static final int sSetWindowRect = 6;
    protected static final int sSetWindowOuterRect = 7;
    protected static final int sSetWindowStyle = 8;
    protected static final int sSetWindowResizable = 9;
    protected static final int sSetTitle = 10;
    protected static final int sSetDockable = 11;
    protected static final int sCreateFigurePeer = 12;
    protected static final int sCauseExpose = 13;
    protected static final int sShowSeparator = 14;
    protected static final int sSetWindowCursor = 15;
    protected static final int sReplaceUicontrol = 16;
    protected static final int sSetGroupName = 17;
    protected static final int sSetDesktopGroup = 18;
    protected static final int sSetDefaultButton = 19;
    protected static final int sCreateFigureHidden = 20;
    protected static final int sSetMaximized = 21;
    protected static final int sSetMinimized = 22;
    protected static final int sSetVisual = 23;
    protected static final int sAddSceneServerPeer = 24;
    protected static final int sSetBackgroundColor = 25;
    protected static final int sSetName = 26;
    private static final int sLastMethodIndex = 26;
    private static final String[] sLogMessages = new String[]{"addComponent", "removeComponent", "setFigureVisible", "disposeFigure", "showMenuBar", "hideMenuBar", "setWindowRect", "setWindowOuterRect", "setWindowStyle", "setWindowResizable", "setTitle", "setDockable", "createFigurePeer", "causeExpose", "showTopSeparator", "setWindowCursor", "replaceUIcontrol", "setGroupName", "setDesktopGroup", "setDefaultButton", "createFigureHidden", "setMaximized", "setMinimized", "setVisual", "addSceneServerPeer", "sSetBackgroundColor", "setName"};
    protected static boolean sNativeHGLibLoaded = false;
    private static Object[] sInterestCookies = new Object[1];
    private boolean fWindowExposePending = false;
    private final ArrayList<FigurePeerPaintEvent> fPaintEventList = new ArrayList();
    private Callback fMouseWheelCallback = new Callback();
    private boolean fCloseRequestEnabled = false;
    private long fLastFalseReturnTime = 0L;
    private long fChildWindowHandle;
    protected static final String sAccessFigureTitle = "Figure";
    protected static final String sAccessToolbar = "Toolbar";
    protected static final String sAccessMenubar = "Menubar";
    public static final int UICONTROLBACKGROUND_OS = 0;
    public static final int UICONTROLBACKGROUND_COMPATIBLE = 1;
    private int fUIControlBackgroundMode = 0;

    boolean isListenersEnabled() {
        return this.fListenersEnabled;
    }

    private static void initializeFigurePeer() {
        try {
            Introspector.getBeanInfo(FigurePeer.class);
            Introspector.getBeanInfo(MenuPeer.class);
            Introspector.getBeanInfo(ToolbarPeer.class);
            Introspector.getBeanInfo(ToolToggleButtonPeer.class);
            Introspector.getBeanInfo(ToolPushButtonPeer.class);
            Introspector.getBeanInfo(Echo.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public FigurePeer() {
    }

    public FigurePeer(int n) throws Throwable {
        this(null, n);
    }

    public FigurePeer(final Desktop desktop, final int n) throws Throwable {
        try {
            AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    FigurePeer.this.doInitializePeer(desktop, n);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw throwable;
        }
    }

    private static void cacheWindowsMinMaxSizes(int n, int n2, int n3, int n4) {
        sCXMin = n;
        sCYMin = n2;
        sCXMaxTrack = n3;
        sCYMaxTrack = n4;
    }

    protected void doInitializePeer(Desktop desktop, int n) {
        block6: {
            if (!sNativeHGLibLoaded && Matlab.isMatlabAvailable()) {
                try {
                    System.loadLibrary("nativehg");
                    sNativeHGLibLoaded = true;
                    if (PlatformInfo.isWindows()) {
                        FigurePeer.cacheWindowsMinMaxSizes(FigurePeer.getCXMin(), FigurePeer.getCYMin(), FigurePeer.getCXMaxTrack(), FigurePeer.getCYMaxTrack());
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
        }
        this.fFigureClient = this.createFigureClient(desktop, "Figures", this.useLightWeightContainer(), this.fTitle, n);
        this.fFigureClient.setNotificationSuccessor(this);
        this.fBlockedOnPositionState = this.createBlockedOnPositionState();
        this.fGroupName = sGroupName;
        if (sDesktop == null) {
            sDesktop = MatlabDesktopServices.getDesktop();
        }
        this.fDesktop = null != desktop ? desktop : sDesktop;
        this.setAccessibleFigureName(this.getAxisComponent());
        this.fFigureClient.initializeClient(n, this.useLightWeightContainer());
        assert (this.fFigureClient.getFrameProxy() != null);
        this.fWindowRectHandler.setFigureClient(this.fFigureClient);
        this.fWindowRectHandler.setFrameProxy(this.fFigureClient.getFrameProxy());
    }

    protected abstract BlockedOnPositionState createBlockedOnPositionState();

    protected abstract WindowRectHandler createWindowRectHandler();

    protected abstract FigureClient createFigureClient(Desktop var1, String var2, boolean var3, String var4, int var5);

    @Override
    public void requestFocus() {
        if (this.fFigureClient != null) {
            this.fFigureClient.requestFocusInAxis();
        }
    }

    @Override
    public FigureValidator getParentFigureValidator() {
        return this;
    }

    @Override
    public int getUserLastMethodID() {
        return FigurePeer.getLastMethodIndex();
    }

    @Override
    public String getUserMethodDescription(int n) {
        String string = null;
        if (n >= 0 && n <= 26) {
            string = sLogMessages[n - 0];
        }
        return string;
    }

    protected static int getLastMethodIndex() {
        return 26;
    }

    private boolean isWindowActiveSinceLastShow() {
        return this.fFigWindowActiveState.isWindowActiveSinceLastShow();
    }

    void setWindowActiveSinceLastShow(boolean bl) {
        this.fFigWindowActiveState.setWindowActiveSinceLastShow(bl);
    }

    void setActivatedEventReceived(boolean bl) {
        this.fFigWindowActiveState.setActivatedEventReceived(bl);
    }

    void setWindowExposePending(boolean bl) {
        this.fWindowExposePending = bl;
    }

    boolean isWindowExposePending() {
        return this.fWindowExposePending;
    }

    @Override
    public void validateFigure() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call validateFigure from event dispatch thread";
        if (this.fFigureClient != null) {
            this.fFigureClient.validateFigure();
        }
    }

    @Override
    public abstract void addFocusListener(FocusListener var1);

    @Override
    public abstract void removeFocusListener(FocusListener var1);

    public synchronized void removeFigurePeerPaintListener(FigurePeerPaintListener figurePeerPaintListener) {
        DebugUtilities.logMessage(288, "FigurePeer.removeFigurePeerPaintListener", this);
        this.fFigurePeerListeners.remove(FigurePeerPaintListener.class, figurePeerPaintListener);
    }

    public synchronized void addFigurePeerPaintListener(FigurePeerPaintListener figurePeerPaintListener) {
        DebugUtilities.logMessage(288, "FigurePeer.addFigurePeerPaintListener", this);
        this.fFigurePeerListeners.add(FigurePeerPaintListener.class, figurePeerPaintListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFigurePeerPaintEvent(FigurePeerPaintEvent figurePeerPaintEvent) {
        DebugUtilities.logMessage(544, "FigurePeer.fireFigurePeerPaintEvent", this);
        FigurePeerPaintListener[] figurePeerPaintListenerArray = this.fPaintEventList;
        synchronized (this.fPaintEventList) {
            FigurePeer.removeConsumedEvents(this.fPaintEventList);
            this.fPaintEventList.add(figurePeerPaintEvent);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (FigurePeerPaintListener figurePeerPaintListener : figurePeerPaintListenerArray = (FigurePeerPaintListener[])this.fFigurePeerListeners.getListeners(FigurePeerPaintListener.class)) {
                figurePeerPaintListener.figurePeerPaintEvent(figurePeerPaintEvent);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator getExposeEvents() {
        ArrayList arrayList = null;
        ArrayList<FigurePeerPaintEvent> arrayList2 = this.fPaintEventList;
        synchronized (arrayList2) {
            if (this.fPaintEventList.isEmpty()) {
                return null;
            }
            arrayList = (ArrayList)this.fPaintEventList.clone();
        }
        FigurePeer.removeConsumedEvents(arrayList);
        return arrayList.listIterator();
    }

    private static void removeConsumedEvents(ArrayList arrayList) {
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            FigurePeerPaintEvent figurePeerPaintEvent = (FigurePeerPaintEvent)listIterator.next();
            if (!figurePeerPaintEvent.isConsumed()) continue;
            listIterator.remove();
        }
    }

    public synchronized void removeFigurePeerComponentListener(FigurePeerComponentListener figurePeerComponentListener) {
        DebugUtilities.logMessage(288, "FigurePeer.removeFigurePeerComponentListener", this);
        this.fFigurePeerListeners.remove(FigurePeerComponentListener.class, figurePeerComponentListener);
    }

    public synchronized void addFigurePeerComponentListener(FigurePeerComponentListener figurePeerComponentListener) {
        DebugUtilities.logMessage(288, "FigurePeer.addFigurePeerComponentListener", this);
        this.fFigurePeerListeners.add(FigurePeerComponentListener.class, figurePeerComponentListener);
    }

    protected void fireFigurePeerComponentEvent(FigurePeerComponentEvent figurePeerComponentEvent) {
        FigurePeerComponentListener[] figurePeerComponentListenerArray;
        DebugUtilities.logMessage(544, "FigurePeer.fireFigurePeerComponentEvent", this);
        for (FigurePeerComponentListener figurePeerComponentListener : figurePeerComponentListenerArray = (FigurePeerComponentListener[])this.fFigurePeerListeners.getListeners(FigurePeerComponentListener.class)) {
            figurePeerComponentListener.figurePeerComponentEvent(figurePeerComponentEvent);
        }
    }

    public synchronized void removeFigurePeerFocusListener(FigurePeerFocusListener figurePeerFocusListener) {
        DebugUtilities.logMessage(288, "FigurePeer.removeFigurePeerFocusListener", this);
        this.fFigurePeerListeners.remove(FigurePeerFocusListener.class, figurePeerFocusListener);
    }

    public synchronized void addFigurePeerFocusListener(FigurePeerFocusListener figurePeerFocusListener) {
        DebugUtilities.logMessage(288, "FigurePeer.addFigurePeerFocusListener", this);
        this.fFigurePeerListeners.add(FigurePeerFocusListener.class, figurePeerFocusListener);
    }

    protected void fireFigurePeerFocusEvent(FigurePeerFocusEvent figurePeerFocusEvent) {
        FigurePeerFocusListener[] figurePeerFocusListenerArray;
        DebugUtilities.logMessage(544, "FigurePeer.fireFigurePeerFocusEvent", this);
        for (FigurePeerFocusListener figurePeerFocusListener : figurePeerFocusListenerArray = (FigurePeerFocusListener[])this.fFigurePeerListeners.getListeners(FigurePeerFocusListener.class)) {
            figurePeerFocusListener.figurePeerFocusEvent(figurePeerFocusEvent);
        }
    }

    public synchronized void removeFigurePeerAcceleratorKeyListener(FigurePeerAcceleratorKeyListener figurePeerAcceleratorKeyListener) {
        DebugUtilities.logMessage(288, "FigurePeer.removeFigurePeerAcceleratorKeyListener", this);
        this.fFigurePeerListeners.remove(FigurePeerAcceleratorKeyListener.class, figurePeerAcceleratorKeyListener);
    }

    public synchronized void addFigurePeerAcceleratorKeyListener(FigurePeerAcceleratorKeyListener figurePeerAcceleratorKeyListener) {
        DebugUtilities.logMessage(288, "FigurePeer.addFigurePeerAcceleratorKeyListener", this);
        this.fFigurePeerListeners.add(FigurePeerAcceleratorKeyListener.class, figurePeerAcceleratorKeyListener);
    }

    protected void fireFigurePeerAcceleratorKeyEvent(KeyEvent keyEvent) {
        FigurePeerAcceleratorKeyListener[] figurePeerAcceleratorKeyListenerArray;
        DebugUtilities.logMessage(544, "FigurePeer.fireFigurePeerAcceleratorKeyEvent", this);
        for (FigurePeerAcceleratorKeyListener figurePeerAcceleratorKeyListener : figurePeerAcceleratorKeyListenerArray = (FigurePeerAcceleratorKeyListener[])this.fFigurePeerListeners.getListeners(FigurePeerAcceleratorKeyListener.class)) {
            figurePeerAcceleratorKeyListener.figurePeerAcceleratorKeyEvent(keyEvent);
        }
    }

    public synchronized void removeFigurePeerKeyListener(FigurePeerKeyListener figurePeerKeyListener) {
        DebugUtilities.logMessage(288, "FigurePeer.removeFigurePeerKeyListener", this);
        this.fFigurePeerListeners.remove(FigurePeerKeyListener.class, figurePeerKeyListener);
    }

    public synchronized void addFigurePeerKeyListener(FigurePeerKeyListener figurePeerKeyListener) {
        DebugUtilities.logMessage(288, "FigurePeer.addFigurePeerKeyListener", this);
        this.fFigurePeerListeners.add(FigurePeerKeyListener.class, figurePeerKeyListener);
    }

    protected void fireFigurePeerKeyEvent(KeyEvent keyEvent) {
        FigurePeerKeyListener[] figurePeerKeyListenerArray;
        DebugUtilities.logMessage(544, "FigurePeer.fireFigurePeerKeyEvent", this);
        for (FigurePeerKeyListener figurePeerKeyListener : figurePeerKeyListenerArray = (FigurePeerKeyListener[])this.fFigurePeerListeners.getListeners(FigurePeerKeyListener.class)) {
            figurePeerKeyListener.figurePeerKeyEvent(keyEvent);
        }
    }

    public synchronized void removeFigurePeerMouseListener(FigurePeerMouseListener figurePeerMouseListener) {
        DebugUtilities.logMessage(288, "FigurePeer.removeFigurePeerMouseListener", this);
        this.fFigurePeerListeners.remove(FigurePeerMouseListener.class, figurePeerMouseListener);
    }

    public synchronized void addFigurePeerMouseListener(FigurePeerMouseListener figurePeerMouseListener) {
        DebugUtilities.logMessage(288, "FigurePeer.addFigurePeerMouseListener", this);
        this.fFigurePeerListeners.add(FigurePeerMouseListener.class, figurePeerMouseListener);
    }

    private void fireFigurePeerMouseEvent(FigurePeerMouseEvent figurePeerMouseEvent) {
        FigurePeerMouseListener[] figurePeerMouseListenerArray;
        DebugUtilities.logMessage(544, "FigurePeer.fireFigurePeerMouseEvent", this);
        for (FigurePeerMouseListener figurePeerMouseListener : figurePeerMouseListenerArray = (FigurePeerMouseListener[])this.fFigurePeerListeners.getListeners(FigurePeerMouseListener.class)) {
            figurePeerMouseListener.figurePeerMouseEvent(figurePeerMouseEvent);
        }
    }

    public synchronized void removeFigurePeerButtonMotionListener(FigurePeerButtonMotionListener figurePeerButtonMotionListener) {
        DebugUtilities.logMessage(288, "FigurePeer.removeFigurePeerButtonMotionListener", this);
        this.fFigurePeerListeners.remove(FigurePeerButtonMotionListener.class, figurePeerButtonMotionListener);
    }

    public synchronized void addFigurePeerButtonMotionListener(FigurePeerButtonMotionListener figurePeerButtonMotionListener) {
        DebugUtilities.logMessage(288, "FigurePeer.addFigurePeerButtonMotionListener", this);
        this.fFigurePeerListeners.add(FigurePeerButtonMotionListener.class, figurePeerButtonMotionListener);
    }

    protected void fireFigurePeerButtonMotionEvent(FigurePeerMouseEvent figurePeerMouseEvent) {
        FigurePeerButtonMotionListener[] figurePeerButtonMotionListenerArray;
        DebugUtilities.logMessage(544, "FigurePeer.fireFigurePeerButtonMotionEvent", this);
        for (FigurePeerButtonMotionListener figurePeerButtonMotionListener : figurePeerButtonMotionListenerArray = (FigurePeerButtonMotionListener[])this.fFigurePeerListeners.getListeners(FigurePeerButtonMotionListener.class)) {
            figurePeerButtonMotionListener.figurePeerButtonMotionEvent(figurePeerMouseEvent);
        }
    }

    public synchronized void removeFigurePeerScrollWheelListener(FigurePeerScrollWheelListener figurePeerScrollWheelListener) {
        DebugUtilities.logMessage(288, "FigurePeer.removeFigurePeerScrollWheelListener", this);
        this.fFigurePeerListeners.remove(FigurePeerScrollWheelListener.class, figurePeerScrollWheelListener);
    }

    public synchronized void addFigurePeerScrollWheelListener(FigurePeerScrollWheelListener figurePeerScrollWheelListener) {
        DebugUtilities.logMessage(288, "FigurePeer.addFigurePeerScrollWheelListener", this);
        this.fFigurePeerListeners.add(FigurePeerScrollWheelListener.class, figurePeerScrollWheelListener);
    }

    protected void fireFigurePeerScrollWheelEvent(FigurePeerScrollWheelEvent figurePeerScrollWheelEvent) {
        FigurePeerScrollWheelListener[] figurePeerScrollWheelListenerArray;
        DebugUtilities.logMessage(544, "FigurePeer.fireFigurePeerScrollWheelEvent", this);
        for (FigurePeerScrollWheelListener figurePeerScrollWheelListener : figurePeerScrollWheelListenerArray = (FigurePeerScrollWheelListener[])this.fFigurePeerListeners.getListeners(FigurePeerScrollWheelListener.class)) {
            figurePeerScrollWheelListener.figurePeerScrollWheelEvent(figurePeerScrollWheelEvent);
        }
    }

    public synchronized void removeFigurePeerWindowListener(FigurePeerWindowListener figurePeerWindowListener) {
        DebugUtilities.logMessage(288, "FigurePeer.removeFigurePeerWindowListener", this);
        this.fFigWindowActiveState.removeFigurePeerWindowListener(figurePeerWindowListener);
    }

    public synchronized void addFigurePeerWindowListener(FigurePeerWindowListener figurePeerWindowListener) {
        DebugUtilities.logMessage(288, "FigurePeer.addFigurePeerWindowListener", this);
        this.fFigWindowActiveState.addFigurePeerWindowListener(figurePeerWindowListener);
    }

    public synchronized void removeFigurePeerWindowStyleListener(FigurePeerWindowStyleListener figurePeerWindowStyleListener) {
        DebugUtilities.logMessage(288, "FigurePeer.removeFigurePeerWindowStyleListener", this);
        this.fFigurePeerListeners.remove(FigurePeerWindowStyleListener.class, figurePeerWindowStyleListener);
    }

    public synchronized void addFigurePeerWindowStyleListener(FigurePeerWindowStyleListener figurePeerWindowStyleListener) {
        DebugUtilities.logMessage(288, "FigurePeer.addFigurePeerWindowStyleListener", this);
        this.fFigurePeerListeners.add(FigurePeerWindowStyleListener.class, figurePeerWindowStyleListener);
    }

    protected void fireFigurePeerWindowStyleEvent(FigurePeerWindowStyleEvent figurePeerWindowStyleEvent) {
        FigurePeerWindowStyleListener[] figurePeerWindowStyleListenerArray;
        DebugUtilities.logMessage(544, "FigurePeer.fireFigurePeerWindowStyleEvent", this);
        for (FigurePeerWindowStyleListener figurePeerWindowStyleListener : figurePeerWindowStyleListenerArray = (FigurePeerWindowStyleListener[])this.fFigurePeerListeners.getListeners(FigurePeerWindowStyleListener.class)) {
            figurePeerWindowStyleListener.figurePeerWindowStyleEvent(figurePeerWindowStyleEvent);
        }
    }

    public Callback getMouseWheelCallback() {
        return this.fMouseWheelCallback;
    }

    public synchronized void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        DebugUtilities.logMessage(288, "FigurePeer.removeMouseWheelListener", this);
        if (this.figureMouseWheelListeners != null && this.figureMouseWheelListeners.contains(mouseWheelListener)) {
            Vector vector = (Vector)this.figureMouseWheelListeners.clone();
            vector.removeElement(mouseWheelListener);
            this.figureMouseWheelListeners = vector;
        }
    }

    public synchronized void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        Vector vector;
        DebugUtilities.logMessage(288, "FigurePeer.addMouseWheelListeners", this);
        Vector vector2 = vector = this.figureMouseWheelListeners == null ? new Vector(2) : (Vector)this.figureMouseWheelListeners.clone();
        if (!vector.contains(mouseWheelListener)) {
            vector.addElement(mouseWheelListener);
            this.figureMouseWheelListeners = vector;
        }
    }

    protected void fireMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        DebugUtilities.logMessage(544, "FigurePeer.fireMouseWheelEvent", this);
        if (this.figureMouseWheelListeners != null) {
            Vector vector = this.figureMouseWheelListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((MouseWheelListener)vector.elementAt(i)).mouseWheelMoved(mouseWheelEvent);
            }
        }
        this.fMouseWheelCallback.postCallback(new Object[]{mouseWheelEvent});
    }

    private void disableListeners() {
        DebugUtilities.logMessage(288, "FigurePeer.disableListeners", this);
        if (!this.fListenersEnabled) {
            return;
        }
        this.fListenersEnabled = false;
        this.fFigureClient.setCloseRequestEnabled(false);
        DebugUtilities.logMessage(256, "Listeners disabled", this);
    }

    private void enableListeners() {
        DebugUtilities.logMessage(288, "FigurePeer.enableListeners", this);
        if (this.fListenersEnabled) {
            return;
        }
        this.fListenersEnabled = true;
        this.fFigureClient.setCloseRequestEnabled(this.fCloseRequestEnabled);
        DebugUtilities.logMessage(32, "fListenersEnabled " + this.fListenersEnabled, this);
        DebugUtilities.logMessage(256, "Listeners enabled", this);
    }

    private static String styleString(WindowStyle windowStyle) {
        String string = "(unknown)";
        switch (windowStyle) {
            case MODAL: {
                string = "(modal)";
                break;
            }
            case NORMAL: {
                string = "(normal)";
                break;
            }
            case DOCKED: {
                string = "(docked)";
                break;
            }
            case DOCKED_HIDDEN: {
                string = "(docked-hidden)";
                break;
            }
            case UNSET: {
                string = "(unset)";
                break;
            }
        }
        return string;
    }

    public void setWindowStyle(int n) {
        final WindowStyle windowStyle = WindowStyle.convertInt(n);
        if (this.doPreSetWindowStyle(windowStyle)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 8, 7){

                @Override
                public void run() {
                    FigurePeer.this.doSetWindowStyle(windowStyle);
                }
            });
        }
    }

    private int getWindowStyle() {
        return this.fCurrentWindowStyle.value();
    }

    boolean isWindowDocked() {
        return this.fCurrentWindowStyle == WindowStyle.DOCKED || this.fCurrentWindowStyle == WindowStyle.DOCKED_HIDDEN;
    }

    void setResizable(final boolean bl) {
        if (this.doPreSetWindowResizable(bl)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 9, 7){

                @Override
                public void run() {
                    FigurePeer.this.doSetWindowResizable(bl);
                }
            });
        }
    }

    public void showTopSeparator(final boolean bl) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 14, 7, false){

            @Override
            public void run() {
                if (FigurePeer.this.fFigureClient != null) {
                    FigurePeer.this.fFigureClient.showClientTopSeparator(bl);
                    FigurePeer.this.fFigureClient.getFrameProxy().repaint();
                } else {
                    DebugUtilities.logMessage(16, "FigurePeer.showTopSeparator unsuccessful. No fFigureClient", this);
                }
            }
        });
    }

    @Override
    public void addUIcontrol(Component component, int n) {
        if (this.fFigureClient != null) {
            this.fFigureClient.addUIcontrol(component, n);
        }
    }

    @Override
    public void removeUIcontrol(Component component) {
        if (this.fFigureClient != null) {
            this.fFigureClient.removeUIcontrol(component);
        }
    }

    @Override
    public void replaceUIcontrol(AbstractUicontrolPeer abstractUicontrolPeer, AbstractUicontrolPeer abstractUicontrolPeer2) {
        if (this.fFigureClient != null) {
            this.fFigureClient.replaceUIcontrol(abstractUicontrolPeer, abstractUicontrolPeer2);
        }
    }

    @Override
    public void postProcessAddUIcontrol(AbstractUicontrolPeer abstractUicontrolPeer) {
    }

    @Override
    public void postProcessRemoveUIcontrol(AbstractUicontrolPeer abstractUicontrolPeer) {
    }

    void setDefaultButton(final PushButtonPeer pushButtonPeer) {
        if (this.doPreSetDefaultButton(pushButtonPeer)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 19, 7){

                @Override
                public void run() {
                    FigurePeer.this.doSetDefaultButton(pushButtonPeer);
                }
            });
        }
    }

    boolean doPreSetDefaultButton(PushButtonPeer pushButtonPeer) {
        DebugUtilities.logMessage(32, "FigurePeer.setDefaultButton ", this);
        return pushButtonPeer != null;
    }

    void doSetDefaultButton(PushButtonPeer pushButtonPeer) {
        JButton jButton = (JButton)pushButtonPeer.getComponentPeer();
        this.fFigureClient.getFrameProxy().setDefaultButton(jButton);
    }

    public FigureChild addchild(Component component) {
        DebugUtilities.logMessage(32, "FigurePeer.add(Component)", this);
        return this.fFigureClient.addchild(component);
    }

    public FigureChild addchild(FigureChild figureChild) {
        DebugUtilities.logMessage(32, "FigurePeer.add(FigureChild)", this);
        assert (figureChild instanceof UitablePeer || figureChild instanceof UITreePeer);
        return this.fFigureClient.addchild(figureChild);
    }

    public void remove(FigureChild figureChild) {
        DebugUtilities.logMessage(32, "FigurePeer.remove(FigureChild)", this);
        this.fFigureClient.removechild(figureChild);
    }

    public Component addchild(final JComponent jComponent, final String string) {
        DebugUtilities.logMessage(32, "FigurePeer.add(Component,String)", this);
        if (this.doPreAdd(jComponent, string)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 0, 4, false){

                @Override
                public void run() {
                    FigurePeer.this.doAdd(jComponent, string);
                }
            });
        }
        return jComponent;
    }

    boolean doPreAdd(JComponent jComponent, String string) {
        DebugUtilities.logMessage(32, "FigurePeer.add(Component,String)", this);
        if (!string.equals("Overlay")) {
            int n = FigureJavaComponentListener.getComponentIndexFromConstraint(string);
            assert (n != -1);
            this.cleanupJavaComponent(this.fJavaComponents[n]);
            this.fJavaComponents[n] = jComponent;
            this.fJavaComponentListeners[n].setTarget(jComponent);
            jComponent.addAncestorListener(this.fJavaComponentListeners[n]);
        }
        return true;
    }

    Component doAdd(JComponent jComponent, String string) {
        DebugUtilities.logMessage(64, "Start add run", this);
        if (string.equals("Overlay")) {
            assert (this.fFigureClient.getFigurePanelContainer().getLayout() instanceof FigureOverlayLayout);
            this.fFigureClient.getFigurePanelContainer().add(jComponent, string, 0);
        } else {
            this.fFigureClient.getContentPane().add(jComponent, string, 0);
            int n = FigureJavaComponentListener.getComponentIndexFromConstraint(string);
            assert (n != -1);
        }
        DebugUtilities.logMessage(64, "Done add run", this);
        return jComponent;
    }

    public void remove(final Component component) {
        DebugUtilities.logMessage(32, "FigurePeer.remove(Component)", this);
        HGUtils.invokeLater(new HGPeerRunnable(this, 1, 5, false){

            @Override
            public void run() {
                Container container = component.getParent();
                if (container != null) {
                    Container container2 = container.getParent();
                    UIPanel.removeFrom(container2, container, component);
                }
                if (container == FigurePeer.this.fFigureClient.getContentPane()) {
                    FigurePeer.this.cleanupJavaComponent(component);
                }
            }
        });
    }

    void setCursor(final Cursor cursor) {
        DebugUtilities.logMessage(32, "FigurePeer.setCursor", this);
        HGUtils.invokeLater(new HGPeerRunnable(this, 15, 7){

            @Override
            public void run() {
                if (FigurePeer.this.fFigureClient != null) {
                    FigurePeer.this.fFigureClient.setCursor(cursor);
                }
            }
        });
    }

    void addToolBar(JToolBar jToolBar) {
        DebugUtilities.logMessage(32, "FigurePeer.addToolBar", this);
        this.fFigureToolBars.add(jToolBar);
        this.fFigureClient.setClientToolBars(this.fFigureToolBars);
        this.setAccessibleToolbarName(jToolBar);
    }

    void removeToolBar(JToolBar jToolBar) {
        DebugUtilities.logMessage(32, "FigurePeer.removeToolBar", this);
        if (this.fFigureToolBars == null) {
            return;
        }
        this.fFigureToolBars.remove(jToolBar);
        Window window = SwingUtilities.getWindowAncestor(jToolBar);
        this.fFigureClient.setClientToolBars(this.fFigureToolBars);
        if (window != null && window != this.fFigureClient.getWindow()) {
            window.dispose();
        }
    }

    MJMenuBar getMenuBar() {
        DebugUtilities.logMessage(32, "FigurePeer.getMenuBar", this);
        MJMenuBar mJMenuBar = null;
        if (this.fFigureClient != null) {
            mJMenuBar = this.fFigureClient.getMenuBar();
            this.setAccessibleMenubarName(mJMenuBar);
        }
        return mJMenuBar;
    }

    void doShowContextMenu(JPopupMenu jPopupMenu, int n, int n2) {
        assert (SwingUtilities.isEventDispatchThread());
        Point point = new Point(n, n2);
        if (this.isWindowDocked()) {
            Rectangle rectangle = this.getDrawableRect();
            point.translate(-rectangle.x, -rectangle.y);
            Rectangle rectangle2 = this.getWindowRect();
            point.translate(rectangle2.x, rectangle2.y);
        }
        this.fWindowRectHandler.moveContainerPointToClientPoint(this.fFigureClient.getLocation(), point);
        jPopupMenu.show(this.fComponentContainer.getComponent(), point.x, point.y);
    }

    void doHideContextMenu(JPopupMenu jPopupMenu) {
        assert (SwingUtilities.isEventDispatchThread());
        jPopupMenu.setVisible(false);
        this.requestFocus();
    }

    void setTitle(String string) {
        if (this.doPreSetTitle(string)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 10, 7){

                @Override
                public void run() {
                    FigurePeer.this.doSetTitle();
                }
            });
        }
    }

    boolean doPreSetTitle(String string) {
        assert (!SwingUtilities.isEventDispatchThread());
        DebugUtilities.logMessage(32, "FigurePeer.setTitle " + string, this);
        this.fTitle = string;
        return true;
    }

    void doSetTitle() {
        this.fFigureClient.setClientTitle(this.fTitle);
        this.setAccessibleFigureName(this.getAxisComponent());
    }

    void setName(final String string) {
        if (FigurePeer.doPreSetName(string)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 26, 7){

                @Override
                public void run() {
                    FigurePeer.this.doSetName(string);
                }
            });
        }
    }

    static boolean doPreSetName(String string) {
        return true;
    }

    void doSetName(String string) {
        this.fFigureClient.setName(string);
    }

    void setDockable(final boolean bl) {
        if (this.doPreSetDockable(bl)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 11, 7){

                @Override
                public void run() {
                    FigurePeer.this.doSetDockable(bl);
                }
            });
        }
    }

    boolean doPreSetDockable(boolean bl) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Must call setDockable from MATLAB thread";
        DebugUtilities.logMessage(32, "FigurePeer.setDockable", this);
        return true;
    }

    void doSetDockable(boolean bl) {
        this.fFigureClient.setClientDockable(bl);
    }

    void setCloseRequestEnabled(boolean bl) {
        this.fCloseRequestEnabled = bl;
        if (this.fListenersEnabled) {
            this.fFigureClient.setCloseRequestEnabled(bl);
        }
    }

    void vetoFigureClose() {
        this.fFigureClient.vetoClientClose();
    }

    public ImageIcon getFigureIcon() {
        return FigureClientProxy.getClientIcon();
    }

    public void setFigureIcon(ImageIcon imageIcon) {
        this.fFigureClient.setClientIcon(imageIcon);
    }

    public void setGroupName(final String string) {
        if (this.doPreSetGroupName(string)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 17, 7){

                @Override
                public void run() {
                    FigurePeer.this.doSetGroupName(string);
                }
            });
        }
    }

    boolean doPreSetGroupName(String string) {
        DebugUtilities.logMessage(32, "FigurePeer.setGroupName", this);
        this.fGroupName = string;
        return true;
    }

    void doSetGroupName(String string) {
        this.disableListeners();
        this.fFigureClient.setGroupName(this.fGroupName, this.isShowing());
        this.enableListeners();
    }

    public String getGroupName() {
        return this.fGroupName;
    }

    public void setDesktopGroup(final Desktop desktop, final String string) {
        if (this.doPreSetDesktopGroup(desktop, string)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 18, 7){

                @Override
                public void run() {
                    FigurePeer.this.doSetDesktopGroup(desktop, string);
                }
            });
        }
    }

    boolean doPreSetDesktopGroup(Desktop desktop, String string) {
        DebugUtilities.logMessage(32, "FigurePeer.setDesktopGroup", this);
        this.fDesktop = desktop;
        this.fGroupName = string;
        return true;
    }

    void doSetDesktopGroup(Desktop desktop, String string) {
        assert (this.fDesktop == desktop);
        this.disableListeners();
        this.fFigureClient.setGroupName(this.fDesktop, this.fGroupName, this.isShowing());
        this.enableListeners();
    }

    public Desktop getDesktop() {
        return this.fDesktop;
    }

    private int getButtonEx(MouseEvent mouseEvent) {
        int n = mouseEvent.getButton();
        int n2 = mouseEvent.getModifiersEx();
        if ((n2 & 0) != 0) {
            n = 2;
        } else if (n == 1 && (n2 & 0x1000) != 0 || n == 3 && (n2 & 0x400) != 0) {
            n = 2;
        }
        return n;
    }

    private void handleFigureMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.requestFocus();
            FigureEditableComponentManager.commitCurrentEditableComponent();
        }
        this.handleMouseEvent(mouseEvent, null, true);
    }

    private void translatePointToContainerCoodinates(MouseEvent mouseEvent) {
        mouseEvent.translatePoint(this.fWindowRectHandler.getBounds().x, this.fWindowRectHandler.getBounds().y);
        if (this.fCurrentWindowStyle == WindowStyle.DOCKED) {
            Point point = this.fFigureClient.getContainerLocation();
            mouseEvent.translatePoint(point.x, point.y);
        }
    }

    private void handleMouseEvent(MouseEvent mouseEvent, Point point, boolean bl) {
        if (this.fListenersEnabled) {
            FigurePeerMouseEvent figurePeerMouseEvent;
            if (mouseEvent instanceof FigurePeerMouseEvent) {
                figurePeerMouseEvent = (FigurePeerMouseEvent)mouseEvent;
            } else {
                if (point == null) {
                    point = mouseEvent.getPoint();
                }
                int n = this.getButtonEx(mouseEvent);
                figurePeerMouseEvent = new FigurePeerMouseEvent(mouseEvent.getComponent(), n, bl, mouseEvent.getID(), mouseEvent.getWhen(), point.x, point.y, mouseEvent.getModifiers(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            }
            this.translatePointToContainerCoodinates(figurePeerMouseEvent);
            switch (figurePeerMouseEvent.getID()) {
                case 501: 
                case 502: {
                    this.fireFigurePeerMouseEvent(figurePeerMouseEvent);
                    break;
                }
                case 503: 
                case 506: {
                    this.fireFigurePeerButtonMotionEvent(figurePeerMouseEvent);
                }
            }
        }
    }

    private void handleMouseWheelEvent(MouseWheelEvent mouseWheelEvent, Point point) {
        if (this.fListenersEnabled) {
            FigurePeerScrollWheelEvent figurePeerScrollWheelEvent = null;
            if (mouseWheelEvent instanceof FigurePeerScrollWheelEvent) {
                figurePeerScrollWheelEvent = (FigurePeerScrollWheelEvent)mouseWheelEvent;
            } else {
                if (point == null) {
                    point = mouseWheelEvent.getPoint();
                }
                figurePeerScrollWheelEvent = new FigurePeerScrollWheelEvent(mouseWheelEvent.getComponent(), mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), point.x, point.y, mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
            }
            this.translatePointToContainerCoodinates(figurePeerScrollWheelEvent);
            this.fireFigurePeerScrollWheelEvent(figurePeerScrollWheelEvent);
        }
    }

    static void setCurrentEdit(EditTextPeer editTextPeer) {
        assert (editTextPeer != null) : "use clearCurrentEdit instead.";
        FigureEditableComponentManager.setCurrentEditableComponent(editTextPeer);
    }

    static void clearCurrentEdit(EditTextPeer editTextPeer) {
        FigureEditableComponentManager.clearCurrentEditableComponent(editTextPeer);
    }

    public static EditTextPeer getCurrentEdit() {
        FigureEditableComponent figureEditableComponent = FigureEditableComponentManager.getFigureEditableComponent();
        if (figureEditableComponent instanceof EditTextPeer) {
            return (EditTextPeer)figureEditableComponent;
        }
        return null;
    }

    protected abstract void handleFigureBoundsNotification(FigureBoundsNotification var1);

    private void handleMoveOrResize(boolean bl, boolean bl2) {
        Rectangle rectangle = this.getWindowOuterRect();
        Rectangle rectangle2 = this.getWindowRect();
        this.handleFigureBoundsNotificationHelper(bl, bl2, rectangle, rectangle2);
    }

    protected void handleFigureBoundsNotificationHelper(boolean bl, boolean bl2, Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle.isEmpty() || rectangle2.isEmpty()) {
            return;
        }
        Rectangle rectangle3 = new Rectangle(rectangle2);
        rectangle3 = this.getDrawableRectHelper(rectangle3);
        this.fireFigurePeerComponentEvent(new FigurePeerComponentEvent(this.fFigureClient.getFigurePanelContainer(), bl ? 100 : 101, rectangle2, rectangle, rectangle3, bl2));
    }

    private boolean isWindowActive() {
        return this.fFigWindowActiveState.isWindowActive();
    }

    private void causeExposeIfActive() {
        if (this.isWindowExposePending()) {
            this.doCauseExpose(null);
        }
    }

    private boolean preSetWindowRect(Rectangle rectangle, boolean bl) {
        this.fWindowRectHandler.setActivePositionMode(bl);
        if (this.isWindowDocked() && !this.fDockPending) {
            return false;
        }
        this.fWindowRectHandler.presetBounds(rectangle);
        return true;
    }

    private boolean preSetWindowOuterRect(Rectangle rectangle, boolean bl) {
        this.fWindowRectHandler.setActivePositionMode(bl);
        if (this.isWindowDocked() && !this.fDockPending) {
            return false;
        }
        this.fWindowRectHandler.presetOuterBounds(rectangle);
        return true;
    }

    private void doSetWindowRect(Rectangle rectangle) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call doSetWindowRect from event dispatch thread";
        PositionEventType positionEventType = this.fWindowRectHandler.isWaitingForResize();
        if (positionEventType == PositionEventType.RESIZED) {
            this.fBlockedOnPositionState.startWaitForResize(positionEventType);
        }
        if (this.fWindowRectHandler.setBounds(rectangle)) {
            this.handleMoveOrResize(positionEventType == PositionEventType.MOVED, false);
        }
    }

    private void doSetWindowOuterRect(Rectangle rectangle) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call doSetWindowOuterRect from event dispatch thread";
        PositionEventType positionEventType = this.fWindowRectHandler.isWaitingForResize();
        if (positionEventType == PositionEventType.RESIZED) {
            this.fBlockedOnPositionState.startWaitForResize(positionEventType);
        }
        if (this.fWindowRectHandler.setOuterBounds(rectangle)) {
            this.handleMoveOrResize(positionEventType == PositionEventType.MOVED, false);
        }
    }

    void setWindowRect(int n, int n2, int n3, int n4, boolean bl) {
        final Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (this.preSetWindowRect(rectangle, bl)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 6, 7){

                @Override
                public void run() {
                    FigurePeer.this.doSetWindowRect(rectangle);
                }
            });
        }
    }

    void setWindowOuterRect(int n, int n2, int n3, int n4, boolean bl) {
        final Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (this.preSetWindowOuterRect(rectangle, bl)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 7, 7){

                @Override
                public void run() {
                    FigurePeer.this.doSetWindowOuterRect(rectangle);
                }
            });
        }
    }

    protected void doCreateFigureHidden() {
        assert (this.fFigureClient != null);
        Window window = this.fFigureClient.getWindow();
        if (window == null) {
            switch (this.fCurrentWindowStyle) {
                case MODAL: {
                    this.fFigureClient.setModal(true);
                }
                case NORMAL: {
                    this.fFigureClient.showClientHidden();
                    break;
                }
                case DOCKED: {
                    System.out.println("Creating an invisible figure frame is currently not supported for docked figures");
                }
            }
            window = this.fFigureClient.getWindow();
            assert (window != null);
        }
        window.addNotify();
        window.validate();
    }

    boolean doPreCreateFigureHidden() {
        DebugUtilities.logMessage(32, "FigurePeer.doPreCreateFigureHidden", this);
        return true;
    }

    protected void createFigureHidden() {
        if (this.doPreCreateFigureHidden()) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 20, 9){

                @Override
                public void run() {
                    FigurePeer.this.doCreateFigureHidden();
                }
            });
        }
    }

    private void show() {
        DebugUtilities.logMessage(32, "FigurePeer.show()", this);
        assert (SwingUtilities.isEventDispatchThread()) : "Must call this method from event dispatch thread";
        this.doSetWindowResizable(this.fPendingResizeState);
        switch (this.fCurrentWindowStyle) {
            case MODAL: {
                this.fFigureClient.setModal(true);
            }
            case NORMAL: {
                this.fFigureClient.showClient(false);
                this.requestFocus();
                break;
            }
            case DOCKED_HIDDEN: {
                this.doSetWindowStyle(WindowStyle.DOCKED);
            }
            case DOCKED: {
                DebugUtilities.logMessage(1024, "Docked: Show Client", this);
                this.fFigureClient.showClient(true);
                this.fFigureClient.getFrameProxy().setResizable(true);
                this.fDockPending = false;
                break;
            }
            default: {
                DebugUtilities.logMessage(16, "5 Unrecognized window style: " + (Object)((Object)this.fCurrentWindowStyle), this);
            }
        }
        this.forcePaintEvent();
    }

    private void forcePaintEvent() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Component component;
                if (FigurePeer.this.getNativeWindowHandle() == -1L && FigurePeer.this.fFigureClient != null && (component = FigurePeer.this.getAxisComponent()) != null) {
                    component.paint(null);
                }
            }
        };
        FigurePeer.runOnEDT(runnable);
    }

    private void setFigureVisible(final boolean bl, final boolean bl2) {
        if (this.doPreSetFigureVisible(bl)) {
            DebugUtilities.logMessage(16384, "FigurePeer.setFigureVisible vis: " + bl + " raise " + bl2, this);
            this.setActivatedEventReceived(false);
            this.fFigureVisible = bl;
            HGUtils.invokeLater(new HGPeerRunnable(this, 2, bl ? 9 : 10){

                @Override
                public void run() {
                    FigurePeer.this.doSetFigureVisible(bl, bl2);
                }
            });
        }
    }

    private void setFigureVisible(boolean bl) {
        this.setFigureVisible(bl, false);
    }

    void toFront() {
        DebugUtilities.logMessage(32, "FigurePeer.toFront", this);
        this.setFigureVisible(true, true);
    }

    void showFigure() {
        DebugUtilities.logMessage(32, "FigurePeer.showFigure", this);
        this.setFigureVisible(true);
    }

    public boolean isWindowShowing(boolean bl) {
        boolean bl2;
        boolean bl3 = this.isWindowActiveSinceLastShow() && !this.isWindowExposePending();
        boolean bl4 = bl2 = bl3 && this.fFigWindowActiveState.isActivatedEventReceived();
        long l = System.currentTimeMillis();
        int n = 250;
        if (PlatformInfo.isUnix()) {
            n = 2500;
        }
        if (this.fLastFalseReturnTime == 0L && bl) {
            this.fLastFalseReturnTime = l;
        }
        if (bl4 && this.fWindowRectHandler.isSizeLocationPending()) {
            this.fWindowRectHandler.recheckPendingLocationOrSizeOnEDT();
            if (this.fLastFalseReturnTime > 0L && l - (long)n > this.fLastFalseReturnTime) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (FigurePeer.this.fWindowRectHandler.isSizeLocationPending()) {
                            FigurePeer.this.fWindowRectHandler.updateInsets();
                            DebugUtilities.logMessage(16384, "Stop waiting for the right size or position", this);
                            FigurePeer.this.fWindowRectHandler.releaseSizeLocationPending();
                        }
                    }
                };
                FigurePeer.runOnEDT(runnable);
                this.fLastFalseReturnTime = l;
            }
            bl4 = false;
        } else if (!bl2) {
            if (this.fLastFalseReturnTime > 0L && l - (long)n > this.fLastFalseReturnTime) {
                DebugUtilities.logMessage(16384, "Stop waiting for windowActivated event", this);
                this.setActivatedEventReceived(true);
                this.fFigWindowActiveState.setWindowActiveSinceLastShow(true);
                this.setWindowExposePending(false);
                bl4 = true;
                this.fLastFalseReturnTime = 0L;
            }
        } else {
            this.fLastFalseReturnTime = 0L;
        }
        return bl4;
    }

    boolean isBeingDestroyed() {
        DebugUtilities.logMessage(32, "isBeingDestroyed", this);
        return this.fFigureIsBeingDestroyed;
    }

    boolean isShowing() {
        boolean bl = false;
        bl = this.fFigureClient != null && this.fFigureClient.isShowing();
        DebugUtilities.logMessage(32, "isShowing " + bl, this);
        return bl;
    }

    boolean isHidden() {
        boolean bl = false;
        bl = this.fFigureClient != null && this.fFigureClient.isHidden();
        DebugUtilities.logMessage(32, "isHidden " + bl, this);
        return bl;
    }

    private void hide() {
        DebugUtilities.logMessage(32, "FigurePeer.hide", this);
        assert (SwingUtilities.isEventDispatchThread()) : "Must call this method from event dispatch thread";
        switch (this.fCurrentWindowStyle) {
            case MODAL: {
                this.fFigureClient.setModal(false);
            }
            case NORMAL: 
            case DOCKED: {
                DebugUtilities.logMessage(1024, "Hide client", this);
                this.fFigureClient.hideClient();
                break;
            }
            case DOCKED_HIDDEN: {
                break;
            }
            default: {
                DebugUtilities.logMessage(16, "6 Unrecognized window style: " + (Object)((Object)this.fCurrentWindowStyle), this);
            }
        }
        this.setWindowActiveSinceLastShow(false);
    }

    void hideFigure() {
        DebugUtilities.logMessage(32, "hideFigure ", this);
        this.setFigureVisible(false);
    }

    private void nullOutReferences() {
        this.fFigureClient = null;
        this.fComponentContainer = null;
        this.fFigureToolBars = null;
        this.fFigurePeerListeners = null;
        this.figureMouseWheelListeners = null;
        this.fJavaComponents = null;
        this.fJavaComponentListeners = null;
        this.fWindowRectHandler = null;
    }

    void cleanup() {
        this.cleanupAllJavaComponents();
    }

    void cleanupAllJavaComponents() {
        if (this.fComponentContainer == null || this.fFigureClient == null) {
            return;
        }
        this.fComponentContainer.getContainer().removeAll();
        if (this.fFigureClient != null) {
            this.fFigureClient.getContentPane().removeAll();
        }
        for (int i = 0; i <= 3; ++i) {
            this.cleanupJavaComponent(this.fJavaComponents[i]);
        }
    }

    void cleanupJavaComponent(Component component) {
        int n = FigureJavaComponentListener.getComponentIndex(component, this.fJavaComponents);
        if (n >= 0) {
            assert (component instanceof JComponent);
            ((JComponent)component).removeAncestorListener(this.fJavaComponentListeners[n]);
            this.fJavaComponentListeners[n].setTarget(null);
            this.fJavaComponents[n] = null;
        }
    }

    void disposeFigure() {
        if (this.doPreDisposeFigure()) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 3, 1){

                @Override
                public void run() {
                    FigurePeer.this.doDisposeFigure();
                }
            });
        }
    }

    private Rectangle getDrawableRectHelper(Rectangle rectangle) {
        Point point;
        if (this.fCurrentWindowStyle == WindowStyle.DOCKED && (point = this.fFigureClient.getContainerLocation()) != null) {
            rectangle.translate(point.x, point.y);
        }
        assert (rectangle != null);
        return rectangle;
    }

    Rectangle getDrawableRect() {
        DebugUtilities.logMessage(160, "FigurePeer.getDrawableRect", this);
        Rectangle rectangle = this.getWindowRect();
        return this.getDrawableRectHelper(rectangle);
    }

    protected Rectangle getWindowRect() {
        Rectangle rectangle;
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        if (this.fWindowRectHandler != null && (rectangle = this.fWindowRectHandler.getBounds()) != null) {
            rectangle2 = rectangle;
        }
        return rectangle2;
    }

    protected Rectangle getWindowOuterRect() {
        Rectangle rectangle = this.fWindowRectHandler.getOuterBounds();
        assert (rectangle != null);
        return rectangle;
    }

    Rectangle getContainerRect() {
        DebugUtilities.logMessage(160, "FigurePeer.getContainerRect", this);
        Dimension dimension = null;
        if (!this.fDockPending && this.fCurrentWindowStyle == WindowStyle.DOCKED && this.fFigureClient != null) {
            dimension = this.fFigureClient.getContainerSize();
        }
        if (dimension == null) {
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
        }
        return new Rectangle(0, 0, dimension.width, dimension.height);
    }

    void notifyMousePress() {
        FigurePeerMouseEvent figurePeerMouseEvent = new FigurePeerMouseEvent(this.fComponentContainer.getComponent(), 0, 501, 0L, 0, 0, 0, 0, false);
        this.fireFigurePeerMouseEvent(figurePeerMouseEvent);
    }

    private void translateComponentPointToFigurePoint(Component component, Point point) {
        while (component != null) {
            Point point2 = component.getLocation();
            point.translate(point2.x, point2.y);
            if (component.getParent().equals(this.fComponentContainer.getContainer())) break;
            component = component.getParent();
        }
    }

    public void handleUIControlMouseEvent(MouseEvent mouseEvent, boolean bl) {
        Point point = mouseEvent.getPoint();
        Component component = mouseEvent.getComponent();
        this.translateComponentPointToFigurePoint(component, point);
        if (component != null) {
            this.handleMouseEvent(mouseEvent, point, bl);
        } else assert (false) : "Could not locate parent for figure child during mouse event dispatch.";
    }

    public void handleUIControlMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        Point point = mouseWheelEvent.getPoint();
        Component component = mouseWheelEvent.getComponent();
        this.translateComponentPointToFigurePoint(component, point);
        this.handleMouseWheelEvent(mouseWheelEvent, point);
    }

    public long getNativeChildWindowHandle() {
        return this.fChildWindowHandle;
    }

    void setNativeChildWindowHandle(long l) {
        this.fChildWindowHandle = l;
    }

    public ActiveXCanvas getActiveXCanvas() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Must call this method from the MATLAB thread";
        ActiveXCanvas activeXCanvas = null;
        if (PlatformInfo.isWindows()) {
            activeXCanvas = this.getActiveXCanvasImpl();
        } else assert (false);
        return activeXCanvas;
    }

    protected abstract ActiveXCanvas getActiveXCanvasImpl();

    protected void addActiveXControl(final ActiveXCanvas activeXCanvas) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Must call this method from the MATLAB thread";
        if (PlatformInfo.isWindows()) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 0, 4){

                @Override
                public void run() {
                    FigurePeer.this.fComponentContainer.getContainer().add(activeXCanvas, null, 0);
                    FigurePeer.this.createHWNDForActiveXImpl(activeXCanvas);
                }
            });
        }
    }

    protected abstract void createHWNDForActiveXImpl(ActiveXCanvas var1);

    public void removeActiveXControl(final ActiveXCanvas activeXCanvas) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Must call this method from the MATLAB thread";
        if (PlatformInfo.isWindows()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    FigurePeer.this.fComponentContainer.getContainer().remove(activeXCanvas);
                }
            };
            FigurePeer.runOnEDT(runnable);
        }
    }

    private void refreshActiveXCanvases() {
        if (this.fComponentContainer != null) {
            int n = this.fComponentContainer.getContainer().getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = this.fComponentContainer.getContainer().getComponent(i);
                if (!(component instanceof ActiveXCanvas)) continue;
                ActiveXCanvas activeXCanvas = (ActiveXCanvas)component;
                activeXCanvas.paintChildren();
            }
        }
    }

    static void closeOpenMenus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        });
        FigureEditableComponentManager.commitCurrentEditableComponent();
    }

    boolean setRenderInProgress(boolean bl) {
        boolean bl2 = true;
        if (this.getAxisComponent() == null) {
            DebugUtilities.logMessage(4096, "null axis component", this);
        } else if (bl) {
            DebugUtilities.logMessage(4096, "calling block awt", this);
            bl2 = FigureRenderLocker.blockAwtThread();
        } else {
            DebugUtilities.logMessage(4096, "calling unblock awt", this);
            bl2 = FigureRenderLocker.unblockAwtThread();
        }
        DebugUtilities.logMessage(4096, "waiting ? " + bl2, this);
        return bl2;
    }

    public long getNativeWindowHandle() {
        DebugUtilities.logMessage(32, "FigurePeer.getNativeWindowHandle", this);
        if (this.getAxisComponent() != null) {
            return this.fFigureClient.getNativeWindowHandle();
        }
        return 0L;
    }

    protected void setVisualImpl(int n) {
        assert (false);
    }

    void setVisual(final int n) {
        DebugUtilities.logMessage(32, "FigurePeer.setVisual " + n, this);
        assert (!SwingUtilities.isEventDispatchThread()) : "Must call this method from the MATLAB thread";
        HGUtils.invokeLater(new HGPeerRunnable(this, 23, 7){

            @Override
            public void run() {
                FigurePeer.this.setVisualImpl(n);
            }
        });
    }

    Graphics getUIJGraphics() {
        DebugUtilities.logMessage(32, "FigurePeer.getUIJGraphics", this);
        if (this.getAxisComponent() != null) {
            return this.fFigureClient.getUIJGraphics();
        }
        return null;
    }

    Graphics getGraphics() {
        DebugUtilities.logMessage(32, "FigurePeer.getGraphics", this);
        return this.fFigureClient.getGraphics();
    }

    public static boolean ulwc(boolean bl) {
        boolean bl2 = LightWeightManager.isUseLightWeightContainer();
        LightWeightManager.setUseLightWeightContainer(bl);
        return bl2;
    }

    @Override
    public boolean useLightWeightContainer() {
        return this.fUseLightWeightContainer;
    }

    @Override
    public void doAddPreOperation() {
    }

    @Override
    public void doAddPostOperation() {
    }

    @Override
    public void doRemovePreOperation() {
    }

    @Override
    public void doRemovePostOperation() {
    }

    public Component getAxisComponent() {
        return this.fFigureClient != null ? this.fFigureClient.getAxisComponent() : null;
    }

    public Container getFigurePanelContainer() {
        return this.fFigureClient.getFigurePanelContainer();
    }

    protected void setBackingStore(Image image) {
    }

    void setOffscreenRendering(boolean bl) {
        this.fOffscreenRendering = bl;
        this.fFigureClient.setOffscreenRendering(bl);
    }

    boolean getOffscreenRendering() {
        return this.fOffscreenRendering;
    }

    private boolean doPreDisposeFigure() {
        DebugUtilities.logMessage(32, "FigurePeer.disposeFigure ", this);
        assert (!SwingUtilities.isEventDispatchThread()) : "Must call this method from the MATLAB thread";
        this.fFigureIsBeingDestroyed = true;
        return true;
    }

    private void doDisposeFigure() {
        DebugUtilities.logMessage(64, "Start disposeFigure run", this);
        if (this.isShowing()) {
            DebugUtilities.logMessage(32, "doDisposeFigure Expected hideFigure to be called before disposeFigure.", this);
            this.doSetFigureVisible(false);
        }
        if (this.fListenersEnabled) {
            DebugUtilities.logMessage(32, "doDisposeFigure Expected disableListeners to be called before disposeFigure.", this);
            this.disableListeners();
        }
        this.fCurrentWindowStyle = WindowStyle.UNSET;
        this.cleanup();
        this.fFigureClient.approveClientClose();
        this.fFigureClient.disposeClient();
        this.nullOutReferences();
        DebugUtilities.logMessage(64, "Done disposeFigure run", this);
    }

    boolean doPreSetFigureVisible(boolean bl) {
        String string = "showFigure(pre)";
        if (!bl) {
            string = "hideFigure(pre)";
        }
        if (bl) {
            this.setWindowActiveSinceLastShow(this.isWindowActive());
        }
        DebugUtilities.logMessage(32, "FigurePeer." + string, this);
        assert (!SwingUtilities.isEventDispatchThread()) : "Must call this method from the MATLAB thread";
        return true;
    }

    protected void doSetFigureVisible(boolean bl) {
        this.doSetFigureVisible(bl, false);
    }

    protected void doSetFigureVisible(boolean bl, boolean bl2) {
        String string = "showFigure";
        if (!bl) {
            string = "hideFigure";
        }
        DebugUtilities.logMessage(64, "Start " + string + " run ", this);
        if (bl) {
            this.enableListeners();
            DebugUtilities.logMessage(16384, "FigurePeer.doSetFigureVisible to true", this);
            if (!this.isShowing() || this.isHidden()) {
                this.show();
            } else if (this.fFigureClient.isSelected()) {
                this.setActivatedEventReceived(true);
            } else {
                this.fFigureClient.toFront();
            }
            if (this.fCurrentWindowStyle == WindowStyle.NORMAL && bl2 && this.isShowing()) {
                this.fFigureClient.getFrameProxy().toFront();
            }
        } else {
            this.disableListeners();
            this.hide();
            this.fFigureClient.approveClientClose();
        }
        DebugUtilities.logMessage(64, "Done " + string + " run", this);
    }

    boolean doPreSetWindowStyle(WindowStyle windowStyle) {
        DebugUtilities.logMessage(32, "FigurePeer.setWindowStyle", this);
        if (this.fCurrentWindowStyle != windowStyle) assert (!SwingUtilities.isEventDispatchThread()) : "Must call this method from the MATLAB thread";
        return true;
    }

    void doSetWindowStyle(WindowStyle windowStyle) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call this method from event dispatch thread";
        if (this.fCurrentWindowStyle == windowStyle) {
            return;
        }
        if (windowStyle == WindowStyle.DOCKED) {
            this.fDockPending = true;
            this.fWindowRectHandler.releaseSizeLocationPending();
            this.fBlockedOnPositionState.startWaitingForWindowStyle();
        } else {
            this.fDockPending = false;
            if (this.fCurrentWindowStyle == WindowStyle.DOCKED) {
                this.fBlockedOnPositionState.startWaitingForWindowStyle();
            }
        }
        this.fCurrentWindowStyle = windowStyle;
        this.fFigureClient.setClientWindowStyle(windowStyle == WindowStyle.DOCKED, windowStyle == WindowStyle.MODAL);
    }

    boolean doPreSetWindowResizable(boolean bl) {
        if (!bl && this.fCurrentWindowStyle == WindowStyle.DOCKED) {
            DebugUtilities.logMessage(16, "Cannot set resizable 'off' for docked windows.", this);
            return false;
        }
        if (this.fCurrentWindowStyle == WindowStyle.DOCKED_HIDDEN || this.fCurrentWindowStyle == WindowStyle.DOCKED) {
            return false;
        }
        DebugUtilities.logMessage(32, "FigurePeer.doPreSetWindowResizable", this);
        assert (!SwingUtilities.isEventDispatchThread()) : "Must call this method from the MATLAB thread";
        this.fPendingResizeState = bl;
        return this.fListenersEnabled;
    }

    private void doSetWindowResizable(boolean bl) {
        if (!bl && this.fCurrentWindowStyle == WindowStyle.DOCKED) {
            DebugUtilities.logMessage(16, "Cannot set resizable 'off' for docked windows.", this);
            return;
        }
        this.fPendingResizeState = bl;
        if (this.fCurrentWindowStyle == WindowStyle.DOCKED_HIDDEN || this.fCurrentWindowStyle == WindowStyle.DOCKED) {
            return;
        }
        this.fFigureClient.getFrameProxy().setResizable(bl);
        this.fWindowRectHandler.setResizable(bl);
    }

    private void doCauseExpose(Rectangle rectangle) {
        rectangle = null;
        DebugUtilities.logMessage(32, "FigurePeer.doCauseExpose()", this);
        if (this.isShowing() && this.isWindowActiveSinceLastShow()) {
            this.fFigureClient.paintCallback(null);
            this.refreshActiveXCanvases();
        } else {
            this.setWindowExposePending(true);
        }
    }

    void causeExpose(Rectangle rectangle) {
        DebugUtilities.logMessage(32, "FigurePeer.causeExpose()", this);
        HGUtils.invokeLater(new CauseExposeRunnable(this, rectangle));
    }

    void setAccessibleFigureName(Component component) {
        if (component == null) {
            return;
        }
        String string = sAccessFigureTitle;
        if (null != this.fTitle && this.fTitle.length() > 0) {
            string = this.fTitle;
        }
        component.getAccessibleContext().setAccessibleName(string);
    }

    void setAccessibleToolbarName(JToolBar jToolBar) {
        if (jToolBar == null) {
            return;
        }
        String string = "Figure Toolbar";
        if (null != this.fTitle && this.fTitle.length() > 0) {
            string = this.fTitle + " " + sAccessToolbar;
        }
        jToolBar.getAccessibleContext().setAccessibleName(string);
        jToolBar.getAccessibleContext().setAccessibleDescription(string);
    }

    void setAccessibleMenubarName(MJMenuBar mJMenuBar) {
        if (mJMenuBar == null) {
            return;
        }
        String string = "Figure Menubar";
        if (null != this.fTitle && this.fTitle.length() > 0) {
            string = this.fTitle + " " + sAccessMenubar;
        }
        mJMenuBar.getAccessibleContext().setAccessibleName(string);
        mJMenuBar.getAccessibleContext().setAccessibleDescription(string);
    }

    public static void runOnEDT(Runnable runnable) {
        MJUtilities.runOnEventDispatchThread((Runnable)runnable);
    }

    @Override
    public void handleNotification(FigureNotification figureNotification) {
        this.fNotificationHandler.handleNotification(figureNotification);
    }

    @Override
    public FigureNotificationHandler getNotificationSuccessor() {
        return this.fNotificationHandler.getNotificationSuccessor();
    }

    @Override
    public void setNotificationSuccessor(FigureNotificationHandler figureNotificationHandler) {
        this.fNotificationHandler.setNotificationSuccessor(figureNotificationHandler);
    }

    public int setUIControlBackgroundCompatibilityMode(int n) {
        if (n == 0 || n == 1) {
            this.fUIControlBackgroundMode = n;
        }
        return this.fUIControlBackgroundMode;
    }

    public int getUIControlBackgroundCompatibilityMode() {
        return this.fUIControlBackgroundMode;
    }

    public boolean isMaximized() {
        return this.fFigureClient.isMaximized();
    }

    public boolean isMinimized() {
        return this.fFigureClient.isMinimized();
    }

    public void setMaximized(final boolean bl) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 21, 7){

            @Override
            public void run() {
                FigurePeer.this.doSetMaximized(bl);
            }
        });
    }

    void doSetMaximized(boolean bl) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call this method from event dispatch thread";
        if (this.fPendingResizeState) {
            this.fFigureClient.setMaximized(bl);
        }
    }

    public void setMinimized(final boolean bl) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 22, 7){

            @Override
            public void run() {
                FigurePeer.this.doSetMinimized(bl);
            }
        });
    }

    void doSetMinimized(boolean bl) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call this method from event dispatch thread";
        this.fFigureClient.setMinimized(bl);
    }

    public abstract void clearWaitForResize(boolean var1, boolean var2);

    public abstract void setWaitForResize(boolean var1);

    public abstract boolean getWaitForResize();

    public abstract boolean getWaitForWindowStyle();

    @Override
    public void addSceneServerPeer(JavaSceneServerPeer javaSceneServerPeer) {
        assert (false);
    }

    static native int getCXMin();

    static native int getCYMin();

    static native int getCXMaxTrack();

    static native int getCYMaxTrack();

    public void setBackgroundColor(Color color) {
        assert (false);
    }

    @Override
    public Dimension getClientAreaSize() {
        return this.getWindowRect().getSize();
    }

    static {
        FigurePeer.initializeFigurePeer();
        if (Matlab.isMatlabAvailable()) {
            FigurePeer.sInterestCookies[0] = new Matlab().registerInterest(1, 0x4000000, (CompletionObserver)new BreakpointDispatch());
        }
    }

    private class FigurePeerNotificationHandler
    extends FigureNotificationHandlerImpl {
        private FigurePeerNotificationHandler() {
        }

        @Override
        public void handleNotification(FigureNotification figureNotification) {
            if (figureNotification instanceof FigureMoveResizeNotification) {
                FigurePeer.this.handleMoveOrResize(((FigureMoveResizeNotification)figureNotification).isMove(), true);
            } else if (figureNotification instanceof FigureBoundsNotification) {
                FigurePeer.this.handleFigureBoundsNotification((FigureBoundsNotification)figureNotification);
            } else if (figureNotification instanceof UIControlMouseNotification) {
                UIControlMouseNotification uIControlMouseNotification = (UIControlMouseNotification)figureNotification;
                FigurePeer.this.handleUIControlMouseEvent(uIControlMouseNotification.getMouseEvent(), uIControlMouseNotification.getFireButtonDownFcn());
            } else if (figureNotification instanceof UIControlMouseWheelNotification) {
                FigurePeer.this.handleUIControlMouseWheelEvent(((UIControlMouseWheelNotification)figureNotification).getMouseWheelEvent());
            } else {
                if (figureNotification instanceof FigureJavaEventNotification) {
                    this.handleJavaEventNotification((FigureJavaEventNotification)figureNotification);
                    return;
                }
                if (figureNotification instanceof FigurePaintNotification) {
                    Component component = ((FigurePaintNotification)figureNotification).getComponent();
                    Graphics graphics = ((FigurePaintNotification)figureNotification).getGraphics();
                    FigurePeer.this.fireFigurePeerPaintEvent(new FigurePeerPaintEvent(component, 800, graphics == null ? null : graphics.getClipBounds()));
                    return;
                }
                if (figureNotification instanceof FigureWindowNotification) {
                    this.handleWindowNotification((FigureWindowNotification)figureNotification);
                    return;
                }
                if (figureNotification instanceof FigureMenuBarNotification) {
                    this.handleMenuBarNotification((FigureMenuBarNotification)figureNotification);
                    return;
                }
                if (figureNotification instanceof FigureDTClientEventNotification) {
                    this.handleDTClientEventNotification((FigureDTClientEventNotification)figureNotification);
                    return;
                }
                if (figureNotification instanceof FigureToolBarNotification) {
                    FigurePeer.this.fWindowRectHandler.setToolbarContainerHeight(((FigureToolBarNotification)figureNotification).getHeight());
                    if (!FigurePeer.this.fFigureVisible) {
                        FigurePeer.this.handleMoveOrResize(false, false);
                    }
                    return;
                }
                if (figureNotification instanceof FigureComponentContainerNotification) {
                    FigurePeer.this.fComponentContainer = ((FigureComponentContainerNotification)figureNotification).getComponentContainer();
                } else if (figureNotification instanceof RestoreFocusNotification) {
                    FigurePeer.this.requestFocus();
                } else if (figureNotification instanceof AcceleratorEventNotification) {
                    this.fireAcceleratorEvent(((AcceleratorEventNotification)figureNotification).getKeyEvent());
                }
            }
            super.handleNotification(figureNotification);
        }

        private void handleMenuBarNotification(FigureMenuBarNotification figureMenuBarNotification) {
            switch (figureMenuBarNotification.getType()) {
                case 1: {
                    FigurePeer.this.fWindowRectHandler.setCachedMenuBarHeight(figureMenuBarNotification.getHeight());
                    if (!FigurePeer.this.fFigureVisible) {
                        FigurePeer.this.handleMoveOrResize(false, false);
                    }
                    return;
                }
            }
            super.handleNotification(figureMenuBarNotification);
        }

        private void handleJavaEventNotification(FigureJavaEventNotification figureJavaEventNotification) {
            AWTEvent aWTEvent = figureJavaEventNotification.getEvent();
            if (aWTEvent instanceof KeyEvent) {
                if (FigurePeer.this.fListenersEnabled) {
                    int n = aWTEvent.getID();
                    switch (n) {
                        case 401: {
                            this.keyPressed((KeyEvent)aWTEvent);
                            return;
                        }
                        case 402: {
                            this.keyReleased((KeyEvent)aWTEvent);
                            return;
                        }
                        case 400: {
                            this.keyTyped((KeyEvent)aWTEvent);
                            return;
                        }
                    }
                    assert (false);
                }
            } else if (aWTEvent instanceof MouseWheelEvent) {
                MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)aWTEvent;
                FigurePeer.this.fireMouseWheelEvent(mouseWheelEvent);
                if (FigurePeer.this.fListenersEnabled) {
                    FigurePeer.this.handleMouseWheelEvent(mouseWheelEvent, null);
                }
            } else {
                if (aWTEvent instanceof MouseEvent) {
                    if (FigurePeer.this.fListenersEnabled) {
                        FigurePeer.this.handleFigureMouseEvent((MouseEvent)aWTEvent);
                    }
                    return;
                }
                if (aWTEvent instanceof FocusEvent) {
                    FocusEvent focusEvent = (FocusEvent)aWTEvent;
                    if (focusEvent.getID() == 1004) {
                        FigurePeer.this.requestFocus();
                    }
                } else if (aWTEvent instanceof ComponentEvent) {
                    ComponentEvent componentEvent = (ComponentEvent)aWTEvent;
                    FigurePeerWindowEvent figurePeerWindowEvent = new FigurePeerWindowEvent(componentEvent.getComponent(), componentEvent.getID());
                    switch (componentEvent.getID()) {
                        case 200: {
                            DebugUtilities.logMessage(16928, "FigurePeerNotificationHandler.windowOpened", this);
                            assert (FigurePeer.this.fListenersEnabled);
                            FigurePeer.this.fFigWindowActiveState.figureOpened(figurePeerWindowEvent);
                            FigurePeer.this.causeExposeIfActive();
                            FigurePeer.this.fWindowRectHandler.windowOpened();
                            return;
                        }
                        case 205: {
                            if (FigurePeer.this.fListenersEnabled) {
                                DebugUtilities.logMessage(16928, "FigurePeerNotificationHandler.windowActivated", this);
                                FigurePeer.this.fFigWindowActiveState.figureActivated(figurePeerWindowEvent);
                                FigurePeer.this.causeExposeIfActive();
                            }
                            return;
                        }
                        case 202: {
                            DebugUtilities.logMessage(16928, "FigurePeerNotificationHandler.windowClosed", this);
                            FigurePeer.this.fFigWindowActiveState.figureClosed(figurePeerWindowEvent);
                            return;
                        }
                        case 201: {
                            DebugUtilities.logMessage(16928, "FigurePeerNotificationHandler.windowClosing", this);
                            FigurePeer.this.fFigWindowActiveState.figureClosing(figurePeerWindowEvent);
                            return;
                        }
                        case 206: {
                            if (FigurePeer.this.fListenersEnabled) {
                                DebugUtilities.logMessage(16928, "FigurePeerNotificationHandler.windowDeactivated", this);
                                FigurePeer.this.fFigWindowActiveState.figureDeactivated(figurePeerWindowEvent);
                            }
                            return;
                        }
                        case 209: {
                            return;
                        }
                    }
                }
            }
            super.handleNotification(figureJavaEventNotification);
        }

        private void handleDTClientEventNotification(FigureDTClientEventNotification figureDTClientEventNotification) {
            DTClientEvent dTClientEvent = figureDTClientEventNotification.getEvent();
            switch (dTClientEvent.getType()) {
                case 4: {
                    this.clientDocking(dTClientEvent);
                    return;
                }
                case 6: {
                    this.clientUndocking(dTClientEvent);
                    return;
                }
                case 5: {
                    this.clientDocked(dTClientEvent);
                    return;
                }
                case 7: {
                    this.clientUndocked(dTClientEvent);
                    return;
                }
            }
            assert (false);
            super.handleNotification(figureDTClientEventNotification);
        }

        private void handleWindowNotification(FigureWindowNotification figureWindowNotification) {
            switch (figureWindowNotification.getType()) {
                case 1: {
                    FigurePeer.this.setWindowActiveSinceLastShow(true);
                    return;
                }
                case 2: {
                    FigurePeer.this.setWindowExposePending(false);
                    return;
                }
            }
            assert (false);
            super.handleNotification(figureWindowNotification);
        }

        private void clientDocking(DTClientEvent dTClientEvent) {
            FigurePeer.this.fDockPending = true;
            FigurePeer.this.fWindowRectHandler.setDockedPending();
            FigurePeer.this.fCurrentWindowStyle = WindowStyle.DOCKED;
        }

        public void clientDocked(DTClientEvent dTClientEvent) {
            FigurePeer.this.fDockPending = false;
            FigurePeer.this.fWindowRectHandler.setDocked(true);
            FigurePeer.this.fireFigurePeerWindowStyleEvent(new FigurePeerWindowStyleEvent(dTClientEvent.getClient(), WindowStyle.DOCKED.value()));
        }

        private void clientUndocking(DTClientEvent dTClientEvent) {
            if (FigurePeer.this.fCurrentWindowStyle == WindowStyle.DOCKED) {
                FigurePeer.this.fCurrentWindowStyle = WindowStyle.NORMAL;
            }
        }

        private void clientUndocked(DTClientEvent dTClientEvent) {
            WindowStyle windowStyle = FigurePeer.this.fCurrentWindowStyle;
            assert (windowStyle == WindowStyle.NORMAL || windowStyle == WindowStyle.MODAL);
            FigurePeer.this.fWindowRectHandler.setDocked(false);
            FigurePeer.this.fireFigurePeerWindowStyleEvent(new FigurePeerWindowStyleEvent(dTClientEvent.getClient(), windowStyle.value()));
        }

        void fireAcceleratorEvent(KeyEvent keyEvent) {
            if (keyEvent != null && (keyEvent.isControlDown() && keyEvent.getKeyCode() != 17 || PlatformInfo.isMacintosh() && keyEvent.isMetaDown() && keyEvent.getKeyCode() != 157)) {
                DebugUtilities.logMessage(544, "FigureAcceleratorKeyListener.AcceleratorKey", this);
                FigurePeer.this.fireFigurePeerAcceleratorKeyEvent(keyEvent);
            }
        }

        private void keyPressed(KeyEvent keyEvent) {
            DebugUtilities.logMessage(544, "FigurePeerNotificationHandler.keyPressed", this);
            this.fireAcceleratorEvent(keyEvent);
            if (FigurePeer.this.fListenersEnabled) {
                FigurePeer.this.fireFigurePeerKeyEvent(keyEvent);
            }
        }

        private void keyReleased(KeyEvent keyEvent) {
            DebugUtilities.logMessage(544, "FigurePeerNotificationHandler.keyReleased", this);
            if (FigurePeer.this.fListenersEnabled) {
                FigurePeer.this.fireFigurePeerKeyEvent(keyEvent);
            }
        }

        private void keyTyped(KeyEvent keyEvent) {
            DebugUtilities.logMessage(544, "FigurePeerNotificationHandler.keyTyped", this);
            if ((keyEvent.getKeyChar() == '\u0003' || (PlatformInfo.isLinux() || PlatformInfo.isLinux64()) && (keyEvent.getKeyChar() == 'c' || keyEvent.getKeyChar() == 'C') && (keyEvent.getModifiers() & 2) != 0) && FigurePeer.this.fCurrentWindowStyle == WindowStyle.MODAL) {
                DebugUtilities.logMessage(2048, "Got Ctrl-C - disabling modal", this);
                FigurePeer.this.fireFigurePeerWindowStyleEvent(new FigurePeerWindowStyleEvent(keyEvent.getComponent(), WindowStyle.NORMAL.value()));
                FigurePeer.this.fFigureClient.setModal(false);
            }
        }
    }

    private class CauseExposeRunnable
    extends HGPeerRunnable {
        Rectangle fBounds;

        public CauseExposeRunnable(HGPeerQueueUser hGPeerQueueUser, Rectangle rectangle) {
            super(hGPeerQueueUser, 13, 11, false);
            this.fBounds = null;
            this.fBounds = rectangle;
        }

        @Override
        public void run() {
            FigurePeer.this.doCauseExpose(this.fBounds);
        }
    }

    private static class BreakpointDispatch
    implements CompletionObserver {
        private BreakpointDispatch() {
        }

        public void completed(int n, Object object) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModalManagerImpl.getInstance().demodalizeAll();
                }
            });
            FigureRenderLocker.unblockAwtThread();
        }
    }

    private static final class WindowStyle
    extends Enum<WindowStyle> {
        public static final /* enum */ WindowStyle UNSET = new WindowStyle(-1);
        public static final /* enum */ WindowStyle NORMAL = new WindowStyle(0);
        public static final /* enum */ WindowStyle MODAL = new WindowStyle(1);
        public static final /* enum */ WindowStyle DOCKED = new WindowStyle(2);
        public static final /* enum */ WindowStyle DOCKED_HIDDEN = new WindowStyle(3);
        private final int fValue;
        private static final /* synthetic */ WindowStyle[] $VALUES;

        public static WindowStyle[] values() {
            return (WindowStyle[])$VALUES.clone();
        }

        public static WindowStyle valueOf(String string) {
            return Enum.valueOf(WindowStyle.class, string);
        }

        private WindowStyle(int n2) {
            this.fValue = n2;
        }

        public int value() {
            return this.fValue;
        }

        public static WindowStyle convertInt(int n) {
            for (WindowStyle windowStyle : WindowStyle.values()) {
                if (windowStyle.value() != n) continue;
                return windowStyle;
            }
            assert (false);
            return UNSET;
        }

        static {
            $VALUES = new WindowStyle[]{UNSET, NORMAL, MODAL, DOCKED, DOCKED_HIDDEN};
        }
    }

    public static class LightWeightManager {
        private static boolean sUseLightWeightContainer = PlatformInfo.isMacintosh();

        public static boolean isUseLightWeightContainer() {
            return sUseLightWeightContainer;
        }

        public static void setUseLightWeightContainer(boolean bl) {
            sUseLightWeightContainer = bl;
        }
    }
}

