/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.ActiveXCanvas;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.FigureComponent;
import com.mathworks.hg.peer.FigurePanel;
import com.mathworks.hg.peer.FigurePanelContainer;
import com.mathworks.hg.peer.JavaSceneServerPeer;
import com.mathworks.hg.peer.UIComponentParent;
import com.mathworks.hg.peer.ui.borders.TitledBorder;
import com.mathworks.mwswing.MJPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Panel;

public class HeavyweightLightweightContainerFactory {
    static final int WORKAROUND_NONE = 0;
    static final int WORKAROUND_BEFORE_RESHAPE = 1;
    static final int WORKAROUND_AFTER_RESHAPE = 2;
    private static int sUseWorkaround = 1;

    private HeavyweightLightweightContainerFactory() {
    }

    public static Container getUIComponentContainer(UIComponentParent uIComponentParent) {
        assert (uIComponentParent != null);
        return HeavyweightLightweightContainerFactory.getUIComponentContainer(uIComponentParent.useLightWeightContainer());
    }

    public static Container getUIComponentContainer(boolean bl) {
        UIComponentHost uIComponentHost = bl ? new UIComponentLightweightContainer() : new UIComponentHeavyweightContainer();
        return uIComponentHost;
    }

    public static Container getFigurePanelContainer(boolean bl) {
        FigurePanelContainer figurePanelContainer;
        if (bl) {
            FigurePanelContainerLight figurePanelContainerLight = new FigurePanelContainerLight();
            figurePanelContainerLight.setLightweight(bl);
            figurePanelContainerLight.setFigureContainer(true);
            figurePanelContainer = figurePanelContainerLight;
        } else {
            FigurePanelContainerHeavy figurePanelContainerHeavy = new FigurePanelContainerHeavy();
            figurePanelContainerHeavy.setFigureContainer(true);
            figurePanelContainer = figurePanelContainerHeavy;
        }
        return figurePanelContainer;
    }

    public static Container getUIPanelContainer(boolean bl) {
        UIPanelHost uIPanelHost = bl ? new UIPanelLightweightContainer() : new UIPanelHeavyweightContainer();
        return uIPanelHost;
    }

    public static ActiveXCanvas getActiveXContainer(UIComponentParent uIComponentParent) {
        return new ActiveXCanvas(uIComponentParent){

            @Override
            public void reshape(int n, int n2, int n3, int n4) {
                if (HeavyweightLightweightContainerFactory.getUseWorkaround() != 2) {
                    HeavyweightLightweightContainerFactory.usePaintingIssueWorkaround(this);
                }
                super.reshape(n, n2, n3, n4);
                if (HeavyweightLightweightContainerFactory.getUseWorkaround() != 1) {
                    HeavyweightLightweightContainerFactory.usePaintingIssueWorkaround(this);
                }
            }
        };
    }

    static void usePaintingIssueWorkaround(Component component) {
        Container container;
        if (HeavyweightLightweightContainerFactory.getUseWorkaround() != 0 && component != null && component.isVisible() && (container = component.getParent()) != null) {
            container.invalidate();
        }
    }

    public static void setUseWorkaround(int n) {
        sUseWorkaround = n;
    }

    public static int getUseWorkaround() {
        return sUseWorkaround;
    }

    public static class FigurePanelContainerPrinter {
        private Container fContainer;
        private boolean fComponentContainer = true;
        private boolean fFigureContainer;

        FigurePanelContainerPrinter(Container container, boolean bl, boolean bl2) {
            this.fContainer = container;
            this.fComponentContainer = bl;
            this.fFigureContainer = bl2;
        }

        private static void visitChildren(Container container, boolean bl, boolean bl2) {
            int n;
            for (int i = n = container.getComponentCount(); i > 0; --i) {
                Component component = container.getComponent(i - 1);
                if (component instanceof FigurePrintable) {
                    ((FigurePrintable)((Object)component)).setPrintUI(bl);
                    ((FigurePrintable)((Object)component)).setDebug(bl2);
                }
                if (!(component instanceof Container)) continue;
                FigurePanelContainerPrinter.visitChildren((Container)component, bl, bl2);
            }
        }

        public Exception printFigurePanel(Graphics graphics, boolean bl, boolean bl2) {
            assert (graphics instanceof Graphics2D);
            int n = this.fContainer.getComponentCount();
            if (this.fFigureContainer) {
                FigurePanelContainerPrinter.visitChildren(this.fContainer, bl, bl2);
            }
            Component[] componentArray = new Component[n];
            for (int i = n; i > 0; --i) {
                Component component;
                componentArray[this.fContainer.getComponentZOrder((Component)component)] = component = this.fContainer.getComponent(i - 1);
            }
            String string = "*** Detected known meta-file printing bug - g651078.";
            if (!bl2) {
                string = string + " Use print -DEBUG for details.";
            }
            for (int i = n; i > 0; --i) {
                Component component = componentArray[i - 1];
                if (this.fComponentContainer && !(component instanceof FigureComponent) && !(component instanceof FigurePanelContainer)) {
                    String string2 = "Unexpected component requested print: " + component;
                    DebugUtilities.logMessage(16, string2, this);
                    if (!bl2) continue;
                    System.out.println(string2);
                    continue;
                }
                if (!bl && component instanceof FigurePanelContainer) {
                    if (!bl2) continue;
                    System.out.println("Not printing UI based on '-noui' flag");
                    continue;
                }
                try {
                    component.printAll(graphics);
                    continue;
                }
                catch (JavaSceneServerPeer.HGGLRuntimeException hGGLRuntimeException) {
                    return hGGLRuntimeException;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    System.out.println(string);
                    if (bl2) {
                        indexOutOfBoundsException.printStackTrace();
                    }
                    return null;
                }
                catch (NullPointerException nullPointerException) {
                    System.out.println(string);
                    if (bl2) {
                        nullPointerException.printStackTrace();
                    }
                    return null;
                }
                catch (TitledBorder.DrawStringException drawStringException) {
                    System.out.println(string);
                    if (bl2) {
                        drawStringException.printStackTrace();
                    }
                    return null;
                }
            }
            return null;
        }
    }

    public static class PrintableContainerUtility {
        private boolean fPrinting;

        public void setPrinting(boolean bl) {
            this.fPrinting = bl;
        }

        public Component getComponent(Component component) {
            Component component2 = component;
            if (this.fPrinting && component instanceof Container && component instanceof UIComponentHost) {
                Container container = (Container)component;
                assert (container.getComponentCount() == 1);
                component2 = container.getComponent(0);
                component2.setBounds(container.getBounds());
            }
            return component2;
        }
    }

    public static interface FigurePrintable {
        public void setPrintUI(boolean var1);

        public void setDebug(boolean var1);
    }

    public static class PrintHelper {
        private PrintHelper() {
        }

        public static void printAllComponents(Container container, Graphics graphics) {
            int n;
            for (int i = n = container.getComponentCount(); i > 0; --i) {
                Component component = container.getComponent(i - 1);
                Graphics graphics2 = graphics.create(component.getX(), component.getY(), component.getWidth(), component.getHeight());
                component.printAll(graphics2);
                graphics2.dispose();
            }
        }
    }

    public static class FigurePanelContainerHeavy
    extends Panel
    implements FigurePanelContainer,
    FigurePrintable {
        private PrintableContainerUtility fPrintableContainerUtility = new PrintableContainerUtility();
        private boolean fPrintUI = true;
        private boolean fDebug;
        private boolean fFigureContainer;
        private boolean fComponentContainer;

        @Override
        public void setPrintUI(boolean bl) {
            this.fPrintUI = bl;
        }

        @Override
        public void setDebug(boolean bl) {
            this.fDebug = bl;
        }

        @Override
        public void setFigureContainer(boolean bl) {
            this.fFigureContainer = bl;
        }

        @Override
        public void setComponentContainer(boolean bl) {
            this.fComponentContainer = bl;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getSize();
        }

        @Override
        public Exception printFigurePanel(Graphics graphics, boolean bl, boolean bl2) {
            this.setPrintUI(bl);
            this.setDebug(bl2);
            return new FigurePanelContainerPrinter(this, this.fComponentContainer, this.fFigureContainer).printFigurePanel(graphics, bl, bl2);
        }

        @Override
        public Container getTargetContainer() {
            return this;
        }

        @Override
        public void addNotify() {
            super.addNotify();
            FigurePanel.disableBackgroundEraseHack(this);
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        @Override
        public Component getComponent(int n) {
            return this.fPrintableContainerUtility.getComponent(super.getComponent(n));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(Graphics graphics) {
            this.fPrintableContainerUtility.setPrinting(true);
            try {
                super.print(graphics);
            }
            finally {
                this.fPrintableContainerUtility.setPrinting(false);
            }
        }

        @Override
        public void printAll(Graphics graphics) {
            new FigurePanelContainerPrinter(this, this.fComponentContainer, this.fFigureContainer).printFigurePanel(graphics, this.fPrintUI, this.fDebug);
        }
    }

    public static class FigurePanelContainerLight
    extends MJPanel
    implements FigurePanelContainer,
    FigurePrintable {
        private boolean fLightweight;
        private PrintableContainerUtility fPrintableContainerUtility = new PrintableContainerUtility();
        private boolean fPrintUI = true;
        private boolean fDebug;
        private boolean fFigureContainer;
        private boolean fComponentContainer;

        @Override
        public void setPrintUI(boolean bl) {
            this.fPrintUI = bl;
        }

        @Override
        public void setDebug(boolean bl) {
            this.fDebug = bl;
        }

        void setLightweight(boolean bl) {
            this.fLightweight = bl;
        }

        @Override
        public void setFigureContainer(boolean bl) {
            this.fFigureContainer = bl;
        }

        @Override
        public void setComponentContainer(boolean bl) {
            this.fComponentContainer = bl;
        }

        public Dimension getPreferredSize() {
            return this.getSize();
        }

        @Override
        public Exception printFigurePanel(Graphics graphics, boolean bl, boolean bl2) {
            this.fPrintUI = bl;
            this.fDebug = bl2;
            return new FigurePanelContainerPrinter((Container)((Object)this), this.fComponentContainer, this.fFigureContainer).printFigurePanel(graphics, bl, bl2);
        }

        @Override
        public Container getTargetContainer() {
            return this;
        }

        public Component getComponent(int n) {
            return this.fPrintableContainerUtility.getComponent(super.getComponent(n));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void printChildren(Graphics graphics) {
            this.fPrintableContainerUtility.setPrinting(true);
            try {
                super.printChildren(graphics);
            }
            finally {
                this.fPrintableContainerUtility.setPrinting(false);
            }
        }

        public void printAll(Graphics graphics) {
            if (this.fLightweight && !this.fComponentContainer) {
                super.print(graphics);
                new FigurePanelContainerPrinter((Container)((Object)this), this.fComponentContainer, this.fFigureContainer).printFigurePanel(graphics, this.fPrintUI, this.fDebug);
            } else {
                super.printAll(graphics);
                PrintHelper.printAllComponents((Container)((Object)this), graphics);
            }
        }
    }

    public static class UIComponentHeavyweightContainer
    extends Panel
    implements UIComponentHost {
        private PrintableContainerUtility fPrintableContainerUtility = new PrintableContainerUtility();

        public UIComponentHeavyweightContainer() {
            super(new BorderLayout());
        }

        @Override
        public void reshape(int n, int n2, int n3, int n4) {
            if (HeavyweightLightweightContainerFactory.getUseWorkaround() != 2) {
                HeavyweightLightweightContainerFactory.usePaintingIssueWorkaround(this);
            }
            super.reshape(n, n2, n3, n4);
            if (HeavyweightLightweightContainerFactory.getUseWorkaround() != 1) {
                HeavyweightLightweightContainerFactory.usePaintingIssueWorkaround(this);
            }
        }

        @Override
        public Component getComponent(int n) {
            return this.fPrintableContainerUtility.getComponent(super.getComponent(n));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(Graphics graphics) {
            this.fPrintableContainerUtility.setPrinting(true);
            try {
                super.print(graphics);
            }
            finally {
                this.fPrintableContainerUtility.setPrinting(false);
            }
        }

        @Override
        public void printAll(Graphics graphics) {
            super.printAll(graphics);
        }
    }

    public static class UIComponentLightweightContainer
    extends MJPanel
    implements UIComponentHost {
        public UIComponentLightweightContainer() {
            super((LayoutManager)new BorderLayout());
            this.setOpaque(false);
        }
    }

    public static interface UIComponentHost {
    }

    public static class UIPanelHeavyweightContainer
    extends Panel
    implements UIPanelHost,
    FigurePrintable,
    FigurePanelContainer {
        private PrintableContainerUtility fPrintableContainerUtility = new PrintableContainerUtility();
        private boolean fPrintUI = true;
        private boolean fDebug;
        private boolean fFigureContainer;
        private boolean fComponentContainer;

        @Override
        public void setPrintUI(boolean bl) {
            this.fPrintUI = bl;
        }

        @Override
        public void setDebug(boolean bl) {
            this.fDebug = bl;
        }

        @Override
        public Exception printFigurePanel(Graphics graphics, boolean bl, boolean bl2) {
            this.fPrintUI = bl;
            this.fDebug = bl2;
            return new FigurePanelContainerPrinter(this, this.fComponentContainer, this.fFigureContainer).printFigurePanel(graphics, bl, bl2);
        }

        @Override
        public Container getTargetContainer() {
            return this;
        }

        @Override
        public void setFigureContainer(boolean bl) {
            this.fFigureContainer = bl;
        }

        @Override
        public void setComponentContainer(boolean bl) {
            this.fComponentContainer = bl;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getSize();
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        @Override
        public Component getComponent(int n) {
            return this.fPrintableContainerUtility.getComponent(super.getComponent(n));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(Graphics graphics) {
            this.fPrintableContainerUtility.setPrinting(true);
            try {
                super.print(graphics);
            }
            finally {
                this.fPrintableContainerUtility.setPrinting(false);
            }
        }

        @Override
        public void printAll(Graphics graphics) {
            new FigurePanelContainerPrinter(this, this.fComponentContainer, this.fFigureContainer).printFigurePanel(graphics, this.fPrintUI, this.fDebug);
        }
    }

    public static class UIPanelLightweightContainer
    extends MJPanel
    implements UIPanelHost {
        public Dimension getPreferredSize() {
            return this.getSize();
        }

        public void printAll(Graphics graphics) {
            super.printAll(graphics);
            PrintHelper.printAllComponents((Container)((Object)this), graphics);
        }
    }

    public static interface UIPanelHost {
    }
}

