/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.ui;

import com.jidesoft.grid.CellEditorFactory;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.grid.ContextSensitiveTableTransferHandler;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.ListComboBoxCellEditor;
import com.jidesoft.grid.TableSelectionEvent;
import com.jidesoft.grid.TableSelectionListener;
import com.jidesoft.grid.TableSelectionModel;
import com.mathworks.beans.editors.EditorCustomizer;
import com.mathworks.beans.editors.EditorManager;
import com.mathworks.hg.peer.FigureEditableComponent;
import com.mathworks.hg.peer.FigureEditableComponentManager;
import com.mathworks.hg.peer.ui.AbstractUIGroupPeer;
import com.mathworks.hg.peer.ui.table.CheckboxCellRenderer;
import com.mathworks.hg.peer.ui.table.ComboboxCellRenderer;
import com.mathworks.hg.peer.ui.table.DefaultUIStyleTableModel;
import com.mathworks.hg.peer.ui.table.MultilineTableHeaderRenderer;
import com.mathworks.hg.peer.ui.table.TableHeaderNames;
import com.mathworks.hg.peer.ui.table.UIBooleanCheckBoxCellEditor;
import com.mathworks.hg.peer.ui.table.UIListComboBoxCellEditor;
import com.mathworks.hg.peer.ui.table.UINumericCellEditor;
import com.mathworks.hg.peer.ui.table.UISortableTable;
import com.mathworks.hg.peer.ui.table.UISpreadsheetCellRenderer;
import com.mathworks.hg.peer.ui.table.UIStringCellEditor;
import com.mathworks.hg.peer.ui.table.UIStyledTableCellRenderer;
import com.mathworks.hg.peer.ui.table.event.UITableCellEditListener;
import com.mathworks.hg.peer.ui.table.event.UITableCellEditValidationListener;
import com.mathworks.hg.peer.ui.table.event.UITableCellEvent;
import com.mathworks.hg.peer.ui.table.event.UITableDataUpdateEvent;
import com.mathworks.hg.peer.ui.table.event.UITableDataUpdateListener;
import com.mathworks.hg.peer.ui.table.event.UITableModelCellEditListener;
import com.mathworks.hg.peer.ui.table.event.UITableSelectionChangeEvent;
import com.mathworks.hg.peer.ui.table.event.UITableSelectionChangeListener;
import com.mathworks.hg.peer.utils.UIScrollPane;
import com.mathworks.hg.types.HGColor;
import com.mathworks.hg.types.HGRectangle;
import com.mathworks.hg.types.HGTablePropertyEditor;
import com.mathworks.hg.util.FontConverter;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.hg.util.UnicodeTextTranslator;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabMCRFactory;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.SynchronousInvokeUtility;
import com.mathworks.util.Log;
import com.mathworks.widgets.spreadsheet.data.ComplexArray;
import com.mathworks.widgets.spreadsheet.data.ComplexScalar;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.CellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class UITablePeer
extends AbstractUIGroupPeer
implements UITableModelCellEditListener,
FigureEditableComponent {
    public static String DEFAULT_FORMAT = "default";
    public static String NUMBERIC = "numeric";
    public static String CHAR = "char";
    public static String LOGIC = "logical";
    public static String AUTO = "auto";
    public static int TABLE_COLUMN_DEFAULT_WIDTH = 75;
    public static Color DISABLED_TEXT_COLOR = Color.GRAY;
    private static final int sFirstMethodIndex = AbstractUIGroupPeer.getLastMethodIndex();
    private static final int sSetTableModel = sFirstMethodIndex + 1;
    private static final int sDataChanged = sFirstMethodIndex + 2;
    private static final int sSetColumnName = sFirstMethodIndex + 3;
    private static final int sSetShowRowHeader = sFirstMethodIndex + 4;
    private static final int sSetRowStriping = sFirstMethodIndex + 5;
    private static final int sSetColumnWidth = sFirstMethodIndex + 6;
    private static final int sSetRowHeight = sFirstMethodIndex + 7;
    private static final int sSetRowName = sFirstMethodIndex + 8;
    private static final int sColumnFormat = sFirstMethodIndex + 9;
    private static final int sGetExtent = sFirstMethodIndex + 10;
    private static final int sSetRearrangeableColumns = sFirstMethodIndex + 11;
    private static final int sSetSortable = sFirstMethodIndex + 12;
    private static final int sSetColumnEditable = sFirstMethodIndex + 13;
    private static final int sSetTableEditable = sFirstMethodIndex + 14;
    private static final int sUpdateCell = sFirstMethodIndex + 15;
    protected static final int sLastBaseMethodIndex = sSetTableEditable;
    private static final String[] sLogMessagesBase = new String[]{"setTableModel", "SetDataSource", "SetColumnName", "SetShowRowHeader", "SetRowStriping", "SetColumnWidth", "SetRowHeight", "SetRowName", "Columnformat", "GetExtent", "SetRearrangeableColumns", "SetSortable", "SetColumnEditable", "SetTableEditable", "UpdateCell"};
    private Map fCellEditorMap = new TreeMap();
    private Map fCellRendererMap = new TreeMap();
    private MultilineTableHeaderRenderer fMultilineTableHeaderRenderer = null;
    private UIScrollPane fTableScrollPane = null;
    private UISortableTable fTable;
    private DefaultUIStyleTableModel fTableModel;
    private EditorContext fEditorContext;
    private Object fHandle;
    private ScrollbarMouseListener fScrollbarMouseListener;
    private UITablePeerTableDataUpdateListener fTableDataUpdateListener;
    private Color fLastForegroundColor;
    private Object[] fColumnFormat;
    private Object[] fColumnWidth;
    protected Font fRenderingFont;
    private MatlabMCR fMatlabMCR;
    private boolean fDisposed = false;

    public UITablePeer(Object object) {
        MJUtilities.initJIDE();
        this.fHandle = object;
        this.fMultilineTableHeaderRenderer = new MultilineTableHeaderRenderer();
        this.initCellEditorMap();
        this.initCellRendererMap();
        this.fMatlabMCR = MatlabMCRFactory.getForCurrentMCR();
    }

    @Override
    public boolean isDisposed() {
        return this.fDisposed;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.cleanup();
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.fCellEditorMap.clear();
        this.fCellRendererMap.clear();
        CellEditorManager.unregisterEditor(Boolean.class, (EditorContext)this.fEditorContext);
        CellEditorManager.unregisterEditor(ComplexScalar.class, (EditorContext)this.fEditorContext);
        CellEditorManager.unregisterEditor(String.class, (EditorContext)this.fEditorContext);
        CellEditorManager.unregisterEditor(ComplexArray.class, (EditorContext)this.fEditorContext);
        CellRendererManager.unregisterRenderer(Boolean.class, (EditorContext)this.fEditorContext);
        CellRendererManager.unregisterRenderer(ComplexScalar.class, (EditorContext)this.fEditorContext);
        CellRendererManager.unregisterRenderer(String.class, (EditorContext)this.fEditorContext);
        CellRendererManager.unregisterRenderer(ComplexArray.class, (EditorContext)this.fEditorContext);
        this.fDisposed = true;
    }

    private void initCellRendererMap() {
        FormatIdentifier[] formatIdentifierArray;
        UIStyledTableCellRenderer uIStyledTableCellRenderer = new UIStyledTableCellRenderer();
        UISpreadsheetCellRenderer uISpreadsheetCellRenderer = new UISpreadsheetCellRenderer(FormatIdentifier.getDefaultInstance());
        CheckboxCellRenderer checkboxCellRenderer = new CheckboxCellRenderer();
        this.fCellRendererMap.put(DEFAULT_FORMAT, uIStyledTableCellRenderer);
        this.fCellRendererMap.put(NUMBERIC, uISpreadsheetCellRenderer);
        this.fCellRendererMap.put(CHAR, uIStyledTableCellRenderer);
        this.fCellRendererMap.put(LOGIC, checkboxCellRenderer);
        for (FormatIdentifier formatIdentifier : formatIdentifierArray = FormatIdentifier.values()) {
            UISpreadsheetCellRenderer uISpreadsheetCellRenderer2 = new UISpreadsheetCellRenderer(formatIdentifier);
            this.fCellRendererMap.put(formatIdentifier.getName().toLowerCase(), uISpreadsheetCellRenderer2);
        }
    }

    private void initCellEditorMap() {
        FormatIdentifier[] formatIdentifierArray;
        UIStringCellEditor uIStringCellEditor = new UIStringCellEditor();
        uIStringCellEditor.addKeyListener(new AbstractUIGroupPeer.InnerUicontrolKeyListener());
        this.fCellEditorMap.put(DEFAULT_FORMAT, uIStringCellEditor);
        UINumericCellEditor uINumericCellEditor = new UINumericCellEditor(FormatIdentifier.getDefaultInstance());
        uINumericCellEditor.addKeyListener(new AbstractUIGroupPeer.InnerUicontrolKeyListener());
        this.fCellEditorMap.put(NUMBERIC, uINumericCellEditor);
        this.fCellEditorMap.put(CHAR, uIStringCellEditor);
        UIBooleanCheckBoxCellEditor uIBooleanCheckBoxCellEditor = new UIBooleanCheckBoxCellEditor();
        uIBooleanCheckBoxCellEditor.addKeyListener(new AbstractUIGroupPeer.InnerUicontrolKeyListener());
        this.fCellEditorMap.put(LOGIC, uIBooleanCheckBoxCellEditor);
        for (FormatIdentifier formatIdentifier : formatIdentifierArray = FormatIdentifier.values()) {
            UINumericCellEditor uINumericCellEditor2 = new UINumericCellEditor(formatIdentifier);
            uINumericCellEditor2.addKeyListener(new AbstractUIGroupPeer.InnerUicontrolKeyListener());
            this.fCellEditorMap.put(formatIdentifier.getName().toLowerCase(), uINumericCellEditor2);
        }
    }

    @Override
    protected JComponent getUIComponent() {
        return this.fTable;
    }

    @Override
    protected JComponent getTopLevelComponent() {
        if (this.fTableScrollPane == null) {
            this.createPeerComponent();
        }
        return this.fTableScrollPane;
    }

    @Override
    protected void createPeerComponentImpl() {
        try {
            AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    UITablePeer.this.createTopLevelComponent();
                }
            });
        }
        catch (Throwable throwable) {
            Log.logThrowable((Throwable)throwable);
        }
    }

    public final void setBackgroundColor(final HGColor[] hGColorArray) {
        if (this.doPreSetBackgroundColor(hGColorArray)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 2, 7){

                @Override
                public void run() {
                    UITablePeer.this.doSetBackgroundColor(hGColorArray);
                }
            });
        }
    }

    protected boolean doPreSetBackgroundColor(HGColor[] hGColorArray) {
        this.addLogMessage(2);
        return true;
    }

    protected void doSetBackgroundColor(HGColor[] hGColorArray) {
        this.fTableModel.setBackground(hGColorArray);
        this.getUIComponent().repaint();
    }

    @Override
    protected void doSetForegroundColor(Color color) {
        this.fLastForegroundColor = color;
        Color color2 = this.fTable.isEnabled() ? this.fLastForegroundColor : DISABLED_TEXT_COLOR;
        this.fTableModel.setForeground(color2);
        this.getUIComponent().repaint();
    }

    public final void initializePeerProperty(final double[] dArray, final String[] stringArray, final HGColor[] hGColorArray, final boolean[] blArray, final Object[] objectArray, final Object[] objectArray2, final int n, final int n2, final int n3, final int n4) {
        if (this.doPreInitializePeerProperty(dArray, stringArray, hGColorArray, blArray, objectArray, objectArray2, n, n2, n3, n4)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 9, 7, true){

                @Override
                public void run() {
                    UITablePeer.this.doInitializePeerProperty(dArray, stringArray, hGColorArray, blArray, objectArray, objectArray2, n, n2, n3, n4);
                }
            });
        }
    }

    public void setTableModel(final DefaultUIStyleTableModel defaultUIStyleTableModel) {
        this.fTableModel = defaultUIStyleTableModel;
        HGUtils.invokeLater(new HGPeerRunnable(this, sSetTableModel){

            @Override
            public void run() {
                UITablePeer.this.fTable.setModel((TableModel)((Object)defaultUIStyleTableModel));
            }
        });
    }

    public int getColumnWidthAt(int n) {
        return this.fTable.getColumnModel().getColumn(n).getWidth();
    }

    public void setColumnWidth(final Object[] objectArray) {
        HGUtils.invokeLater(new HGPeerRunnable(this, sSetColumnWidth){

            @Override
            public void run() {
                UITablePeer.this.doSetColumnWidth(objectArray);
            }
        });
    }

    protected void doSetColumnWidth(Object[] objectArray) {
        this.fColumnWidth = objectArray;
        if (objectArray == null || objectArray.length == 0) {
            for (int i = 0; i <= this.fTable.getColumnCount() - 1; ++i) {
                this.setColumnWidthAutoAt(i);
            }
            return;
        }
        if (objectArray.length == 1) {
            Object object = objectArray[0];
            if (object instanceof String) {
                if (AUTO.equalsIgnoreCase((String)object)) {
                    for (int i = 0; i <= this.fTable.getColumnCount() - 1; ++i) {
                        this.setColumnWidthAutoAt(i);
                    }
                }
                return;
            }
            if (object instanceof Number) {
                Number number = (Number)objectArray[0];
                if (number != null) {
                    int n = number.intValue();
                    for (int i = 0; i <= this.fTable.getColumnCount() - 1; ++i) {
                        this.fTable.getColumnModel().getColumn(i).setPreferredWidth(n);
                    }
                }
                return;
            }
            return;
        }
        int n = Math.min(objectArray.length, this.fTable.getColumnModel().getColumnCount());
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (object instanceof Number) {
                int n2 = ((Number)object).intValue();
                if (n2 < this.fTable.getColumnModel().getColumn(i).getMinWidth()) {
                    this.fTable.getColumnModel().getColumn(i).setMinWidth(n2);
                } else if (n2 > this.fTable.getColumnModel().getColumn(i).getMaxWidth()) {
                    this.fTable.getColumnModel().getColumn(i).setMaxWidth(n2);
                }
                this.fTable.getColumnModel().getColumn(i).setPreferredWidth(n2);
                continue;
            }
            if (!(object instanceof String) || !AUTO.equalsIgnoreCase((String)object)) continue;
            this.setColumnWidthAutoAt(i);
        }
    }

    private void setColumnWidthAutoAt(int n) {
        TableColumn tableColumn = this.fTable.getColumnModel().getColumn(n);
        if (tableColumn == null) {
            return;
        }
        if (tableColumn.getHeaderRenderer() != null) {
            Component component = tableColumn.getHeaderRenderer().getTableCellRendererComponent((JTable)((Object)this.fTable), tableColumn.getHeaderValue(), false, false, 0, n);
            int n2 = component.getPreferredSize().width;
            tableColumn.setPreferredWidth(Math.max(TABLE_COLUMN_DEFAULT_WIDTH, n2));
        } else {
            String string = (String)tableColumn.getHeaderValue();
            FontMetrics fontMetrics = this.fTable.getTableHeader().getFontMetrics(this.getFont());
            tableColumn.setPreferredWidth(Math.max(TABLE_COLUMN_DEFAULT_WIDTH, fontMetrics.stringWidth(string) + 4));
        }
    }

    public void setRowStriping(final boolean bl) {
        HGUtils.invokeLater(new HGPeerRunnable(this, sSetRowStriping){

            @Override
            public void run() {
                UITablePeer.this.doSetRowStriping(bl);
            }
        });
    }

    protected void doSetRowStriping(boolean bl) {
        this.fTableModel.setRowStriping(bl);
    }

    public void setColumnEditable(final boolean[] blArray) {
        HGUtils.invokeLater(new HGPeerRunnable(this, sSetColumnEditable){

            @Override
            public void run() {
                UITablePeer.this.doSetColumnEditable(blArray);
            }
        });
    }

    protected void doSetColumnEditable(boolean[] blArray) {
        this.fTableModel.setColumnEditable(blArray);
        this.fTable.repaint();
    }

    public void setRearrangeableColumns(final boolean bl) {
        HGUtils.invokeLater(new HGPeerRunnable(this, sSetRearrangeableColumns){

            @Override
            public void run() {
                UITablePeer.this.doSetRearrangeableColumns(bl);
            }
        });
    }

    protected void doSetRearrangeableColumns(boolean bl) {
        JTableHeader jTableHeader = this.fTable.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.setReorderingAllowed(bl);
        }
    }

    public void setTableSortable(final boolean bl) {
        HGUtils.invokeLater(new HGPeerRunnable(this, sSetSortable){

            @Override
            public void run() {
                UITablePeer.this.doSetTableSortable(bl);
            }
        });
    }

    protected void doSetTableSortable(boolean bl) {
        this.fTable.setSortable(bl);
    }

    public void setTableEditable(final boolean bl) {
        HGUtils.invokeLater(new HGPeerRunnable(this, sSetTableEditable){

            @Override
            public void run() {
                UITablePeer.this.doSetTableEditable(bl);
            }
        });
    }

    protected void doSetTableEditable(boolean bl) {
        this.fTableModel.setTableEditable(bl);
        this.fTable.repaint();
    }

    public boolean isShowRowHeader() {
        return this.fTable.isShowRowNumber();
    }

    public void setColumnWidth(final int n, final int n2) {
        HGUtils.invokeLater(new HGPeerRunnable(this, sSetColumnWidth){

            @Override
            public void run() {
                UITablePeer.this.fTable.getColumnModel().getColumn(n).setPreferredWidth(n2);
            }
        });
    }

    public int getRowHeight() {
        return this.fTable.getRowHeight();
    }

    public void setRowHeight(final int n) {
        HGUtils.invokeLater(new HGPeerRunnable(this, sSetRowHeight){

            @Override
            public void run() {
                UITablePeer.this.fTable.setRowHeight(n);
            }
        });
    }

    public int getRowHeight(int n) {
        return this.fTable.getRowHeight(n);
    }

    public void setRowHeight(final int n, final int n2) {
        HGUtils.invokeLater(new HGPeerRunnable(this, sSetRowHeight){

            @Override
            public void run() {
                UITablePeer.this.fTable.setRowHeight(n, n2);
            }
        });
    }

    public void dataChanged(final int n, final int n2) {
        HGUtils.invokeLater(new HGPeerRunnable(this, sDataChanged){

            @Override
            public void run() {
                UITablePeer.this.doDataChanged(n, n2);
            }
        });
    }

    public void updateCellAt(final int n, final int n2) {
        HGUtils.invokeLater(new HGPeerRunnable(this, sUpdateCell){

            @Override
            public void run() {
                UITablePeer.this.doUpdateCellAt(n, n2);
            }
        });
    }

    private void doUpdateCellAt(int n, int n2) {
        this.fTableModel.updateCellAt(n, n2);
    }

    protected void doDataChanged(int n, int n2) {
        this.fTableModel.setDataRowCount(n);
        this.fTableModel.setDataColumnCount(n2);
        this.fTableModel.updateData();
        this.updateTableColumn();
    }

    @Override
    protected void addUicomponentButtondownListener() {
        super.addUicomponentButtondownListener();
        this.fTable.addMouseListeners(this.fButtondownListener, this.fButtondownListener);
        this.fTableScrollPane.addMouseListener(this.fButtondownListener);
        this.fTableScrollPane.addMouseMotionListener(this.fButtondownListener);
        this.fTableScrollPane.getViewport().addMouseListener(this.fButtondownListener);
        this.fTableScrollPane.getViewport().addMouseMotionListener(this.fButtondownListener);
    }

    @Override
    protected void addUicontrolKeyListeners() {
        super.addUicontrolKeyListeners();
        this.fTableScrollPane.getViewport().addKeyListener(this.fKeyListener);
    }

    @Override
    protected void removeUicontrolKeyListeners() {
        super.removeUicontrolKeyListeners();
        this.fTableScrollPane.getViewport().removeKeyListener(this.fKeyListener);
    }

    public void setColumnName(final Object[] objectArray) {
        HGUtils.invokeLater(new HGPeerRunnable(this, sSetColumnName){

            @Override
            public void run() {
                UITablePeer.this.doSetColumnName(objectArray);
                UITablePeer.this.doSetColumnWidth(UITablePeer.this.fColumnWidth);
            }
        });
    }

    protected void doSetColumnName(Object[] objectArray) {
        this.fTableModel.setColumnIdentifiers(objectArray);
        this.updateTableColumn();
    }

    public void setRowName(final Object[] objectArray) {
        HGUtils.invokeLater(new HGPeerRunnable(this, sSetRowName){

            @Override
            public void run() {
                UITablePeer.this.doSetRowName(objectArray);
            }
        });
    }

    protected void doSetRowName(Object[] objectArray) {
        this.fTableModel.setRowNameCount(objectArray == null || TableHeaderNames.isNumbered(objectArray) ? 0 : objectArray.length);
        this.fTable.setRowIdentifiers(objectArray);
    }

    public boolean isEditable(final int n) {
        SynchronousInvokeRunnable synchronousInvokeRunnable = new SynchronousInvokeRunnable(){

            @Override
            public void run() {
                this.setResult(UITablePeer.this.fTableModel.isCellEditable(0, n - 1));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            synchronousInvokeRunnable.run();
        } else {
            SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter((Runnable)synchronousInvokeRunnable));
        }
        return (Boolean)synchronousInvokeRunnable.getResult();
    }

    public boolean isEnabled(final int n) {
        SynchronousInvokeRunnable synchronousInvokeRunnable = new SynchronousInvokeRunnable(){

            @Override
            public void run() {
                TableColumn tableColumn = UITablePeer.this.fTable.getColumnModel().getColumn(n - 1);
                boolean bl = ((Component)((Object)tableColumn.getCellRenderer())).isEnabled();
                this.setResult(bl);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            synchronousInvokeRunnable.run();
        } else {
            SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter((Runnable)synchronousInvokeRunnable));
        }
        return (Boolean)synchronousInvokeRunnable.getResult();
    }

    public void setEnabled(final int n, final boolean bl) {
        HGUtils.invokeLater(new HGPeerRunnable(this, AbstractUIGroupPeer.sSetEnable){

            @Override
            public void run() {
                TableColumn tableColumn = UITablePeer.this.fTable.getColumnModel().getColumn(n - 1);
                ((Component)((Object)tableColumn.getCellRenderer())).setEnabled(bl);
                UITablePeer.this.fTable.updateUI();
            }
        });
    }

    @Override
    protected void doSetEnable(int n) {
        super.doSetEnable(n);
        if (n == 0) {
            this.getTopLevelComponent().setEnabled(false);
            this.getTopLevelComponent().addMouseListener(this.fScrollbarMouseListener);
        } else {
            this.getTopLevelComponent().removeMouseListener(this.fScrollbarMouseListener);
            this.getTopLevelComponent().setEnabled(true);
        }
        Color color = n != 0 ? this.fLastForegroundColor : DISABLED_TEXT_COLOR;
        this.fTableModel.setForeground(color);
    }

    public void setColumnFormat(final Object[] objectArray) {
        HGUtils.invokeLater(new HGPeerRunnable(this, sColumnFormat){

            @Override
            public void run() {
                UITablePeer.this.doSetColumnFormat(objectArray);
            }
        });
    }

    protected void doSetColumnFormat(Object[] objectArray) {
        this.fColumnFormat = objectArray;
        this.fTable.repaint();
    }

    public final HGRectangle getControlExtent() {
        this.addLogMessage(sGetExtent);
        return this.doPreGetExtent();
    }

    protected HGRectangle doPreGetExtent() {
        HGRectangle hGRectangle = null;
        try {
            hGRectangle = (HGRectangle)AWTUtilities.invokeAndWait((AWTUtilities.InvocationRunnable)new AWTUtilities.InvocationRunnable(){

                public Object runWithOutput() {
                    int n;
                    Dimension dimension = UITablePeer.this.fTable.getPreferredSize();
                    Dimension dimension2 = UITablePeer.this.fTableScrollPane.getRowHeader() == null ? new Dimension(0, 0) : UITablePeer.this.fTableScrollPane.getRowHeader().getPreferredSize();
                    Dimension dimension3 = UITablePeer.this.fTableScrollPane.getColumnHeader() == null ? new Dimension(0, 0) : UITablePeer.this.fTableScrollPane.getColumnHeader().getPreferredSize();
                    HGRectangle hGRectangle = new HGRectangle(0.0, 0.0, 4.0, 4.0);
                    int n2 = dimension.width + dimension2.width;
                    if (n2 > 0) {
                        hGRectangle.setWidth(n2 + 4);
                    }
                    if ((n = dimension.height + dimension3.height) > 0) {
                        hGRectangle.setHeight(n + 4);
                    }
                    return hGRectangle;
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return hGRectangle;
    }

    public synchronized void removeUITableCellEditListener(UITableCellEditListener uITableCellEditListener) {
        this.fListenerList.remove(UITableCellEditListener.class, uITableCellEditListener);
    }

    public synchronized void addUITableCellEditListener(UITableCellEditListener uITableCellEditListener) {
        this.fListenerList.add(UITableCellEditListener.class, uITableCellEditListener);
    }

    protected void fireUITableCellEditAction(UITableCellEvent uITableCellEvent) {
        EventListener[] eventListenerArray;
        for (EventListener eventListener : eventListenerArray = this.fListenerList.getListeners(UITableCellEditListener.class)) {
            ((UITableCellEditListener)eventListener).UITableCellEditAction(uITableCellEvent);
        }
    }

    public synchronized void removeUITableCellEditValidationListener(UITableCellEditValidationListener uITableCellEditValidationListener) {
        this.fListenerList.remove(UITableCellEditValidationListener.class, uITableCellEditValidationListener);
    }

    public synchronized void addUITableCellEditValidationListener(UITableCellEditValidationListener uITableCellEditValidationListener) {
        this.fListenerList.add(UITableCellEditValidationListener.class, uITableCellEditValidationListener);
    }

    protected void fireUITableCellEditValidation(UITableCellEvent uITableCellEvent) {
        EventListener[] eventListenerArray;
        for (EventListener eventListener : eventListenerArray = this.fListenerList.getListeners(UITableCellEditValidationListener.class)) {
            ((UITableCellEditValidationListener)eventListener).UITableCellEditValidation(uITableCellEvent);
        }
    }

    public synchronized void removeUITableSelectionChangeListener(UITableSelectionChangeListener uITableSelectionChangeListener) {
        this.fListenerList.remove(UITableSelectionChangeListener.class, uITableSelectionChangeListener);
    }

    public synchronized void addUITableSelectionChangeListener(UITableSelectionChangeListener uITableSelectionChangeListener) {
        this.fListenerList.add(UITableSelectionChangeListener.class, uITableSelectionChangeListener);
    }

    protected void fireUITableSelectionChange(UITableSelectionChangeEvent uITableSelectionChangeEvent) {
        EventListener[] eventListenerArray;
        FigureEditableComponentManager.commitCurrentEditableComponent(this);
        for (EventListener eventListener : eventListenerArray = this.fListenerList.getListeners(UITableSelectionChangeListener.class)) {
            ((UITableSelectionChangeListener)eventListener).selectionChanged(uITableSelectionChangeEvent);
        }
    }

    protected boolean doPreInitializePeerProperty(double[] dArray, String[] stringArray, HGColor[] hGColorArray, boolean[] blArray, Object[] objectArray, Object[] objectArray2, int n, int n2, int n3, int n4) {
        String string;
        int n5 = 0;
        int n6 = 0;
        boolean bl = true;
        int n7 = n5++;
        if (dArray[n7] > 0.0) {
            bl = dArray[n5++] != 0.0;
        }
        int n8 = n5++;
        if (dArray[n8] > 0.0) {
            this.doPreSetEnable((int)dArray[n5++]);
        }
        int n9 = n5++;
        if (dArray[n9] > 0.0) {
            this.doPreSetForegroundColor(new Color((float)dArray[n5++], (float)dArray[n5++], (float)dArray[n5++]));
        }
        double d = 0.0;
        int n10 = n5++;
        if (dArray[n10] > 0.0) {
            d = dArray[n5++];
        }
        int n11 = 0;
        int n12 = n5++;
        if (dArray[n12] > 0.0) {
            n11 = (int)dArray[n5++];
        }
        int n13 = 0;
        int n14 = n5++;
        if (dArray[n14] > 0.0) {
            n13 = (int)dArray[n5++];
        }
        if ((string = stringArray[n6++]) != null) {
            this.doPreSetFont(FontConverter.convertToJavaFont(string, d, n11, n13));
        }
        this.doPreSetName(stringArray[n6++]);
        this.doPreSetTooltip(stringArray[n6++]);
        this.doDataChanged(n, n2);
        this.doPreSetVisible(bl);
        return true;
    }

    @Override
    protected boolean doPreSetFont(Font font) {
        this.fRenderingFont = UnicodeTextTranslator.deriveFont(font);
        return super.doPreSetFont(font);
    }

    protected void doInitializePeerProperty(double[] dArray, String[] stringArray, HGColor[] hGColorArray, boolean[] blArray, Object[] objectArray, Object[] objectArray2, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = 0;
        int n7 = 0;
        boolean bl = true;
        int n8 = n6++;
        if (dArray[n8] > 0.0) {
            bl = dArray[n6++] != 0.0;
        }
        int n9 = n6++;
        if (dArray[n9] > 0.0) {
            this.doSetEnable((int)dArray[n6++]);
        }
        int n10 = n6++;
        if (dArray[n10] > 0.0) {
            this.doSetForegroundColor(new Color((float)dArray[n6++], (float)dArray[n6++], (float)dArray[n6++]));
        }
        n6 += 6;
        ++n7;
        this.doSetFont(this.fRenderingFont);
        int n11 = n6++;
        if (dArray[n11] > 0.0) {
            this.doSetRowStriping(dArray[n6++] != 0.0);
        }
        int n12 = n6++;
        if (dArray[n12] > 0.0) {
            this.doSetRearrangeableColumns(dArray[n6++] != 0.0);
        }
        this.doSetName(stringArray[n7++]);
        this.doSetTooltip(stringArray[n7++]);
        Object[] objectArray3 = new String[n4];
        for (n5 = 0; n5 < n4; ++n5) {
            objectArray3[n5] = stringArray[n7++];
        }
        this.doSetColumnName(objectArray3);
        objectArray3 = new String[n3];
        for (n5 = 0; n5 < n3; ++n5) {
            objectArray3[n5] = stringArray[n7++];
        }
        this.doSetRowName(objectArray3);
        if (hGColorArray != null && hGColorArray.length != 0) {
            this.doSetBackgroundColor(hGColorArray);
        }
        if (blArray != null && blArray.length != 0) {
            this.doSetColumnEditable(blArray);
        }
        if (objectArray2 != null && objectArray2.length != 0) {
            this.doSetColumnFormat(objectArray2);
        }
        this.doDataChanged(n, n2);
        if (objectArray != null && objectArray.length != 0) {
            this.doSetColumnWidth(objectArray);
        }
        this.doSetVisible(bl);
    }

    private TableCellRenderer getCellRendererByType(Object object, int n, int n2) {
        if (object == null) {
            return (TableCellRenderer)this.fCellRendererMap.get(DEFAULT_FORMAT);
        }
        if (object instanceof String) {
            String string = ((String)object).toLowerCase();
            if (this.fCellRendererMap.containsKey(string)) {
                return (TableCellRenderer)this.fCellRendererMap.get(string);
            }
            return (TableCellRenderer)this.fCellRendererMap.get(DEFAULT_FORMAT);
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            ComboboxCellRenderer comboboxCellRenderer = new ComboboxCellRenderer(objectArray);
            comboboxCellRenderer.setButtonVisible(this.fTable.isCellEditable(n, n2));
            return comboboxCellRenderer;
        }
        return (TableCellRenderer)this.fCellRendererMap.get(DEFAULT_FORMAT);
    }

    private TableCellEditor getCellEditorByType(Object object) {
        if (object == null) {
            return (TableCellEditor)this.fCellEditorMap.get(DEFAULT_FORMAT);
        }
        if (object instanceof String) {
            String string = ((String)object).toLowerCase();
            if (this.fCellEditorMap.containsKey(string)) {
                return (TableCellEditor)this.fCellEditorMap.get(string);
            }
            return (TableCellEditor)this.fCellEditorMap.get(DEFAULT_FORMAT);
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            String string = Arrays.toString(objectArray).toLowerCase();
            if (this.fCellEditorMap.containsKey(string)) {
                return (ListComboBoxCellEditor)this.fCellEditorMap.get(string);
            }
            UIListComboBoxCellEditor uIListComboBoxCellEditor = new UIListComboBoxCellEditor(objectArray);
            this.fCellEditorMap.put(string, uIListComboBoxCellEditor);
            return uIListComboBoxCellEditor;
        }
        return (TableCellEditor)this.fCellEditorMap.get(DEFAULT_FORMAT);
    }

    @Override
    public void cellChanged(UITableCellEvent uITableCellEvent) {
        this.fireUITableCellEditAction(uITableCellEvent);
    }

    private void createTable() {
        this.fColumnWidth = null;
        this.fTableModel = new DefaultUIStyleTableModel(this.fHandle, this.fMatlabMCR);
        this.fEditorContext = new EditorContext(this.fTableModel.getContextKey());
        this.fTable = new UISortableTable((TableModel)((Object)this.fTableModel)){

            public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
                FigureEditableComponentManager.setCurrentEditableComponent(UITablePeer.this);
                return super.prepareEditor(tableCellEditor, n, n2);
            }

            public TableCellEditor getCellEditor(int n, int n2) {
                Object object = UITablePeer.this.getColumnFormatAt(n2);
                if (null != object) {
                    return UITablePeer.this.getCellEditorByType(object);
                }
                return super.getCellEditor(n, n2);
            }

            public TableCellRenderer getCellRenderer(int n, int n2) {
                Object object = UITablePeer.this.getColumnFormatAt(n2);
                if (null != object) {
                    return UITablePeer.this.getCellRendererByType(object, n, n2);
                }
                return super.getCellRenderer(n, n2);
            }

            protected TableCellEditor getCellEditorFromManager(int n, int n2) {
                TableCellEditor tableCellEditor = super.getCellEditorFromManager(n, n2);
                UIStringCellEditor uIStringCellEditor = new UIStringCellEditor();
                uIStringCellEditor.addKeyListener(new AbstractUIGroupPeer.InnerUicontrolKeyListener());
                return tableCellEditor == null ? uIStringCellEditor : tableCellEditor;
            }

            protected TableCellRenderer getCellRendererFromManager(int n, int n2) {
                TableCellRenderer tableCellRenderer = super.getCellRendererFromManager(n, n2);
                return tableCellRenderer == null ? (TableCellRenderer)UITablePeer.this.fCellRendererMap.get(DEFAULT_FORMAT) : tableCellRenderer;
            }

            public void processEvent(AWTEvent aWTEvent) {
                if (UITablePeer.this.fEnable == 1) {
                    super.processEvent(aWTEvent);
                } else {
                    UITablePeer.this.doProcessEvent(aWTEvent);
                }
            }

            public boolean isFocusable() {
                return UITablePeer.this.fEnable == 1;
            }
        };
        this.fTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.fTable.setAutoResizeMode(0);
        this.fTable.setSortable(false);
        this.fTable.setTransferHandler((TransferHandler)((Object)new innerContextSensitiveTableTransferHandler()));
        this.fTable.setBackground(UIManager.getColor("Viewport.background"));
        JTableHeader jTableHeader = this.fTable.getTableHeader();
        if (jTableHeader != null) {
            ((DefaultTableCellRenderer)jTableHeader.getDefaultRenderer()).setHorizontalAlignment(0);
        }
        CellEditorManager.initDefaultEditor();
        CellEditorManager.registerEditor(Boolean.class, (CellEditorFactory)new CellEditorFactory(){

            public CellEditor create() {
                return (CellEditor)UITablePeer.this.fCellEditorMap.get(LOGIC);
            }
        }, (EditorContext)this.fEditorContext);
        CellEditorManager.registerEditor(ComplexScalar.class, (CellEditorFactory)new CellEditorFactory(){

            public CellEditor create() {
                return (CellEditor)UITablePeer.this.fCellEditorMap.get(NUMBERIC);
            }
        }, (EditorContext)this.fEditorContext);
        CellEditorManager.registerEditor(String.class, (CellEditorFactory)new CellEditorFactory(){

            public CellEditor create() {
                return (CellEditor)UITablePeer.this.fCellEditorMap.get(DEFAULT_FORMAT);
            }
        }, (EditorContext)this.fEditorContext);
        CellEditorManager.registerEditor(ComplexArray.class, (CellEditorFactory)new CellEditorFactory(){

            public CellEditor create() {
                return (CellEditor)UITablePeer.this.fCellEditorMap.get(DEFAULT_FORMAT);
            }
        }, (EditorContext)this.fEditorContext);
        CellRendererManager.initDefaultRenderer();
        CellRendererManager.registerRenderer(Boolean.class, (TableCellRenderer)((TableCellRenderer)this.fCellRendererMap.get(LOGIC)), (EditorContext)this.fEditorContext);
        CellRendererManager.registerRenderer(ComplexScalar.class, (TableCellRenderer)((TableCellRenderer)this.fCellRendererMap.get(NUMBERIC)), (EditorContext)this.fEditorContext);
        CellRendererManager.registerRenderer(String.class, (TableCellRenderer)((TableCellRenderer)this.fCellRendererMap.get(DEFAULT_FORMAT)), (EditorContext)this.fEditorContext);
        CellRendererManager.registerRenderer(ComplexArray.class, (TableCellRenderer)((TableCellRenderer)this.fCellRendererMap.get(DEFAULT_FORMAT)), (EditorContext)this.fEditorContext);
        this.fTableModel.addUITableModelCellEditListener(this);
        this.fTableDataUpdateListener = new UITablePeerTableDataUpdateListener();
        this.fTableModel.addUITableDataUpdateListener(this.fTableDataUpdateListener);
        this.fTable.setNonContiguousCellSelection(true);
        UITableSelectionListener uITableSelectionListener = new UITableSelectionListener();
        this.fTable.getTableSelectionModel().addTableSelectionListener((TableSelectionListener)uITableSelectionListener);
    }

    @Override
    public void commitEditAction() {
        TableCellEditor tableCellEditor = this.fTable.getCellEditor();
        if (null != tableCellEditor) {
            tableCellEditor.stopCellEditing();
        }
    }

    private void createTopLevelComponent() {
        if (this.fTable == null) {
            this.createTable();
        }
        this.fTableScrollPane = new UIScrollPane((Component)((Object)this.fTable));
        this.fTableScrollPane.setHorizontalScrollBarPolicy(30);
        this.fTableScrollPane.setVerticalScrollBarPolicy(20);
        this.fScrollbarMouseListener = new ScrollbarMouseListener();
        this.fTableScrollPane.addMouseMotionListener(this.fScrollbarMouseListener);
        this.fTableScrollPane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                UITablePeer.this.handleMouseWheelEvent(mouseWheelEvent);
            }
        });
        this.fTableScrollPane.getViewport().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                mouseEvent.getComponent().requestFocus();
            }
        });
    }

    private void updateTableColumn() {
        Enumeration<TableColumn> enumeration = this.fTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(this.fMultilineTableHeaderRenderer);
        }
        this.doSetColumnWidth(this.fColumnWidth);
    }

    private int getModelSelectedColumn() {
        return this.fTable.convertColumnIndexToModel(this.fTable.getSelectedColumn());
    }

    @Override
    public void addGUIDEViewListeners(EventListener[] eventListenerArray) {
        if (eventListenerArray != null) {
            for (EventListener eventListener : eventListenerArray) {
                if (!(eventListener instanceof UITableDataUpdateListener)) continue;
                this.fTableModel.addUITableDataUpdateListener((UITableDataUpdateListener)eventListener);
            }
        }
    }

    private Object restoreOldFormatStringStyle(Object object) {
        Object object2 = object;
        if (object instanceof String) {
            String string = (String)object;
            if (string.equals("shorte")) {
                string = "short e";
            } else if (string.equals("longe")) {
                string = "long e";
            } else if (string.equals("shortg")) {
                string = "short g";
            } else if (string.equals("longg")) {
                string = "long g";
            } else if (string.equals("shorteng")) {
                string = "short eng";
            } else if (string.equals("longeng")) {
                string = "long eng";
            }
            object2 = string;
        }
        return object2;
    }

    private Object getColumnFormatAt(int n) {
        int n2 = this.fTable.convertColumnIndexToModel(n);
        if (this.fColumnFormat != null && this.fColumnFormat.length != 0 && n2 < this.fColumnFormat.length) {
            return this.restoreOldFormatStringStyle(this.fColumnFormat[n2]);
        }
        return null;
    }

    private boolean isNumericFormatString(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            try {
                FormatIdentifier.fromString((String)((String)object));
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
        return false;
    }

    private boolean isValueDisplayedAsCheckbox(Object object, Object object2) {
        if (object2 != null && object2 instanceof String && ((String)object2).equals(LOGIC)) {
            return true;
        }
        return object2 == null && object instanceof Boolean;
    }

    static {
        EditorManager.registerCustomEditor((EditorCustomizer)new HGTablePropertyEditor());
    }

    private class innerContextSensitiveTableTransferHandler
    extends ContextSensitiveTableTransferHandler {
        private innerContextSensitiveTableTransferHandler() {
        }

        protected String convertElementToString(JTable jTable, int n, int n2, Object object) {
            Object object2 = UITablePeer.this.getColumnFormatAt(n2);
            if (UITablePeer.this.isNumericFormatString(object2)) {
                return FormatIdentifier.fromString((String)((String)object2)).getFormatter().format(object);
            }
            if (UITablePeer.this.isValueDisplayedAsCheckbox(object, object2)) {
                if (new Boolean(object.toString()).booleanValue()) {
                    return "true";
                }
                return "false";
            }
            return super.convertElementToString(jTable, n, n2, object);
        }
    }

    private class UITablePeerTableDataUpdateListener
    implements UITableDataUpdateListener {
        private UITablePeerTableDataUpdateListener() {
        }

        @Override
        public void dataUpdated(UITableDataUpdateEvent uITableDataUpdateEvent) {
            UITablePeer.this.fTable.repaint();
        }
    }

    private class ScrollbarMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private ScrollbarMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            UITablePeer.this.doProcessEvent(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            UITablePeer.this.doProcessEvent(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            UITablePeer.this.doProcessEvent(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            UITablePeer.this.doProcessEvent(mouseEvent);
        }
    }

    public class UITableSelectionListener
    implements TableSelectionListener {
        private Vector<Point> fLastSelection = new Vector();

        public void valueChanged(TableSelectionEvent tableSelectionEvent) {
            Vector<Point> vector = new Vector<Point>(20, 10);
            if (!tableSelectionEvent.getValueIsAdjusting()) {
                TableSelectionModel tableSelectionModel = (TableSelectionModel)tableSelectionEvent.getSource();
                int n = tableSelectionModel.getMinSelectedRowIndex();
                int n2 = tableSelectionModel.getMaxSelectedRowIndex();
                int n3 = tableSelectionModel.getMinSelectedColumnIndex();
                int n4 = tableSelectionModel.getMaxSelectedColumnIndex();
                for (int i = n; i <= n2; ++i) {
                    for (int j = n3; j <= n4; ++j) {
                        if (!tableSelectionModel.isSelected(i, j)) continue;
                        vector.add(new Point(i, j));
                    }
                }
                if (!this.fLastSelection.equals(vector)) {
                    UITablePeer.this.fireUITableSelectionChange(new UITableSelectionChangeEvent(vector, (Object)UITablePeer.this.fTable));
                    this.fLastSelection = vector;
                }
            }
        }
    }

    private static abstract class SynchronousInvokeRunnable
    implements Runnable {
        private Object fResult = null;

        private SynchronousInvokeRunnable() {
        }

        public void setResult(Object object) {
            this.fResult = object;
        }

        public Object getResult() {
            return this.fResult;
        }
    }
}

