/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.ui.table;

import com.mathworks.hg.peer.ui.table.MultilineTableHeaderRenderer;
import com.mathworks.hg.peer.ui.table.RowHeader;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.jidesoft.grid.MWSortableTable;
import com.mathworks.widgets.spreadsheet.HeaderBorder;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class UISortableTable
extends MWSortableTable {
    private boolean fIsShowRowCountColumn;
    private JViewport fRowNumberViewPort;
    private RowHeader fRowHeader;
    private JComponent fRowNumberLabel;
    private static final int sROWHEIGHTPADDING = 2;

    public UISortableTable() {
        this.initialize();
    }

    public UISortableTable(TableModel tableModel) {
        super(tableModel);
        this.initialize();
    }

    public UISortableTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.initialize();
    }

    public UISortableTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.initialize();
    }

    public UISortableTable(int n, int n2) {
        super(n, n2);
        this.initialize();
    }

    public UISortableTable(Vector vector, Vector vector2) {
        super(vector, vector2);
        this.initialize();
    }

    public UISortableTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.initialize();
    }

    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.fIsShowRowCountColumn && this.fRowHeader != null) {
            this.fRowHeader.updateGUI();
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.fIsShowRowCountColumn && this.fRowHeader != null) {
            int n = this.fRowHeader.getFontMetrics(this.fRowHeader.getFont()).getHeight() + 2;
            this.setRowHeight(Math.max(this.getRowHeight(), n));
            this.fRowHeader.updateGUI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tableChanged(TableModelEvent tableModelEvent) {
        block8: {
            block7: {
                super.tableChanged(tableModelEvent);
                try {
                    if (this.fIsShowRowCountColumn && this.fRowHeader != null) break block7;
                }
                catch (Throwable throwable) {
                    Rectangle rectangle = this.getVisibleRect();
                    Rectangle rectangle2 = this.getCellRect(this.getSelectedRow(), 0, true);
                    int n = rectangle.y;
                    int n2 = n + rectangle.height;
                    int n3 = rectangle2.y;
                    int n4 = n3 + rectangle2.height;
                    if (n <= n3 && n2 >= n4) {
                        return;
                    }
                    Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle2.y - rectangle.height / 2, rectangle.width, rectangle.height);
                    this.scrollRectToVisible(rectangle3);
                    throw throwable;
                }
                Rectangle rectangle = this.getVisibleRect();
                Rectangle rectangle4 = this.getCellRect(this.getSelectedRow(), 0, true);
                int n = rectangle.y;
                int n5 = n + rectangle.height;
                int n6 = rectangle4.y;
                int n7 = n6 + rectangle4.height;
                if (n <= n6 && n5 >= n7) {
                    return;
                }
                Rectangle rectangle5 = new Rectangle(rectangle.x, rectangle4.y - rectangle.height / 2, rectangle.width, rectangle.height);
                this.scrollRectToVisible(rectangle5);
                return;
            }
            if (tableModelEvent != null && tableModelEvent.getFirstRow() != -1 && tableModelEvent.getType() != 1 && tableModelEvent.getType() != -1 && tableModelEvent.getLastRow() != Integer.MAX_VALUE) break block8;
            this.fRowHeader.updateGUI();
            Rectangle rectangle = this.getVisibleRect();
            Rectangle rectangle6 = this.getCellRect(this.getSelectedRow(), 0, true);
            int n = rectangle.y;
            int n8 = n + rectangle.height;
            int n9 = rectangle6.y;
            int n10 = n9 + rectangle6.height;
            if (n <= n9 && n8 >= n10) {
                return;
            }
            Rectangle rectangle7 = new Rectangle(rectangle.x, rectangle6.y - rectangle.height / 2, rectangle.width, rectangle.height);
            this.scrollRectToVisible(rectangle7);
            return;
        }
        Rectangle rectangle = this.getVisibleRect();
        Rectangle rectangle8 = this.getCellRect(this.getSelectedRow(), 0, true);
        int n = rectangle.y;
        int n11 = n + rectangle.height;
        int n12 = rectangle8.y;
        int n13 = n12 + rectangle8.height;
        if (n <= n12 && n11 >= n13) {
            return;
        }
        Rectangle rectangle9 = new Rectangle(rectangle.x, rectangle8.y - rectangle.height / 2, rectangle.width, rectangle.height);
        this.scrollRectToVisible(rectangle9);
    }

    public int getSelectedRow() {
        int n = super.getSelectedRow();
        return n < this.getModel().getRowCount() ? n : -1;
    }

    public int[] getSelectedRows() {
        int[] nArray = super.getSelectedRows();
        int n = this.getModel().getRowCount();
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < n) continue;
            nArray[i] = -1;
            ++n2;
        }
        if (n2 > 0) {
            int[] nArray2 = nArray;
            nArray = new int[nArray2.length - n2];
            int n3 = 0;
            for (int i = 0; i < nArray2.length; ++i) {
                if (nArray2[i] == -1) continue;
                nArray[n3++] = nArray2[i];
            }
        }
        return nArray;
    }

    public int getSelectedColumn() {
        int n = super.getSelectedColumn();
        return n < this.getModel().getColumnCount() ? n : -1;
    }

    public int[] getSelectedColumns() {
        int[] nArray = super.getSelectedColumns();
        int n = this.getModel().getColumnCount();
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < n) continue;
            nArray[i] = -1;
            ++n2;
        }
        if (n2 > 0) {
            int[] nArray2 = nArray;
            nArray = new int[nArray2.length - n2];
            int n3 = 0;
            for (int i = 0; i < nArray2.length; ++i) {
                if (nArray2[i] == -1) continue;
                nArray[n3++] = nArray2[i];
            }
        }
        return nArray;
    }

    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        if (this.fIsShowRowCountColumn) {
            this.setRowNumberHeaderForScrollPane();
        }
    }

    protected void unconfigureEnclosingScrollPane() {
        if (this.fIsShowRowCountColumn) {
            this.removeRowNumberHeaderForScrollPane();
        }
        super.unconfigureEnclosingScrollPane();
    }

    private void setShowRowNumber(boolean bl) {
        if (this.fIsShowRowCountColumn == bl) {
            return;
        }
        this.fIsShowRowCountColumn = bl;
        if (this.fIsShowRowCountColumn) {
            this.setRowNumberHeaderForScrollPane();
        } else {
            this.removeRowNumberHeaderForScrollPane();
        }
    }

    public void setRowIdentifiers(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            this.setShowRowNumber(false);
            return;
        }
        this.setShowRowNumber(true);
        if (this.fRowHeader == null) {
            this.fRowHeader = new RowHeader((JTable)((Object)this));
        }
        this.fRowHeader.setRowNames(objectArray);
    }

    public void addMouseListeners(MouseListener mouseListener, MouseMotionListener mouseMotionListener) {
        JComponent jComponent;
        this.getRowNumberViewPort();
        if (null != this.fRowHeader) {
            this.fRowHeader.addMouseListener(mouseListener);
            this.fRowHeader.addMouseMotionListener(mouseMotionListener);
        }
        if (null != this.getTableHeader()) {
            this.getTableHeader().addMouseListener(mouseListener);
            this.getTableHeader().addMouseMotionListener(mouseMotionListener);
        }
        if (null != (jComponent = this.getRowNumberLabel())) {
            jComponent.addMouseListener(mouseListener);
            jComponent.addMouseMotionListener(mouseMotionListener);
        }
    }

    public void addKeyListeners(KeyListener keyListener) {
        JComponent jComponent;
        this.getRowNumberViewPort();
        if (null != this.fRowHeader) {
            this.fRowHeader.addKeyListener(keyListener);
        }
        if (null != this.getTableHeader()) {
            this.getTableHeader().addKeyListener(keyListener);
        }
        if (null != (jComponent = this.getRowNumberLabel())) {
            jComponent.addKeyListener(keyListener);
        }
    }

    public void removeKeyListeners(KeyListener keyListener) {
        JComponent jComponent;
        this.getRowNumberViewPort();
        if (null != this.fRowHeader) {
            this.fRowHeader.removeKeyListener(keyListener);
        }
        if (null != this.getTableHeader()) {
            this.getTableHeader().removeKeyListener(keyListener);
        }
        if (null != (jComponent = this.getRowNumberLabel())) {
            jComponent.removeKeyListener(keyListener);
        }
    }

    public boolean isShowRowNumber() {
        return this.fIsShowRowCountColumn;
    }

    private void initialize() {
        this.getTableHeader().setAlignmentX(0.5f);
        this.setShowRowNumber(true);
    }

    private void setRowNumberHeaderForScrollPane() {
        JScrollPane jScrollPane = this.getParentScrollPane();
        if (null != jScrollPane) {
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.setRowHeader(this.getRowNumberViewPort());
            this.fRowHeader.adjustPreferredScrollableViewportSize();
            jScrollPane.setCorner("UPPER_LEFT_CORNER", this.getRowNumberLabel());
        }
    }

    private JViewport getRowNumberViewPort() {
        if (this.fRowNumberViewPort == null) {
            if (this.fRowHeader == null) {
                this.fRowHeader = new RowHeader((JTable)((Object)this));
            }
            this.fRowNumberViewPort = new JViewport();
            this.fRowNumberViewPort.setView(this.fRowHeader);
        }
        return this.fRowNumberViewPort;
    }

    private JComponent getRowNumberLabel() {
        if (this.fRowNumberLabel == null) {
            if (PlatformInfo.isMacintosh()) {
                this.fRowNumberLabel = new JList();
                MultilineTableHeaderRenderer.setMacHeaderUI((JTable)((Object)this), this.fRowNumberLabel);
            } else {
                this.fRowNumberLabel = new JLabel("", 0);
                LookAndFeel.installColorsAndFont(this.fRowNumberLabel, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
                this.fRowNumberLabel.setBorder((Border)new HeaderBorder((Color)SystemColor.controlShadow));
            }
        }
        return this.fRowNumberLabel;
    }

    private void removeRowNumberHeaderForScrollPane() {
        JScrollPane jScrollPane = this.getParentScrollPane();
        if (null != jScrollPane) {
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.setRowHeader(null);
        }
    }

    private JScrollPane getParentScrollPane() {
        Container container;
        JScrollPane jScrollPane = null;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            jScrollPane = (JScrollPane)container;
        }
        return jScrollPane;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (null != this.fRowHeader) {
            this.fRowHeader.setEnabled(bl);
        }
    }
}

