/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.table.panel;

import com.mathworks.hg.types.table.panel.EditableTableSupport;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class EditableTableUtils {
    private EditableTableUtils() {
    }

    public static void attachTableAccelerators(final JTable jTable, final EditableTableSupport editableTableSupport) {
        jTable.getInputMap(1).put(KeyStroke.getKeyStroke(155, 0), "InsertRow");
        jTable.getActionMap().put("InsertRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jTable.isEditing()) {
                    jTable.getCellEditor().stopCellEditing();
                }
                editableTableSupport.addEntry();
            }
        });
        jTable.getInputMap(1).put(KeyStroke.getKeyStroke(68, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK), "DeleteRow");
        jTable.getActionMap().put("DeleteRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jTable.isEditing()) {
                    jTable.getCellEditor().stopCellEditing();
                }
                editableTableSupport.removeEntry();
            }
        });
        jTable.getInputMap(1).put(KeyStroke.getKeyStroke(80, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK), "CopyRow");
        jTable.getActionMap().put("CopyRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jTable.isEditing()) {
                    jTable.getCellEditor().stopCellEditing();
                }
                editableTableSupport.copyEntry();
            }
        });
        jTable.getInputMap(1).put(KeyStroke.getKeyStroke(38, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK), "MoveUp");
        jTable.getActionMap().put("MoveUp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jTable.isEditing()) {
                    jTable.getCellEditor().stopCellEditing();
                }
                editableTableSupport.moveEntryUp();
            }
        });
        jTable.getInputMap(1).put(KeyStroke.getKeyStroke(40, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK), "MoveDown");
        jTable.getActionMap().put("MoveDown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jTable.isEditing()) {
                    jTable.getCellEditor().stopCellEditing();
                }
                editableTableSupport.moveEntryDown();
            }
        });
    }

    public static String getWindowTitle(JComponent jComponent) {
        String string = null;
        if (jComponent.getTopLevelAncestor() instanceof Window) {
            Window window = (Window)jComponent.getTopLevelAncestor();
            if (window instanceof Dialog) {
                string = ((Dialog)window).getTitle();
            } else if (window instanceof Frame) {
                string = ((Frame)window).getTitle();
            }
        }
        if (string == null) {
            string = MJOptionPane.getFrameForComponent((Component)jComponent).getTitle();
        }
        return string;
    }

    public static void showWarningMessage(JComponent jComponent, String string) {
        MJOptionPane.showMessageDialog((Component)jComponent.getTopLevelAncestor(), (Object)string, (String)EditableTableUtils.getWindowTitle(jComponent), (int)2);
    }

    public static boolean showConfirmMessage(JComponent jComponent, String string) {
        int n = MJOptionPane.showConfirmDialog((Component)jComponent.getTopLevelAncestor(), (Object)string, (String)EditableTableUtils.getWindowTitle(jComponent), (int)0);
        return n == 0;
    }

    public static int showYesNoCancelMessage(JComponent jComponent, String string) {
        return MJOptionPane.showConfirmDialog((Component)jComponent.getTopLevelAncestor(), (Object)string, (String)EditableTableUtils.getWindowTitle(jComponent), (int)1);
    }
}

