/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.uij;

import com.mathworks.hg.uij.ExportClipboardHelper;
import com.mathworks.hg.util.OutputGenerator;
import com.mathworks.hg.util.OutputHelperProcessingException;
import com.mathworks.jmi.NativeMatlab;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.ResourceBundle;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.graphicsio.ps.EPSGraphics2D;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.freehep.graphicsio.svg.SVGGraphics2D;
import org.freehep.util.UserProperties;

public class FreehepHelper
implements OutputGenerator {
    private Color fBackgroundColor = null;
    private int fWidth = 0;
    private int fHeight = 0;
    private int fX = 0;
    private int fY = 0;
    private String fFilename = null;
    private OutputStream fDestination = null;
    private ByteArrayOutputStream fDestinationByteArray = null;
    private FileFormats fFormat = FileFormats.INVALID_FORMAT;
    private UserProperties fProps = new UserProperties();
    private VectorGraphics fGraphics = null;
    private boolean fToClipboard = false;
    private String fClipboardFormat = null;
    static ResourceBundle sMLInfo = ResourceBundle.getBundle("com.mathworks.hg.uij.resources.RES_freehep");

    @Override
    public void setSize(int n, int n2) {
        this.fWidth = n;
        this.fHeight = n2;
    }

    public void setSize(Dimension dimension) {
        this.fWidth = (int)dimension.getWidth();
        this.fHeight = (int)dimension.getHeight();
    }

    public void setSize(Rectangle rectangle) {
        this.fX = (int)rectangle.getX();
        this.fY = (int)rectangle.getY();
        this.fWidth = (int)rectangle.getWidth();
        this.fHeight = (int)rectangle.getHeight();
    }

    public Rectangle getBoundingBox() {
        return new Rectangle(this.fX, this.fY, this.fWidth, this.fHeight);
    }

    public Dimension getSize() {
        return new Dimension(this.fWidth, this.fHeight);
    }

    @Override
    public void setFormat(String string) {
        String string2 = sMLInfo.getString("creator.program");
        String string3 = "Letter";
        String string4 = "false";
        String string5 = "Type3";
        if (string.indexOf("ps") == 0 || string.indexOf("eps") == 0) {
            this.fFormat = FileFormats.PS_FORMAT;
            if (string.indexOf("eps") >= 0) {
                this.fFormat = FileFormats.EPS_FORMAT;
            }
            this.fProps.setProperty(PSGraphics2D.EMBED_FONTS, string4);
            this.fProps.setProperty(PSGraphics2D.EMBED_FONTS_AS, string5);
            this.fProps.setProperty(PSGraphics2D.TEXT_AS_SHAPES, "false");
            this.fProps.setProperty(PSGraphics2D.FOR, string2);
            this.fProps.setProperty(PSGraphics2D.FIT_TO_PAGE, "false");
            this.fProps.setProperty(PSGraphics2D.PAGE_SIZE, string3);
            if (string.indexOf("2") >= 2) {
                if (this.fFormat == FileFormats.PS_FORMAT) {
                    this.fFormat = FileFormats.PS_2_FORMAT;
                } else if (this.fFormat == FileFormats.EPS_FORMAT) {
                    this.fFormat = FileFormats.EPS_2_FORMAT;
                }
            }
            if (string.indexOf("c") >= 2) {
                // empty if block
            }
        } else if (string.indexOf("pdfwrite") == 0) {
            this.fFormat = FileFormats.PDF_FORMAT;
            this.fProps.setProperty(PDFGraphics2D.EMBED_FONTS, string4);
            this.fProps.setProperty(PDFGraphics2D.EMBED_FONTS_AS, string5);
            this.fProps.setProperty(PDFGraphics2D.TEXT_AS_SHAPES, "false");
            this.fProps.setProperty(PDFGraphics2D.FIT_TO_PAGE, "false");
            this.fClipboardFormat = "pdf";
            this.fProps.setProperty(PDFGraphics2D.PAGE_SIZE, string3);
        } else if (string.indexOf("meta") == 0) {
            this.fFormat = FileFormats.EMF_FORMAT;
            this.fProps.setProperty(EMFGraphics2D.TEXT_AS_SHAPES, "false");
            this.fProps.setProperty(EMFGraphics2D.BACKGROUND, "true");
            this.fClipboardFormat = "emf";
        } else if (string.indexOf("svg") >= 0) {
            this.fFormat = FileFormats.SVG_FORMAT;
            this.fProps.setProperty(SVGGraphics2D.EMBED_FONTS, string4);
            this.fProps.setProperty(SVGGraphics2D.TEXT_AS_SHAPES, "false");
        }
    }

    public void setFilename(String string) {
        this.fFilename = string;
        if (this.fFilename.length() == 0 && this.fClipboardFormat != null) {
            this.fToClipboard = true;
        }
    }

    public void setBackgroundColor(float f, float f2, float f3, float f4) {
        this.fBackgroundColor = new Color(f, f2, f3, f4);
    }

    public OutputStream setDestination() throws FileNotFoundException {
        return this.setDestination(this.fFilename);
    }

    @Override
    public OutputStream setDestination(String string) throws FileNotFoundException {
        this.fDestination = null;
        this.setFilename(string);
        if (!this.fToClipboard) {
            this.fDestination = new FileOutputStream(string);
            this.fDestinationByteArray = null;
        } else {
            this.fDestinationByteArray = new ByteArrayOutputStream();
            this.fDestination = this.fDestinationByteArray;
        }
        return this.fDestination;
    }

    public OutputStream getDestination() {
        return this.fDestination;
    }

    @Override
    public Graphics createGraphicsForFormat() {
        Dimension dimension = this.getSize();
        PSGraphics2D pSGraphics2D = null;
        EPSGraphics2D ePSGraphics2D = null;
        switch (this.fFormat) {
            case PS_2_FORMAT: {
                pSGraphics2D = new PSGraphics2D(this.fDestination, this.getBoundingBox(), 2);
                pSGraphics2D.setCenterOnPage(false);
                this.fGraphics = pSGraphics2D;
                break;
            }
            case PS_FORMAT: {
                pSGraphics2D = new PSGraphics2D(this.fDestination, this.getBoundingBox());
                pSGraphics2D.setMultiPage(true);
                pSGraphics2D.setCenterOnPage(false);
                this.fGraphics = pSGraphics2D;
                break;
            }
            case EPS_2_FORMAT: {
                ePSGraphics2D = new EPSGraphics2D(this.fDestination, this.getBoundingBox(), 2);
                ePSGraphics2D.setCenterOnPage(false);
                this.fGraphics = ePSGraphics2D;
                break;
            }
            case EPS_FORMAT: {
                ePSGraphics2D = new EPSGraphics2D(this.fDestination, this.getBoundingBox());
                ePSGraphics2D.setCenterOnPage(false);
                this.fGraphics = ePSGraphics2D;
                break;
            }
            case PDF_FORMAT: {
                this.fGraphics = new PDFGraphics2D(this.fDestination, this.getBoundingBox());
                break;
            }
            case SVG_FORMAT: {
                this.fGraphics = new SVGGraphics2D(this.fDestination, dimension);
                break;
            }
            case EMF_FORMAT: {
                this.fGraphics = new EMFGraphics2D(this.fDestination, dimension);
                break;
            }
            default: {
                this.fGraphics = null;
            }
        }
        this.setProperties();
        this.fGraphics.startExport();
        return this.fGraphics;
    }

    private void setProperties() {
        this.fGraphics.setProperties((Properties)this.fProps);
        String string = sMLInfo.getString("creator.program") + ", " + sMLInfo.getString("creator.company");
        StringBuffer stringBuffer = new StringBuffer(NativeMatlab.GetMatlabVersion());
        String string2 = System.getProperty("os.name");
        this.fGraphics.setCreator(string + " " + sMLInfo.getString("creator.version") + " " + stringBuffer + ". " + sMLInfo.getString("creator.operatingSystem") + " " + string2 + ".");
    }

    public Graphics getGraphics() {
        if (this.fGraphics == null) {
            Dimension dimension = this.getSize();
            try {
                this.fDestination = this.setDestination();
                this.fGraphics = (VectorGraphics)this.createGraphicsForFormat();
                if (this.fGraphics == null) {
                    return null;
                }
                this.doPage(true);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.fGraphics;
    }

    @Override
    public void doPage(boolean bl) {
        String string = sMLInfo.getString("page.title");
        try {
            switch (this.fFormat) {
                case PS_2_FORMAT: 
                case PS_FORMAT: {
                    if (bl) {
                        ((PSGraphics2D)this.fGraphics).openPage(this.getSize(), string);
                        break;
                    }
                    ((PSGraphics2D)this.fGraphics).closePage();
                    break;
                }
                case PDF_FORMAT: {
                    if (bl) {
                        ((PDFGraphics2D)this.fGraphics).openPage(this.getSize(), string);
                        break;
                    }
                    ((PDFGraphics2D)this.fGraphics).closePage();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Graphics open(String string, Rectangle rectangle, String string2) throws OutputHelperProcessingException {
        this.setFormat(string);
        this.setSize(rectangle);
        try {
            this.setDestination(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new OutputHelperProcessingException(fileNotFoundException.getMessage());
        }
        return this.createGraphicsForFormat();
    }

    @Override
    public void close() {
        try {
            this.fGraphics.endExport();
            try {
                this.fDestination.close();
                if (this.fToClipboard && this.fDestinationByteArray != null) {
                    ExportClipboardHelper exportClipboardHelper = new ExportClipboardHelper(this.fClipboardFormat, this.fDestinationByteArray);
                    exportClipboardHelper.copyToClipboard();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void write() {
        try {
            this.doPage(false);
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static enum FileFormats {
        INVALID_FORMAT,
        PS_FORMAT,
        EPS_FORMAT,
        PS_2_FORMAT,
        EPS_2_FORMAT,
        PDF_FORMAT,
        SVG_FORMAT,
        EMF_FORMAT;

    }
}

