/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search;

import com.mathworks.search.SearchException;
import com.mathworks.search.SearchResult;
import com.mathworks.search.SearchResultCollector;
import com.mathworks.search.SearchResultFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class FilterCollector
implements SearchResultCollector {
    private final SearchResultFilter fFilter;
    private final List<SearchResultCollector> fCollectors;
    private int fNumFiltered = 0;

    public FilterCollector(SearchResultFilter filter, SearchResultCollector ... collectors) {
        this(filter, Arrays.asList(collectors));
    }

    public FilterCollector(SearchResultFilter filter, Collection<SearchResultCollector> collectors) {
        this.fFilter = filter;
        this.fCollectors = new ArrayList<SearchResultCollector>(collectors);
    }

    @Override
    public void examineResult(SearchResult result) throws SearchException {
        if (this.fFilter.accept(result)) {
            this.notifyCollectors(result);
        } else {
            ++this.fNumFiltered;
        }
    }

    private void notifyCollectors(SearchResult result) throws SearchException {
        for (SearchResultCollector collector : this.fCollectors) {
            collector.examineResult(result);
        }
    }

    @Override
    public void resultsComplete() {
        for (SearchResultCollector collector : this.fCollectors) {
            collector.resultsComplete();
        }
    }

    public int getNumFiltered() {
        return this.fNumFiltered;
    }
}

