/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.IndexDocument;
import com.mathworks.search.Indexer;
import com.mathworks.search.SearchLanguage;
import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.LuceneIndexer;
import com.mathworks.search.lucene.RAMDirectoryIndexLocation;
import java.io.IOException;
import org.apache.lucene.store.Directory;

public class LuceneBatchIndexer
implements Indexer {
    private long fWaitBetweenIndexAttempts = 5000L;
    private final LuceneIndexer fRealIndexer;
    private final int fNumRetries;
    private LuceneIndexer fRAMIndexer;

    public LuceneBatchIndexer(IndexLocation location, SearchLanguage language) throws IOException {
        this(new LuceneIndexer(location, language));
    }

    public LuceneBatchIndexer(IndexLocation location, SearchLanguage language, int numRetries) throws IOException {
        this(new LuceneIndexer(location, language), numRetries);
    }

    public LuceneBatchIndexer(LuceneIndexer realIndexer) {
        this(realIndexer, 1);
    }

    public LuceneBatchIndexer(LuceneIndexer realIndexer, int numRetries) {
        this.fRealIndexer = realIndexer;
        this.fNumRetries = numRetries;
    }

    public void setWaitBetweenIndexAttempts(long wait) {
        this.fWaitBetweenIndexAttempts = wait;
    }

    @Override
    public void openIndex() throws IOException {
        this.fRAMIndexer = new LuceneIndexer(new RAMDirectoryIndexLocation(), this.fRealIndexer.getLanguage());
        this.fRAMIndexer.openIndex();
    }

    @Override
    public void addDocument(IndexDocument doc) throws IOException {
        this.fRAMIndexer.addDocument(doc);
    }

    @Override
    public void closeIndex() throws IOException {
        this.fRAMIndexer.closeIndex();
        IOException caughtException = null;
        for (int i = 0; i < this.fNumRetries; ++i) {
            if (i > 0) {
                try {
                    Thread.sleep(this.fWaitBetweenIndexAttempts);
                }
                catch (Exception e) {
                    continue;
                }
            }
            try {
                this.tryToWriteIndex();
                return;
            }
            catch (IOException ioe) {
                caughtException = ioe;
            }
        }
        throw caughtException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void tryToWriteIndex() throws IOException {
        this.fRealIndexer.openIndex();
        try {
            Directory ramDirectory = this.fRAMIndexer.getLuceneDirectory();
            this.fRealIndexer.addDirectories(ramDirectory);
        }
        finally {
            this.fRealIndexer.closeIndex();
        }
    }
}

