/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery;

import com.mathworks.toolstrip.accessories.CalloutToolTipManager;
import com.mathworks.toolstrip.accessories.ToolTipContentProvider;
import com.mathworks.toolstrip.components.ButtonOrientation;
import com.mathworks.toolstrip.components.TSButton;
import com.mathworks.toolstrip.plaf.GalleryButtonUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;

public class GalleryButton
extends TSButton {
    private int fLabelLineCount;
    private JButton fFavoriteButton;
    private boolean fShowFavoriteUponRollover;
    private MouseListener fMouseListener;

    public GalleryButton(Action action) {
        super(action);
        this.setAutoMnemonicEnabled(false);
        this.setButtonMnemonic(null);
        super.setOrientation(ButtonOrientation.VERTICAL);
        CalloutToolTipManager.getInstance().register(new CalloutToolTipManager.Client(){

            @Override
            public JComponent getComponent() {
                return GalleryButton.this;
            }

            @Override
            public ToolTipContentProvider getToolTipContentProvider() {
                return GalleryButton.this.getToolTipContentProvider();
            }
        });
    }

    @Override
    public GalleryButtonUI getUI() {
        return (GalleryButtonUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return "Toolstrip.GalleryButtonUI";
    }

    @Override
    public TSButton setOrientation(ButtonOrientation buttonOrientation) {
        return this;
    }

    public void setLabelLineCount(int n) {
        this.fLabelLineCount = n;
    }

    public int getLabelLineCount() {
        return this.fLabelLineCount;
    }

    public void setFavoriteButton(JButton jButton, boolean bl) {
        if (this.fFavoriteButton != null) {
            this.remove(this.fFavoriteButton);
            if (this.fMouseListener != null) {
                this.fFavoriteButton.removeMouseListener(this.fMouseListener);
            }
        }
        this.fFavoriteButton = jButton;
        this.fFavoriteButton.putClientProperty("tool component", true);
        this.fShowFavoriteUponRollover = bl;
        if (this.fFavoriteButton != null) {
            if (bl) {
                this.fFavoriteButton.setVisible(false);
            }
            this.add(this.fFavoriteButton);
            if (this.fMouseListener == null) {
                this.fMouseListener = new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        if (GalleryButton.this.fFavoriteButton != null && GalleryButton.this.fShowFavoriteUponRollover && !GalleryButton.isShowingContextMenu()) {
                            GalleryButton.this.fFavoriteButton.setVisible(true);
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        if (GalleryButton.this.fFavoriteButton != null && GalleryButton.this.fShowFavoriteUponRollover) {
                            Point point = mouseEvent.getPoint();
                            if (mouseEvent.getComponent() != GalleryButton.this) {
                                point = SwingUtilities.convertPoint(mouseEvent.getComponent(), point, (Component)((Object)GalleryButton.this));
                            }
                            if (!GalleryButton.this.contains(point)) {
                                GalleryButton.this.fFavoriteButton.setVisible(false);
                            }
                        }
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        if (GalleryButton.this.fFavoriteButton != null && GalleryButton.this.fShowFavoriteUponRollover && mouseEvent.getComponent() == GalleryButton.this) {
                            GalleryButton.this.fFavoriteButton.setVisible(false);
                        }
                    }
                };
                this.addMouseListener(this.fMouseListener);
            }
            this.fFavoriteButton.addMouseListener(this.fMouseListener);
        }
        this.revalidate();
        this.repaint();
    }

    private static boolean isShowingContextMenu() {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        return menuElementArray != null && menuElementArray.length > 0;
    }

    public void doLayout() {
        if (this.fFavoriteButton != null) {
            Dimension dimension = this.fFavoriteButton.getPreferredSize();
            this.fFavoriteButton.setBounds(this.getWidth() - dimension.width - 2, 2, dimension.width, dimension.height);
        }
    }

    public String getToolTipText() {
        return this.getToolTipContentProvider() == null ? super.getToolTipText() : null;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getToolTipContentProvider() == null ? super.getToolTipText(mouseEvent) : null;
    }

    private ToolTipContentProvider getToolTipContentProvider() {
        Action action = this.getAction();
        return action == null ? null : (ToolTipContentProvider)action.getValue("tool-tip-content-provider");
    }
}

