/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery.model;

import com.mathworks.toolstrip.components.gallery.model.Category;
import com.mathworks.toolstrip.components.gallery.model.GalleryModel;
import com.mathworks.toolstrip.components.gallery.model.Item;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultGalleryModel
implements GalleryModel {
    private final List<Category> fCategories;
    private final Map<Category, List<Item>> fItems;
    private final Map<String, Category> fCategoriesByName;
    private final Map<String, Item> fItemsByName;
    protected final PropertyChangeSupport fPropertySupport = new PropertyChangeSupport(this){

        @Override
        public void firePropertyChange(String string, Object object, Object object2) {
            if (!DefaultGalleryModel.this.fSuppressPropertyChanges) {
                super.firePropertyChange(string, object, object2);
            }
        }
    };
    private boolean fSuppressPropertyChanges;
    private Object fFactoryData;

    public DefaultGalleryModel() {
        this.fCategories = new ArrayList<Category>();
        this.fCategoriesByName = new HashMap<String, Category>();
        this.fItemsByName = new HashMap<String, Item>();
        this.fItems = new HashMap<Category, List<Item>>();
        this.addCategory(Category.FAVORITES);
    }

    @Override
    public List<Category> getCategories() {
        return Collections.unmodifiableList(this.fCategories);
    }

    @Override
    public List<Item> getItems(Category category) {
        return Collections.unmodifiableList(this.fItems.get(category));
    }

    @Override
    public boolean isFavorite(Item item) {
        return this.getItems(Category.FAVORITES).contains(item);
    }

    @Override
    public Category getCategory(String string) {
        return this.fCategoriesByName.get(string);
    }

    @Override
    public Item getItem(String string) {
        return this.fItemsByName.get(string);
    }

    @Override
    public void addCategory(Category category) {
        this.insertCategory(category, this.fCategories.size());
    }

    @Override
    public void insertCategory(Category category, int n) {
        if (!this.fCategories.contains(category)) {
            this.fCategories.add(n, category);
            this.fCategoriesByName.put(category.getName(), category);
            this.fItems.put(category, new ArrayList());
            this.fPropertySupport.firePropertyChange("categories", null, category);
        }
    }

    @Override
    public void removeCategory(Category category) {
        this.fCategories.remove(category);
        this.fCategoriesByName.remove(category.getName());
        List<Item> list = this.fItems.remove(category);
        for (Item item : list) {
            this.fItemsByName.remove(item.getName());
        }
        this.fPropertySupport.firePropertyChange("categories", category, null);
    }

    @Override
    public void moveCategory(Category category, int n) {
        if (n == 0 && !category.equals(Category.FAVORITES) || n < 0 || n > this.fCategories.size()) {
            throw new IllegalArgumentException("Invalid index: " + n + " for category " + category.getName());
        }
        this.fCategories.remove(category);
        this.fCategories.add(n, category);
        this.fPropertySupport.firePropertyChange("categories", null, category);
    }

    @Override
    public void addItem(Category category, Item item) {
        this.addCategory(category);
        this.fItems.get(category).add(item);
        this.fItemsByName.put(item.getName(), item);
        this.fPropertySupport.firePropertyChange("items-" + category.getName(), null, item);
    }

    @Override
    public void removeItem(Category category, Item item) {
        if (category.equals(Category.FAVORITES)) {
            this.removeFromFavorites(item);
            return;
        }
        this.getOrThrowException(category).remove(item);
        this.fItemsByName.remove(item.getName());
        this.fPropertySupport.firePropertyChange("items-" + category.getName(), item, null);
    }

    @Override
    public void moveItem(Category category, Item item, int n) {
        List<Item> list = this.getOrThrowException(category);
        int n2 = list.indexOf(item);
        if (n2 < 0) {
            throw new IllegalArgumentException("Item " + item + " does not exist in category " + category);
        }
        if (n < 0 || n >= list.size()) {
            throw new IllegalArgumentException("Invalid index " + n + " in category with " + list.size() + " items");
        }
        list.remove(n2);
        list.add(n, item);
        this.fPropertySupport.firePropertyChange("items-" + category.getName(), null, item);
    }

    @Override
    public void moveItem(Category category, Category category2, Item item) {
        this.removeItem(category, item);
        this.addItem(category2, item);
    }

    @Override
    public void addToFavorites(Item item) {
        if (!this.contains(item.getName())) {
            throw new IllegalArgumentException("Item " + item + " does not exist in this gallery.");
        }
        List<Item> list = this.fItems.get(Category.FAVORITES);
        if (!list.contains(item)) {
            list.add(item);
        }
        this.fPropertySupport.firePropertyChange(FAVORITES_PROPERTY, null, item);
    }

    @Override
    public void removeFromFavorites(Item item) {
        if (!this.contains(item.getName())) {
            throw new IllegalArgumentException("Item " + item + " does not exist in the gallery.");
        }
        List<Item> list = this.fItems.get(Category.FAVORITES);
        if (!list.contains(item)) {
            throw new IllegalArgumentException("Item " + item + " does not exist in favorites.");
        }
        list.remove(item);
        this.fPropertySupport.firePropertyChange(FAVORITES_PROPERTY, item, null);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void startUpdateSequence() {
        this.fSuppressPropertyChanges = true;
    }

    public void endUpdateSequence() {
        this.fSuppressPropertyChanges = false;
        this.fPropertySupport.firePropertyChange("arbitrary", null, this);
    }

    public void clear() {
        this.fCategories.clear();
        this.fCategoriesByName.clear();
        this.fItemsByName.clear();
        this.fItems.clear();
        this.addCategory(Category.FAVORITES);
        this.fPropertySupport.firePropertyChange("arbitrary", null, this);
    }

    public void setFactoryData(Object object) {
        this.fFactoryData = object;
    }

    public Object getFactoryData() {
        return this.fFactoryData;
    }

    private List<Item> getOrThrowException(Category category) {
        List<Item> list = this.fItems.get(category);
        if (list == null) {
            throw new IllegalArgumentException("Invalid category: " + category);
        }
        return list;
    }

    private boolean contains(String string) {
        return this.getItem(string) != null;
    }
}

