/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery.model;

import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import org.apache.commons.lang.Validate;

public final class Item {
    private final String fName;
    private final Action fAction;
    private final List<String> fKeyWords;
    public static final String EXTENDED_LABEL = "extended-label";
    public static final String AUXILIARY_ACTION = "auxiliary-action";

    public Item(String string, Action action, List<String> list) {
        Validate.notNull((Object)string, (String)"The ID cannot be null");
        Validate.notNull((Object)action.getValue("Name"), (String)"The name cannot be null");
        Validate.notNull((Object)action.getValue("SmallIcon"), (String)"The icon cannot be null");
        this.fName = string;
        this.fAction = action;
        this.fKeyWords = list;
    }

    public boolean isEnabled() {
        return this.fAction.isEnabled();
    }

    public void setEnabled(boolean bl) {
        this.fAction.setEnabled(bl);
    }

    public boolean isSelected() {
        return (Boolean)this.fAction.getValue("SwingSelectedKey");
    }

    public List<String> getKeyWords() {
        return this.fKeyWords;
    }

    public String getToolTip() {
        return null;
    }

    public String getName() {
        return this.fName;
    }

    public String getLabel() {
        return (String)this.fAction.getValue("Name");
    }

    public String getExtendedLabel() {
        return (String)this.fAction.getValue(EXTENDED_LABEL);
    }

    public String getDescription() {
        return (String)this.fAction.getValue("ShortDescription");
    }

    public Icon getIcon() {
        return (Icon)this.fAction.getValue("SmallIcon");
    }

    public int hashCode() {
        return this.fName.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof Item && this.getName().equals(((Item)object).getName());
    }

    public String toString() {
        return (String)this.fAction.getValue("Name");
    }

    public Action getAction() {
        return this.fAction;
    }

    public Action getAuxiliaryAction() {
        return (Action)this.fAction.getValue(AUXILIARY_ACTION);
    }
}

