/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery.popupview;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolstrip.components.gallery.GalleryIcon;
import com.mathworks.toolstrip.components.gallery.GalleryResources;
import com.mathworks.toolstrip.components.gallery.model.GalleryModel;
import com.mathworks.toolstrip.components.gallery.model.Item;
import com.mathworks.toolstrip.components.gallery.popupview.DisappearingButton;
import com.mathworks.toolstrip.components.gallery.popupview.GalleryPopupView;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Action;

class FavoriteButton
extends DisappearingButton {
    FavoriteButton(Item item, GalleryModel galleryModel, Runnable runnable) {
        super((Action)((Object)new FavoriteAction(item, galleryModel, runnable)));
        this.setName("Favorite_" + item.getName());
        this.setMargin(new Insets(1, 1, 1, 1));
    }

    private static class FavoriteAction
    extends MJAbstractAction {
        private Item iItem;
        private GalleryModel iModel;
        private Runnable iFavoritesAnimation;

        FavoriteAction(Item item, GalleryModel galleryModel, Runnable runnable) {
            this.iItem = item;
            this.iModel = galleryModel;
            this.iFavoritesAnimation = runnable;
            this.setComponentName("Favorite_" + item.getName());
            this.update();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.iFavoritesAnimation instanceof GalleryPopupView.FavoriteAnimation) {
                if (((GalleryPopupView.FavoriteAnimation)((Object)this.iFavoritesAnimation)).isRunning()) {
                    return;
                }
                if (this.iModel.isFavorite(this.iItem)) {
                    ((GalleryPopupView.FavoriteAnimation)((Object)this.iFavoritesAnimation)).setItem(this.iItem);
                    ((GalleryPopupView.FavoriteAnimation)((Object)this.iFavoritesAnimation)).setMoveTo(false);
                    this.iFavoritesAnimation.run();
                } else {
                    ((GalleryPopupView.FavoriteAnimation)((Object)this.iFavoritesAnimation)).setItem(this.iItem);
                    ((GalleryPopupView.FavoriteAnimation)((Object)this.iFavoritesAnimation)).setMoveTo(true);
                    this.iFavoritesAnimation.run();
                }
                this.update();
            }
        }

        private void update() {
            if (this.iModel.isFavorite(this.iItem)) {
                this.putValue("SmallIcon", GalleryIcon.ACTIVE_FAVORITE_ICON.getIcon());
                this.setTip(GalleryResources.getString("favorite.remove.tooltip"));
            } else {
                this.putValue("SmallIcon", GalleryIcon.INACTIVE_FAVORITE_ICON.getIcon());
                this.setTip(GalleryResources.getString("favorite.add.tooltip"));
            }
        }
    }
}

