/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.factory;

import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.toolstrip.factory.TSToolPath;
import com.mathworks.toolstrip.factory.XMLUtils;
import com.mathworks.util.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.DataFormatException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class QuickAccessConfiguration {
    private final List<Tool> fToolList = new ArrayList<Tool>();
    private List<ChangeListener> fListenerList;
    private QuickAccessConfiguration fParent;
    private static final String CONFIGURATION_TAG = "quick_access_configuration";
    private static final String TOOL_TAG = "tool";
    private static final String ANCESTOR_TAG = "ancestor";
    private static final String CONTEXT_ID_ATTRIBUTE = "context_id";
    private static final String TAB_ID_ATTRIBUTE = "tab_id";
    private static final String SECTION_ID_ATTRIBUTE = "section_id";
    private static final String COMMON_ATTRIBUTE = "common";
    private static final String TOOL_ID_ATTRIBUTE = "tool_id";
    private static final String TOOL_SET_ID_ATTRIBUTE = "toolset_id";
    private static final String DISPLAY_CONDITION_ATTRIBUTE = "display_condition";
    private static final String LABEL_VISIBLE_ATTRIBUTE = "label_visible";
    private static final String ALWAYS_VALUE = "always";
    private static final String WHEN_TAB_PRESENT_VALUE = "when_tab_present";
    private static final String WHEN_TOOLSTRIP_MINIMIZED_VALUE = "when_toolstrip_minimized";

    public QuickAccessConfiguration() {
    }

    public QuickAccessConfiguration(QuickAccessConfiguration quickAccessConfiguration) {
        for (Tool tool : quickAccessConfiguration.fToolList) {
            this.addTool(tool.iPath, tool.iCondition, tool.isLabelVisible());
        }
    }

    public QuickAccessConfiguration(QuickAccessConfiguration quickAccessConfiguration, Predicate<TSToolPath> predicate) {
        for (Tool tool : quickAccessConfiguration.fToolList) {
            if (!predicate.accept((Object)tool.getPath())) continue;
            this.addTool(tool.iPath, tool.iCondition, tool.iIsLabelVisible);
        }
        this.fParent = quickAccessConfiguration;
    }

    public List<Tool> getTools() {
        return Collections.unmodifiableList(this.fToolList);
    }

    public void addTool(TSToolPath tSToolPath) {
        this.addTool(tSToolPath, DisplayCondition.ALWAYS);
    }

    public void addTool(TSToolPath tSToolPath, DisplayCondition displayCondition) {
        this.addTool(tSToolPath, displayCondition, false);
    }

    public void addTool(TSToolPath tSToolPath, DisplayCondition displayCondition, boolean bl) {
        Tool tool = new Tool(tSToolPath, displayCondition);
        tool.setLabelVisible(bl);
        this.fToolList.add(tool);
        this.notifyListeners(ChangeType.ADD, tool, -1, this.fToolList.size() - 1);
    }

    public void insertTool(int n, TSToolPath tSToolPath) {
        this.insertTool(n, tSToolPath, DisplayCondition.ALWAYS);
    }

    public void insertTool(int n, TSToolPath tSToolPath, DisplayCondition displayCondition) {
        this.insertTool(n, tSToolPath, displayCondition, false);
    }

    public void insertTool(int n, TSToolPath tSToolPath, DisplayCondition displayCondition, boolean bl) {
        Tool tool = new Tool(tSToolPath, displayCondition);
        tool.setLabelVisible(bl);
        this.fToolList.add(n, tool);
        this.notifyListeners(ChangeType.ADD, tool, -1, n);
    }

    public void removeTool(TSToolPath tSToolPath) {
        int n = this.indexOfTool(tSToolPath);
        if (n != -1) {
            Tool tool = this.fToolList.remove(n);
            this.notifyListeners(ChangeType.REMOVE, tool, n, -1);
        }
        if (this.fParent != null) {
            this.fParent.removeTool(tSToolPath);
        }
    }

    public boolean isLabelVisible(TSToolPath tSToolPath) {
        int n = this.indexOfTool(tSToolPath);
        return n >= 0 && this.fToolList.get(n).isLabelVisible();
    }

    public void setLabelVisible(TSToolPath tSToolPath, boolean bl) {
        Tool tool;
        int n = this.indexOfTool(tSToolPath);
        if (n >= 0 && (tool = this.fToolList.get(n)).iIsLabelVisible != bl) {
            tool.setLabelVisible(bl);
            this.notifyListeners(ChangeType.LABEL_VISIBILITY, tool, n, n);
        }
    }

    public boolean containsTool(TSToolPath tSToolPath) {
        return this.indexOfTool(tSToolPath) >= 0;
    }

    public Tool getTool(TSToolPath tSToolPath) {
        int n = this.indexOfTool(tSToolPath);
        return n >= 0 ? this.fToolList.get(n) : null;
    }

    private int indexOfTool(TSToolPath tSToolPath) {
        return this.fToolList.indexOf(new Tool(tSToolPath, null));
    }

    public void moveTool(TSToolPath tSToolPath, Movement movement) {
        int n = this.indexOfTool(tSToolPath);
        if (n == -1) {
            return;
        }
        int n2 = n;
        switch (movement) {
            case TOWARD_BEGINNING: {
                if (n2 <= 0) break;
                --n2;
                break;
            }
            case TOWARD_END: {
                if (n2 >= this.fToolList.size() - 1) break;
                ++n2;
                break;
            }
            case TO_BEGINNING: {
                n2 = 0;
                break;
            }
            case TO_END: {
                n2 = this.fToolList.size() - 1;
            }
        }
        this.moveTool(n, n2);
    }

    public void moveTool(int n, int n2) {
        if (n2 == n) {
            return;
        }
        Tool tool = this.fToolList.remove(n);
        this.fToolList.add(n2, tool);
        this.notifyListeners(ChangeType.MOVE, tool, n, n2);
    }

    public void updateFrom(QuickAccessConfiguration quickAccessConfiguration) {
        this.fToolList.clear();
        for (Tool tool : quickAccessConfiguration.fToolList) {
            this.fToolList.add(new Tool(tool));
        }
        this.notifyListeners(ChangeType.OTHER, null, -1, -1);
    }

    public void addListener(ChangeListener changeListener) {
        if (this.fListenerList == null) {
            this.fListenerList = new ArrayList<ChangeListener>();
        }
        this.fListenerList.add(changeListener);
    }

    public void removeListener(ChangeListener changeListener) {
        if (this.fListenerList != null) {
            this.fListenerList.remove(changeListener);
        }
    }

    private void notifyListeners(ChangeType changeType, Tool tool, int n, int n2) {
        if (this.fListenerList == null) {
            return;
        }
        ChangeEvent changeEvent = new ChangeEvent(this, changeType, tool, n, n2);
        for (ChangeListener changeListener : this.fListenerList) {
            changeListener.configurationChanged(changeEvent);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof QuickAccessConfiguration)) {
            return false;
        }
        QuickAccessConfiguration quickAccessConfiguration = (QuickAccessConfiguration)object;
        if (this.fToolList.size() != quickAccessConfiguration.fToolList.size()) {
            return false;
        }
        for (int i = 0; i < this.fToolList.size(); ++i) {
            Tool tool = this.fToolList.get(i);
            Tool tool2 = quickAccessConfiguration.fToolList.get(i);
            if (tool.iCondition == tool2.iCondition && tool.iIsLabelVisible == tool2.iIsLabelVisible && tool.iPath.equals(tool2.iPath)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (Tool tool : this.fToolList) {
            n = 17 * n + tool.iPath.hashCode();
            n = 17 * n + tool.iCondition.hashCode();
        }
        return n;
    }

    public QuickAccessConfiguration(SimpleElement simpleElement) throws DataFormatException {
        assert (CONFIGURATION_TAG.equals(simpleElement.getTagName()));
        SimpleNodeList simpleNodeList = simpleElement.getChildrenByTagName(TOOL_TAG);
        int n = simpleNodeList.getLength();
        for (int i = 0; i < n; ++i) {
            SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.item(i);
            TSToolPath tSToolPath = new TSToolPath(simpleElement2.getAttribute(CONTEXT_ID_ATTRIBUTE), QuickAccessConfiguration.readIdAttribute(simpleElement2, TOOL_TAG, TAB_ID_ATTRIBUTE), QuickAccessConfiguration.readIdAttribute(simpleElement2, TOOL_TAG, SECTION_ID_ATTRIBUTE));
            SimpleNodeList simpleNodeList2 = simpleElement2.getChildrenByTagName(ANCESTOR_TAG);
            int n2 = simpleNodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                SimpleElement simpleElement3 = (SimpleElement)simpleNodeList2.item(j);
                tSToolPath = new TSToolPath(tSToolPath, QuickAccessConfiguration.readIdAttribute(simpleElement3, ANCESTOR_TAG, TOOL_ID_ATTRIBUTE), QuickAccessConfiguration.readIdAttribute(simpleElement3, ANCESTOR_TAG, TOOL_SET_ID_ATTRIBUTE));
            }
            tSToolPath = new TSToolPath(tSToolPath, QuickAccessConfiguration.readIdAttribute(simpleElement2, TOOL_TAG, TOOL_ID_ATTRIBUTE), QuickAccessConfiguration.readIdAttribute(simpleElement2, TOOL_TAG, TOOL_SET_ID_ATTRIBUTE), XMLUtils.readBooleanAttribute(simpleElement2, COMMON_ATTRIBUTE, false));
            this.addTool(tSToolPath, QuickAccessConfiguration.readConditionAttribute(simpleElement2), XMLUtils.readBooleanAttribute(simpleElement2, LABEL_VISIBLE_ATTRIBUTE, false));
        }
    }

    private static String readIdAttribute(SimpleElement simpleElement, String string, String string2) throws DataFormatException {
        if (!simpleElement.hasAttribute(string2)) {
            throw new DataFormatException("Missing required attibute " + string + ":" + string2);
        }
        String string3 = simpleElement.getAttribute(string2);
        return string3;
    }

    private static DisplayCondition readConditionAttribute(SimpleElement simpleElement) throws DataFormatException {
        DisplayCondition displayCondition;
        String string = simpleElement.getAttribute(DISPLAY_CONDITION_ATTRIBUTE);
        if (ALWAYS_VALUE.equals(string)) {
            displayCondition = DisplayCondition.ALWAYS;
        } else if (WHEN_TAB_PRESENT_VALUE.equals(string)) {
            displayCondition = DisplayCondition.WHEN_TAB_PRESENT;
        } else if (WHEN_TOOLSTRIP_MINIMIZED_VALUE.equals(string)) {
            displayCondition = DisplayCondition.WHEN_TOOLSTRIP_MINIMIZED;
        } else {
            throw new DataFormatException("Invalid attibute tool:display_condition=" + string);
        }
        return displayCondition;
    }

    public Element toXML(Document document) {
        Element element = document.createElement(CONFIGURATION_TAG);
        for (Tool tool : this.fToolList) {
            Element element2 = document.createElement(TOOL_TAG);
            TSToolPath tSToolPath = tool.getPath();
            if (tSToolPath.getContextName() != null) {
                element2.setAttribute(CONTEXT_ID_ATTRIBUTE, tSToolPath.getContextName());
            }
            element2.setAttribute(TAB_ID_ATTRIBUTE, tSToolPath.getTabName());
            element2.setAttribute(SECTION_ID_ATTRIBUTE, tSToolPath.getSectionName());
            if (tSToolPath.isCommon()) {
                element2.setAttribute(COMMON_ATTRIBUTE, "true");
            }
            element2.setAttribute(TOOL_ID_ATTRIBUTE, tSToolPath.getToolName());
            element2.setAttribute(TOOL_SET_ID_ATTRIBUTE, tSToolPath.getToolSetName());
            QuickAccessConfiguration.writeConditionAttribute(element2, tool.getDisplayCondition());
            if (tool.isLabelVisible()) {
                element2.setAttribute(LABEL_VISIBLE_ATTRIBUTE, "true");
            }
            int n = tSToolPath.getAncestorCount();
            for (int i = 0; i < n; ++i) {
                Element element3 = document.createElement(ANCESTOR_TAG);
                element3.setAttribute(TOOL_ID_ATTRIBUTE, tSToolPath.getAncestorTool(i));
                element3.setAttribute(TOOL_SET_ID_ATTRIBUTE, tSToolPath.getAncestorToolSet(i));
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
        return element;
    }

    private static void writeConditionAttribute(Element element, DisplayCondition displayCondition) {
        String string = null;
        switch (displayCondition) {
            case ALWAYS: {
                string = ALWAYS_VALUE;
                break;
            }
            case WHEN_TAB_PRESENT: {
                string = WHEN_TAB_PRESENT_VALUE;
                break;
            }
            case WHEN_TOOLSTRIP_MINIMIZED: {
                string = WHEN_TOOLSTRIP_MINIMIZED_VALUE;
            }
        }
        element.setAttribute(DISPLAY_CONDITION_ATTRIBUTE, string);
    }

    public static interface ChangeListener {
        public void configurationChanged(ChangeEvent var1);
    }

    public static class ChangeEvent {
        private final QuickAccessConfiguration fSource;
        private final ChangeType fType;
        private final Tool fTool;
        private final int fFromIndex;
        private final int fToIndex;

        private ChangeEvent(QuickAccessConfiguration quickAccessConfiguration, ChangeType changeType, Tool tool, int n, int n2) {
            this.fSource = quickAccessConfiguration;
            this.fType = changeType;
            this.fTool = tool;
            this.fFromIndex = n;
            this.fToIndex = n2;
        }

        public QuickAccessConfiguration getSource() {
            return this.fSource;
        }

        public ChangeType getType() {
            return this.fType;
        }

        public Tool getTool() {
            return this.fTool;
        }

        public int getFromIndex() {
            return this.fFromIndex;
        }

        public int getToIndex() {
            return this.fToIndex;
        }
    }

    public static class Tool {
        private final TSToolPath iPath;
        private final DisplayCondition iCondition;
        private boolean iIsLabelVisible;

        public TSToolPath getPath() {
            return this.iPath;
        }

        public DisplayCondition getDisplayCondition() {
            return this.iCondition;
        }

        public boolean isLabelVisible() {
            return this.iIsLabelVisible;
        }

        private Tool(TSToolPath tSToolPath, DisplayCondition displayCondition) {
            this.iPath = tSToolPath;
            this.iCondition = displayCondition;
        }

        private Tool(Tool tool) {
            this.iPath = tool.iPath;
            this.iCondition = tool.iCondition;
            this.iIsLabelVisible = tool.iIsLabelVisible;
        }

        private void setLabelVisible(boolean bl) {
            this.iIsLabelVisible = bl;
        }

        public boolean equals(Object object) {
            return object instanceof Tool && this.iPath.equals(((Tool)object).iPath);
        }

        public int hashCode() {
            return this.iPath.hashCode();
        }
    }

    public static enum ChangeType {
        ADD,
        REMOVE,
        MOVE,
        LABEL_VISIBILITY,
        OTHER;

    }

    public static enum Movement {
        TO_BEGINNING,
        TOWARD_BEGINNING,
        TOWARD_END,
        TO_END;

    }

    public static enum DisplayCondition {
        ALWAYS,
        WHEN_TAB_PRESENT,
        WHEN_TOOLSTRIP_MINIMIZED;

    }
}

