/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.factory;

import com.mathworks.fl.i18n.XMLMessageSystem;
import com.mathworks.mwswing.SimpleElement;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.zip.DataFormatException;

public class XMLUtils {
    public static final String RESOURCE_BUNDLE_ATTRIBUTE = "resbundle";
    public static final String MESSAGE_CATALOG_ATTRIBUTE = "message_catalog";
    public static final String ID_ATTRIBUTE = "id";
    public static final String TRUE_VALUE = "true";
    public static final String FALSE_VALUE = "false";

    private XMLUtils() {
    }

    public static String readIdAttribute(SimpleElement simpleElement, String string) throws DataFormatException {
        if (!simpleElement.hasAttribute(ID_ATTRIBUTE)) {
            throw new DataFormatException("Missing required attibute " + string + ":" + ID_ATTRIBUTE);
        }
        String string2 = simpleElement.getAttribute(ID_ATTRIBUTE);
        return string2;
    }

    public static boolean readBooleanAttribute(SimpleElement simpleElement, String string, boolean bl) throws DataFormatException {
        boolean bl2 = bl;
        if (simpleElement.hasAttribute(string)) {
            String string2 = simpleElement.getAttribute(string);
            if (TRUE_VALUE.equals(string2)) {
                bl2 = true;
            } else if (FALSE_VALUE.equals(string2)) {
                bl2 = false;
            } else {
                throw new DataFormatException("Invalid attibute " + simpleElement.getTagName() + ":" + string + "=" + string2);
            }
        }
        return bl2;
    }

    public static int readIntegerAttribute(SimpleElement simpleElement, String string, int n) throws DataFormatException {
        int n2 = n;
        if (simpleElement.hasAttribute(string)) {
            String string2 = simpleElement.getAttribute(string);
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid attibute " + simpleElement.getTagName() + ":" + string + "=" + string2);
            }
        }
        return n2;
    }

    public static float readFloatAttribute(SimpleElement simpleElement, String string, float f) throws DataFormatException {
        float f2 = f;
        if (simpleElement.hasAttribute(string)) {
            String string2 = simpleElement.getAttribute(string);
            try {
                f2 = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid attibute " + simpleElement.getTagName() + ":" + string + "=" + string2);
            }
        }
        return f2;
    }

    public static ResourceBundle readResourceBundleAttribute(SimpleElement simpleElement) {
        if (simpleElement.hasAttribute(RESOURCE_BUNDLE_ATTRIBUTE)) {
            return ResourceBundle.getBundle(simpleElement.getAttribute(RESOURCE_BUNDLE_ATTRIBUTE));
        }
        if (simpleElement.hasAttribute(MESSAGE_CATALOG_ATTRIBUTE)) {
            return XMLMessageSystem.getBundle((String)simpleElement.getAttribute(MESSAGE_CATALOG_ATTRIBUTE));
        }
        return null;
    }

    public static String getString(ResourceBundle resourceBundle, String ... stringArray) {
        return resourceBundle.getString(XMLUtils.buildResourceKey(XMLUtils.getResourceKeySeparator(resourceBundle), stringArray));
    }

    private static String buildResourceKey(char c, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static char getResourceKeySeparator(ResourceBundle resourceBundle) {
        return resourceBundle instanceof PropertyResourceBundle ? (char)'.' : '_';
    }
}

