/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.RegularButtonUI;
import com.mathworks.toolstrip.plaf.ToggleButtonUI;
import com.mathworks.toolstrip.plaf.ToolstripButtonUI;
import com.mathworks.toolstrip.plaf.ToolstripIcons;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class ToolstripCheckBoxUI
extends ToggleButtonUI {
    public static final int LEFT_GAP_H = 6;
    private static final ToolstripCheckBoxUI CHECKBOX_UI = new ToolstripCheckBoxUI();
    private Dimension fSize = new Dimension();
    private Rectangle fViewRect = new Rectangle();
    private Rectangle fIconRect = new Rectangle();
    private Rectangle fTextRect = new Rectangle();
    private Rectangle fPrefViewRect = new Rectangle();
    private Rectangle fPrefIconRect = new Rectangle();
    private Rectangle fPrefTextRect = new Rectangle();
    private Insets fPrefInsets = new Insets(0, 0, 0, 0);

    public static ToolstripCheckBoxUI createUI(JComponent jComponent) {
        return CHECKBOX_UI;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
    }

    protected Icon getCheckedIcon() {
        return ToolstripIcons.CHECKBOX_CHECKED.getIcon();
    }

    protected Icon getUnCheckedIcon() {
        return ToolstripIcons.CHECKBOX_UNCHECKED.getIcon();
    }

    @Override
    protected ToolstripButtonUI.ToolstripButtonListener newToolstripButtonListener(AbstractButton abstractButton) {
        return new RegularButtonUI.RegularToolstripButtonListener(abstractButton){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TSUtil.toolstripActionProcessed(this.fButton);
            }
        };
    }

    @Override
    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics, font);
        Insets insets = jComponent.getInsets();
        this.fSize = abstractButton.getSize(this.fSize);
        this.fViewRect.x = insets.left + 6;
        this.fViewRect.y = insets.top;
        this.fViewRect.width = this.fSize.width - (insets.right + this.fViewRect.x);
        this.fViewRect.height = this.fSize.height - (insets.bottom + this.fViewRect.y);
        this.fIconRect.height = 0;
        this.fIconRect.width = 0;
        this.fIconRect.y = 0;
        this.fIconRect.x = 0;
        this.fTextRect.height = 0;
        this.fTextRect.width = 0;
        this.fTextRect.y = 0;
        this.fTextRect.x = 0;
        Icon icon = abstractButton.isSelected() ? this.getCheckedIcon() : this.getUnCheckedIcon();
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), this.fViewRect, this.fIconRect, this.fTextRect, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        if (jComponent.isOpaque()) {
            graphics.setColor(abstractButton.getBackground());
            graphics.fillRect(0, 0, this.fSize.width, this.fSize.height);
        }
        if (!abstractButton.isEnabled()) {
            icon = LAFUtil.getDisabledIcon(abstractButton, icon);
        }
        icon.paintIcon(jComponent, graphics, this.fIconRect.x, this.fIconRect.y);
        if (string != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, this.fTextRect);
            } else {
                this.paintText(graphics, abstractButton, this.fTextRect, string);
            }
            if (abstractButton.hasFocus() && abstractButton.isFocusPainted() && this.fTextRect.width > 0 && this.fTextRect.height > 0) {
                this.paintFocus(graphics, this.fTextRect, this.fSize);
            }
        }
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle, Dimension dimension) {
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (jComponent.getComponentCount() > 0) {
            return null;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        String string = abstractButton.getText();
        Icon icon = this.getCheckedIcon();
        Font font = abstractButton.getFont();
        FontMetrics fontMetrics = abstractButton.getFontMetrics(font);
        this.fPrefViewRect.y = 0;
        this.fPrefViewRect.x = 0;
        this.fPrefViewRect.width = Short.MAX_VALUE;
        this.fPrefViewRect.height = Short.MAX_VALUE;
        this.fPrefIconRect.height = 0;
        this.fPrefIconRect.width = 0;
        this.fPrefIconRect.y = 0;
        this.fPrefIconRect.x = 0;
        this.fPrefTextRect.height = 0;
        this.fPrefTextRect.width = 0;
        this.fPrefTextRect.y = 0;
        this.fPrefTextRect.x = 0;
        SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, string, icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), this.fPrefViewRect, this.fPrefIconRect, this.fPrefTextRect, string == null ? 0 : abstractButton.getIconTextGap());
        int n = Math.min(this.fPrefIconRect.x, this.fPrefTextRect.x);
        int n2 = Math.max(this.fPrefIconRect.x + this.fPrefIconRect.width, this.fPrefTextRect.x + this.fPrefTextRect.width);
        int n3 = Math.min(this.fPrefIconRect.y, this.fPrefTextRect.y);
        int n4 = Math.max(this.fPrefIconRect.y + this.fPrefIconRect.height, this.fPrefTextRect.y + this.fPrefTextRect.height);
        int n5 = n2 - n + 6;
        int n6 = n4 - n3;
        this.fPrefInsets = abstractButton.getInsets(this.fPrefInsets);
        return new Dimension(n5 += this.fPrefInsets.left + this.fPrefInsets.right, n6 += this.fPrefInsets.top + this.fPrefInsets.bottom);
    }
}

