/*
 * Decompiled with CFR 0.152.
 */
package ice.storm.print.jdk12;

import ice.debug.Debug;
import ice.storm.StormPrinter;
import ice.storm.print.jdk12.PageFormatConverter;
import ice.storm.print.jdk12.PrintablePage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;

public class PageableDocument {
    StormPrinter stormPrinter;
    PageFormat pageFormat;
    private String OEAB = "StormPrinter";
    private boolean append = false;
    private boolean ex = false;

    public PageableDocument(StormPrinter stormPrinter) {
        this.stormPrinter = stormPrinter;
        this.pageFormat = PageFormatConverter.getPageFormat(stormPrinter.getStormPageFormat());
    }

    public void setStormPrinter(StormPrinter stormPrinter) {
        this.stormPrinter = stormPrinter;
        this.pageFormat = PageFormatConverter.getPageFormat(stormPrinter.getStormPageFormat());
    }

    public void setPrintDialogVisible(boolean bl) {
        this.append = bl;
    }

    public void setPageDialogVisible(boolean bl) {
        this.ex = bl;
    }

    public String getDocumentName() {
        return this.OEAB;
    }

    public void setDocumentName(String string) {
        this.OEAB = string;
    }

    public void print() {
        this.print(0, this.stormPrinter.getPageCount() - 1);
    }

    public void print(int n, int n2) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setJobName(this.OEAB);
        if (this.ex) {
            this.pageFormat = printerJob.pageDialog(new PageFormat());
            this.stormPrinter.setStormPageFormat(PageFormatConverter.getStormPageFormat(this.pageFormat));
            n2 = this.stormPrinter.getPageCount() - 1;
        }
        if (n2 > this.stormPrinter.getPageCount() - 1 || n < 0 || n2 < n) {
            throw new IndexOutOfBoundsException("start " + n + " end " + n2);
        }
        Book book = new Book();
        int n3 = n;
        while (n3 <= n2) {
            PrintablePage printablePage = new PrintablePage(this.stormPrinter, n3);
            book.append(printablePage, this.pageFormat);
            ++n3;
        }
        printerJob.setPageable(book);
        try {
            if (this.append) {
                if (printerJob.printDialog()) {
                    printerJob.print();
                }
            } else {
                printerJob.print();
            }
        }
        catch (Exception exception) {
            Debug.ex((Throwable)exception);
        }
    }
}

