/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.controllib.guide;

import com.mathworks.jmi.Callback;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.toolbox.shared.controllib.guide.AbstractHMITableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class AbstractHMITableWrapper {
    protected MJTable fTable = null;
    protected AbstractHMITableModel fModel = null;
    private MJPanel fPanel = null;
    private final Callback fTableChangedCallback = new Callback();
    private final Callback fValueChangedCallback = new Callback();

    protected void init() {
        this.fPanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fPanel.add((Component)new MJScrollPane((Component)this.fTable), (Object)"Center");
        this.fModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getColumn() > -1) {
                    AbstractHMITableWrapper.this.fTableChangedCallback.postCallback(new Object[]{tableModelEvent});
                }
            }
        });
        this.fTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    AbstractHMITableWrapper.this.fValueChangedCallback.postCallback(new Object[]{listSelectionModel.getMinSelectionIndex()});
                }
            }
        });
    }

    public MJPanel getWrappedComponent() {
        return this.fPanel;
    }

    public int getRowCount() {
        return this.fModel.getRowCount();
    }

    public void setRowCount(int n) {
        this.fModel.setRowCount(n);
    }

    public Object getValueAt(int n, int n2) {
        return this.fModel.getValueAt(n, n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.fModel.setValueAt(object, n, n2);
    }

    public int getSelectedRow() {
        return this.fTable.getSelectedRow();
    }

    public void setSelectedRow(int n) {
        if (n == -1) {
            this.fTable.clearSelection();
        } else {
            this.fTable.getSelectionModel().setSelectionInterval(n, n);
            Rectangle rectangle = this.fTable.getCellRect(n, 0, true);
            this.fTable.scrollRectToVisible(rectangle);
        }
    }

    public void removeEditor() {
        this.fTable.removeEditor();
    }

    public void stopEditing() {
        if (this.fTable.isEditing()) {
            this.fTable.getCellEditor().stopCellEditing();
        }
    }

    public Callback getTableChangedCallback() {
        return this.fTableChangedCallback;
    }

    public Callback getValueChangedCallback() {
        return this.fValueChangedCallback;
    }

    public String getName() {
        return this.fTable.getName();
    }

    public void setName(String string) {
        this.fTable.setName(string);
    }

    public boolean isEnabled() {
        return this.fTable.isEnabled();
    }

    public void setEnabled(boolean bl) {
        this.fTable.setEnabled(bl);
    }
}

