/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DElement;
import ice.pilots.html4.Names;
import ice.util.alg.CharKit;
import java.awt.Color;

final class HtmlToCss {
    HtmlToCss() {
    }

    static void apply(DElement dElement, CSSAttribs cSSAttribs, CSSBox cSSBox, int n) {
        switch (dElement.tagId) {
            case 1: {
                char[] cArray;
                Color color;
                DAnchorElement dAnchorElement;
                String string;
                if (dElement.getAttribute(46) == null || (string = (dAnchorElement = (DAnchorElement)dElement).getVisited() ? dElement.doc.getVlinkColor() : dElement.doc.getLinkColor()) == null || (color = CSSUtil.parseColor(cArray = string.toCharArray(), 0, cArray.length)) == null) break;
                cSSAttribs.color = color;
                break;
            }
            case 5: {
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                HtmlToCss.apply_vspace_hspace(dElement, cSSAttribs, n);
                HtmlToCss.apply_block_align(dElement, cSSAttribs);
                break;
            }
            case 9: {
                break;
            }
            case 13: {
                Names names;
                int n2;
                HtmlToCss.apply_direction(dElement, cSSAttribs);
                HtmlToCss.apply_bgcolor(dElement, cSSAttribs);
                HtmlToCss.apply_text_color(dElement, cSSAttribs, 109);
                String string = dElement.getAttribute(11);
                if (string != null && cSSAttribs.background_image == null) {
                    cSSAttribs.background_image = string;
                }
                if ((n2 = HtmlToCss.parse_length(dElement, 58, n)) >= 0) {
                    cSSAttribs.padding_left = cSSAttribs.padding_right = n2;
                }
                if (n2 == 0) {
                    cSSAttribs.margin_right = 0;
                    cSSAttribs.margin_left = 0;
                }
                if ((n2 = HtmlToCss.parse_length(dElement, 57, n)) >= 0) {
                    cSSAttribs.padding_top = cSSAttribs.padding_bottom = n2;
                }
                if (n2 == 0) {
                    cSSAttribs.margin_bottom = 0;
                    cSSAttribs.margin_top = 0;
                }
                if ((n2 = HtmlToCss.parse_length(dElement, (names = dElement.doc.getDom().getStormData().names).getAttrId(3, "topmargin"), n)) >= 0) {
                    cSSAttribs.padding_top = n2;
                }
                if ((n2 = HtmlToCss.parse_length(dElement, names.getAttrId(3, "bottommargin"), n)) >= 0) {
                    cSSAttribs.padding_bottom = n2;
                }
                if ((n2 = HtmlToCss.parse_length(dElement, names.getAttrId(3, "leftmargin"), n)) >= 0) {
                    cSSAttribs.padding_left = n2;
                }
                if ((n2 = HtmlToCss.parse_length(dElement, names.getAttrId(3, "rightmargin"), n)) < 0) break;
                cSSAttribs.padding_right = n2;
                break;
            }
            case 14: {
                String string = dElement.getAttribute(23);
                if (string == null) break;
                if (string.equalsIgnoreCase("left")) {
                    cSSAttribs.do_floats = (byte)(cSSAttribs.do_floats | 4);
                    break;
                }
                if (string.equalsIgnoreCase("right")) {
                    cSSAttribs.do_floats = (byte)(cSSAttribs.do_floats | 8);
                    break;
                }
                if (!string.equalsIgnoreCase("both") && !string.equalsIgnoreCase("all")) break;
                cSSAttribs.do_floats = (byte)(cSSAttribs.do_floats | (4 | 8));
                break;
            }
            case 95: {
                cSSAttribs.misc = (short)(cSSAttribs.misc | 4);
                break;
            }
            case 16: {
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                break;
            }
            case 20: {
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                HtmlToCss.apply_v_align(dElement, cSSAttribs, 113);
                HtmlToCss.apply_bgcolor(dElement, cSSAttribs);
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                break;
            }
            case 21: {
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                HtmlToCss.apply_v_align(dElement, cSSAttribs, 113);
                HtmlToCss.apply_bgcolor(dElement, cSSAttribs);
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                break;
            }
            case 93: {
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                HtmlToCss.apply_bgcolor(dElement, cSSAttribs);
                break;
            }
            case 26: {
                HtmlToCss.apply_direction(dElement, cSSAttribs);
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                HtmlToCss.apply_bgcolor(dElement, cSSAttribs);
                break;
            }
            case 31: {
                HtmlToCss.apply_text_color(dElement, cSSAttribs, 27);
                String string = dElement.getAttribute(40);
                if (string != null && string.length() != 0) {
                    cSSAttribs.font_family = cSSAttribs.sdata.fontCache.getSupportedFontFamily(string);
                }
                if ((string = dElement.getAttribute(100)) == null) break;
                int n3 = 0;
                int n4 = string.length();
                if ((n3 = CharKit.trimStart((String)string, (int)n3, (int)n4)) == (n4 = CharKit.trimEnd((String)string, (int)n3, (int)n4))) break;
                char c = string.charAt(n3);
                if (c == '+' || c == '-') {
                    int n5 = CSSUtil.parseInt(string, n3 + 1, n4, Integer.MIN_VALUE);
                    if (n5 == Integer.MIN_VALUE) break;
                    if (c == '-') {
                        n5 = -n5;
                    }
                    cSSAttribs.font_size = cSSAttribs.sdata.fontCache.getFontSizeAbs(n5 += 3, n);
                    break;
                }
                int n6 = CSSUtil.parseInt(string, n3, n4, -1);
                if (n6 < 0) break;
                if (n6 == 0) {
                    n6 = 1;
                }
                cSSAttribs.font_size = cSSAttribs.sdata.fontCache.getFontSizeAbs(n6, n);
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                break;
            }
            case 42: {
                cSSAttribs.text_align = 2;
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                break;
            }
            case 46: {
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                HtmlToCss.apply_vspace_hspace(dElement, cSSAttribs, n);
                HtmlToCss.apply_block_align(dElement, cSSAttribs);
                HtmlToCss.apply_v_align(dElement, cSSAttribs, 6);
                HtmlToCss.apply_v_align(dElement, cSSAttribs, 113);
                break;
            }
            case 47: {
                HtmlToCss.apply_direction(dElement, cSSAttribs);
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                break;
            }
            case 45: 
            case 60: {
                String string = dElement.getAttribute("hidden");
                if (string != null && string.equalsIgnoreCase("true")) {
                    cSSAttribs.misc = (short)(cSSAttribs.misc & ~1);
                }
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                HtmlToCss.apply_vspace_hspace(dElement, cSSAttribs, n);
                HtmlToCss.apply_block_align(dElement, cSSAttribs);
                break;
            }
            case 52: {
                break;
            }
            case 53: {
                char c;
                String string = dElement.getAttribute(111);
                if (string == null) break;
                int n7 = 99;
                int n8 = string.length();
                if (n8 == 1) {
                    char c2 = string.charAt(0);
                    if (c2 == 'A') {
                        n7 = 107;
                    }
                } else if (n8 == 4) {
                    char c3 = string.charAt(0);
                    if (c3 == 'D' || c3 == 'd') {
                        if (CharKit.equalsIgnoreAsciiCase((String)"disc", (String)string)) {
                            n7 = 97;
                        }
                    } else if ((c3 == 'N' || c3 == 'n') && CharKit.equalsIgnoreAsciiCase((String)"none", (String)string)) {
                        n7 = 8;
                    }
                } else if (n8 == 6 && ((c = string.charAt(0)) == 'C' || c == 'c') && CharKit.equalsIgnoreAsciiCase((String)"circle", (String)string)) {
                    n7 = 98;
                }
                cSSAttribs.listStyleType = (byte)n7;
                break;
            }
            case 61: {
                String string = dElement.getAttribute(111);
                if (string == null || string.length() <= 0) break;
                int n9 = string.charAt(0);
                n9 = n9 == 105 ? 102 : (n9 == 73 ? 103 : (n9 == 97 ? 105 : (n9 == 65 ? 107 : 100)));
                cSSAttribs.listStyleType = (byte)n9;
                break;
            }
            case 64: {
                HtmlToCss.apply_direction(dElement, cSSAttribs);
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                break;
            }
            case 79: {
                int n10;
                String string = dElement.getAttribute(11);
                if (string != null) {
                    cSSAttribs.background_image = string;
                }
                HtmlToCss.apply_direction(dElement, cSSAttribs);
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                HtmlToCss.apply_block_align(dElement, cSSAttribs);
                HtmlToCss.apply_bgcolor(dElement, cSSAttribs);
                if (dElement.getAttribute(15) != null) {
                    n10 = HtmlToCss.parse_length(dElement, 15, n);
                    if (n10 >= 0) {
                        cSSAttribs.border_spacing_x = n10;
                        cSSAttribs.border_spacing_y = n10;
                    }
                } else if (!dElement.getSynthetic()) {
                    cSSAttribs.border_spacing_x = 3;
                    cSSAttribs.border_spacing_y = 3;
                }
                n10 = 0;
                string = dElement.getAttribute(13);
                if (string != null && (n10 = CSSUtil.parseInt(string, -1)) < 0) {
                    n10 = 1;
                }
                cSSAttribs.border_top_style = 155;
                cSSAttribs.border_bottom_style = 155;
                cSSAttribs.border_left_style = 155;
                cSSAttribs.border_right_style = 155;
                cSSAttribs.border_top_width = n10;
                cSSAttribs.border_bottom_width = n10;
                cSSAttribs.border_left_width = n10;
                cSSAttribs.border_right_width = n10;
                break;
            }
            case 80: 
            case 83: 
            case 85: {
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                HtmlToCss.apply_v_align(dElement, cSSAttribs, 113);
                break;
            }
            case 81: 
            case 84: {
                String string = dElement.getAttribute(11);
                if (string != null) {
                    cSSAttribs.background_image = string;
                }
                if ((string = dElement.getAttribute(67)) != null) {
                    cSSAttribs.misc = (short)(cSSAttribs.misc | 8);
                }
                HtmlToCss.apply_direction(dElement, cSSAttribs);
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                HtmlToCss.apply_v_align(dElement, cSSAttribs, 113);
                HtmlToCss.apply_width_height(dElement, cSSAttribs, n);
                HtmlToCss.apply_bgcolor(dElement, cSSAttribs);
                DElement dElement2 = (DElement)dElement.getParentDNode().getParentDNode().getParentDNode();
                string = dElement2.getAttribute(13);
                int n11 = 0;
                if (string != null && (n11 = CSSUtil.parseInt(string, -1)) < 0) {
                    n11 = 1;
                }
                if (n11 > 0) {
                    cSSAttribs.border_top_style = 154;
                    cSSAttribs.border_bottom_style = 154;
                    cSSAttribs.border_left_style = 154;
                    cSSAttribs.border_right_style = 154;
                    cSSAttribs.border_top_width = 1;
                    cSSAttribs.border_bottom_width = 1;
                    cSSAttribs.border_left_width = 1;
                    cSSAttribs.border_right_width = 1;
                    CSSBox cSSBox2 = cSSBox.getParentBox().getParentBox();
                    Color color = cSSBox2.css.background_color;
                    if (color != null) {
                        cSSAttribs.border_top_color = color;
                        cSSAttribs.border_bottom_color = color;
                        cSSAttribs.border_left_color = color;
                        cSSAttribs.border_right_color = color;
                    }
                }
                if ((n11 = HtmlToCss.parse_length(dElement2, 14, n)) < 0) break;
                cSSAttribs.padding_top = n11;
                cSSAttribs.padding_bottom = n11;
                cSSAttribs.padding_left = n11;
                cSSAttribs.padding_right = n11;
                break;
            }
            case 87: {
                HtmlToCss.apply_text_align(dElement, cSSAttribs);
                HtmlToCss.apply_v_align(dElement, cSSAttribs, 113);
                HtmlToCss.apply_bgcolor(dElement, cSSAttribs);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 18: 
            case 19: 
            case 24: 
            case 29: 
            case 43: 
            case 50: 
            case 66: 
            case 67: 
            case 69: 
            case 73: 
            case 75: 
            case 77: 
            case 78: 
            case 91: {
                HtmlToCss.apply_direction(dElement, cSSAttribs);
            }
        }
    }

    private static void apply_direction(DElement dElement, CSSAttribs cSSAttribs) {
        String string = dElement.getAttribute(37);
        if (string != null) {
            if (string.equalsIgnoreCase("rtl")) {
                cSSAttribs.directionFlag = 1;
            } else if (string.equalsIgnoreCase("ltr")) {
                cSSAttribs.directionFlag = (byte)2;
            }
        }
    }

    private static void apply_text_align(DElement dElement, CSSAttribs cSSAttribs) {
        String string = dElement.getAttribute(6);
        if (string != null) {
            cSSAttribs.text_align = string.equalsIgnoreCase("right") ? 3 : (string.equalsIgnoreCase("center") || string.equalsIgnoreCase("middle") ? 2 : 1);
        }
    }

    private static void apply_v_align(DElement dElement, CSSAttribs cSSAttribs, int n) {
        String string = dElement.getAttribute(n);
        if (string != null) {
            if (string.equalsIgnoreCase("top")) {
                cSSAttribs.vertical_align_type = 16;
            } else if (string.equalsIgnoreCase("bottom")) {
                cSSAttribs.vertical_align_type = 17;
            } else if (string.equalsIgnoreCase("middle")) {
                cSSAttribs.vertical_align_type = 144;
            } else if (string.equalsIgnoreCase("baseline")) {
                cSSAttribs.vertical_align_type = 140;
            }
        }
    }

    private static void apply_block_align(DElement dElement, CSSAttribs cSSAttribs) {
        String string = dElement.getAttribute(6);
        if (string != null) {
            if (string.equalsIgnoreCase("right")) {
                cSSAttribs.do_floats = (byte)(cSSAttribs.do_floats | 2);
            } else if (string.equalsIgnoreCase("left")) {
                cSSAttribs.do_floats = (byte)(cSSAttribs.do_floats | 1);
            } else if (string.equalsIgnoreCase("center")) {
                cSSAttribs.misc = (short)(cSSAttribs.misc | 0x40);
            }
        }
    }

    private static void apply_width_height(DElement dElement, CSSAttribs cSSAttribs, int n) {
        int n2 = HtmlToCss.parse_length(dElement, 119, n);
        if (n2 >= 0) {
            cSSAttribs.width = n2;
            cSSAttribs.percentage_flag &= ~0x100000;
        } else if (n2 != Integer.MIN_VALUE) {
            cSSAttribs.width = -n2;
            cSSAttribs.percentage_flag |= 0x100000;
        }
        n2 = HtmlToCss.parse_length(dElement, 45, n);
        if (n2 >= 0) {
            cSSAttribs.height = n2;
            cSSAttribs.percentage_flag &= ~8;
        } else if (n2 != Integer.MIN_VALUE) {
            cSSAttribs.height = -n2;
            cSSAttribs.percentage_flag |= 8;
        }
    }

    private static void apply_vspace_hspace(DElement dElement, CSSAttribs cSSAttribs, int n) {
        int n2 = HtmlToCss.parse_length(dElement, 48, n);
        if (n2 > 0) {
            cSSAttribs.padding_left = cSSAttribs.padding_right = n2;
        }
        if ((n2 = HtmlToCss.parse_length(dElement, 118, n)) > 0) {
            cSSAttribs.padding_top = cSSAttribs.padding_bottom = n2;
        }
    }

    private static void apply_bgcolor(DElement dElement, CSSAttribs cSSAttribs) {
        char[] cArray;
        Color color;
        String string = dElement.getAttribute(12);
        if (string != null && (color = CSSUtil.parseColor(cArray = string.toCharArray(), 0, cArray.length)) != null) {
            cSSAttribs.background_color = color;
        }
    }

    private static void apply_text_color(DElement dElement, CSSAttribs cSSAttribs, int n) {
        char[] cArray;
        Color color;
        String string = dElement.getAttribute(n);
        if (string != null && (color = CSSUtil.parseColor(cArray = string.toCharArray(), 0, cArray.length)) != null) {
            cSSAttribs.color = color;
        }
    }

    private static int parse_length(DElement dElement, int n, int n2) {
        int n3;
        String string = dElement.getAttribute(n);
        if (string != null && (n3 = CSSUtil.parseLength(string)) != Integer.MIN_VALUE) {
            if (n3 > 0) {
                n3 = n3 * n2 >> 8;
            }
            return n3;
        }
        return Integer.MIN_VALUE;
    }
}

