/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.image;

import ice.debug.Debug;
import ice.pilots.image.ImageComponent;
import ice.pilots.image.ThePrinter;
import ice.storm.ContentLoader;
import ice.storm.LPilot;
import ice.storm.StormPrinter;
import ice.util.ICEException;
import ice.util.memory.MemoryManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;

public class ThePilot
extends LPilot
implements ImageObserver {
    private static final Cursor WAIT_CURSOR = new Cursor(3);
    private static final Cursor NORMAL_CURSOR = new Cursor(0);
    private static final int BUFFERSIZE = 8192;
    private Image theImage = null;
    private int forcedWidth = -1;
    private int forcedHeight = -1;
    private int width = 20;
    private int height = 20;
    private String toolkit;
    private ImageComponent component;
    private MemoryManager memoryManager = null;

    public void init(String string) {
        super.init(string);
        this.memoryManager = MemoryManager.getInstance();
        this.toolkit = string;
    }

    public Component createComponent() {
        block4: {
            String string = "ice.pilots.image." + this.toolkit + ".TheContainer";
            try {
                Object obj = Class.forName(string).newInstance();
                this.component = (ImageComponent)obj;
                this.component.init(this);
            }
            catch (Exception exception) {
                if (Debug.ex) {
                    Debug.ex((Throwable)exception);
                }
                if (Debug.trace) {
                    Debug.trace((String)("Failed to create component: " + exception));
                }
                if (this.toolkit.equals("awt")) break block4;
                this.toolkit = "awt";
                this.createComponent();
            }
        }
        return (Component)((Object)this.component);
    }

    public StormPrinter createPrinter() {
        ThePrinter thePrinter = new ThePrinter(this);
        return thePrinter;
    }

    void flushImage() {
        if (this.theImage != null) {
            this.theImage.flush();
            this.theImage = null;
        }
    }

    public void clear(String string) {
        this.flushImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(ContentLoader contentLoader) throws IOException {
        try {
            Object object;
            this.setCursor(WAIT_CURSOR);
            this.firePropertyChange("location", null, contentLoader.getLocation());
            this.firePropertyChange("title", null, contentLoader.getLocation());
            if ("image/png".equalsIgnoreCase(contentLoader.getContentType()) && (object = this.createPngImageProducer(contentLoader)) != null) {
                this.theImage = Toolkit.getDefaultToolkit().createImage((ImageProducer)object);
            }
            if (this.theImage == null) {
                object = contentLoader.getInputStream();
                try {
                    if (!this.memoryManager.canAllocate(16384)) {
                        throw new ICEException(1, 3, 2);
                    }
                    byte[] byArray = new byte[8192];
                    byte[] byArray2 = new byte[8192];
                    boolean bl = false;
                    int n = 0;
                    int n2 = 0;
                    while (!bl) {
                        n = ((InputStream)object).read(byArray);
                        if (n == -1) {
                            bl = true;
                            break;
                        }
                        if (byArray2.length - n2 > n) {
                            System.arraycopy(byArray, 0, byArray2, n2, n);
                            n2 += n;
                            continue;
                        }
                        int n3 = Math.max(byArray2.length * 2, byArray2.length + n);
                        if (!this.memoryManager.canAllocate(n3)) {
                            byArray2 = null;
                            throw new ICEException(1, 3, 2);
                        }
                        byte[] byArray3 = new byte[n3];
                        System.arraycopy(byArray2, 0, byArray3, 0, n2);
                        byArray2 = byArray3;
                        System.arraycopy(byArray, 0, byArray2, n2, n);
                        n2 += n;
                    }
                    if (!this.memoryManager.canAllocate(n2)) {
                        throw new ICEException(1, 3, 2);
                    }
                    byte[] byArray4 = new byte[n2];
                    System.arraycopy(byArray2, 0, byArray4, 0, n2);
                    this.theImage = Toolkit.getDefaultToolkit().createImage(byArray4);
                }
                finally {
                    ((InputStream)object).close();
                }
            }
            if (this.theImage == null) {
                return;
            }
            Toolkit.getDefaultToolkit().prepareImage(this.theImage, -1, -1, this);
            int n = this.theImage.getWidth(this);
            int n4 = this.theImage.getHeight(this);
            if (n > 0) {
                this.width = n;
            }
            if (n4 > 0) {
                this.height = n4;
            }
        }
        finally {
            this.setCursor(NORMAL_CURSOR);
        }
    }

    public Image getImage() {
        return this.theImage;
    }

    public void dispose() {
        this.flushImage();
    }

    public int getWidth() {
        int n = this.getPilotViewport().getZoom();
        return this.width * n >> 8;
    }

    public int getHeight() {
        int n = this.getPilotViewport().getZoom();
        return this.height * n >> 8;
    }

    public void setSize(int n, int n2) {
        this.forcedWidth = n;
        this.forcedHeight = n2;
    }

    protected void setZoom(int n) {
        this.refreshViewport();
        if (this.component != null) {
            this.component.updateYourself();
        }
    }

    public void paint(Graphics graphics) {
        if (this.theImage != null) {
            int n = this.getPilotViewport().getZoom();
            if (this.forcedWidth >= 0 && this.forcedHeight >= 0) {
                graphics.drawImage(this.theImage, 0, 0, this.forcedWidth, this.forcedHeight, 0, 0, this.width, this.height, this);
            } else if (n != 256) {
                int n2 = this.width * n >> 8;
                int n3 = this.height * n >> 8;
                graphics.drawImage(this.theImage, 0, 0, n2, n3, 0, 0, this.width, this.height, this);
            } else {
                graphics.drawImage(this.theImage, 0, 0, this.width, this.height, this);
            }
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 1) != 0) {
            this.width = n4;
        }
        if ((n & 2) != 0) {
            this.height = n5;
        }
        if ((n & 0x33) != 0) {
            this.refreshViewport();
            if (this.component != null) {
                this.component.updateYourself();
            }
        }
        return (n & 0xE0) == 0;
    }

    ImageProducer createPngImageProducer(ContentLoader contentLoader) {
        ImageProducer imageProducer = null;
        try {
            Class<?> clazz = Class.forName("com.sixlegs.image.png.PngImage");
            Class[] classArray = new Class[]{InputStream.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{contentLoader.getInputStream()};
            imageProducer = (ImageProducer)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imageProducer;
    }

    private void setCursor(Cursor cursor) {
        if (this.component != null) {
            this.component.setCursor(cursor);
        }
    }
}

