/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.CallbackAdapter;
import ice.storm.ContentLoader;
import ice.storm.DefaultFactory;
import ice.storm.HistoryManager;
import ice.storm.ImageCache;
import ice.storm.Pilot;
import ice.storm.PilotFactory;
import ice.storm.PilotInfo;
import ice.storm.PseudoHistoryManager;
import ice.storm.Scripter;
import ice.storm.ScripterCallback;
import ice.storm.ScripterFactory;
import ice.storm.ScripterInfo;
import ice.storm.StormCallback;
import ice.storm.URLClassLoaderFactory;
import ice.storm.UrlMaster;
import ice.storm.Viewport;
import ice.storm.ViewportCallback;
import ice.storm.ViewportLayoutManager;
import ice.storm.ViewportVisitor;
import ice.util.Defs;
import ice.util.Emulation;
import ice.util.alg.IThread;
import ice.util.alg.Listeners;
import ice.util.alg.Session;
import ice.util.awt.TimedAWTExecutor;
import ice.util.memory.MemoryManager;
import ice.util.security.BoxedCode;
import ice.util.security.SecurityKit;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StormBase {
    public static final String VERSION = "v6_0_2";
    public static final String EXPIRES_STRING = "EXPIRY_DATE_TEXT";
    public static final String EXPIRES_LONG = "988668001910L";
    private static final boolean disable_pilot_reuse;
    private final Object viewportTreeLock = new Object();
    private HistoryManager historyManager;
    private PilotFactory pilotFactory;
    private URLClassLoaderFactory classLoaderFactory;
    private String componentToolkitName = "awt";
    private Container container;
    private ViewportCallback viewportCallback;
    private ScripterCallback scripterCallback;
    private Hashtable scripters = new Hashtable();
    private Vector viewports = new Vector();
    String initialViewportName;
    private Viewport activeViewport;
    private Object globalListeners;
    private Hashtable disabledMimeTypes = new Hashtable();
    private TimedAWTExecutor timedAWTExecutor;
    private UrlMaster urlMaster;
    private final long[] recursiveTimestamp = new long[1];
    private MemoryCheck memoryCheck;
    private final boolean trace_viewport_messages = Debug.trace && Defs.booleanProperty((String)"ice.storm.trace_viewport_messages");
    private Session session;

    public StormBase() {
        this(new Session());
    }

    public StormBase(Session session) {
        this.session = session;
        this.setupMemoryCheck();
        DefaultFactory defaultFactory = new DefaultFactory();
        defaultFactory.loadDefaultResources();
        this.pilotFactory = defaultFactory;
        this.classLoaderFactory = defaultFactory;
        this.setHistoryManager(new PseudoHistoryManager(this));
        this.addPropertyChangeListener(this.getHistoryManager(), null);
    }

    public final Session getSession() {
        return this.session;
    }

    private void setupMemoryCheck() {
        String string = Defs.sysProperty((String)"ice.browser.memoryCheck.period");
        if (string != null) {
            long l;
            block4: {
                l = 0L;
                try {
                    l = Long.parseLong(string);
                }
                catch (RuntimeException runtimeException) {
                    if (!Debug.ex) break block4;
                    Debug.ex((Throwable)runtimeException);
                }
            }
            if (l > 0L) {
                this.memoryCheck = new MemoryCheck(l);
            }
        }
    }

    void onLowMemory() {
        Vector vector = this.viewports;
        int n = vector.size();
        while (n-- != 0) {
            Viewport viewport = (Viewport)vector.elementAt(n);
            this.onLowMemory_r(viewport);
        }
    }

    private void onLowMemory_r(Viewport viewport) {
        for (Viewport viewport2 = viewport.getFirstChild(); viewport2 != null; viewport2 = viewport2.getNextSibling()) {
            this.onLowMemory_r(viewport2);
        }
        Pilot pilot = viewport.getPilot();
        if (pilot != null) {
            pilot.onLowMemory();
        }
    }

    public final void setHistoryManager(HistoryManager historyManager) {
        this.historyManager = historyManager;
    }

    public final HistoryManager getHistoryManager() {
        return this.historyManager;
    }

    public final ScripterFactory getScripterFactory() {
        return this.getPilotFactory();
    }

    public final void setPilotFactory(PilotFactory pilotFactory) {
        this.pilotFactory = pilotFactory;
    }

    public final PilotFactory getPilotFactory() {
        return this.pilotFactory;
    }

    public final void setURLClassLoaderFactory(URLClassLoaderFactory uRLClassLoaderFactory) {
        this.classLoaderFactory = uRLClassLoaderFactory;
    }

    public final URLClassLoaderFactory getURLClassLoaderFactory() {
        return this.classLoaderFactory;
    }

    public final void setComponentToolkitName(String string) {
        this.componentToolkitName = string;
    }

    public final String getComponentToolkitName() {
        return this.componentToolkitName;
    }

    public final void setContainer(Container container, String string) {
        if (this.viewportCallback != null || this.container != null) {
            return;
        }
        this.container = container;
        this.configureViewport(new Viewport(this, string));
    }

    public final Container getContainer(Container container) {
        return this.container;
    }

    public final void setCallback(StormCallback stormCallback) {
        CallbackAdapter.OldCallbackWrap oldCallbackWrap = new CallbackAdapter.OldCallbackWrap(stormCallback);
        oldCallbackWrap.registerWith(this);
    }

    public final StormCallback getCallback() {
        if (this.viewportCallback instanceof CallbackAdapter) {
            return ((CallbackAdapter.OldCallbackWrap)this.viewportCallback).oldCallback;
        }
        return null;
    }

    public final ViewportCallback getViewportCallback() {
        return this.viewportCallback;
    }

    public final void setViewportCallback(ViewportCallback viewportCallback) {
        if (this.container != null) {
            return;
        }
        this.viewportCallback = viewportCallback;
        this.viewportCallback.init(this);
    }

    public final ScripterCallback getScripterCallback() {
        return this.scripterCallback;
    }

    public final void setScripterCallback(ScripterCallback scripterCallback) {
        this.scripterCallback = scripterCallback;
    }

    public void setActiveViewport(Viewport viewport) {
        this.activeViewport = viewport;
    }

    public Viewport getActiveViewport() {
        return this.activeViewport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener, String string) {
        if (string == null) {
            Object object = this.viewportTreeLock;
            synchronized (object) {
                this.globalListeners = Listeners.add((Object)this.globalListeners, (Object)propertyChangeListener);
            }
        } else {
            Viewport viewport = this.findViewportByName(string);
            if (viewport != null) {
                viewport.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener, String string) {
        if (string == null) {
            Object object = this.viewportTreeLock;
            synchronized (object) {
                this.globalListeners = Listeners.remove((Object)this.globalListeners, (Object)propertyChangeListener);
            }
        } else {
            Viewport viewport = this.findViewportByName(string);
            if (viewport != null) {
                viewport.removePropertyChangeListener(propertyChangeListener);
            }
        }
    }

    boolean sendViewportMessage(Viewport viewport, String string, Object object, Object object2) {
        if (viewport == null) {
            return false;
        }
        if (this.trace_viewport_messages && Debug.trace) {
            Debug.trace((String)(viewport + ", " + string + ", " + object + ", " + object2));
        }
        if (this.viewportCallback != null) {
            try {
                this.viewportCallback.processViewportMessage(viewport, string, object, object2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (Debug.ex) {
                    Debug.ex((Throwable)outOfMemoryError);
                }
                return false;
            }
            catch (RuntimeException runtimeException) {
                if (Debug.ex) {
                    Debug.ex((Throwable)runtimeException);
                }
                return false;
            }
        }
        boolean bl = true;
        PropertyChangeEvent propertyChangeEvent = null;
        Viewport viewport2 = viewport;
        while (true) {
            Object object3;
            if ((object3 = viewport2 == null ? this.globalListeners : viewport2.getPropertyListeners()) != null) {
                if (propertyChangeEvent == null) {
                    propertyChangeEvent = new PropertyChangeEvent(viewport, string, object, object2);
                }
                bl &= StormBase.firePropertyChangeEvent(object3, propertyChangeEvent);
            }
            if (viewport2 == null) break;
            viewport2 = viewport2.getParent();
        }
        return bl;
    }

    private static boolean firePropertyChangeEvent(Object object, PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeListener propertyChangeListener;
        if (object == null) {
            Defs.badArg();
        }
        boolean bl = true;
        int n = 0;
        while ((propertyChangeListener = (PropertyChangeListener)Listeners.get((Object)object, (int)n)) != null) {
            try {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (Debug.ex) {
                    Debug.ex((Throwable)outOfMemoryError);
                }
                return false;
            }
            catch (RuntimeException runtimeException) {
                if (Debug.ex) {
                    Debug.ex((Throwable)runtimeException);
                }
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public boolean isMimeTypeEnabled(String string) {
        Enumeration enumeration;
        PilotFactory pilotFactory;
        boolean bl = false;
        if (!this.disabledMimeTypes.containsKey(string) && (pilotFactory = this.getPilotFactory()) != null && (enumeration = pilotFactory.getAllPilotInfos()) != null) {
            while (enumeration.hasMoreElements()) {
                PilotInfo pilotInfo = (PilotInfo)enumeration.nextElement();
                if (!pilotInfo.isSupportedContentType(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void setMimeTypeEnabled(String string, boolean bl) {
        Object v = this.disabledMimeTypes.get(string);
        if (v != null && bl) {
            this.disabledMimeTypes.remove(string);
        } else if (v == null && !bl) {
            this.disabledMimeTypes.put(string, string);
        }
    }

    public UrlMaster getUrlMaster() {
        UrlMaster urlMaster = this.urlMaster;
        if (urlMaster == null) {
            this.urlMaster = urlMaster = UrlMaster.get(this.session);
        }
        return urlMaster;
    }

    public void renderContent(String string, String string2, String string3) {
        this.renderContent(string, string2, this.prepare_viewport(string3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderContent(String string, String string2, Viewport viewport) {
        if (viewport == null) {
            Debug.bug();
        }
        string = this.getUrlMaster().resolve(viewport.getBaseUrl(), string);
        Debug.trace((String)(string + " in " + viewport));
        Scripter scripter = this.getScripterForCodeLocation(string);
        if (scripter != null) {
            scripter.evalCodeLocation(viewport, string);
            return;
        }
        Object object = this.viewportTreeLock;
        synchronized (object) {
            ContentLoader contentLoader = new ContentLoader(string, string2);
            contentLoader.setReferer(viewport.getBaseUrl());
            if (this.anchorsHandled(contentLoader, viewport) && contentLoader.getPostData() == null) {
                return;
            }
            try {
                this.stopLoading(viewport.getName());
            }
            catch (RuntimeException runtimeException) {
                Debug.ex((Throwable)runtimeException);
            }
            viewport.queueRenderContent(contentLoader);
        }
        this.sendViewportMessage(viewport, "viewport", null, "ready");
    }

    private boolean anchorsHandled(ContentLoader contentLoader, Viewport viewport) {
        String string;
        String string2;
        boolean bl = false;
        URL uRL = contentLoader.getURL();
        if (uRL != null && (string2 = uRL.getRef()) != null && (string = viewport.getLocation()) != null) {
            Pilot pilot;
            String string3;
            int n = string.lastIndexOf(35);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if ((n = (string3 = uRL.toExternalForm()).lastIndexOf(35)) >= 0) {
                string3 = string3.substring(0, n);
            }
            if (string.equals(string3) && (pilot = viewport.getPilot()) != null) {
                bl = true;
                if (pilot.refExists(string2)) {
                    try {
                        this.getHistoryManager().goingSomewhere(contentLoader, viewport.getId());
                        pilot.gotoRef(string2);
                    }
                    catch (RuntimeException runtimeException) {
                        Debug.ex((Throwable)runtimeException);
                    }
                }
            }
        }
        return bl;
    }

    public void renderContent(ContentLoader contentLoader, String string) {
        Viewport viewport = this.prepare_viewport(string);
        if (viewport == null) {
            if (Debug.trace) {
                Debug.trace((String)("Failed: no view for " + string));
            }
            return;
        }
        this.renderViewportContent(contentLoader, viewport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderViewportContent(ContentLoader contentLoader, Viewport viewport) {
        Debug.trace((String)("loader=" + contentLoader + " view=" + viewport));
        Object object = this.viewportTreeLock;
        synchronized (object) {
            if (this.anchorsHandled(contentLoader, viewport) && contentLoader.getPostData() == null) {
                return;
            }
            this.stopViewportLoading(viewport);
            viewport.queueRenderContent(contentLoader);
        }
        this.sendViewportMessage(viewport, "viewport", null, "ready");
    }

    public void renderContentFully(ContentLoader contentLoader, String string) {
        Viewport viewport = this.prepare_viewport(string);
        if (viewport == null) {
            Debug.trace((String)("Failed: no viewport for " + string + " to render " + contentLoader));
            return;
        }
        this.renderViewportContentFully(contentLoader, viewport);
    }

    public void renderVieportContentFully(ContentLoader contentLoader, Viewport viewport) {
        this.renderViewportContentFully(contentLoader, viewport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderViewportContentFully(ContentLoader contentLoader, Viewport viewport) {
        Debug.trace((String)("contentLoader=" + contentLoader + ", viewport=" + viewport));
        Object object = this.viewportTreeLock;
        synchronized (object) {
            if (this.anchorsHandled(contentLoader, viewport) && contentLoader.getPostData() == null) {
                return;
            }
            this.stopViewportLoading(viewport);
            this.do_render_content(contentLoader, viewport);
        }
        this.sendViewportMessage(viewport, "viewport", null, "ready");
    }

    public void clearContent(String string, String string2) {
        Viewport viewport = this.prepare_viewport(string2);
        if (viewport == null) {
            return;
        }
        if (Debug.trace) {
            Debug.trace((String)("contentType=" + string + " viewport=" + viewport));
        }
        this.stopViewportLoading(viewport);
        this.do_clear_content(null, string, viewport);
        this.sendViewportMessage(viewport, "viewport", null, "ready");
    }

    public void clearVieportContent(String string, Viewport viewport) {
        this.clearViewportContent(string, viewport);
    }

    public void clearViewportContent(String string, Viewport viewport) {
        Debug.trace((String)("contentType=" + string + ", viewport=" + viewport));
        this.stopViewportLoading(viewport);
        this.do_clear_content(null, string, viewport);
        this.sendViewportMessage(viewport, "viewport", null, "ready");
    }

    public Viewport newTopLevelViewport(String string) {
        Viewport viewport = new Viewport(this, string);
        if (!this.configureViewport(viewport)) {
            viewport = null;
        }
        return viewport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Viewport prepare_viewport(String string) {
        if ("_blank".equals(string)) {
            string = null;
        }
        Viewport viewport = null;
        Object object = this.viewportTreeLock;
        synchronized (object) {
            if (string != null) {
                if (this.viewports.size() == 0) {
                    this.initialViewportName = string = new String(string);
                } else {
                    viewport = this.findViewportByName(string);
                }
            } else if (this.container != null && this.viewports.size() == 1) {
                viewport = (Viewport)this.viewports.elementAt(0);
            }
        }
        if (viewport == null) {
            viewport = this.newTopLevelViewport(string);
        }
        return viewport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void do_clear_content(ContentLoader contentLoader, String string, Viewport viewport) {
        Object object;
        if (viewport.isStopRequested()) {
            return;
        }
        Object object2 = this.viewportTreeLock;
        synchronized (object2) {
            object = new ViewportUnloader();
            viewport.iterate((ViewportVisitor)object);
        }
        if (disable_pilot_reuse) {
            object2 = this.viewportTreeLock;
            synchronized (object2) {
                viewport.clearContent();
            }
            object2 = viewport.getPilot();
            if (object2 != null) {
                viewport.removePilot();
            }
            object = this.viewportTreeLock;
            synchronized (object) {
                viewport.removeWindowVariables();
            }
            this.loadNewPilot(contentLoader, string, viewport);
        } else {
            object2 = this.viewportTreeLock;
            synchronized (object2) {
                viewport.clearContent();
            }
            object2 = viewport.getPilot();
            if (object2 != null) {
                boolean bl = this.getPilotFactory().isContentTypeSupported((Pilot)object2, contentLoader, string);
                if (!bl) {
                    if (viewport.isStopRequested()) {
                        return;
                    }
                    viewport.removePilot();
                    object2 = null;
                } else {
                    if (contentLoader != null) {
                        string = contentLoader.getContentType();
                    }
                    viewport.setLocationUrl(null);
                    ((Pilot)object2).clear(string);
                }
            }
            Object object3 = this.viewportTreeLock;
            synchronized (object3) {
                viewport.removeWindowVariables();
            }
            if (object2 == null) {
                this.loadNewPilot(contentLoader, string, viewport);
            }
        }
    }

    private void loadNewPilot(ContentLoader contentLoader, String string, Viewport viewport) {
        Pilot pilot;
        this.sendViewportMessage(viewport, "pilotLoading", null, "begin");
        if (this.disabledMimeTypes.containsKey(string)) {
            pilot = this.getPilotFactory().createPilot("application/disabled");
        } else if (contentLoader != null) {
            pilot = this.getPilotFactory().createPilot(contentLoader);
            string = contentLoader.getContentType();
        } else {
            pilot = this.getPilotFactory().createPilot(string);
        }
        if (pilot == null) {
            this.sendViewportMessage(viewport, "pilotLoading", null, "error");
            return;
        }
        if (viewport.isStopRequested()) {
            return;
        }
        pilot.base = this;
        pilot.viewport = viewport;
        pilot.init(this.componentToolkitName);
        viewport.setPilot(pilot);
        viewport.setLocationUrl(null);
        pilot.clear(string);
        this.sendViewportMessage(viewport, "pilotLoading", null, "end");
    }

    void do_render_content(ContentLoader contentLoader, Viewport viewport) {
        IOException iOException;
        if (!this.sendViewportMessage(viewport, "contentLoading", contentLoader, "request")) {
            return;
        }
        this.sendViewportMessage(viewport, "contentLoading", contentLoader, "connect");
        if (!contentLoader.hasReply() && contentLoader.getContentType() == null) {
            contentLoader.make();
        }
        if ((iOException = contentLoader.getException()) == null) {
            if (contentLoader.getContentType().equals("application/external")) {
                return;
            }
            if (viewport.isStopRequested()) {
                return;
            }
            this.do_clear_content(contentLoader, contentLoader.getContentType(), viewport);
            viewport.setLocationUrl(contentLoader.getLocation());
            if (viewport.isStopRequested()) {
                return;
            }
            Pilot pilot = viewport.getPilot();
            if (pilot == null) {
                this.sendViewportMessage(viewport, "pilotLoading", null, "error");
                return;
            }
            ImageCache.get(this.session).setReload(true);
            ImageCache.get(this.session).setExpire(0);
            this.getHistoryManager().goingSomewhere(contentLoader, viewport.getId());
            if (viewport.isStopRequested()) {
                return;
            }
            this.sendViewportMessage(viewport, "contentLoading", contentLoader, "begin");
            if (!this.isRecursiveLoading(viewport, contentLoader)) {
                try {
                    pilot.parse(contentLoader);
                }
                catch (IOException iOException2) {
                    if (Debug.ex) {
                        Debug.ex((Throwable)iOException2);
                    }
                    iOException = iOException2;
                    contentLoader.setException(iOException);
                }
            }
            if (viewport.isStopRequested()) {
                return;
            }
            if (iOException == null) {
                this.sendViewportMessage(viewport, "contentLoading", contentLoader, "end");
                pilot.parsingDone();
            }
        }
        if (iOException != null) {
            if (Debug.trace) {
                Debug.trace((String)("Failed to load: " + contentLoader));
            }
            this.sendViewportMessage(viewport, "contentLoading", contentLoader, "error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isRecursiveLoading(Viewport viewport, ContentLoader contentLoader) {
        int n = 0;
        String string = contentLoader.getLocation();
        if (string == null) {
            return false;
        }
        for (viewport = viewport.getParent(); viewport != null; viewport = viewport.getParent()) {
            String string2 = viewport.getLocation();
            if (string2 == null || !string.equals(string2) || ++n <= 1) continue;
            long[] lArray = this.recursiveTimestamp;
            synchronized (this.recursiveTimestamp) {
                if (this.recursiveTimestamp[0] == 0L) {
                    this.recursiveTimestamp[0] = System.currentTimeMillis();
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return false;
                }
                if (System.currentTimeMillis() - this.recursiveTimestamp[0] > 2000L) {
                    this.recursiveTimestamp[0] = System.currentTimeMillis();
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return false;
                }
                this.recursiveTimestamp[0] = System.currentTimeMillis();
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return true;
            }
        }
        return false;
    }

    public void reload(String string) {
        this.getHistoryManager().reload(string);
    }

    public void goBack(String string) {
        this.getHistoryManager().goBack(string);
    }

    public boolean canGoBack(String string) {
        return this.getHistoryManager().canGoBack(string);
    }

    public void goForward(String string) {
        this.getHistoryManager().goForward(string);
    }

    public boolean canGoForward(String string) {
        return this.getHistoryManager().canGoForward(string);
    }

    public boolean configureViewport(Viewport viewport, String string) {
        return this.configureViewport(viewport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean configureViewport(Viewport viewport) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            this.activeViewport = null;
        }
        if (this.viewportCallback != null) {
            object = this.viewportTreeLock;
            synchronized (object) {
                this.viewports.addElement(viewport);
            }
            object = (Container)SecurityKit.doPrivileged((BoxedCode)CallbackAdapter.box_createTopLevelContainer(this.viewportCallback, viewport));
            if (object == null && !"none".equalsIgnoreCase(this.componentToolkitName)) {
                if (Debug.trace) {
                    Debug.trace((String)("Failed to create AWT container for " + viewport));
                }
                Object object2 = this.viewportTreeLock;
                synchronized (object2) {
                    this.viewports.removeElement(viewport);
                }
                return false;
            }
            if (Debug.trace) {
                Viewport viewport2 = null;
                Object object3 = this.viewportTreeLock;
                synchronized (object3) {
                    Vector vector = this.viewports;
                    int n = vector.size();
                    while (n-- != 0) {
                        Viewport viewport3 = (Viewport)vector.elementAt(n);
                        if (viewport == viewport3 || viewport3.getContainer() != object) continue;
                        viewport2 = viewport3;
                        break;
                    }
                }
                if (viewport2 != null) {
                    Debug.trace((String)("ERROR: got same AWT container for " + viewport2 + " and " + viewport));
                }
            }
            viewport.setContainer((Container)object);
            if (object != null) {
                ((Container)object).setLayout(new ViewportLayoutManager(viewport));
            }
        } else if (this.container != null) {
            if (this.viewports.size() > 0) {
                return false;
            }
            viewport.setContainer(this.container);
            if (this.container != null) {
                this.container.setLayout(new ViewportLayoutManager(viewport));
            }
            object = this.viewportTreeLock;
            synchronized (object) {
                this.viewports.addElement(viewport);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Viewport findViewportByName(String string) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            Viewport viewport = null;
            for (int n = 0; n < this.viewports.size() && viewport == null; viewport = viewport.findViewportByName(string), ++n) {
                viewport = (Viewport)this.viewports.elementAt(n);
            }
            return viewport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getAllPilotInstances(Class clazz, Vector vector) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            for (int i = 0; i != this.viewports.size(); ++i) {
                Viewport viewport = (Viewport)this.viewports.elementAt(i);
                this.getAllPilotInstances_r(viewport, clazz, vector);
            }
        }
    }

    private void getAllPilotInstances_r(Viewport viewport, Class clazz, Vector vector) {
        Pilot pilot = viewport.getPilot();
        if (clazz.isInstance(pilot)) {
            vector.addElement(pilot);
        }
        for (Viewport viewport2 = viewport.getFirstChild(); viewport2 != null; viewport2 = viewport2.getNextSibling()) {
            this.getAllPilotInstances_r(viewport2, clazz, vector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTopLevelViewport(Viewport viewport) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            int n = this.viewports.size();
            for (int i = 0; i != n; ++i) {
                if (viewport != this.viewports.elementAt(i)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isKnownViewport(Viewport viewport) {
        viewport = viewport.getTopParent();
        return this.isTopLevelViewport(viewport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Viewport findViewportByHistoryId(String string) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            Viewport viewport = null;
            for (int n = 0; n < this.viewports.size() && viewport == null; viewport = viewport.findViewportByHistoryId(string), ++n) {
                viewport = (Viewport)this.viewports.elementAt(n);
            }
            return viewport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAllViewports(Vector vector) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            int n = this.viewports.size();
            for (int i = 0; i != n; ++i) {
                Viewport viewport = (Viewport)this.viewports.elementAt(i);
                viewport.getViewAndAllChildren(vector);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeViewport(String string) {
        Viewport viewport = null;
        Object object = this.viewportTreeLock;
        synchronized (object) {
            int n;
            this.activeViewport = null;
            for (n = 0; n < this.viewports.size(); ++n) {
                Viewport viewport2 = (Viewport)this.viewports.elementAt(n);
                if (!viewport2.getId().equals(string) && !viewport2.getName().equals(string)) continue;
                viewport = viewport2;
                break;
            }
            if (viewport == null) {
                if (Debug.trace) {
                    Debug.trace((String)("No top view: " + string));
                }
                return;
            }
            this.viewports.removeElementAt(n);
        }
        if (Debug.trace) {
            Debug.trace((String)("view=" + viewport));
        }
        viewport.stopLoading();
        viewport.dispose();
        if (this.viewportCallback != null) {
            this.viewportCallback.disposeTopLevelContainer(viewport);
        }
    }

    public String getViewportState(String string) {
        Viewport viewport = this.findViewportByName(string);
        if (viewport == null) {
            return null;
        }
        return viewport.stateString;
    }

    public void stopLoading(String string) {
        Viewport viewport = this.findViewportByName(string);
        if (viewport != null) {
            this.stopViewportLoading(viewport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopViewportLoading(Viewport viewport) {
        this.sendViewportMessage(viewport, "contentLoading", null, "stop");
        Object object = this.viewportTreeLock;
        synchronized (object) {
            this.process_stop_loading(viewport);
        }
    }

    void process_stop_loading(Viewport viewport) {
        viewport.stopLoading();
        for (Viewport viewport2 = viewport.getFirstChild(); viewport2 != null; viewport2 = viewport2.getNextSibling()) {
            this.process_stop_loading(viewport2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object;
        Enumeration<Object> enumeration = this.scripters.elements();
        while (enumeration.hasMoreElements()) {
            object = (Scripter)enumeration.nextElement();
            ((Scripter)object).dispose();
        }
        this.scripters.clear();
        object = this.viewportTreeLock;
        synchronized (object) {
            this.activeViewport = null;
            enumeration = this.viewports.elements();
            while (enumeration.hasMoreElements()) {
                Viewport viewport = (Viewport)enumeration.nextElement();
                viewport.dispose();
            }
            this.viewports.removeAllElements();
            this.initialViewportName = null;
        }
        if (this.timedAWTExecutor != null) {
            this.timedAWTExecutor.shutdown();
        }
        this.session.disposeResources();
    }

    public static void unload() {
    }

    public void suspend() {
        Object object;
        Enumeration<Object> enumeration = this.scripters.elements();
        while (enumeration.hasMoreElements()) {
            object = (Scripter)enumeration.nextElement();
            ((Scripter)object).suspend();
        }
        enumeration = this.viewports.elements();
        while (enumeration.hasMoreElements()) {
            object = (Viewport)enumeration.nextElement();
            Pilot pilot = ((Viewport)object).getPilot();
            if (pilot == null) continue;
            pilot.suspend();
        }
    }

    public void resume() {
        Object object;
        Enumeration<Object> enumeration = this.scripters.elements();
        while (enumeration.hasMoreElements()) {
            object = (Scripter)enumeration.nextElement();
            ((Scripter)object).resume();
        }
        enumeration = this.viewports.elements();
        while (enumeration.hasMoreElements()) {
            object = (Viewport)enumeration.nextElement();
            Pilot pilot = ((Viewport)object).getPilot();
            if (pilot == null) continue;
            pilot.resume();
        }
    }

    public Scripter getScripterForCodeLocation(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            String string2 = string.substring(0, n);
            return this.getScripter(string2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scripter getScripter(String string) {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            ScripterInfo scripterInfo = this.getPilotFactory().getScripterInfo(string);
            if (scripterInfo == null) {
                return null;
            }
            Scripter scripter = (Scripter)this.scripters.get(scripterInfo);
            if (scripter != null) {
                return scripter;
            }
            scripter = this.getPilotFactory().createScripter(string);
            if (scripter == null) {
                return null;
            }
            this.scripters.put(scripterInfo, scripter);
            scripter.init(this);
            return scripter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadAllScripters() {
        Object object = this.viewportTreeLock;
        synchronized (object) {
            Object object2;
            Enumeration enumeration = this.getPilotFactory().getAllScripterInfos();
            while (enumeration.hasMoreElements()) {
                object2 = (ScripterInfo)enumeration.nextElement();
                ((ScripterInfo)object2).setEnabled(false);
            }
            enumeration = this.scripters.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (Scripter)enumeration.nextElement();
                ((Scripter)object2).dispose();
            }
            this.scripters.clear();
            object2 = this.viewports;
            int n = ((Vector)object2).size();
            while (n-- != 0) {
                Viewport viewport = (Viewport)((Vector)object2).elementAt(n);
                this.clear_viewport_dynwrapper_r(viewport);
            }
        }
    }

    private void clear_viewport_dynwrapper_r(Viewport viewport) {
        viewport.clearWindowObj();
        for (viewport = viewport.getFirstChild(); viewport != null; viewport = viewport.getNextSibling()) {
            this.clear_viewport_dynwrapper_r(viewport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimedAWTExecutor getTimedAWTExecutor() {
        TimedAWTExecutor timedAWTExecutor = this.timedAWTExecutor;
        if (timedAWTExecutor == null) {
            StormBase stormBase = this;
            synchronized (stormBase) {
                timedAWTExecutor = this.timedAWTExecutor;
                if (timedAWTExecutor == null) {
                    this.timedAWTExecutor = timedAWTExecutor = new TimedAWTExecutor();
                }
            }
        }
        return timedAWTExecutor;
    }

    public void runOnEventThreadAndWait(Runnable runnable, long l) {
        try {
            this.getTimedAWTExecutor().invokeAndWait(runnable, l);
        }
        catch (InterruptedException interruptedException) {
            Debug.ex((Throwable)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Debug.ex((Throwable)invocationTargetException);
        }
    }

    public void runOnEventThreadLater(Runnable runnable, long l) {
        this.getTimedAWTExecutor().invokeLater(runnable, l);
    }

    public boolean isEventThread() {
        return this.getTimedAWTExecutor().isEventThread();
    }

    static {
        if (Debug.trace) {
            Debug.traceAsIs((String)"ICEbrowser v6_0_2");
        } else if (Defs.booleanProperty((String)"ice.browser.verbose", (boolean)true)) {
            System.out.println("ICEbrowser v6_0_2");
            System.out.println("(c) ICEsoft Technologies, Inc.");
        }
        String string = Defs.property((String)"http.agent");
        if (string == null) {
            string = Emulation.getEmulatedUserAgent();
            Defs.setSystemProperty((String)"http.agent", (String)string);
        }
        disable_pilot_reuse = Defs.booleanProperty((String)"ice.storm.disable_pilot_reuse");
    }

    final class ViewportUnloader
    implements ViewportVisitor {
        ViewportUnloader() {
        }

        public final void visit(Viewport viewport) {
            Pilot pilot = viewport.getPilot();
            if (pilot != null) {
                pilot.beforeUnload();
            }
        }
    }

    class MemoryCheck
    implements Runnable {
        boolean shouldStop;
        long check_interval;
        MemoryManager memory_manager;

        MemoryCheck(long l) {
            IThread iThread;
            block3: {
                this.memory_manager = MemoryManager.getInstance();
                this.check_interval = l;
                iThread = new IThread((Runnable)this, "Memory Check");
                iThread.setDaemon(true);
                int n = iThread.getPriority();
                if (n > 1) {
                    try {
                        iThread.setPriority(n - 1);
                    }
                    catch (RuntimeException runtimeException) {
                        if (!Debug.ex) break block3;
                        Debug.ex((Throwable)runtimeException);
                    }
                }
            }
            iThread.start();
        }

        public void run() {
            while (!this.shouldStop) {
                block3: {
                    try {
                        Thread.sleep(this.check_interval);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!Debug.ex) break block3;
                        Debug.ex((Throwable)interruptedException);
                    }
                }
                this.checkMemory();
            }
        }

        private void checkMemory() {
            if (this.memory_manager.isLowMemory()) {
                StormBase.this.onLowMemory();
            }
        }
    }
}

