/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.net.BasicConnection;
import ice.net.CacheManager;
import ice.net.CachedInputStream;
import ice.net.Connection;
import ice.net.ConnectionManagerSettings;
import ice.net.HttpRequest;
import ice.net.HttpResponse;
import ice.net.HttpSession;
import ice.net.HttpURLConnection;
import ice.net.HttpURLConnectionEvent;
import ice.net.HttpURLConnectionListener;
import ice.net.PersistentConnection;
import ice.net.proxy.Proxy;
import ice.util.UnsupportedOperationException;
import ice.util.alg.Listeners;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Vector;

public class ConnectionManager {
    private Object CLEAN_INTERVAL = new Object();
    private static final ConnectionManagerSettings I = new ConnectionManagerSettings();
    private long OEAB;
    private Object READBUFFERSIZE = new Object();
    private Object TIMEOUTVALUE;
    private Hashtable add = new Hashtable();
    private int addElement;
    private boolean append;
    private PersistentConnection[] arePersistentConnectionsEnabled = new PersistentConnection[20];
    private boolean awaitingSocketCreation;
    private int checkMaxPersistentConnections;
    private int checkPersistentConnectionTimeout;
    private int checkReadBufferSize;
    private HttpSession checkSoTimeout;

    public ConnectionManager() {
        this(new ConnectionManagerSettings());
    }

    public ConnectionManager(ConnectionManagerSettings connectionManagerSettings) {
        this.setMaxPersistentConnections(connectionManagerSettings.getMaxPersistentConnections());
        this.setNagleEnabled(connectionManagerSettings.isNagleEnabled());
        this.setPersistentConnectionsEnabled(connectionManagerSettings.arePersistentConnectionsEnabled());
        this.setPersistentConnectionTimeout(connectionManagerSettings.getPersistentConnectionTimeout());
        this.setReadBufferSize(connectionManagerSettings.getReadBufferSize());
        this.setSoTimeout(connectionManagerSettings.getSoTimeout());
    }

    public ConnectionManager(HttpSession httpSession) {
        this.checkSoTimeout = httpSession;
    }

    public void addHttpURLConnectionListener(HttpURLConnectionListener httpURLConnectionListener) {
        if (httpURLConnectionListener != null) {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                this.TIMEOUTVALUE = Listeners.add((Object)this.TIMEOUTVALUE, (Object)httpURLConnectionListener);
            }
        }
    }

    public boolean arePersistentConnectionsEnabled() {
        if (this.checkSoTimeout == null) {
            return this.awaitingSocketCreation;
        }
        return this.checkSoTimeout.isPersistent;
    }

    public int getMaxPersistentConnections() {
        if (this.checkSoTimeout == null) {
            return this.addElement;
        }
        return this.checkSoTimeout.maxInstances;
    }

    public boolean getPersistent() {
        return this.arePersistentConnectionsEnabled();
    }

    public int getPersistentConnectionTimeout() {
        if (this.checkSoTimeout == null) {
            return this.checkMaxPersistentConnections;
        }
        return this.checkSoTimeout.TIMEOUTVALUE;
    }

    public int getReadBufferSize() {
        if (this.checkSoTimeout == null) {
            return this.checkPersistentConnectionTimeout;
        }
        return this.checkSoTimeout.READBUFFERSIZE;
    }

    public int getSoTimeout() {
        if (this.checkSoTimeout == null) {
            return this.checkReadBufferSize;
        }
        return this.checkSoTimeout.so_Timeout;
    }

    public boolean isNagleEnabled() {
        if (this.checkSoTimeout == null) {
            return this.append;
        }
        return this.checkSoTimeout.enableNagle;
    }

    public void removeHttpURLConnectionListener(HttpURLConnectionListener httpURLConnectionListener) {
        if (httpURLConnectionListener != null) {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                this.TIMEOUTVALUE = Listeners.remove((Object)this.TIMEOUTVALUE, (Object)httpURLConnectionListener);
            }
        }
    }

    public static void setLimits(boolean bl) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setMaxPersistentConnections(int n) throws IllegalArgumentException {
        ConnectionManager.checkMaxPersistentConnections(n);
        if (this.checkSoTimeout == null) {
            this.addElement = n;
        } else {
            this.checkSoTimeout.maxInstances = n;
        }
    }

    public void setNagleEnabled(boolean bl) {
        if (this.checkSoTimeout == null) {
            this.append = bl;
        } else {
            this.checkSoTimeout.enableNagle = bl;
        }
    }

    public void setPersistent(boolean bl) {
        this.setPersistentConnectionsEnabled(bl);
    }

    public void setPersistentConnectionsEnabled(boolean bl) {
        if (this.checkSoTimeout == null) {
            this.awaitingSocketCreation = bl;
        } else {
            this.checkSoTimeout.isPersistent = bl;
        }
    }

    public void setPersistentConnectionTimeout(int n) throws IllegalArgumentException {
        ConnectionManager.checkPersistentConnectionTimeout(n);
        if (this.checkSoTimeout == null) {
            this.checkMaxPersistentConnections = n;
        } else {
            this.checkSoTimeout.TIMEOUTVALUE = n;
        }
    }

    public void setReadBufferSize(int n) throws IllegalArgumentException {
        ConnectionManager.checkReadBufferSize(n);
        if (this.checkSoTimeout == null) {
            this.checkPersistentConnectionTimeout = n;
        } else {
            this.checkSoTimeout.READBUFFERSIZE = n;
        }
    }

    public void setSoTimeout(int n) throws IllegalArgumentException {
        ConnectionManager.checkSoTimeout(n);
        if (this.checkSoTimeout == null) {
            this.checkReadBufferSize = n;
        } else {
            this.checkSoTimeout.so_Timeout = n;
        }
    }

    protected Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        Socket socket = new Socket(inetAddress, n);
        if (this.checkSoTimeout == null) {
            socket.setSoTimeout(this.checkReadBufferSize);
            socket.setTcpNoDelay(this.append);
        } else {
            socket.setSoTimeout(this.checkSoTimeout.so_Timeout);
            socket.setTcpNoDelay(this.checkSoTimeout.enableNagle);
        }
        return socket;
    }

    protected void fireHttpURLConnectionEvent(HttpURLConnection httpURLConnection, int n, HttpRequest httpRequest) throws IllegalArgumentException {
        this.fireHttpURLConnectionEvent(httpURLConnection, n, httpRequest, null);
    }

    protected void fireHttpURLConnectionEvent(HttpURLConnection httpURLConnection, int n, HttpRequest httpRequest, HttpResponse httpResponse) throws IllegalArgumentException {
        if (this.TIMEOUTVALUE != null) {
            HttpURLConnectionEvent httpURLConnectionEvent = new HttpURLConnectionEvent(httpURLConnection, n, httpRequest, httpResponse);
            if (!(this.TIMEOUTVALUE instanceof Object[])) {
                ((HttpURLConnectionListener)this.TIMEOUTVALUE).onHttpURLConnectionEvent(httpURLConnectionEvent);
            } else {
                int n2 = 0;
                while (n2 < ((Object[])this.TIMEOUTVALUE).length) {
                    ((HttpURLConnectionListener)((Object[])this.TIMEOUTVALUE)[n2]).onHttpURLConnectionEvent(httpURLConnectionEvent);
                    ++n2;
                }
            }
            if (httpURLConnectionEvent.isConsumed()) {
                if (n == 1) {
                    httpURLConnection.requestCancelled = true;
                } else if (n == 3) {
                    httpURLConnection.responseCancelled = true;
                }
            }
        }
    }

    static void allocateInstance() {
        int n = I.getMaxPersistentConnections();
        if (n >= 0) {
            Object object = ConnectionManager.I.instancesLock;
            synchronized (object) {
                ++ConnectionManager.I.instancesInUse;
                while (ConnectionManager.I.instancesInUse > n) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    static void checkMaxPersistentConnections(int n) throws IllegalArgumentException {
        if (n < -1) {
            throw new IllegalArgumentException("maxPersistentConnections < -1");
        }
    }

    static void checkPersistentConnectionTimeout(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("persistentConnectionTimeout < 0");
        }
    }

    static void checkReadBufferSize(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException("readBufferSize < 1");
        }
    }

    static void checkSoTimeout(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("soTimeout < 0");
        }
    }

    static void freeInstance() {
        if (I.getMaxPersistentConnections() >= 0) {
            --ConnectionManager.I.instancesInUse;
        }
    }

    public CachedInputStream createInputStream(java.net.HttpURLConnection httpURLConnection, CacheManager cacheManager, Connection connection, byte[] byArray, int n, int n2) {
        return new CachedInputStream(httpURLConnection, cacheManager, connection, byArray, n, n2);
    }

    private int CLEAN_INTERVAL(Vector vector) {
        int n = 0;
        PersistentConnection persistentConnection = null;
        int n2 = 0;
        while (n2 < vector.size()) {
            persistentConnection = (PersistentConnection)vector.elementAt(n2);
            if (persistentConnection.hasTimedOut()) {
                vector.removeElementAt(n2);
                ++n;
                --n2;
            }
            ++n2;
        }
        return n;
    }

    private PersistentConnection I(Vector vector, boolean bl) {
        int n = vector.size();
        if (n == 0) {
            return null;
        }
        if (this.arePersistentConnectionsEnabled.length < n) {
            this.arePersistentConnectionsEnabled = new PersistentConnection[n];
        }
        int n2 = 0;
        while (n2 < n) {
            this.arePersistentConnectionsEnabled[n2] = (PersistentConnection)vector.elementAt(n2);
            ++n2;
        }
        int n3 = 0;
        while (true) {
            int n4 = 0;
            while (n4 < n) {
                if (!this.arePersistentConnectionsEnabled[n4].isActive()) {
                    return this.arePersistentConnectionsEnabled[n4];
                }
                ++n4;
            }
            if (!bl) {
                return null;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (++n3 != 10) continue;
            Object object = this.CLEAN_INTERVAL;
            synchronized (object) {
                n = vector.size();
                int n5 = 0;
                while (n5 < n) {
                    PersistentConnection persistentConnection = (PersistentConnection)vector.elementAt(n5);
                    if (persistentConnection.hasTimedOut()) {
                        PersistentConnection persistentConnection2 = persistentConnection;
                        return persistentConnection2;
                    }
                    ++n5;
                }
                n3 = 0;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public Connection getConnection(HttpURLConnection var1_1, URL var2_2, InetAddress var3_3, int var4_4) throws IOException {
        block47: {
            block50: {
                var5_5 = var1_1;
                var6_6 = var4_4;
                if (var5_5 instanceof HttpURLConnection) {
                    var7_7 = var2_2.getProtocol();
                    var8_8 = var5_5.getClass().getName();
                    if (var7_7.equals("https") && !var8_8.equals("ice.https.HttpsURLConnection")) {
                        var5_5 = (HttpURLConnection)var2_2.openConnection();
                        var9_9 = var5_5.getInstanceProxyResolver();
                        if (var9_9 != null) {
                            var10_13 = null;
                            try {
                                var10_13 = var9_9.findProxyForUrl(var5_5.getURL());
                            }
                            catch (Exception var11_20) {
                                Debug.ex((Throwable)var11_20);
                            }
                            if (var10_13 != null && var10_13 instanceof Proxy) {
                                var6_6 = ((Proxy)var10_13).getPort();
                            } else if (var6_6 == 80) {
                                var6_6 = 443;
                            }
                        } else if (var6_6 == 80) {
                            var6_6 = 443;
                        }
                    } else if (var7_7.equals("http") && !var8_8.equals("ice.net.HttpURLConnection")) {
                        var5_5 = (HttpURLConnection)var2_2.openConnection();
                        var9_9 = var5_5.getInstanceProxyResolver();
                        if (var9_9 != null) {
                            var10_13 = null;
                            try {
                                var10_13 = var9_9.findProxyForUrl(var5_5.getURL());
                            }
                            catch (Exception var11_21) {
                                Debug.ex((Throwable)var11_21);
                            }
                            if (var10_13 != null && var10_13 instanceof Proxy) {
                                var6_6 = ((Proxy)var10_13).getPort();
                            } else if (var6_6 == 443) {
                                var6_6 = 80;
                            }
                        } else if (var6_6 == 443) {
                            var6_6 = 80;
                        }
                    }
                }
                if (!(this.checkSoTimeout == null ? this.awaitingSocketCreation : this.checkSoTimeout.isPersistent)) break block47;
                if (this.checkSoTimeout == null) {
                    if (System.currentTimeMillis() - this.OEAB > 10000L) {
                        var7_7 = this.READBUFFERSIZE;
                        synchronized (var7_7) {
                            this.OEAB = System.currentTimeMillis();
                            var8_8 = this.add.keys();
                            var9_10 = this.add.size();
                            var10_14 = 0;
                            while (var10_14 < var9_10) {
                                var11_22 = (String)var8_8.nextElement();
                                var12_23 = (Vector)this.add.get(var11_22);
                                this.CLEAN_INTERVAL(var12_23);
                                if (var12_23.size() == 0) {
                                    this.add.remove(var11_22);
                                }
                                ++var10_14;
                            }
                        }
                    }
                } else if (System.currentTimeMillis() - this.checkSoTimeout.lastCleanedAt > (long)this.checkSoTimeout.CLEAN_INTERVAL) {
                    var7_7 = this.checkSoTimeout.cleanLock;
                    synchronized (var7_7) {
                        this.checkSoTimeout.lastCleanedAt = System.currentTimeMillis();
                        var8_8 = this.checkSoTimeout.theConnections.keys();
                        var9_11 = this.checkSoTimeout.theConnections.size();
                        var10_15 = 0;
                        while (var10_15 < var9_11) {
                            var11_22 = (String)var8_8.nextElement();
                            var12_24 = (Vector)this.checkSoTimeout.theConnections.get(var11_22);
                            this.CLEAN_INTERVAL(var12_24);
                            if (var12_24.size() == 0) {
                                this.checkSoTimeout.theConnections.remove(var11_22);
                            }
                            ++var10_15;
                        }
                    }
                }
                var7_7 = null;
                var8_8 = this.CLEAN_INTERVAL;
                synchronized (var8_8) {
                    block51: {
                        block48: {
                            block49: {
                                var9_12 = var3_3.getHostAddress() + var6_6;
                                if (this.checkSoTimeout != null) break block48;
                                if (!this.add.containsKey(var9_12)) ** GOTO lbl124
                                var10_16 = (Vector)this.add.get(var9_12);
                                this.CLEAN_INTERVAL(var10_16);
                                if (var10_16.size() >= this.addElement) break block49;
                                var7_7 = this.I(var10_16, false);
                                if (var7_7 == null) ** GOTO lbl110
                                if (var7_7.hasTimedOut()) {
                                    var10_16.removeElement(var7_7);
                                    var7_7 = new PersistentConnection(null, HttpURLConnection.getGlobalCacheManager(), this, HttpURLConnection.getGlobalMemoryManager());
                                    var10_16.addElement(var7_7);
                                } else {
                                    var7_7.reInit();
                                    var11_22 = var7_7;
                                    return var11_22;
lbl110:
                                    // 1 sources

                                    var7_7 = new PersistentConnection(null, HttpURLConnection.getGlobalCacheManager(), this, HttpURLConnection.getGlobalMemoryManager());
                                    var10_16.addElement(var7_7);
                                }
                                break block50;
                            }
                            var7_7 = this.I(var10_16, true);
                            if (var7_7.hasTimedOut()) {
                                var10_16.removeElement(var7_7);
                                var7_7 = new PersistentConnection(null, HttpURLConnection.getGlobalCacheManager(), this, HttpURLConnection.getGlobalMemoryManager());
                                var10_16.addElement(var7_7);
                            } else {
                                var7_7.reInit();
                                var11_22 = var7_7;
                                return var11_22;
lbl124:
                                // 1 sources

                                var10_17 = new Vector<Object>();
                                var7_7 = new PersistentConnection(null, HttpURLConnection.getGlobalCacheManager(), this, HttpURLConnection.getGlobalMemoryManager());
                                var10_17.addElement(var7_7);
                                this.add.put(var9_12, var10_17);
                            }
                            break block50;
                        }
                        if (!this.checkSoTimeout.theConnections.containsKey(var9_12)) ** GOTO lbl161
                        var10_18 = (Vector)this.checkSoTimeout.theConnections.get(var9_12);
                        this.CLEAN_INTERVAL(var10_18);
                        if (var10_18.size() >= this.checkSoTimeout.maxInstances) break block51;
                        var7_7 = this.I(var10_18, false);
                        if (var7_7 == null) ** GOTO lbl147
                        if (var7_7.hasTimedOut()) {
                            var10_18.removeElement(var7_7);
                            var7_7 = new PersistentConnection(HttpURLConnection.getGlobalCacheManager(), null, this.checkSoTimeout);
                            var10_18.addElement(var7_7);
                        } else {
                            var7_7.reInit();
                            var11_22 = var7_7;
                            return var11_22;
lbl147:
                            // 1 sources

                            var7_7 = new PersistentConnection(HttpURLConnection.getGlobalCacheManager(), null, this.checkSoTimeout);
                            var10_18.addElement(var7_7);
                        }
                        break block50;
                    }
                    var7_7 = this.I(var10_18, true);
                    if (var7_7.hasTimedOut()) {
                        var10_18.removeElement(var7_7);
                        var7_7 = new PersistentConnection(HttpURLConnection.getGlobalCacheManager(), null, this.checkSoTimeout);
                        var10_18.addElement(var7_7);
                    } else {
                        var7_7.reInit();
                        var11_22 = var7_7;
                        return var11_22;
lbl161:
                        // 1 sources

                        var10_19 = new Vector<Object>();
                        var7_7 = new PersistentConnection(HttpURLConnection.getGlobalCacheManager(), null, this.checkSoTimeout);
                        var10_19.addElement(var7_7);
                        this.checkSoTimeout.theConnections.put(var9_12, var10_19);
                    }
                }
            }
            if (var7_7.awaitingSocketCreation()) {
                var7_7.setSocket(var5_5.createSimpleSocket(var3_3, var6_6));
                return var7_7;
            }
            return null;
        }
        if (this.checkSoTimeout == null) {
            return new BasicConnection(var5_5.createSimpleSocket(var3_3, var6_6), HttpURLConnection.getGlobalCacheManager(), this, HttpURLConnection.getGlobalMemoryManager());
        }
        return new BasicConnection(HttpURLConnection.getGlobalCacheManager(), var5_5.createSimpleSocket(var3_3, var6_6), this.checkSoTimeout);
    }

    protected InetAddress getByName(String string) throws SecurityException, UnknownHostException {
        return this.getByName(string, true);
    }

    protected InetAddress getByName(String string, boolean bl) throws SecurityException, UnknownHostException {
        return bl ? InetAddress.getByName(string) : InetAddress.getLocalHost();
    }
}

